<?php

/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 * Easy set variables
 */
include_once('../../../../param.php');

$salespersonID = $_GET['salespersonID'];

// DB table to use
$table = 'Orders';

// Table's primary key
$primaryKey = "order_code";

// Array of database columns which should be read and sent back to DataTables.
// The `db` parameter represents the column name in the database, while the `dt`
// parameter represents the DataTables column identifier. In this case object
// parameter names
$columns = array(
    array( 'db' => '`o`.`order_code`', 'dt' => 'img', 'formatter' => function( $d, $row ) {

        return '<img class="custom-rounded-image invoice center-canvas" src="//' . HTML_PATH . '/cop/backend/themes/' . THEME_NAME . '/img/pickinglisticon.png" width="30" height="30"></td>';},
        'field' => 'order_code' ),
    array( 'db' => '`o`.`order_code`', 'dt' => 'ordercode', 'field' => 'order_code' ),
    array( 'db' => '`p`.`pick_code`', 'dt' =>  'code', 'field' =>'pick_code' ),
    array( 'db' => '`c`.`customer_company_name`', 'dt' => 'customer', 'field' => 'customer_company_name' ),
    array( 'db' => '`c`.`customer_code`', 'dt' => 'customercode', 'field' => 'customer_code' ),
    array( 'db' => '`o`.`delivery_date`', 'dt' => 'delivery', 'formatter' => function( $d, $row ) {
            return date('d-m-Y',strtotime($d));},'field' => 'delivery_date' ),
    array( 'db' => '`p`.`date`', 'dt' => 'date' , 'formatter' => function( $d, $row ) {
        return date('d-m-Y',strtotime($d));},'field' => 'date' ),

    array( 'db' => '`p`.`pick_id`', 'dt' => 'salesperson','formatter' => function( $d, $row){

        global $username, $password, $database;

        $db = new mysqli(localhost,$username,$password,$database);
        if (mysqli_connect_errno())
        {
            printf("Connect failed: %s\n", mysqli_connect_error());
            exit();
        }
        $db->set_charset("utf8");

        $stm = $db->prepare("SELECT Pick.salesperson_id, salesperson_code, CONCAT(first_name,' ',last_name) FROM Pick LEFT JOIN SalesPersons ON (Pick.salesperson_id=SalesPersons.salesperson_id) WHERE pick_id LIKE '$d'");
        $stm->execute();
        $stm->bind_result($currentSalesPersonID, $salesPersonCode, $salesPersonName);
        while ($stm->fetch()) {}
        $stm->close();
        $select = "<select name='select$d' id ='select$d' class='form-control' onchange='updateSalesPerson($d , $currentSalesPersonID)'>";
        $select .= "<option value='$currentSalesPersonID' selected >$salesPersonCode $salesPersonName</option>";

        $stm = $db->prepare("SELECT salesperson_id, salesperson_code, CONCAT(first_name,' ',last_name) FROM SalesPersons  WHERE salesperson_id NOT LIKE '$currentSalesPersonID'");
        $stm->execute();
        $stm->bind_result($salesPersonID, $salesPersonCode, $salesPersonName);
        while ($stm->fetch()) {
            $select .= "<option value='$salesPersonID' >$salesPersonCode $salesPersonName</option>";
        }
        $stm->close();
        $select.= "</select>";


        return $select;

    }, 'field' => 'pick_id' ),
    array( 'db' => '`p`.`status`', 'dt' => 'status', 'field' => 'status' ),

    array( 'db' => '`p`.`pick_id`', 'dt' => 'form', 'formatter' => function( $d, $row ) {




        return '<form method="post"  action="//'.HTML_PATH .'/cop/backend/core/views/view/view_pick.php" target="_blank" style="display: inline;" >
                    <input type="hidden" name="pick_id" value="'.$d.'">
                    <button type="submit" class="btn btn-primary" style="font-size:12px; width: 60px;display: inline-block;margin-top: 2px;" >View </button>
                </form>';},
        'field' => 'pick_id' )
);

// SQL server connection information
$sql_details = array(
    'user' => $username,
    'pass' => $password,
    'db'   => $database ,
    'host' => 'localhost'
);


/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 * If you just want to use the basic configuration for DataTables with PHP
 * server-side, there is no need to edit below this line.
 */
$joinQuery = "FROM `Pick` AS `p` LEFT JOIN `Pick_Order` AS `po` ON (`p`.`pick_id` = `po`.`pick_id`) LEFT JOIN `Orders` AS `o`  ON (`po`.`order_id` = `o`.`order_id`) LEFT JOIN `Customers` AS `c` ON (`o`.`customer_id` = `c`.`customer_id`) LEFT JOIN `SalesPersons` AS `s` ON (`p`.`salesperson_id` = `s`.`salesperson_id`)";
$where = " `p`.`status` NOT LIKE ('Cancelled') AND `p`.`status` NOT LIKE ('Completed') AND `p`.`salesperson_id` LIKE ('$salespersonID')";
if(isset($_SESSION['Allow_Customers']) && strcmp($_SESSION['Allow_Customers'],'')!=0){
    if(strcmp($where,'')!=0){$where.= " AND ";}
    $where .= "`c`.`customer_id` IN (".$_SESSION['Allow_Customers'].")";
}
if(isset($_SESSION['Allow_Salespersons']) && strcmp($_SESSION['Allow_Salespersons'],'')!=0){
    if(strcmp($where,'')!=0){$where.= " AND ";}
    $where .= " `p`.`salesperson_id` IN (".$_SESSION['Allow_Salespersons'].")";
}
require( ROOT.'backend/core/controllers/ssp2.class.php' );

echo json_encode(
    SSP::simple( $_GET, $sql_details, $table, $primaryKey, $columns,$joinQuery,$where)
);

?>
