<?php

/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 * Easy set variables
 */
include_once('../../../../param.php');

// DB table to use
$table = 'Vats';

// Table's primary key
$primaryKey = "vat_id";

// Array of database columns which should be read and sent back to DataTables.
// The `db` parameter represents the column name in the database, while the `dt`
// parameter represents the DataTables column identifier. In this case object
// parameter names
$columns = array(
    array(
        'db' => '`v`.`vat_code`',
        'dt' => 'code',
        'field' => 'vat_code'
    ),
    array(
        'db' => '`v`.`vat_display_name`',
        'dt' => 'name',
        'field' => 'vat_display_name'
    ),
    
    array(
        'db' => '`v`.`percentage`',
        'dt' => 'percentage',
        'field' => 'percentage'
    ),
  
  
    
    array(
    'db' => '`v`.`vat_id`',
    'dt' => 'form',
    'formatter' => function ($d, $row) {
        return  '<form target="_blank" id="edit_' . $d . '" action="//' . HTML_PATH . '/cop/backend/core/views/addedit/new_vat.php" method="post" style="display:inline;">
                <input type="hidden" name="vatID" value="' . $d . '">
                <input type="submit" class="btn btn-primary" value="Edit" style="width:60px;margin-top:5px;padding-top:2px;">
            </form>';
        
    },
    'field' => 'vat_id'
    )

 
    
);
global $username,$password,$database;
// SQL server connection information
$sql_details = array(
    'user' => $username,
    'pass' => $password,
    'db'   => $database,
    'host' => 'localhost'
);

/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 * If you just want to use the basic configuration for DataTables with PHP
 * server-side, there is no need to edit below this line.
 */
$joinQuery = "FROM `Vats` AS `v`";  // No joins needed for vats table in this case
$where = ''; // Add any specific where clauses if needed


require( ROOT.'backend/core/controllers/ssp2.class.php' );

echo json_encode(
    SSP::simple( $_GET, $sql_details, $table, $primaryKey, $columns, $joinQuery, $where )
);

?>