<?php

/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 * Easy set variables
 */
require_once('../../../../param.php');
// DB table to use
$table = 'Receipts';

// Table's primary key
$primaryKey = "receipt_code";
$lockNumberZreport = $_GET['lockNumber'];

// Array of database columns which should be read and sent back to DataTables.
// The `db` parameter represents the column name in the database, while the `dt`
// parameter represents the DataTables column identifier. In this case object
// parameter names
$columns = array(
    array( 'db' => '`r`.`receipt_id`', 'dt' => 'img', 'formatter' => function( $d, $row ) {
        $GLOBALS['tender_id']=$d;
        return '';}, 'field' => 'receipt_id' ),
    array( 'db' => '`r`.`receipt_code`', 'dt' => 'img', 'formatter' => function( $d, $row ) {
        $id = $GLOBALS['tender_id'];
        return '<img class="custom-rounded-image receipt center-canvas" src="//' . HTML_PATH . '/cop/backend/themes/' . THEME_NAME . '/img/receipticon.png" width="30" height="30" onclick="actionHistory('.$id.',\'Receipts\')" title="Track Receipt" ></td>';},
        'field' => 'receipt_code' ),
    array( 'db' => '`r`.`receipt_code`', 'dt' =>  'code', 'field' =>'receipt_code' ),

    array( 'db' => '`r`.`status`', 'dt' =>  'status', 'formatter' => function( $d, $row ) {
        $GLOBALS['status'] = $d;
        return $d;
    }, 'field' =>'status' ),

    array( 'db' => '`c`.`customer_code`', 'dt' => 'customercode', 'field' => 'customer_code' ),
    array( 'db' => '`c`.`customer_company_name`', 'dt' => 'customer', 'field' => 'customer_company_name' ),
    array( 'db' => '`r`.`receipt_date`', 'dt' => 'date' ,  'formatter' => function( $d, $row ) {
        return date('d-m-Y',strtotime($d));},'field' => 'receipt_date' ),

    array( 'db' => '`s`.`salesperson_code`', 'dt' => 'salesperson',

        'formatter' => function( $d, $row ) {


            global $username;
            global $password;
            global $database;
            $db1 = new mysqli(localhost,$username,$password,$database);
            if (mysqli_connect_errno()) {
                printf("Connect failed: %s\n", mysqli_connect_error());
                exit();
            }

            $db1->set_charset("utf8");
            $stm1 = $db1->prepare("SELECT first_name,last_name FROM SalesPersons WHERE salesperson_code='$d'");
            $stm1-> execute();
            $stm1-> bind_result($fname,$lname);
            while ($stm1->fetch()) {

            }
            $stm1->close();

            return "$d - $fname $lname";



        },


        'field' => 'salesperson_code' ),
//    allagh
    array( 'db' => '`ri`.`receipt_item_id`', 'dt' => 'method', 'formatter' => function( $d, $row ) {
        $GLOBALS['receipt_item_id'] = $d;
        return $d;
    }, 'field' => 'receipt_item_id' ),

    array( 'db' => '`r`.`payment_method`', 'dt' => 'method', 'formatter' => function( $d, $row ) {
        $GLOBALS['payment_method'] = $d;
        $receiptItemID = $GLOBALS['receipt_item_id'];

        if (strcmp($d,'Multiple')==0){
            global $username,$password,$database;
            $db = new mysqli(localhost, $username, $password, $database);
            if (mysqli_connect_errno()) {
                printf("Connect failed: %s\n", mysqli_connect_error());
                exit();
            }
            $db->set_charset("utf8");

            $stm = $db->prepare("SELECT payment_method FROM Receipt_Item WHERE receipt_item_id='$receiptItemID'");
            $stm->execute();
            $stm->bind_result($paymentMethodReceiptItem);
            while ($stm->fetch()) {}
            $stm->close();
            return "$paymentMethodReceiptItem";
        }else{
            return $d;
        }
    }, 'field' => 'payment_method' ),
//    new
    array( 'db' => '`r`.`cheque_number`', 'dt' => 'cheque', 'formatter' => function( $d, $row ) {
        $paymentMethod = $GLOBALS['payment_method'];
        $receiptItemID = $GLOBALS['receipt_item_id'];
        if (strcmp($paymentMethod,'Multiple')==0){
            global $username,$password,$database;
            $db = new mysqli(localhost, $username, $password, $database);
            if (mysqli_connect_errno()) {
                printf("Connect failed: %s\n", mysqli_connect_error());
                exit();
            }
            $db->set_charset("utf8");

            $stm = $db->prepare("SELECT cheque_number FROM Receipt_Item WHERE receipt_item_id='$receiptItemID'");
            $stm->execute();
            $stm->bind_result($checkNumberLnine);
            while ($stm->fetch()) {}
            $stm->close();
            return "$checkNumberLnine";
        }else{
            return $d;
        }
    }, 'field' => 'cheque_number' ),

    array( 'db' => '`r`.`cash_discount`', 'dt' => 'discound', 'formatter' => function( $d, $row ) {
        $paymentMethod = $GLOBALS['payment_method'];
        $receiptItemID = $GLOBALS['receipt_item_id'];
        if (strcmp($paymentMethod,'Multiple')==0){
            global $username,$password,$database;
            $db = new mysqli(localhost, $username, $password, $database);
            if (mysqli_connect_errno()) {
                printf("Connect failed: %s\n", mysqli_connect_error());
                exit();
            }
            $db->set_charset("utf8");

            $stm = $db->prepare("SELECT cash_discount FROM Receipt_Item WHERE receipt_item_id='$receiptItemID'");
            $stm->execute();
            $stm->bind_result($cashDiscoundLine);
            while ($stm->fetch()) {}
            $stm->close();
            return "$cashDiscoundLine";
        }else{
            return $d;
        }
    }, 'field' => 'cash_discount' ),

    array( 'db' => '`r`.`notes`', 'dt' => 'notes', 'formatter' => function( $d, $row ) {
        $paymentMethod = $GLOBALS['payment_method'];
        $receiptItemID = $GLOBALS['receipt_item_id'];
        if (strcmp($paymentMethod,'Multiple')==0){
            global $username,$password,$database;
            $db = new mysqli(localhost, $username, $password, $database);
            if (mysqli_connect_errno()) {
                printf("Connect failed: %s\n", mysqli_connect_error());
                exit();
            }
            $db->set_charset("utf8");

            $stm = $db->prepare("SELECT notes FROM Receipt_Item WHERE receipt_item_id='$receiptItemID'");
            $stm->execute();
            $stm->bind_result($notesLines);
            while ($stm->fetch()) {}
            $stm->close();
            return "$notesLines";
        }else{
            return $d;
        }
    }, 'field' => 'notes' ),
    array( 'db' => '`r`.`bank`', 'dt' => 'bank', 'formatter' => function( $d, $row ) {
        $paymentMethod = $GLOBALS['payment_method'];
        $receiptItemID = $GLOBALS['receipt_item_id'];
        if (strcmp($paymentMethod,'Multiple')==0){
            global $username,$password,$database;
            $db = new mysqli(localhost, $username, $password, $database);
            if (mysqli_connect_errno()) {
                printf("Connect failed: %s\n", mysqli_connect_error());
                exit();
            }
            $db->set_charset("utf8");

            $stm = $db->prepare("SELECT bank FROM Receipt_Item WHERE receipt_item_id='$receiptItemID'");
            $stm->execute();
            $stm->bind_result($bankLine);
            while ($stm->fetch()) {}
            $stm->close();
            return "$bankLine";
        }else{
            return $d;
        }
    }, 'field' => 'bank' ),
//end new
    array( 'db' => '`r`.`amount`', 'dt' => 'amount', 'formatter' => function( $d, $row ) {
        global $currencySymbol;
        $statusCheck = $GLOBALS['payment_method'];
        $receiptItemID = $GLOBALS['receipt_item_id'];
        if (strcmp($statusCheck,'Multiple')==0){
            global $username,$password,$database;
            $db = new mysqli(localhost, $username, $password, $database);
            if (mysqli_connect_errno()) {
                printf("Connect failed: %s\n", mysqli_connect_error());
                exit();
            }
            $db->set_charset("utf8");

            $stm = $db->prepare("SELECT amount FROM Receipt_Item WHERE receipt_item_id='$receiptItemID'");
            $stm->execute();
            $stm->bind_result($amountReceiptItemID);
            while ($stm->fetch()) {}
            $stm->close();
            return $currencySymbol. number_format($amountReceiptItemID,2);
        }else{
            return $currencySymbol. number_format($d,2);
        }
    },
        'field' => 'amount' ),
    array( 'db' => '`r`.`status`', 'dt' => 'status', 'field' => 'status' ),

//    receipt item
//    array( 'db' => '`ri`.`payment_method`', 'dt' => 'payment_methodMultiple', 'field' => 'ri.payment_method' ),
//    array( 'db' => '`ri`.`amount`', 'dt' => 'amountMultiple', 'field' => 'ri.amount' ),
//end receipt item

    array( 'db' => '`r`.`receipt_id`', 'dt' => 'form', 'formatter' => function( $d, $row ) {
        $statusCheck = $GLOBALS['status'];


        return '
               
			    
			    <form id="'.$d.'" action="//'.HTML_PATH .'/cop/backend/core/views/view/view_receipt.php" method="post" style="display: inline-block; margin-bottom: 3px;">
                    <input type="hidden" name="receipt_id" value="'.$d.'">	           			                   
                    <input style="font-size:13px;" type="submit" class="btn btn-orange" value="View" style="width:60px">
                </form>
                <form id="'.$d.'"action="//'.HTML_PATH .'/cop/backend/core/views/addedit/create_receipt.php" method="post" target="_blank" style="display: inline-block; margin-bottom: 3px;">
           		    <input type="hidden" name="receipt_id" value="'.$d.'">	           			                   
			        <input style="font-size:13px;width:60px;" type="submit" class="btn btn-primary" value="Edit" >
			    </form>
              
			    ';},
        'field' => 'receipt_id' ),

    array( 'db' => '`r`.`receipt_id`', 'dt' => 'actionsStatus', 'formatter' => function( $d, $row ) {
        $statusCheck = $GLOBALS['status'];
        $buttonSuccess = "";
        $buttonCansel = "";
        if (strcmp($statusCheck,'Accepted')==0){
            $buttonCansel ="<button type=\"button\" class=\"btn btn-danger\" style=\"display: inline-block; margin-bottom: 3px;\" onclick=\"updateReiceptiStatus($d,'Canceled','');\"><i class=\"fa fa-times\"></i></button>";
        }elseif (strcmp($statusCheck,'Canceled')==0){
            $buttonSuccess ="<button type=\"button\" class=\"btn btn-success\" style=\"display: inline-block; margin-bottom: 3px;\" onclick=\"updateReiceptiStatus($d,'Accepted','');\"><i class=\"fa fa-check\" aria-hidden=\"true\"></i></button>";
        }elseif (strcmp($statusCheck,'Confirmed')==0){
            $buttonSuccess ="";
            $buttonCansel = "";
        }else{
            $buttonSuccess ="<button type=\"button\" class=\"btn btn-success\" style=\"display: inline-block; margin-bottom: 3px;\" onclick=\"updateReiceptiStatus($d,'Accepted','');\"><i class=\"fa fa-check\" aria-hidden=\"true\"></i></button>";
            $buttonCansel ="<button type=\"button\" class=\"btn btn-danger\" style=\"display: inline-block; margin-bottom: 3px;\" onclick=\"updateReiceptiStatus($d,'Canceled','');\"><i class=\"fa fa-times\" style='color: white'></i></button>";
        }
        return '
              
                '.$buttonSuccess.'
			    '.$buttonCansel.'
			     
			    ';},
        'field' => 'receipt_id' )
);

// SQL server connection information
$sql_details = array(
    'user' => $username,
    'pass' => $password,
    'db'   => $database ,
    'host' => 'localhost'
);


//$where = "NOT status ='Canceled' ";

/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 * If you just want to use the basic configuration for DataTables with PHP
 * server-side, there is no need to edit below this line.
 */
$where = '';
if(isset($_SESSION['Allow_Customers']) && strcmp($_SESSION['Allow_Customers'],'')!=0){
    if(strcmp($where,'')!=0){$where.= " AND ";}
    $where .= "`c`.`customer_id` IN (".$_SESSION['Allow_Customers'].")";
}
if(isset($_SESSION['Allow_Salespersons']) && strcmp($_SESSION['Allow_Salespersons'],'')!=0){
    if(strcmp($where,'')!=0){$where.= " AND ";}
    $where .= " `r`.`salesperson_id` IN (".$_SESSION['Allow_Salespersons'].")";
}

if(isset($lockNumberZreport) && strcmp($lockNumberZreport,'')!=0){
    global $username,$password,$database;
    $db = new mysqli(localhost, $username, $password, $database);
    if (mysqli_connect_errno()) {
        printf("Connect failed: %s\n", mysqli_connect_error());
        exit();
    }
    $db->set_charset("utf8");

    $arrayFilterOrders = array();
    $stm = $db->prepare("SELECT document_id FROM ZE_Z_Report WHERE lock_number='$lockNumberZreport' AND document_type='Receipts' ");
    $stm->execute();
    $stm->bind_result($docID);
    while ($stm->fetch()) {
        array_push($arrayFilterOrders,$docID);
    }
    $stm->close();

    if (count($arrayFilterOrders)>0){
        $arrayFilterOrdersImplode = implode(',',$arrayFilterOrders);
        if(strcmp($where,'')!=0){$where.= " AND ";}
        $where .= " `r`.`receipt_id` IN ($arrayFilterOrdersImplode)";
    }else{
        if(strcmp($where,'')!=0){$where.= " AND ";}
        $where .= " 0=1";
    }


//    if(strcmp($where,'')!=0){$where.= " AND ";}
//    $where .= " `zer`.`lock_id` = '$lockNumberZreport'";
}
//$where .=" GROUP BY `r`.`receipt_code` ";
$joinQuery = "FROM `Receipts` AS `r` LEFT JOIN `Customers` AS `c` ON (`r`.`customer_id` = `c`.`customer_id`) LEFT JOIN `SalesPersons` AS `s` ON (`r`.`salesperson_id` = `s`.`salesperson_id`) LEFT OUTER JOIN `Receipt_Item` AS `ri` ON (`r`.`receipt_id` = `ri`.`receipt_id`)";
require( ROOT.'backend/core/controllers/ssp2.class.php' );

echo json_encode(
    SSP::simple( $_GET, $sql_details, $table, $primaryKey, $columns,$joinQuery,$where)
);

?>