<?php
include_once("../../../../param.php");
include_once(ROOT."/libs/phpexcel/vendor/autoload.php");

$file_name = "itemsUpload".date('ymdHis').'.xlsx';
$file_path = ROOT . "media/".$file_name;
$returnDirectory = $_POST['returnURL'];
$filters = '';

if(isset($_POST['returnCustomerID']) && strcmp($_POST['returnCustomerID'],'')!=0){
    $customerID = $_POST['returnCustomerID'];
    $filters .= "&customerID=$customerID";
}

if(move_uploaded_file($_FILES['excelFile']['tmp_name'], $file_path)) {
    $file = initiateFileConversion($file_name);
} else {
    $file = 0;
}

header('Location: '.$returnDirectory.'?fromFile='.$file.$filters);


function initiateFileConversion($inputFile)
{

    return basename(processXLSX($inputFile)[0]);

}

function processXLSX($inputFile)
{

    $inputDirectory = "../../../../media/";
    $outputDirectory = "../../../../media/";
    $archiveDirectory = "../../../../media/";

    $inputDelimiter = "";
    $outputDelimiter = "|";

    $startingRow = 0;
    $endingRow = 0;
    if(file_exists($inputDirectory.$inputFile)) {


        $objReader1 = PHPExcel_IOFactory::createReader('Excel2007');
        $objReader1->setReadDataOnly(true);

        $objPHPExcel1 = $objReader1->load($inputDirectory . $inputFile);
        $sheetCount = $objPHPExcel1->getSheetCount();
//        echo "XLS Number of Sheets <i class='fa fa-arrow-right'></i> <b>$sheetCount</b> <br>";
        $filesCreated = "";
        $convertedFiles = array();
        for ($i = 0; $i < $sheetCount; $i++) {

            $sheet1 = $objPHPExcel1->getSheet($i);
            $sheetNameDisplay = $sheet1->getTitle();
            $sheetNumber = $i + 1;
            $lastColumn = $objPHPExcel1->setActiveSheetIndex($i)->getHighestColumn();
            $lastColumnNumber = PHPExcel_Cell::columnIndexFromString($lastColumn);
            $sheetName = strtolower(str_replace(' ', '_', $sheetNameDisplay));
            $outputFile = date('ymdHis').".txt";
            $ColumnArray = array();
            $lastColumnNumber += 1;
            for ($c = 0; $c <= $lastColumnNumber; $c++) {
                array_push($ColumnArray, $c);
            }
//            echo "<br><b>Processing Sheet $sheetNumber (</b>$sheetName<b>):</b> <br>";
            $fileCreated = convert($inputFile, $outputFile, $inputDirectory, $outputDirectory, $inputDelimiter, $outputDelimiter, $startingRow, $endingRow, $ColumnArray, $i);
            array_push($convertedFiles, $fileCreated);
            $filesCreated .= basename($fileCreated) . "<br>";

        }


        if (unlink($inputDirectory . $inputFile)) {
        }
        return $convertedFiles;
    } else {
    }
}

function validateFile($fileDirectory,$validationString){
    $baseFile = basename($fileDirectory);
    $validationRows = explode("\n", $validationString);
    $validationRowsCount = sizeof($validationRows);

    $txt_file = file_get_contents($fileDirectory);
    $rows = explode("\n", $txt_file);
    $processedRows=0;
    $isValidCounter=0;
    foreach ($rows as $row => $data) {
        foreach ($validationRows as $vRow => $vData) {

            if(strcmp($data,$vData)==0){
                $isValidCounter++;
                break;
            }
        }
        $processedRows++;
        if($processedRows >= $validationRowsCount){break;}
    }
    if($isValidCounter >= $processedRows){
        if(rename($fileDirectory, "./import/converted/$baseFile")){
            echo "<b style='color: green'>Success!</b>";
        } else {
            echo "<b style='color: firebrick'>PROCESSING FAILED </b> <i class='fa fa-arrow-right'></i> Please Run the upload again.";
            echo "<script>$('#runParserButton').hide();</script>";
        }
    } else {
        echo "<b style='color: firebrick'>VALIDATION FAILED </b> <i class='fa fa-arrow-right'></i> XLS File Header(s) Changed. Please Correct Headers and upload again.";
        echo "<script>$('#runParserButton').hide();</script>";
        rename($fileDirectory, "./import/error/".date('d-m-y_H:i')."$baseFile");
    }
}



// ------ FILE CONFIGURATION END ---------


function convert($inputFile, $outputFile, $inputDirectory, $outputDirectory, $inputDelimiter, $outputDelimiter, $startingRow, $endingRow,$ColumnArray,$getSheet=0)
{
    $inputFileDirectory  = $inputDirectory.$inputFile;
    $outputFileDirectory = $outputDirectory.$outputFile;


    return XLSInput($inputFileDirectory,$startingRow,$endingRow,$ColumnArray,$outputDelimiter,$outputFileDirectory,$getSheet);

}

function XLSInput($inputFileDirectory,$startingRow,$endingRow,$ColumnArray,$outputDelimiter,$outputFileDirectory,$getSheet = 0)
{
    $file = fopen($outputFileDirectory, "w");
    $objReader = PHPExcel_IOFactory::createReader('Excel2007');
    $objReader->setReadDataOnly(true);

    $objPHPExcel = $objReader->load($inputFileDirectory);
    $sheet = $objPHPExcel->getSheet($getSheet);
    $highestRow = $sheet->getHighestRow();
    $highestColumn = $sheet->getHighestColumn();
    $highestColumn++;
    $colNumber = PHPExcel_Cell::columnIndexFromString($highestColumn);

    if($endingRow == 0){
        $endingRow = $highestRow;
    }

//    echo "<b>Records (Including Headers):</b> $endingRow <i class='fa fa-arrow-right'></i> ";

//  Loop through each row of the worksheet in turn
    for ($row = $startingRow; $row <= $endingRow; $row++) {
        fwrite($file, "\n");
        for($column='A';$column != $highestColumn;$column++) {
            $cell = $sheet->getCell($column.$row);
            if($cell->isFormula()){
                $rowData = $cell->getOldCalculatedValue();

            } else {
                $rowData = $cell->getValue();
            }

            fwrite($file, $rowData);
            fwrite($file, $outputDelimiter);


            }
        }
        $displayRowsProcessed = $row - 1;
//    echo "<b style='color: green'> $displayRowsProcessed rows Processed.</b><br>";
//    echo "<b>File Created:</b> ".basename($outputFileDirectory).PHP_EOL." ";
    fclose($file);

    return $outputFileDirectory;

}

function TXTInput($inputFileDirectory,$startingRow,$endingRow,$ColumnArray,$inputDelimiter,$outputDelimiter,$outputFileDirectory)
{
    $file        = fopen($outputFileDirectory, "w");
    $txt_file    = file_get_contents($inputFileDirectory);
    $rows        = explode("\n", $txt_file);

    array_shift($rows);

    foreach($rows as $row => $fields)
    {
        $row_data = explode($inputDelimiter, $fields);
        $data     = array();

        if($row >= $startingRow) {
            if($row <= $endingRow || $endingRow == 0) {
                foreach ($row_data as $field) {
                    array_push($data, $field);
                }

                foreach ($ColumnArray as $col) {
                    fwrite($file, $data[$col]);
                    fwrite($file, $outputDelimiter);
                }
                fwrite($file, "\n");
            }
        }
    }
    fclose($file);
}


?>