<?php
class ActionAutomation
{
    private $db;
    private $ROOT;
    private $HTML_PATH;
    private $automation_id;
    private $if_table;
    private $if_table_id;
    private $if_column;
    private $if_from;
    private $if_to;
    private $then_table;
    private $then_table_id;
    private $then_column;
    private $then_from;
    private $then_to;
    private $notification_type;
    private $send_to_type;
    private $send_to_id;
    private $send_to_custom;
    private $control_var_from;
    private $control_var_to;
    private $id_column;
    private $id_value;
    private $automation_triggers;
    private $sms_supplier;
    private $sms_username;
    private $sms_password;
    private $email_host;
    private $email_from;
    private $email_username;
    private $email_password;
    private $custom_file_call;
    private $custom_call_param;
    private $notificationTitle;

    private function initVariables($db,$idColumn,$idValue)
    {
        $this->automation_id = array();
        $this->if_table = array();
        $this->if_column = array();
        $this->if_from = array();
        $this->if_to = array();
        $this->then_table = array();
        $this->then_column = array();
        $this->then_from = array();
        $this->then_to = array();
        $this->notification_type = array();
        $this->send_to_type = array();
        $this->send_to_id = array();
        $this->send_to_custom = array();
        $this->control_var_from = array();
        $this->control_var_to = array();
        $this->automation_triggers = array();
        $this->notificationTitle= array();
        $this->custom_file_call= array();
        $this->custom_call_param= array();
        $this->if_table_id = 0;
        $this->then_table_id = 0;
        $this->id_column = $idColumn;
        $this->id_value = $idValue;
        $this->db = $db;
        $this->sms_supplier='';
        $this->sms_username='';
        $this->sms_password='';
        $this->email_host='';
        $this->email_from='';
        $this->email_username='';
        $this->email_password='';

    }

    private function getTemplate($automationID,$key)
    {
        $db = $this->db;
        $template = '';
        $actionCode = '';

        $table = $this->if_table[$key];
        $codeColumn = strtolower(rtrim($table,'s'))."_code";
        $idColumn = $this->id_column;
        $idValue = $this->id_value;

        $statement = $db->prepare("SELECT template FROM ZG_Action_Automations WHERE automation_id='$automationID' LIMIT 1 ");
        $statement->execute();
        $statement->bind_result($template);
        while ($statement->fetch()) {}
        $statement->close();

        $statement = $db->prepare("SELECT $codeColumn FROM $table WHERE $idColumn='$idValue' LIMIT 1");
        $statement->execute();
        $statement->bind_result($actionCode);
        while ($statement->fetch()) {}
        $statement->close();

        $template = str_replace("{code}" ,"$actionCode",$template);


        return $template;
    }

    private function setAutomationID($id){
        array_push($this->automation_id,$id);
    }

    private function setGlobals($root,$htmlPath){
        $this->ROOT=$root;
        $this->HTML_PATH=$htmlPath;
    }

    private function setNotificationCredentials($sms_supplier,$sms_username,$sms_password,$email_host,$email_from,$email_username,$email_password){
        $this->sms_supplier=$sms_supplier;
        $this->sms_username=$sms_username;
        $this->sms_password=$sms_password;
        $this->email_host=$email_host;
        $this->email_from=$email_from;
        $this->email_username=$email_username;
        $this->email_password=$email_password;
    }

    private function setAutomationTriggerValue($bull)
    {
        array_push($this->automation_triggers,$bull);

    }

    private function setIf($table,$column,$from,$to)
    {
        array_push($this->if_table,$table);
        array_push($this->if_column,$column);
        array_push($this->if_from,$from);
        array_push($this->if_to,$to);
    }

    private function setThen($table,$column,$from,$to)
    {
        array_push($this->then_table,$table);
        array_push($this->then_column,$column);
        array_push($this->then_from,$from);
        array_push($this->then_to,$to);
    }

    private function setNotification($notification_type,$send_to_type,$send_to_id,$send_to_custom,$notificationTitle)
    {
        array_push($this->notification_type,$notification_type);
        array_push($this->send_to_type,$send_to_type);
        array_push($this->send_to_id,$send_to_id);
        array_push($this->send_to_custom,$send_to_custom);
        array_push($this->notificationTitle,$notificationTitle);
    }

    private function setCustomFileCall($custom_file_call,$custom_call_param)
    {
        array_push($this->custom_file_call,$custom_file_call);
        array_push($this->custom_call_param,$custom_call_param);
    }

    private function setControlVarFrom($control_var_from)
    {
        array_push($this->control_var_from,$control_var_from);
    }

    private function setControlVarTo($control_var_to)
    {
        array_push($this->control_var_to,$control_var_to);
    }

    private function setControlVariables(){
        $db = $this->db;
        $ifTable  = $this->if_table;
        $column = $this->if_column;
        $idColumn = $this->id_column;
        $idValue  = $this->id_value;
        $var='';
        foreach ($ifTable as $key => $table) {
            $statement = $db->prepare("SELECT $column[$key] FROM $table WHERE $idColumn=$idValue");
            $statement->execute();
            $statement->bind_result($var);
            while ($statement->fetch()) {
                $this->setControlVarFrom($var);
            }
            $statement->close();
        }

    }

    private function checkControlVariables(){
        $db = $this->db;
        $ifTable  = $this->if_table;
        $column = $this->if_column;
        $idColumn = $this->id_column;
        $idValue  = $this->id_value;
        $var='';
        $return = false;
        if($idValue > 0) {
            foreach ($ifTable as $key => $table) {
                $statement = $db->prepare("SELECT $column[$key] FROM $table WHERE $idColumn=$idValue");
                $statement->execute();
                $statement->bind_result($var);
                while ($statement->fetch()) {
                    $this->setControlVarTo($var);
                }
                $statement->close();
                $return = true;
            }
        } else {
            $return = false;
        }
        return $return;

    }

    private function setTriggeredAutomations(){
        $ifTable  = $this->if_table;
        $controlValue = $this->control_var_from;
        $changedValue = $this->control_var_to;
        $valueFrom = $this->if_from;
        $valueTo = $this->if_to;
        foreach ($ifTable as $key => $table) {
            if(strcmp($changedValue[$key], $controlValue[$key])!=0 && (strcmp($valueFrom[$key], $controlValue[$key])==0 || strcmp($valueFrom[$key], 'all')==0) && (strcmp($valueTo[$key], $changedValue[$key])==0 || strcmp($valueTo[$key], 'all')==0)){
                if((strcmp($controlValue[$key], '')==0 && strcmp($valueFrom[$key], 'all')==0)){
                    $this->setAutomationTriggerValue(false);
                } else if((strcmp($changedValue[$key], '')==0 && strcmp($valueTo[$key], 'all')==0)){
                    $this->setAutomationTriggerValue(false);
                } else {
                    $this->setAutomationTriggerValue(true);
                }
            } else {
                $this->setAutomationTriggerValue(false);
            }
        }
    }

    private function sendEmail($sendToType,$sendToCustom,$sendToID,$notificationTitle,$template)
    {
        $senderName = explode('@',$this->email_from)[0];
        $emails = array();

        if(strcmp($sendToType,'custom')==0){
            $toEmails = $sendToCustom;
            $toEmails = trim($toEmails,'"');
            $toEmails = str_replace(",", ";", $toEmails);
            $toEmails = rtrim($toEmails,';');
            $emails = explode(';',$toEmails);
        } else if($sendToID > 0){

        }

        foreach ($emails as $recipient){
            $this->addNotificationToQue('email',$recipient,$notificationTitle,$template,$senderName);
        }


    }

    private function sendInstantEmail($sendToType,$sendToCustom,$sendToID,$notificationTitle,$template)
    {
        $ROOT = $this->ROOT;
        $HTML_PATH = $this->HTML_PATH;
        $mailHost = $this->email_host;
        $mailUsername = $this->email_username;
        $mailPassword = $this->email_password;
        $senderEmail = $this->email_from;
        $senderName = explode('@',$this->email_from)[0];
        $emails = array();

        if(strcmp($sendToType,'custom')==0){
            $toEmails = $sendToCustom;
            $toEmails = trim($toEmails,'"');
            $toEmails = str_replace(",", ";", $toEmails);
            $toEmails = rtrim($toEmails,';');
            $emails = explode(';',$toEmails);
        } else if($sendToID > 0){

        }

        $postFields=array(
            'mailHost' => "$mailHost",
            'mailUsername' => "$mailUsername",
            'mailPassword' => "$mailPassword",
            'senderEmail' => "$senderEmail",
            'senderName' => "$senderName",
            'notificationTitle' => "$notificationTitle",
            'template' => "$template",
            'emails' => $emails
        );



        $this->sentPostUrl("https://$HTML_PATH/cop/backend/modules/webAPI/email/automationEmail.php", $postFields);

    }

    private function sendSMS($sendToType,$sendToCustom,$sendToID,$notificationTitle,$template)
    {

        $senderName = $notificationTitle;
        $phone = '';



        if(strcmp($sendToType,'custom')==0){
            $phone = $sendToCustom;
            $phone = trim($phone,'"');
            $phone = str_replace(",", ";", $phone);
            $phone = rtrim($phone,';');
            $phone = explode(';',$phone);
        } else if($sendToID > 0){

        }

        foreach ($phone as $recipient){
            $this->addNotificationToQue('sms',$recipient,$notificationTitle,$template,$senderName);
        }



    }

    private function sendLog($notificationTitle,$template)
    {

        $senderName = $notificationTitle;
        $this->addNotificationToQue('log','-',$notificationTitle,$template,$senderName);




    }

    private function sendInstantSMS($sendToType,$sendToCustom,$sendToID,$notificationTitle,$template)
    {

        $ROOT = $this->ROOT;
        $HTML_PATH = $this->HTML_PATH;
        $smsSupplier = $this->sms_supplier;
        $smsUserName = $this->sms_username;
        $smsPassword = $this->sms_password;
        $senderName = $notificationTitle;
        $phone = '';



        if(strcmp($sendToType,'custom')==0){
            $phone = $sendToCustom;
            $phone = trim($phone,'"');
            $phone = str_replace(",", ";", $phone);
            $phone = rtrim($phone,';');
            $phone = explode(';',$phone);
        } else if($sendToID > 0){

        }

        $postFields=array(
            'smsSupplier' => "$smsSupplier",
            'smsUserName' => "$smsUserName",
            'smsPassword' => "$smsPassword",
            'notificationTitle' => "$notificationTitle",
            'template' => "$template",
            'phone' => "$phone"

        );

        $this->sentPostUrl("https://$HTML_PATH/cop/backend/modules/webAPI/sms/automationSMS.php", $postFields);


    }

    private function sendPushNotification($sendToType,$sendToCustom,$sendToID,$table,$idColumn,$idValue,$fileParams,$title,$body)
    {

        if(strcmp($sendToType,'custom')==0){
            $db = $this->db;
            $statement = $db->prepare("SELECT $sendToCustom FROM $table WHERE $idColumn='$idValue' AND $idColumn > 0 LIMIT 1");
            $statement->execute();
            $statement->bind_result($sendToID);
            while ($statement->fetch()) {}
            $statement->close();
            $sendToID = intval($sendToID);
        }

        if($sendToID > 0) {

            $deviceObject = $this->getLastDeviceIdFromSalesperson($sendToID);
            $deviceID = $deviceObject->deviceID;
            $deviceType = $deviceObject->type;
            $extraDataKey = '';
            $extraDataValue = '';
            $notificationType = 'Notification';

            if ($deviceID > 0) {

                foreach ($fileParams as $fileParam) {
                    $param = explode('=', $fileParam);
                    $paramKey = $param[0];
                    $tableValue = $param[1];
                    $tableValue = str_replace("}", "", str_replace("{", "", "$tableValue"));

                    $statement = $db->prepare("SELECT $tableValue FROM $table WHERE $idColumn='$idValue' LIMIT 1");
                    $statement->execute();
                    $statement->bind_result($paramValue);
                    while ($statement->fetch()) {}
                    $statement->close();

                    $extraDataKey = $paramKey;
                    $extraDataValue = $paramValue;
                }

                $postFields = array('deviceID' => "$deviceID", 'deviceType' => "$deviceType", 'title' => "$title", 'body' => "$body" ,"table" => "$table","extraDataKey" => "$extraDataKey","extraDataValue" => "$extraDataValue");
                $this->sentPostUrl("https://$this->HTML_PATH/cop/libs/gcm/sendAutomationPushNotification.php", $postFields);
            }
        }
    }


    private function getLastDeviceIdFromSalesperson($salespersonID){

        $db = $this->db;

        $deviceObject = new stdClass();
        $deviceObject->deviceID = 0;
        $deviceObject->type = '';

        $statement = $db->prepare("SELECT device_id,last_update_from FROM Devices WHERE NOT Devices.status='disabled' AND Devices.sales_person_id=? ORDER BY Devices.last_update_from DESC LIMIT 1");
        $statement->bind_param('i', $salespersonID);
        $statement->execute();
        $statement->bind_result($salesDeviceID,$salesLastUpdate);
        while ($statement->fetch()) {}
        $statement->close();


        $statement = $db->prepare("SELECT device_pop_id,last_update_from FROM Devices_Pop WHERE NOT Devices_Pop.status='disabled' AND Devices_Pop.sales_person_id=? ORDER BY Devices_Pop.last_update_from DESC LIMIT 1");
        $statement->bind_param('i', $salespersonID);
        $statement->execute();
        $statement->bind_result($purDeviceID,$purLastUpdate);
        while ($statement->fetch()) {}
        $statement->close();


        if($salesDeviceID > 0 && $purDeviceID > 0){
            if($salesLastUpdate > $purLastUpdate){
                $deviceObject->deviceID = $salesDeviceID;
                $deviceObject->type = 'sale';
            } else {
                $deviceObject->deviceID = $purDeviceID;
                $deviceObject->type = 'pur';
            }
        } else if($salesDeviceID > 0){
            $deviceObject->deviceID = $salesDeviceID;
            $deviceObject->type = 'sale';
        } else if($purDeviceID > 0){
            $deviceObject->deviceID = $purDeviceID;
            $deviceObject->type = 'pur';
        }

        return $deviceObject;

    }


    private function executeTriggeredAutomations(){
        $ifTable   = $this->if_table;
        $trigger   = $this->automation_triggers;
        $db        = $this->db;
        $thenTable = $this->then_table;
        $column    = $this->then_column;
        $idColumn  = $this->id_column;
        $idValue   = $this->id_value;
        $fromValue = $this->then_from;
        $toValue   = $this->then_to;
        $sendToID  = $this->send_to_id;
        $sendToType = $this->send_to_type;
        $sendToCustom = $this->send_to_custom;
        $automationID = $this->automation_id;
        $notificationType = $this->notification_type;
        $notificationTitle = $this->notificationTitle;
        $fileToCall = $this->custom_file_call;
        $fileParams = $this->custom_call_param;

        foreach ($ifTable as $key => $table) {

                if($trigger[$key]){

                    if(strcmp($fromValue[$key],'')!=0 && strcmp($toValue[$key],'')!=0) {
                        if (strcmp($fromValue[$key], 'all') != 0) {
                            $extraWhere = "AND $column[$key]='$fromValue[$key]'";
                        } else {
                            $extraWhere = "";
                        }

                        $db->set_charset("utf8");
                        $statementt = $db->prepare("UPDATE $thenTable[$key] SET $column[$key] = ? WHERE $idColumn = '$idValue' $extraWhere");
                        $statementt->bind_param('s', $toValue[$key]);
                        $statementt->execute();
                        $statementt->close();
                    }

                    if(strcmp($notificationType[$key],'')!=0 && strcmp($sendToType[$key],'')!=0 && (strcmp($sendToCustom[$key],'')!=0 || $sendToID[$key] > 0)){

                        if(strcmp($notificationType[$key],'email')==0){
                            $this->sendEmail($sendToType[$key],$sendToCustom[$key],$sendToID[$key],$notificationTitle[$key],$this->getTemplate($automationID[$key],$key));
                        } else if(strcmp($notificationType[$key],'sms')==0){
                            $this->sendSMS($sendToType[$key],$sendToCustom[$key],$sendToID[$key],$notificationTitle[$key],$this->getTemplate($automationID[$key],$key));
                        } else if(strcmp($notificationType[$key],'emailInstant')==0){
                            $this->sendInstantEmail($sendToType[$key],$sendToCustom[$key],$sendToID[$key],$notificationTitle[$key],$this->getTemplate($automationID[$key],$key));
                        } else if(strcmp($notificationType[$key],'smsInstant')==0){
                            $this->sendInstantSMS($sendToType[$key],$sendToCustom[$key],$sendToID[$key],$notificationTitle[$key],$this->getTemplate($automationID[$key],$key));
                        } else if(strcmp($notificationType[$key],'log')==0){
                            $this->sendLog($notificationTitle[$key],$this->getTemplate($automationID[$key],$key));
                        } else if(strcmp($notificationType[$key],'pushNotification')==0){
                            $this->sendPushNotification($sendToType[$key],$sendToCustom[$key],$sendToID[$key],$table,$idColumn,$idValue,$fileParams,$notificationTitle[$key],$this->getTemplate($automationID[$key],$key));
                        }


                    } else if(strcmp($notificationType[$key],'log')==0){
                        $this->sendLog($notificationTitle[$key],$this->getTemplate($automationID[$key],$key));
                    }

                    if(strcmp($fileToCall[$key],'')!=0 && strcmp($fileParams[$key],'')!=0){
                        $postFields=array("$fileParams[$key]" => "$idValue",);

                        $this->sentPostUrl("https://$this->HTML_PATH/cop/".$fileToCall[$key], $postFields);
                    }
                }

        }
    }

    private function sentPostUrl($url, $postFields=array()){

        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL,$url);
        curl_setopt($ch, CURLOPT_POST, 1);
        curl_setopt($ch, CURLOPT_POSTFIELDS, http_build_query($postFields));
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_exec($ch);
        curl_close($ch);

    }

    private function addNotificationToQue($notificationType,$recipient,$notificationTitle,$template,$senderName){
        $db = $this->db;
        $db->set_charset("utf8");
        $statement = $db->prepare("INSERT INTO ZG_Notification_Que (notification_type,recipient,notification_title,notification_content,sender_name,timestamp) VALUES (?,?,?,?,?,NOW()) ");
        $statement->bind_param('sssss',$notificationType,$recipient,$notificationTitle,$template,$senderName);
        $statement->execute();
        $statement->close();
    }

    public function __construct($db,$ROOT,$HTML_PATH, $table, $idColumn, $idValue ){
        $id = '';
        $if_table='';
        $if_column='';
        $if_from='';
        $if_to='';
        $then_table='';
        $then_column='';
        $then_from='';
        $then_to='';
        $notification_type='';
        $send_to_type='';
        $send_to_id='';
        $send_to_custom='';
        $sms_supplier='';
        $sms_username='';
        $sms_password='';
        $email_host='';
        $email_from='';
        $email_username='';
        $email_password='';
        $notificationTitle='';
        $custom_file_call = '';
        $custom_call_param='';


        $this->initVariables($db,$idColumn,$idValue);

        $db->set_charset("utf8");

        $statement = $db->prepare("SELECT sms_supplier,sms_username,sms_password,email_host,email_from,email_username,email_password FROM Cloud_Configuration LIMIT 1");
        $statement->execute();
        $statement->bind_result($sms_supplier,$sms_username,$sms_password,$email_host,$email_from,$email_username,$email_password);
        while ($statement->fetch())
        {
            $this->setNotificationCredentials($sms_supplier,$sms_username,$sms_password,$email_host,$email_from,$email_username,$email_password);
        }
        $statement->close();

        $statement = $db->prepare("SELECT automation_id,if_table,if_column,if_from,if_to,then_table,then_column,then_from,then_to,custom_file_call,custom_call_param,notification_type,send_to_type,send_to_id,send_to_custom,notification_title FROM ZG_Action_Automations WHERE if_table='$table'");
        $statement->execute();
        $statement->bind_result($id,$if_table,$if_column,$if_from,$if_to,$then_table,$then_column,$then_from,$then_to,$custom_file_call,$custom_call_param,$notification_type,$send_to_type,$send_to_id,$send_to_custom,$notificationTitle);
        while ($statement->fetch())
        {
            $this->setAutomationID($id);
            $this->setGlobals($ROOT,$HTML_PATH);
            $this->setIf($if_table,$if_column,$if_from,$if_to);
            $this->setThen($then_table,$then_column,$then_from,$then_to);
            $this->setNotification($notification_type,$send_to_type,$send_to_id,$send_to_custom,$notificationTitle);
            $this->setCustomFileCall($custom_file_call,$custom_call_param);
        }
        $statement->close();

        $this->setControlVariables();


    }

    public function echoAutomations(){

        if($this->checkControlVariables()) {
            $this->setTriggeredAutomations();

            $ifTable = $this->if_table;
            $thenTable = $this->then_table;
            $column = $this->if_column;
            $column2 = $this->then_column;
            $controlValue = $this->control_var_from;
            $changedValue = $this->control_var_to;
            $valueFrom = $this->if_from;
            $valueTo = $this->if_to;
            $thenValueFrom = $this->then_from;
            $thenValueTo = $this->then_to;
            $trigger = $this->automation_triggers;
            $notificationType = $this->notification_type;
            $sendToType = $this->send_to_type;
            $sendToCustom = $this->send_to_custom;
            $sendToID = $this->send_to_id;
            $notificationTitle = $this->notificationTitle;

            foreach ($ifTable as $key => $table) {

                $tableDisplay = str_replace('_', ' ', $table);
                $tableDisplay2 = str_replace('_', ' ', $thenTable[$key]);
                $columnDisplay = str_replace('_', ' ', $column[$key]);
                $columnDisplay2 = str_replace('_', ' ', $column2[$key]);

                echo "Automation on $tableDisplay $columnDisplay: trigger $valueFrom[$key] => $valueTo[$key] - Checked Values $controlValue[$key] => $changedValue[$key]";

                if ($trigger[$key]) {
                    echo " : Automation Triggered ";
                    if (strcmp($valueFrom[$key], '') != 0 || strcmp($valueTo[$key], '') != 0) {
                        echo " $tableDisplay2 $columnDisplay2 $thenValueFrom[$key] => $thenValueTo[$key] ";
                    }
                    if (strcmp($notificationType[$key], '') != 0 && strcmp($sendToType[$key], '') != 0 && (strcmp($sendToCustom[$key], '') != 0 || $sendToID[$key] > 0)) {

                        echo "  Send $notificationType[$key] to $sendToType[$key] $sendToCustom[$key] $notificationTitle[$key]";

                    }


                } else {
                    echo " : No Trigger.";
                    if (strcmp($changedValue[$key], $controlValue[$key]) == 0) {
                        echo " (Variable Not Changed)";
                    }
                }

                echo "<br>";
            }
        }
    }

    public function executeAutomations()
    {
        if($this->checkControlVariables()){
            $this->setTriggeredAutomations();
            $this->executeTriggeredAutomations();
        }


    }

}


?>