<?php
class AuditLog{

    private $db;
    private $user_id;
    private $change_type_id;
    private $change_type_name;
    private $object_name;
    private $field_name;
    private $field_id;
    private $linked_field_id;
    private $linked_field_name;
    private $previous_value;
    private $changed_value;


    public function __construct($db,$user_id){
        $this->db = $db;
        $this->user_id = intval($user_id);
    }

    public function initModalElement()
    {
        
    }

    public function getLogs($change_type_id,$field_id,$linked_field_id=0,$limit=100){

        $salesperson_id = '';
        $user_id = '';
        $salesperson_name = '';
        $previous_value = '';
        $changed_value = '';
        $date = '';

        $salespersons = array(0=>'');
        $stmt = $this->db->prepare("SELECT salesperson_id, CONCAT(first_name, ' ',last_name) FROM SalesPersons WHERE 1=1");
        $stmt->execute();
        $stmt->bind_result($salesperson_id,$salesperson_name);
        while ($stmt->fetch()) {
            $salespersons[$salesperson_id] = $salesperson_name;
        }
        $stmt->close();

        $result = '<table class="table table-bordered">';
        $result .= '<tr style="background-color: #3276b1;color:white;"><th><center>Date</th><th><center>Time</th><th><center>User</th><th><center>Previous</th><th><center>Changed</th></tr>';

        $stmt = $this->db->prepare("SELECT date,previous_value,changed_value,user_id FROM Audit_Log WHERE change_type_id = ? AND field_id=? AND linked_field_id=? ORDER BY date DESC LIMIT ?");
        $stmt->bind_param("iiii",$change_type_id,$field_id,$linked_field_id,$limit);
        $stmt->execute();
        $stmt->bind_result($date,$previous_value,$changed_value,$user_id);
        while ($stmt->fetch()) {
            if((strtotime($date) !== false)){
                $timezone = 'Europe/Athens';
                date_default_timezone_set($timezone);
                $timestamp = strtotime($date);
                $local_time = $timestamp + date('Z');
                $date = date('d/m/Y', $local_time);
                $time = date('H:i', $local_time);
            }
            $result .= '<tr><td>'.$date.'</td><td>'.$time.'</td><td>'.$salespersons[$user_id].'</td><td>'.$previous_value.'</td><td>'.$changed_value.'</td></tr>';
        }
        $stmt->close();
        $result .= '</table>';

        return $result;
    }

    public function getLastLogDate($change_type_id,$field_id,$linked_field_id=0){
        $date = '';
        $logID = 0;
        $stmt = $this->db->prepare("SELECT audit_log_id,date FROM Audit_Log WHERE change_type_id = ? AND field_id=? AND linked_field_id=? ORDER BY date DESC LIMIT 1");
        $stmt->bind_param("iii",$change_type_id,$field_id,$linked_field_id);
        $stmt->execute();
        $stmt->bind_result($logID,$date);
        while ($stmt->fetch()) {}
        $stmt->close();

        if((strtotime($date) !== false)){
            $timezone = 'Europe/Athens';
            date_default_timezone_set($timezone);
            $timestamp = strtotime($date);
            $local_time = $timestamp + date('Z');
            $date = date('d-m-Y H:i', $local_time);

            $log = $this->getLogs($change_type_id,$field_id,$linked_field_id);
            $date = "<div id='auditLastChangeDate$logID' style='cursor: pointer;' onclick='$(\"#auditLog$logID\").show();$(this).hide();'>$date</div><div id='auditLog$logID' style='display: none;'><button type='button' class='btn btn-primary btn-block' onclick='$(\"#auditLastChangeDate$logID\").show();$(\"#auditLog$logID\").hide();'>Close</button>$log</div>";
        }
        return $date;

    }

    public function logChange($change_type_id,$change_type_name,$table_name,$field_name,$field_id,$previous_value,$changed_value,$linked_field_name='',$linked_field_id=0){
        $this->change_type_id = $change_type_id;
        $this->change_type_name = $change_type_name;
        $this->object_name = $table_name;
        $this->field_name = $field_name;
        $this->field_id = $field_id;
        $this->linked_field_name = $linked_field_name;
        $this->linked_field_id= $linked_field_id;
        $this->previous_value = $previous_value;
        $this->changed_value = $changed_value;


        $this->insertLog();

    }

    private function insertLog(){
        $stmt = $this->db->prepare("INSERT INTO Audit_Log (user_id, date, change_type_id, change_type_name, object_name, field_name, field_id, linked_field_name, linked_field_id, previous_value, changed_value, timestamp) VALUES (?, NOW(), ?, ?, ?, ?, ?, ?, ?, ?, ?,NOW())");
        $stmt->bind_param('iisssisiss',$this->user_id,$this->change_type_id,$this->change_type_name,$this->object_name,$this->field_name,$this->field_id,$this->linked_field_name,$this->linked_field_id,$this->previous_value,$this->changed_value);
        $stmt->execute();
        $error = $stmt->error;
        $stmt->close();

        return $error;
    }






}
?>