<?php
class ErpImport
{
    public $erpImportID;
    public $startTime;
    public $endTime;
    public $name;
    public $type;
    public $resultLog;
    public $affectedRecords;
    public $deletedRecords;
    public $deleteStatementRecords;
    public $sourceName;
    public $sourceMethod;
    public $sourceIP;
    public $status;
    public $parentID;

    public function __construct($name, $type, $resultLog, $affectedRecords, $deletedRecords, $deleteStatementRecords, $sourceName, $sourceMethod, $sourceIP, $status)
    {
        $this->name = $name;
        $this->type = $type;
        $this->resultLog = $resultLog;
        $this->affectedRecords = $affectedRecords;
        $this->deletedRecords = $deletedRecords;
        $this->deleteStatementRecords = $deleteStatementRecords;
        $this->sourceName = $sourceName;
        $this->sourceMethod = $sourceMethod;
        $this->sourceIP = $sourceIP;
        $this->status = $status;
    }

    /**
     * @return mixed
     */
    public function getErpImportID()
    {
        return $this->erpImportID;
    }

    /**
     * @param mixed $erpImportID
     * @return ErpImport
     */
    public function setErpImportID($erpImportID)
    {
        $this->erpImportID = $erpImportID;
        return $this;
    }

    /**
     * @return mixed
     */
    public function getStartTime()
    {
        return $this->startTime;
    }

    /**
     * @param mixed $startTime
     * @return ErpImport
     */
    public function setStartTime($startTime)
    {
        $this->startTime = $startTime;
        return $this;
    }

    /**
     * @return mixed
     */
    public function getEndTime()
    {
        return $this->endTime;
    }

    /**
     * @param mixed $endTime
     * @return ErpImport
     */
    public function setEndTime($endTime)
    {
        $this->endTime = $endTime;
        return $this;
    }

    /**
     * @return mixed
     */
    public function getName()
    {
        return $this->name;
    }

    /**
     * @param mixed $name
     * @return ErpImport
     */
    public function setName($name)
    {
        $this->name = $name;
        return $this;
    }

    /**
     * @return mixed
     */
    public function getType()
    {
        return $this->type;
    }

    /**
     * @param mixed $type
     * @return ErpImport
     */
    public function setType($type)
    {
        $this->type = $type;
        return $this;
    }

    /**
     * @return mixed
     */
    public function getResultLog()
    {
        return $this->resultLog;
    }

    /**
     * @param mixed $resultLog
     * @return ErpImport
     */
    public function setResultLog($resultLog)
    {
        $this->resultLog = $resultLog;
        return $this;
    }

    /**
     * @return mixed
     */
    public function getAffectedRecords()
    {
        return $this->affectedRecords;
    }

    /**
     * @param mixed $affectedRecords
     * @return ErpImport
     */
    public function setAffectedRecords($affectedRecords)
    {
        $this->affectedRecords = $affectedRecords;
        return $this;
    }

    /**
     * @return mixed
     */
    public function getDeletedRecords()
    {
        return $this->deletedRecords;
    }

    /**
     * @param mixed $deletedRecords
     * @return ErpImport
     */
    public function setDeletedRecords($deletedRecords)
    {
        $this->deletedRecords = $deletedRecords;
        return $this;
    }

    /**
     * @return mixed
     */
    public function getDeleteStatementRecords()
    {
        return $this->deleteStatementRecords;
    }

    /**
     * @param mixed $deleteStatementRecords
     * @return ErpImport
     */
    public function setDeleteStatementRecords($deleteStatementRecords)
    {
        $this->deleteStatementRecords = $deleteStatementRecords;
        return $this;
    }


    /**
     * @return mixed
     */
    public function getSourceName()
    {
        return $this->sourceName;
    }

    /**
     * @param mixed $sourceName
     * @return ErpImport
     */
    public function setSourceName($sourceName)
    {
        $this->sourceName = $sourceName;
        return $this;
    }

    /**
     * @return mixed
     */
    public function getSourceMethod()
    {
        return $this->sourceMethod;
    }

    /**
     * @param mixed $sourceMethod
     * @return ErpImport
     */
    public function setSourceMethod($sourceMethod)
    {
        $this->sourceMethod = $sourceMethod;
        return $this;
    }

    /**
     * @return mixed
     */
    public function getSourceIP()
    {
        return $this->sourceIP;
    }

    /**
     * @param mixed $sourceIP
     * @return ErpImport
     */
    public function setSourceIP($sourceIP)
    {
        $this->sourceIP = $sourceIP;
        return $this;
    }

    /**
     * @return mixed
     */
    public function getStatus()
    {
        return $this->status;
    }

    /**
     * @param mixed $status
     * @return ErpImport
     */
    public function setStatus($status)
    {
        $this->status = $status;
        return $this;
    }


    public function start($db,$log='',$erpImportID=0)
    {
        $this->status      = 'Started';
        $this->resultLog   = $log;
        $this->erpImportID = $db->getNextInsertID('ERP_Import','erp_import_id');
        $this->parentID    = $this->erpImportID;
        $this->startTime   = date('Y-m-d H:i:s');

        if($erpImportID > 0){
            $this->parentID  = $erpImportID;
        }

        $db->insertUpdateErpImportByObject($this);
        return $this;

    }

    public function end($db,$log='',$alternativeStatus='')
    {
        $this->status  = 'Complete';
        $this->endTime = date('Y-m-d H:i:s');

        if(strcmp($alternativeStatus,'')!=0){
            $this->status = "$alternativeStatus";
        }

        if(strcmp($log,'')!=0) {
            $this->resultLog .= $log . "\n";
        }

        $db->insertUpdateErpImportByObject($this);
        return $this;
    }

    public function update($db,$log='')
    {
        if(strcmp($log,'')!=0) {
            $log = rtrim($log,"\n");
            $this->resultLog .= $log . "\n";
        }

        $db->insertUpdateErpImportByObject($this);
        return $this;
    }

    public function updateRecordsAffected($db,$affectedRecords,$deletedRecords,$deleteStatementRecords)
    {
        if($affectedRecords > 0){$this->affectedRecords = $affectedRecords;}
        if($deletedRecords > 0){$this->deletedRecords = $deletedRecords;}
        if($deleteStatementRecords > 0){$this->deleteStatementRecords = $deleteStatementRecords;}
        $db->insertUpdateErpImportByObject($this);

        return $this;
    }


}
?>
