<?php
class RouteManager {
    private $googleMapsApiKey;
    private $googleMapsMode;
    private $visitTime;
    private $lastArrivalTime;
    private $lastNextDepartureTime;
    private $lastDepartureTime;
    public function getGoogleMapsApiKey(){
        return $this->googleMapsApiKey;
    }

    public function setGoogleMapsApiKey($googleMapsApiKey){
        $this->googleMapsApiKey = $googleMapsApiKey;
    }

    public function getGoogleMapsMode(){
        return $this->googleMapsMode;
    }

    public function setGoogleMapsMode($googleMapsMode){
        $this->googleMapsMode = $googleMapsMode;
    }

    public function getVisitTime()
    {
        return $this->visitTime;
    }

    public function setVisitTime($visitTime)
    {
        $this->visitTime = $visitTime;
    }


    public function __construct($googleMapsMode="driving",$googleMapsApiKey="AIzaSyCXxVn57dN6LmM9EJuuVCHtGIvwK0fBNs4"){
        $this->googleMapsApiKey = $googleMapsApiKey;
        $this->googleMapsMode = $googleMapsMode;
        $this->visitTime = 30;
    }

//function for optimaze route
    public function optimizeRoute($dateTime,$objectWaypoints,$originObject= '',$destinationObject='',$destinationTime=''){

        $dateTime = $this->getAvailableRouteDateTime($dateTime);
        $destinationTime = $this->getAvailableRouteDateTime($destinationTime);
        $optimizedRoute = array();
        $faultCallbackCounter = 0;
        $faultCallbackLimit = count($objectWaypoints) + 1;

        $originObject->arrivalTimeTitle = date_format(date_create_from_format('Y-m-d H:i:s', $dateTime), 'H:i');
        $originObject->departureTime = $dateTime;
        $originObject->travelTime = (int)$originObject->travelTime;
        $originObject->visitTimeMinutes = (int)$originObject->visitTimeMinutes;

        if($originObject === ''){$originObject = array_shift($objectWaypoints);}

        array_push($optimizedRoute,$originObject);

        while (count($objectWaypoints)>0){

            $this->calculateDistance($objectWaypoints,end($optimizedRoute));

            usort($objectWaypoints, function($a, $b){
                return $a->travelTime > $b->travelTime ;
            });

            array_push($optimizedRoute,array_shift($objectWaypoints));

            $faultCallbackCounter++;
            if ($faultCallbackCounter >= $faultCallbackLimit){
                break;
            }
        }

        if ($destinationObject === ''){

        }else{
            $endObjectOptimazeRoute = end($optimizedRoute);
            $destinationObject->departureTime = $endObjectOptimazeRoute->nextDepartureTime;
            $dateTimeDT = new DateTime($destinationObject->departureTime);
            $travelTime = $this->getTravelTime($endObjectOptimazeRoute->lat, $endObjectOptimazeRoute->lng, $destinationObject->lat, $destinationObject->lng, strtotime($endObjectOptimazeRoute->nextDepartureTime));
            if($travelTime > 0) {
                $dateTimeDT->add(new DateInterval('PT' . (int)$travelTime . 'M'));
            }
            $arrivedTime = $dateTimeDT->format('Y-m-d H:i:s');
            $destinationObject->arrivalTime = $arrivedTime;
            $destinationObject->arrivalTimeTitle = date_format(date_create_from_format('Y-m-d H:i:s', $arrivedTime), 'H:i');
            $destinationObject->travelTime = $travelTime;
            $destinationObject->travelTimeTitle = "$travelTime";
            $destinationObject->visitTimeMinutes = 0;
            $destinationObject->nextDepartureTime = $arrivedTime;
            $destinationObject->nextDepartureTimeTitle = date_format(date_create_from_format('Y-m-d H:i:s', $arrivedTime), 'H:i');
            array_push($optimizedRoute,$destinationObject);
        }

        foreach ($optimizedRoute as $waypoint){
            if($waypoint->travelTime < 0){
                $this->logErrorOnObject($waypoint,'No Travel Time Detected.',"#fa8072");
            }

            if(strcmp($waypoint->lat,'')==0 || strcmp($waypoint->lng,'')==0){
                $this->logErrorOnObject($waypoint,'No Location Detected.',"#fa8072");
            } else if($waypoint->lat <= 0 || $waypoint->lng <= 0 ){
                $this->logErrorOnObject($waypoint,'Location Issue Detected.',"#fa8072");
            }

            $todaysDate = explode(' ',$dateTime)[0];
            $departureDate = explode(' ',$waypoint->nextDepartureTime)[0];


            if(strcmp($departureDate,'')!=0 && $todaysDate != $departureDate){
                $this->logErrorOnObject($waypoint,'No time available for Destination.',"#fa8072");
                $waypoint->departureTime = $this->lastDepartureTime;
                $waypoint->departureTimeTitle = '--:--';
                $waypoint->arrivalTime = $this->lastArrivalTime;
                $waypoint->arrivalTimeTitle = '--:--';
                $waypoint->nextDepartureTime = $this->lastNextDepartureTime;
                $waypoint->nextDepartureTimeTitle = '--:--';
            } else {
                $this->lastArrivalTime = $waypoint->arrivalTime;
                $this->lastNextDepartureTime = $waypoint->nextDepartureTime;
                $this->lastDepartureTime = $waypoint->departureTime;
            }
            if(strcmp($departureDate,'')!=0 && $destinationTime <= $waypoint->nextDepartureTime){
                $this->logErrorOnObject($waypoint,'No time available for  Destination.',"#fa8072");
                $waypoint->departureTime = $this->lastDepartureTime;
                $waypoint->departureTimeTitle = '--:--';
                $waypoint->arrivalTime = $this->lastArrivalTime;
                $waypoint->arrivalTimeTitle = '--:--';
                $waypoint->nextDepartureTime = $this->lastNextDepartureTime;
                $waypoint->nextDepartureTimeTitle = '--:--';
            } else {
                $this->lastArrivalTime = $waypoint->arrivalTime;
                $this->lastNextDepartureTime = $waypoint->nextDepartureTime;
                $this->lastDepartureTime = $waypoint->departureTime;
            }
        }
        return $optimizedRoute;
    }

//    new function
public function customOptimizeRoute($dateTime,$objectWaypoints,$originObject= '',$destinationObject='',$destinationTime=''){

    $dateTime = $this->getAvailableRouteDateTime($dateTime);
    $destinationTime = $this->getAvailableRouteDateTime($destinationTime);
    $optimizedRoute = array();
    $faultCallbackCounter = 0;
    $faultCallbackLimit = count($objectWaypoints) + 1;

    $originObject->arrivalTimeTitle = date_format(date_create_from_format('Y-m-d H:i:s', $dateTime), 'H:i');
    $originObject->departureTime = $dateTime;
    $originObject->travelTime = (int)$originObject->travelTime;
    $originObject->visitTimeMinutes = (int)$originObject->visitTimeMinutes;

    if($originObject === ''){$originObject = array_shift($objectWaypoints);}

    array_push($optimizedRoute,$originObject);

    $counterArray = 0;
    while (count($objectWaypoints)>$counterArray){

        $this->calculateSingleDistance($objectWaypoints[$counterArray],end($optimizedRoute));

        array_push($optimizedRoute,$objectWaypoints[$counterArray]);

        $counterArray++;

        $faultCallbackCounter++;
        if ($faultCallbackCounter >= $faultCallbackLimit){
            break;
        }
    }

    if ($destinationObject === ''){

    }else{
        $endObjectOptimazeRoute = end($optimizedRoute);
        $destinationObject->departureTime = $endObjectOptimazeRoute->nextDepartureTime;
        $dateTimeDT = new DateTime($destinationObject->departureTime);
        $travelTime = $this->getTravelTime($endObjectOptimazeRoute->lat, $endObjectOptimazeRoute->lng, $destinationObject->lat, $destinationObject->lng, strtotime($endObjectOptimazeRoute->nextDepartureTime));
        if($travelTime > 0) {
            $dateTimeDT->add(new DateInterval('PT' . (int)$travelTime . 'M'));
        }
        $arrivedTime = $dateTimeDT->format('Y-m-d H:i:s');
        $destinationObject->arrivalTime = $arrivedTime;
        $destinationObject->arrivalTimeTitle = date_format(date_create_from_format('Y-m-d H:i:s', $arrivedTime), 'H:i');
        $destinationObject->travelTime = $travelTime;
        $destinationObject->travelTimeTitle = "$travelTime";
        $destinationObject->visitTimeMinutes = 0;
        $destinationObject->nextDepartureTime = $arrivedTime;
        $destinationObject->nextDepartureTimeTitle = date_format(date_create_from_format('Y-m-d H:i:s', $arrivedTime), 'H:i');
        array_push($optimizedRoute,$destinationObject);
    }

    foreach ($optimizedRoute as $waypoint){
        if($waypoint->travelTime < 0){
            $this->logErrorOnObject($waypoint,'No Travel Time Detected.',"#fa8072");
        }

        if(strcmp($waypoint->lat,'')==0 || strcmp($waypoint->lng,'')==0){
            $this->logErrorOnObject($waypoint,'No Location Detected.',"#fa8072");
        } else if($waypoint->lat <= 0 || $waypoint->lng <= 0 ){
            $this->logErrorOnObject($waypoint,'Location Issue Detected.',"#fa8072");
        }

        $todaysDate = explode(' ',$dateTime)[0];
        $departureDate = explode(' ',$waypoint->nextDepartureTime)[0];


        if(strcmp($departureDate,'')!=0 && $todaysDate != $departureDate){

            if(strcmp("$this->lastArrivalTime","")==0){$this->lastArrivalTime = $dateTime;}
            if(strcmp("$this->lastNextDepartureTime","")==0){$this->lastNextDepartureTime = $dateTime;}
            if(strcmp("$this->lastDepartureTime","")==0){$this->lastDepartureTime = $dateTime;}

            $this->logErrorOnObject($waypoint,'No time available for Destination.',"#fa8072");
            $waypoint->departureTime = $this->lastDepartureTime;
            $waypoint->departureTimeTitle = '--:--';
            $waypoint->arrivalTime = $this->lastArrivalTime;
            $waypoint->arrivalTimeTitle = '--:--';
            $waypoint->nextDepartureTime = $this->lastNextDepartureTime;
            $waypoint->nextDepartureTimeTitle = '--:--';
        } else {
            $this->lastArrivalTime = $waypoint->arrivalTime;
            $this->lastNextDepartureTime = $waypoint->nextDepartureTime;
            $this->lastDepartureTime = $waypoint->departureTime;
        }
        if(strcmp($departureDate,'')!=0 && $destinationTime <= $waypoint->nextDepartureTime){
            $this->logErrorOnObject($waypoint,'No time available for Destination.',"#fa8072");
            $waypoint->departureTime = $this->lastDepartureTime;
            $waypoint->departureTimeTitle = '--:--';
            $waypoint->arrivalTime = $this->lastArrivalTime;
            $waypoint->arrivalTimeTitle = '--:--';
            $waypoint->nextDepartureTime = $this->lastNextDepartureTime;
            $waypoint->nextDepartureTimeTitle = '--:--';
        } else {
            $this->lastArrivalTime = $waypoint->arrivalTime;
            $this->lastNextDepartureTime = $waypoint->nextDepartureTime;
            $this->lastDepartureTime = $waypoint->departureTime;
        }
    }
    return $optimizedRoute;
}

//end new function

//function for view route
    public function calculateCustomRoute($dateTime,$objectWaypoints,$originObject= '',$destinationObject='',$destinationTime=''){

        $dateTime = $this->getAvailableRouteDateTime($dateTime);
        $optimizedRoute = array();
        $faultCallbackCounter = 0;
        $faultCallbackLimit = count($objectWaypoints) + 1;

        $originObject->departureTime = $dateTime;
        $originObject->color = "darkgoldenrod";
        $originObject->arrivalTimeTitle = date_format(date_create_from_format('Y-m-d H:i:s', $dateTime), 'H:i');
        $originObject->travelTime = (int)$originObject->travelTime;
        $originObject->visitTimeMinutes = (int)$originObject->visitTimeMinutes;

        if($originObject === ''){$originObject = array_shift($objectWaypoints);}

        array_push($optimizedRoute,$originObject);

        $counterArray = 0;
        while (count($objectWaypoints)>$counterArray){

            $this->calculateSingleDistance($objectWaypoints[$counterArray],end($optimizedRoute));

            array_push($optimizedRoute,$objectWaypoints[$counterArray]);

            $counterArray++;

            $faultCallbackCounter++;
            if ($faultCallbackCounter >= $faultCallbackLimit){
                break;
            }
        }
        if ($destinationObject === ''){

        }else{
            $endObjectOptimazeRoute = end($optimizedRoute);
            $destinationObject->departureTime = $endObjectOptimazeRoute->nextDepartureTime;
            $dateTimeDT = new DateTime($destinationObject->departureTime);
            $travelTime = $this->getTravelTime($endObjectOptimazeRoute->lat, $endObjectOptimazeRoute->lng, $destinationObject->lat, $destinationObject->lng, strtotime($endObjectOptimazeRoute->nextDepartureTime));
            if($travelTime > 0) {
                $dateTimeDT->add(new DateInterval('PT' . (int)$travelTime . 'M'));
            }
            $arrivedTime = $dateTimeDT->format('Y-m-d H:i:s');
            $destinationObject->arrivalTime = $arrivedTime;
            $destinationObject->arrivalTimeTitle = date_format(date_create_from_format('Y-m-d H:i:s', $arrivedTime), 'H:i');
            $destinationObject->travelTime = $travelTime;
            $destinationObject->travelTimeTitle = "$travelTime";
            $destinationObject->visitTimeMinutes = 0;
            $destinationObject->nextDepartureTime = $arrivedTime;
            $destinationObject->color = "darkgoldenrod";
            $destinationObject->nextDepartureTimeTitle = date_format(date_create_from_format('Y-m-d H:i:s', $arrivedTime), 'H:i');
            array_push($optimizedRoute,$destinationObject);
        }

        foreach ($optimizedRoute as $waypoint){

            if($waypoint->travelTime < 0){
                $this->logErrorOnObject($waypoint,'No Travel Time Detected.',"#fa8072");
            }

            if(strcmp($waypoint->lat,'')==0 || strcmp($waypoint->lng,'')==0){
                $this->logErrorOnObject($waypoint,'No Location Detected.',"#fa8072");
            } else if($waypoint->lat <= 0 || $waypoint->lng <= 0 ){
                $this->logErrorOnObject($waypoint,'Location Issue Detected.',"#fa8072");
            }

            $todaysDate = explode(' ',$dateTime)[0];
            $departureDate = explode(' ',$waypoint->nextDepartureTime)[0];

            if(strcmp($departureDate,'')!=0 && $todaysDate != $departureDate){
                $this->logErrorOnObject($waypoint,'No time available for Destination.',"#fa8072");
            }


        }

        return $optimizedRoute;
    }

    private function calculateSingleDistance($objectWaypoint,$lastWaypoint){
        $lastWaypointLat = $lastWaypoint->lat;
        $lastWaypointLng = $lastWaypoint->lng;
        $lastDepartureTime = $lastWaypoint->departureTime;
        $lastTravelTime = $lastWaypoint->travelTime;
        $lastVisitTimeMinutes = $lastWaypoint->visitTimeMinutes;

        try {
            if (strcmp($objectWaypoint->visitTimeMinutes, '') == 0) {
                $objectWaypoint->visitTimeMinutes = $this->getVisitTime();
            }

            $dateTimeLTT = new DateTime($lastDepartureTime);
            if($lastVisitTimeMinutes > 0) {
                $dateTimeLTT->add(new DateInterval('PT' . (int)$lastVisitTimeMinutes . 'M'));
            }
            if($lastTravelTime > 0){
                $dateTimeLTT->add(new DateInterval('PT' . (int)$lastTravelTime . 'M'));
            }
            $departureTime = $dateTimeLTT->format('Y-m-d H:i:s');

            $distance = $this->distance($lastWaypointLat, $lastWaypointLng, $objectWaypoint->lat, $objectWaypoint->lng, $unit = 'km');
            $travelTime = $this->getTravelTime($lastWaypointLat, $lastWaypointLng, $objectWaypoint->lat, $objectWaypoint->lng, strtotime($departureTime));

            $dateTimeDT = new DateTime($departureTime);
            if($travelTime > 0) {
                $dateTimeDT->add(new DateInterval('PT' . (int)$travelTime . 'M'));
            }
            $arrivedTime = $dateTimeDT->format('Y-m-d H:i:s');

            $dateTimeAT = new DateTime($arrivedTime);
            if($objectWaypoint->visitTimeMinutes > 0) {
                $dateTimeAT->add(new DateInterval('PT' . $objectWaypoint->visitTimeMinutes . 'M'));
            }
            $nextDepartureTime = $dateTimeAT->format('Y-m-d H:i:s');


            $objectWaypoint->distance = $distance;
            $objectWaypoint->travelTime = $travelTime;
            $objectWaypoint->departureTime = $departureTime;
            $objectWaypoint->arrivalTime = $arrivedTime;
            $objectWaypoint->nextDepartureTime = $nextDepartureTime;
            $objectWaypoint->travelTimeTitle = "$travelTime";
            $objectWaypoint->departureTimeTitle = date_format(date_create_from_format('Y-m-d H:i:s', $departureTime), 'H:i');
            $objectWaypoint->arrivalTimeTitle = date_format(date_create_from_format('Y-m-d H:i:s', $arrivedTime), 'H:i');
            $objectWaypoint->nextDepartureTimeTitle = date_format(date_create_from_format('Y-m-d H:i:s', $nextDepartureTime), 'H:i');
            if(strcmp($objectWaypoint->color,'')==0){$objectWaypoint->color = "#4782b4";}
            $objectWaypoint->error = '';
            $objectWaypoint->errorLine = 0;


        } catch (Exception $ex){
            $this->logErrorOnObject($objectWaypoint,$ex->getMessage().' - Line: '.$ex->getLine(),"#fa8072");
        }
        return $objectWaypoint;
    }

//return date valid to see the route from google api //p.x next valid Monday date
    public function getAvailableRouteDateTime($dateTime){
        $time = explode(" ",$dateTime)[1];
        $date = date('l', strtotime($dateTime));
        $dateFormat = new DateTime();
        $dateFormat->modify("next $date");

        $dateTime = $dateFormat->format('Y-m-d')." $time";

        return $dateTime;
    }
    private function calculateDistance($objectWaypoints,$lastWaypoint){

        $lastWaypointLat = $lastWaypoint->lat;
        $lastWaypointLng = $lastWaypoint->lng;
        $lastDepartureTime = $lastWaypoint->departureTime;
        $lastTravelTime = $lastWaypoint->travelTime;
        $lastVisitTimeMinutes = $lastWaypoint->visitTimeMinutes;

            foreach ($objectWaypoints as $waypoint) {
                try {
                    if (strcmp($waypoint->visitTimeMinutes, '') == 0) {
                        $waypoint->visitTimeMinutes = $this->getVisitTime();
                    }


                    $dateTimeLTT = new DateTime($lastDepartureTime);
                    if($lastVisitTimeMinutes > 0) {
                        $dateTimeLTT->add(new DateInterval('PT' . (int)$lastVisitTimeMinutes . 'M'));
                    }
                    if($lastTravelTime > 0){
                        $dateTimeLTT->add(new DateInterval('PT' . (int)$lastTravelTime . 'M'));
                    }
                    $departureTime = $dateTimeLTT->format('Y-m-d H:i:s');

                    $distance = $this->distance($lastWaypointLat, $lastWaypointLng, $waypoint->lat, $waypoint->lng, $unit = 'km');
                    $travelTime = $this->getTravelTime($lastWaypointLat, $lastWaypointLng, $waypoint->lat, $waypoint->lng, strtotime($departureTime));

                    $dateTimeDT = new DateTime($departureTime);
                    if($travelTime > 0) {
                        $dateTimeDT->add(new DateInterval('PT' . (int)$travelTime . 'M'));
                    }
                    $arrivedTime = $dateTimeDT->format('Y-m-d H:i:s');

                    $dateTimeAT = new DateTime($arrivedTime);
                    if($waypoint->visitTimeMinutes > 0) {
                        $dateTimeAT->add(new DateInterval('PT' . $waypoint->visitTimeMinutes . 'M'));
                    }
                    $nextDepartureTime = $dateTimeAT->format('Y-m-d H:i:s');


                    $waypoint->distance = $distance;
                    $waypoint->travelTime = $travelTime;
                    $waypoint->departureTime = $departureTime;
                    $waypoint->arrivalTime = $arrivedTime;
                    $waypoint->nextDepartureTime = $nextDepartureTime;
                    $waypoint->travelTimeTitle = "$travelTime";
                    $waypoint->departureTimeTitle = date_format(date_create_from_format('Y-m-d H:i:s', $departureTime), 'H:i');
                    $waypoint->arrivalTimeTitle = date_format(date_create_from_format('Y-m-d H:i:s', $arrivedTime), 'H:i');
                    $waypoint->nextDepartureTimeTitle = date_format(date_create_from_format('Y-m-d H:i:s', $nextDepartureTime), 'H:i');
                    $waypoint->color = "#4782b4";
                    $waypoint->error = '';
                    $waypoint->errorLine = 0;


                } catch (Exception $ex){
                    $this->logErrorOnObject($waypoint,$ex->getMessage().' - Line: '.$ex->getLine(),"#fa8072");
                }

            }

        return $objectWaypoints;
    }

    private function logErrorOnObject($object,$error,$color=''){
        if(!is_array($object->errors)){$object->errors = array();}
        if(!in_array($error,$object->errors)){array_push($object->errors, $error);}
        if(strcmp($color,'')!=0){$object->color=$color;}
    }
    public function distance($lat1, $lng1, $lat2, $lng2, $unit = 'km') {
        $radius = $unit == 'km' ? 6371 : 6371000;
        $radius=6371000;
        $lat_diff = deg2rad($lat2 - $lat1);
        $lng_diff = deg2rad($lng2 - $lng1);
        $a = sin($lat_diff / 2) * sin($lat_diff / 2) + cos(deg2rad($lat1)) * cos(deg2rad($lat2)) * sin($lng_diff / 2) * sin($lng_diff / 2);
        $c = 2 * atan2(sqrt($a), sqrt(1 - $a));
        $distance = $radius*$c;
        return $distance;
    }

    private function getTravelTime($originLat, $originLng, $destinationLat, $destinationLng,$departureTimeFormat) {
        $apiKey = $this->googleMapsApiKey;
        $mode = $this->googleMapsMode;
        $url = "https://maps.googleapis.com/maps/api/directions/json?origin=" . $originLat . "," . $originLng . "&destination=" . $destinationLat . "," . $destinationLng . "&mode=" . $mode . "&departure_time=" . $departureTimeFormat . "&traffic_model=best_guess". "&key=" . $apiKey;
        $ch = curl_init($url);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        $response = curl_exec($ch);
        curl_close($ch);
        $data = json_decode($response, true);
        if ($data['status'] === 'OK' && isset($data['routes'][0]['legs'][0]['duration']['value'])) {
            $travelTimeInSeconds = $data['routes'][0]['legs'][0]['duration_in_traffic']['value'];
            $travelTimeInMinutes = round($travelTimeInSeconds / 60);
            return $travelTimeInMinutes;
        } else {
            return -1;
        }
    }

    public function optimazeRouteHtmlButton(){
        return "<button class='btn btn-success btn-block' onclick=\"$('#updateOptimazeRouteCalendarModal').modal('show');\"  >Optimize Route</button>";
    }

    public function changeLocationHtmlButton($buttonName,$addressID,$locationIDfield,$locationIDtable,$lat,$lng,$displayName,$markerCounter){
        $lat = (float)$lat;
        $lng = (float)$lng;
        return "<button class='btn btn-primary' style='border-radius: 0 8px 8px 0;padding-bottom:5px;padding-top:5px;opacity: 0.8' onclick=\"initLocationUpdateMap('$addressID','$locationIDfield','$locationIDtable',$lat,$lng,'$displayName','$markerCounter')\">$buttonName</button>";
    }

    public function createHtmlList($objectArray,$includeOptimizeButton=true,$changeLocation=false){
        $markerCounter = 0;
        $resultLIST = '';
        $resultListModal = '';

        $this->createModalForMarker($objectArray);

        if ($includeOptimizeButton){
            $button = $this->optimazeRouteHtmlButton();
            $resultLIST .= "<li class='list-group-item' style='color:white;background-color:#dbdbdb;opacity:1;border:0.5px solid white;font-family: Sans-serif, Verdana;padding: 0px;';>
                            <center>
                                $button
                            </center>
                        </li>";
        }

        foreach ($objectArray as $objectCustomer){
            $visitTimeMinutesLabel = "";
            $errors = "";
            $codeLabel = "";
            $titleLabel = "";
            $titleColor = '#386890';
            $buttonChangeLocation = '';
            $travelTimeTitle = $objectCustomer->travelTimeTitle;
            $arrivedTimeDisplay = $objectCustomer->arrivalTimeTitle;
            $visitTimeMinutes = $objectCustomer->visitTimeMinutes;
            $nextDepartureTimeDisplay = $objectCustomer->nextDepartureTimeTitle;
            $code = $objectCustomer->code;
            $departureTimeDisplay=$objectCustomer->departureTimeTitle;
            $color = $objectCustomer->color;
            $displayName = $objectCustomer->name;
            $title = $objectCustomer->title;
            $htmlModalElement = $objectCustomer->htmlElementToModal;
            $markerCounter++;



            if($objectCustomer->travelTime <= 0){
                $travelTimeTitle = "0";
            }

            if (strcmp($departureTimeDisplay,'')==0){
                $departureTimeDisplay= date_format(date_create_from_format('Y-m-d H:i:s', $objectCustomer->departureTime), 'H:i');
            }

            if(strlen($objectCustomer->name) > 28){
                $displayName = substr($objectCustomer->name, 0, 25)."...";
            }

            if(strlen($title) > 30){
                $title = substr($title, 0, 27)."...";
            }

            if(strcmp($objectCustomer->name,'')==0){
                $displayName = $objectCustomer->code;
            }

            if(strcmp($objectCustomer->title,'')!=0){
                $titleLabel = "<div style='width: 100%;'  title='$objectCustomer->title'><center>$title</center></div>";
            }

            if(strcmp($departureTimeDisplay,'')!=0){
                $travelTimeLabel = "<span class='pull-right'><i class='fa fa-lg fa-fw fa-arrow-down text-color-grey'></i> $departureTimeDisplay</span>";
            }

            if(strcmp($arrivedTimeDisplay,'')!=0){
                $travelTimeLabel .= "<br><span class='pull-left' ><i class='fa fa-lg fa-fw fa-truck text-color-grey'></i> $travelTimeTitle minutes</span>";

                $arrivedTimeLabel = "<span class='pull-right'><i class='fa fa-lg fa-fw fa-clock-o text-color-grey'></i> $arrivedTimeDisplay</span> ";
            }


            if($visitTimeMinutes > 0){
                $visitTimeMinutesLabel = "<br><span class='pull-left'>&nbsp;<img  src='//".HTML_PATH."/cop/backend/themes/smartadmin/img/visiticon.png' width='18' height='18'>  $visitTimeMinutes minutes </span><span class='pull-right'><i class='fa fa-lg fa-fw fa-clock-o text-color-grey'></i> $nextDepartureTimeDisplay</span>  ";
            }

            if(strcmp($code,'')!=0){
                $serviceCalls = trim($code,',');
                $codeLabel = "<span class='pull-left' ><i class='fa fa-lg fa-fw fa-gear text-color-black'></i> $code</span>";
            }

            if(strcmp($color,'')==0){
                $color = '#4782b4';
            }

            foreach ($objectCustomer->errors as $error){
                $errors = "<div style='width: 100%;font-weight: bold;'><center>$error</center></div>";
                $titleColor = "firebrick";
            }

            if (strcmp($objectCustomer->locationIDfield,'')!=0 && strcmp($objectCustomer->locationIDtable,'')!=0 && $changeLocation){
                if($objectCustomer->addressID>0) {
                    $buttonChangeLocation = $this->changeLocationHtmlButton('<i class="fa fa-map-marker"></i>',$objectCustomer->addressID, $objectCustomer->locationIDfield, $objectCustomer->locationIDtable, $objectCustomer->lat, $objectCustomer->lng, $displayName, $markerCounter);
                } else {
                    $errors = "<div style='width: 100%;font-weight: bold;'><center>No Matching Address Found</center></div>";
                }
            }
            $style='color:white;background-color:'.$color.';opacity:1;border:0.5px solid white;font-family: Sans-serif, Verdana;';

            $resultLIST .= "<li class='list-group-item' style='$style'>
                                
                                <div>$errors</div>
                                <div style='width:100%;cursor:pointer;background-color:$color;margin-bottom:4px;border-radius:8px;display:flex;box-shadow: rgba(0, 0, 0, 0.17) 0px -23px 25px 0px inset, rgba(0, 0, 0, 0.15) 0px -36px 30px 0px inset, rgba(0, 0, 0, 0.1) 0px -79px 40px 0px inset;' title='$objectCustomer->name' >
                                    <div style='border-radius:8px 0 0 8px;background-color:#dfecf2;color:$color;width:22px;padding: 6px 2px;font-weight:bold;' onclick=\"\$('#modalInfoLocationForList$markerCounter').modal('show');\">
                                        <center>$markerCounter</center>
                                    </div> 
                                    <div style='padding: 6px;' onclick=\"\$('#modalInfoLocationForList$markerCounter').modal('show');\">$displayName</div>
                                    <div style='position: absolute;right: 14px;'>$buttonChangeLocation</div>
                                </div>
                                $titleLabel 
                                $codeLabel 
                                $travelTimeLabel 
                                $arrivedTimeLabel 
                                $visitTimeMinutesLabel 
                                <br> 
                            </li>";

            $resultListModal .= '<div id="modalInfoLocationForList'.$markerCounter.'" class="modal fade" role="dialog">
                                    <div class="modal-dialog">
                                        <div class="modal-content">
                                            <div class="modal-header">
                                                <button type="button" class="close" data-dismiss="modal">&times;</button>
                                                <center><b><h2 class="modal-title" style="letter-spacing: 0.5rem;font-weight: bold">'.$markerCounter.'</h2></b></center>
                                            </div>
                                            <div class="modal-body">
                                                '.$htmlModalElement.'
                                            </div>
                                            <div class="modal-footer">
                                                <button type="button" class="btn btn-link pull-right" onclick="$(\'#modalInfoLocationForList'.$markerCounter.'\').modal(\'hide\');" >Close</button>
                                            </div>
                                        </div>
                                    </div>
                                </div>';
        }


        return $resultLIST.$resultListModal;
    }

    public function createModalForMarker($objectArray){
        $counter=0;
        foreach ($objectArray as $objectCustomer){
            $counter++;
            $departureTime=$objectCustomer->departureTimeTitle;
            $travelTimeTitle = $objectCustomer->travelTimeTitle;
            $arrivedTime = $objectCustomer->arrivalTimeTitle;
            $visitTimeMinutes = $objectCustomer->visitTimeMinutes;
            $nextDepartureTime = $objectCustomer->nextDepartureTimeTitle;
            $code = $objectCustomer->code;
            if (strcmp($travelTimeTitle,'')==0){
                $travelTimeTitle=0;
            }
            if(strlen($objectCustomer->name) > 28){
                $displayName = substr($objectCustomer->name, 0, 25)."...";
            }else{
                $displayName = $objectCustomer->name;
            }
            if(strcmp($objectCustomer->name,'')==0){
                $displayName = $objectCustomer->code;
            }

            $table = "
                <table class='table' style='border-collapse: collapse;'>
                    <caption style='background-color: #386890;letter-spacing: 0.2rem;color: whitesmoke;'><h5>$displayName</h5></caption>
                    <tr>
                        <td style='border: 1px solid grey;background-color: #dfecf2;text-align: left !important;width: 50%;'><b>Code</b></td>
                        <td style='border: 1px solid grey;background-color: #dfecf2'>$code</td>
                    </tr>
                    ";
            if (strcmp($departureTime,'')!=0){
                $table .= "
                    <tr>
                        <td style='border: 1px solid grey;background-color: #dfecf2;text-align: left !important;'><b>Departure Time</b></td>
            
                        <td style='border: 1px solid grey;background-color: #dfecf2'>$departureTime</td>
                    </tr>";
            }

            $table .= "
                   
                <tr>
                    <td colspan='2'>
                       <div>
                        <h5><b>Travel Time: </b><span style='color: #386890'>$travelTimeTitle minutes</span></h5>
                        <i class='fa fa-lg fa-fw fa-arrow-down text-color-grey'></i>
                       </div>
                    </td>
                </tr>
                
                <tr>
                    <td style='border: 1px solid grey;background-color: #dfecf2;text-align: left !important;'><b>Arrived Time</b></td>
                    <td style='border: 1px solid grey;background-color: #dfecf2'>$arrivedTime</td>
                </tr>";
            if (strcmp($nextDepartureTime,'')!=0){
                $table .= "
                     <tr>
                        <td colspan='2'>
                           <div>
                            <h5><b>Visit Time: </b><span style='color: #386890;text-align: left !important;'>$visitTimeMinutes minutes</span></h5>
                            <i class='fa fa-lg fa-fw fa-arrow-down text-color-grey'></i>
                           </div>
                        </td>
                    </tr>
                    
                    <tr>
                        <td style='border: 1px solid grey;background-color: #dfecf2;text-align: left !important;'><b>Next Departure Time</b></td>
                        <td style='border: 1px solid grey;background-color: #dfecf2'>$nextDepartureTime</td>
                    </tr>
                    
                   
                ";
            }
            $table .= " </table>";

            $objectCustomer->counter = $counter;
            $objectCustomer->counterString = "$counter";
            $objectCustomer->htmlElementToModal = $table;
        }
    }

//return json with schedule_start and schedule_end to update service call in asing service call calendar
    public function createServiceCallCalendarEventsJson($dateTime,$objectArray){
        $date =date_format( date_create_from_format('Y-m-d H:i:s', $dateTime), 'Y-m-d');
        $checkErrorInArray = false;
        $objectForCalendar = array();
        foreach ($objectArray as $object){
            if (isset($object->errors) && count($object->errors)>0){
                $checkErrorInArray = true;
            }
            if($object->id > 0) {
                $obj = new StdClass();
                $obj->schedule_start_date = $date.' '.date_format( date_create_from_format('Y-m-d H:i:s', $object->arrivalTime), 'H:i:s');
                $obj->schedule_end_date = $date.' '.date_format( date_create_from_format('Y-m-d H:i:s', $object->nextDepartureTime), 'H:i:s');
                $obj->service_call_id = $object->id;

                array_push($objectForCalendar, $obj);
            }
        }
        if ($checkErrorInArray){
            return json_encode($objectForCalendar);
        }else{
            return json_encode($objectForCalendar);
        }

    }
//return json with position to update schedule
    public function createScheduleJson($dateTime,$objectArray){
        $date =date_format( date_create_from_format('Y-m-d H:i:s', $dateTime), 'Y-m-d');
        $checkErrorInArray = false;
        $objectForCalendar = array();
        $counter=1;
        foreach ($objectArray as $object){
            if (isset($object->errors) && count($object->errors)>0){
                $checkErrorInArray = true;
            }

            $obj = new StdClass();
            $obj->scheduleCustomerID = $object->id;
            $obj->position = $counter;

            if($object->id > 0) {
                array_push($objectForCalendar, $obj);
                $counter++;
            }
        }
        if ($checkErrorInArray){
            return json_encode($objectForCalendar);
        }else{
            return json_encode($objectForCalendar);
        }

    }


    public function updateServiceCallCalendarEvents($classDB,$objectArray){
        try {
            $classDB->begin_transaction();

            foreach ($objectArray as $object) {
                $stmt = $classDB->prepare("UPDATE Service_Call SET schedule_start_date = ?,schedule_end_date = ? WHERE service_call_id = ?");
                $stmt->bind_param('ssi', $object->schedule_start_date, $object->schedule_end_date, $object->service_call_id);
                $stmt->execute();
                if (strcmp($stmt->error, "") != 0) {
                    throw new Exception();
                }
                $stmt->close();
            }
            $classDB->commit(true);
            return "";
        } catch (Exception  $e) {
            return 'error';
            $classDB->rollback();
        }
    }

    public function updateSchedulePositionForMap($classDB,$objectArray){
        try {
            $classDB->begin_transaction();

            foreach ($objectArray as $object) {
                $stmt = $classDB->prepare("UPDATE Schedule_Customer SET position = ? WHERE schedule_customer_id = ?");
                $stmt->bind_param('ii', $object->position,$object->scheduleCustomerID);
                $stmt->execute();
                if (strcmp($stmt->error, "") != 0) {
                    throw new Exception();
                }
                $stmt->close();
            }
            $classDB->commit(true);
            return "";
        } catch (Exception  $e) {
            return 'error';
            $classDB->rollback();
        }
    }



    public function createModalForOptimization($objectArray,$optimizeButtonFunction){
        $counter = 0;
        $checkForError = false;
        $checkForResourcesError = false;
        $resultMsg = "<h3>Please, fix the errors before optimizing the Route.</h3><table class='table'>";
        foreach ($objectArray as $object){
            $counter++;
            $title = '';
            foreach ($object->errors as $error){
                $title .= "<div style='width: 100%;font-weight: bold;'><center>$error</center></div>";
            }

            if(!empty($object->OccupiedResources)) {
                $title .= "<center>
                             <table style='width: 100%;'>
                                <tr>
                                    <td style='border: 1px solid rgba(128,128,128,0.5);background-color: lightskyblue;'>Resource</td>
                                    <td style='border: 1px solid rgba(128,128,128,0.5);;background-color: lightskyblue;'>Reference</td>
                                    <td style='border: 1px solid rgba(128,128,128,0.5);;background-color: lightskyblue;'>Start</td>
                                    <td style='border: 1px solid rgba(128,128,128,0.5);;background-color: lightskyblue;'>End</td>
                                </tr>
                ";
                foreach ($object->OccupiedResources as $resource) {
                    $checkForResourcesError = true;
                    $scheduleStart = str_replace(' ', '<br>', date_format(date_create_from_format('Y-m-d H:i:s', $resource->serviceCallstartDate), 'H:i d/m/y'));
                    $scheduleEnd = str_replace(' ', '<br>', date_format(date_create_from_format('Y-m-d H:i:s', $resource->serviceCallendDate), 'H:i d/m/y'));
                    $salesPersonInfo = str_replace(' - ', '<br>', $resource->salesPersonInfo);
                    $title .= "<tr>
                                    <td style='border: 1px solid  rgba(128,128,128,0.5);;padding: 5px;'>$salesPersonInfo</td>
                                    <td style='border: 1px solid  rgba(128,128,128,0.5);;padding: 5px;'>$resource->serviceCallCode</td>
                                    <td style='border: 1px solid  rgba(128,128,128,0.5);;padding: 5px;'>$scheduleStart</td>
                                    <td style='border: 1px solid  rgba(128,128,128,0.5);;padding: 5px;'>$scheduleEnd</td>
                               </tr>";
                }

                $title .= "</table></center>";
            }

            if (strcmp($title,'')!=0){
                $checkForError = true;
                $resultMsg .="
                <tr>
                    <td style='border: 1px solid grey;'>$counter</td>
                    <td style='border: 1px solid grey;'>$object->name</td>
                    <td style='border: 1px solid grey;'>$title</td>
                </tr>
                ";
            }


        }
        $resultMsg .= "</table>";
        if ($checkForResourcesError){
            $style = "style='display:none;";
        }else{
            $resultMsgResources = '';
            $resultMsg = "<h3>You are about to Optimize this Route.<br>Are you sure?</h3>";
        }
        $modal = "<div id='updateOptimazeRouteCalendarModal' class='modal fade' role='dialog'>
                    <div class='modal-dialog'>
                        <div class='modal-content'>
                            <div class='modal-header'>
                                <button type='button' class='close' data-dismiss='modal'>&times;</button>
                                <center><h4 class='modal-title'>Optimize Route</h4></center>
                            </div>
                            <div class='modal-body'>
                                <center>
                                        $resultMsg
                                        $resultMsgResources
                                </center>
                            </div>
                            <div class='modal-footer'>
                                <button type='button' class='btn btn-success pull-left' $style data-dismiss='modal' onclick='$optimizeButtonFunction'>Optimize Route</button>
                                <button type='button' class='btn btn-link pull-right' onclick=\"$('#updateOptimazeRouteCalendarModal').modal('hide');\" >Close</button>
                            </div>
                        </div>
                    </div>
                </div>";

        return $modal;
    }
    public function changeCustomerLocation($classDB,$lat,$lng,$table,$field,$addressID){
        try {
            $classDB->begin_transaction();
            $stmt = $classDB->prepare("UPDATE $table SET lat = ?,lng = ? WHERE $field = ?");
            $stmt->bind_param('ddi', $lat, $lng, $addressID);
            $stmt->execute();
            if (strcmp($stmt->error, "") != 0) {
                throw new Exception();
            }
            $stmt->close();

            $classDB->commit(true);
            return "";
        } catch (Exception  $e) {
            $classDB->rollback();
            return 'error';
        }
    }

    public function changeLocationModal(){
        $modal = "<div class='modal fade' id='locationModal' tabindex='-1' role='dialog' aria-labelledby='appInfoLabel' aria-hidden='true'>
                        <div class='modal-dialog'>
                            <div class='modal-content'>
                                <div class='modal-header'>
                                    <button type='button' class='close' data-dismiss='modal' aria-hidden='true'>&times;</button>
                                    <h4 class='modal-title' style='margin-left:10px;'><i class='fa fa-lg fa-fw fa-map-marker'></i>
                                        <strong style='padding-left:5px;' id='modalChangeLocationCounter'></strong><strong style='padding-left:5px;' id='modalChangeLocationTitle'></strong></h4>
                                </div>
                                
                                <div class='modal-body' style='margin-top:5px;padding-top:5px;'>
                                    <center>
                                        <input id='searchLocation' class='controls form-control pac-container' type='text' placeholder='Search for address' style='height: 39px;font-weight: bold;width: 50% !important;margin-top:10px !important;margin-left:32% !important;'>
                                        <div class='google_maps' style='height:300px; width:100%;   border-radius: 25px;' id='locationUpdateMap' ></div>
                                </div>
                    
                                <footer class='modal-footer' >
                                    <input type='hidden' value='' id='locationUpdateID'>
                                    <input type='hidden' value='' id='locationUpdateField'>
                                    <input type='hidden' value='' id='locationUpdateTable'>
                                    <input type='hidden' value='' id='locationUpdateLat'>
                                    <input type='hidden' value='' id='locationUpdateLng'>
                                    <button type='button' class='btn btn-success pull-left'  onclick='changeLocation();'>Update Location</button>
                                    <button type='button' class='btn btn-link pull-right' onclick=\"$('#locationModal').modal('hide');\" >Close</button>
                                </footer>
                            </div><!-- /.modal-content -->
                        </div><!-- /.modal-dialog -->
                    </div><!-- /.modal -->
                    <style>
                        .pac-container {
                            z-index: 1051 !important;
                        }
                    </style>
                    
                    <script type='text/javascript'>
                        
                        function initLocationUpdateMap(addressID,field,table,lat,lng,title,markerCounter) {
                            $('#modalChangeLocationCounter').html(markerCounter);
                            $('#modalChangeLocationTitle').html(title);
                            $('#locationUpdateID').val(addressID);
                            $('#locationUpdateField').val(field);
                            $('#locationUpdateTable').val(table);
                            $('#locationUpdateLat').val(lat);
                            $('#locationUpdateLng').val(lng);
                            
                            
                            var infowindow = new google.maps.InfoWindow();
                    
                            var zoom = 15;
                            var hasMarker = true;
                            if((lat===0  && lng===0) || Number.isNaN(lat) || Number.isNaN(lng)){
                                lat = 35.1264;
                                lng = 33.4299;
                                zoom = 8;
                                var hasMarker = false;
                            }
                            console.log(lat);
                            console.log(lng);
                            var updateLocationMap = new google.maps.Map(document.getElementById('locationUpdateMap'), {
                                center: {lat: lat, lng: lng},
                                zoom: zoom,
                                mapTypeControl: true,
                                streetViewControl: false,
                                zoomControl: true
                            });
                    
                            var input = document.getElementById('searchLocation');
                            $('#searchLocation').val('');
                            
                            var autocomplete = new google.maps.places.Autocomplete(input);
                            autocomplete.bindTo('bounds', updateLocationMap);
                            
                           
                            
                            if(hasMarker) {
                                var copMarker = new google.maps.Marker({
                                    position: {lat: lat, lng: lng},
                                    map: updateLocationMap,
                                    draggable: true
                                });
                            } else {
                                var copMarker = new google.maps.Marker({
                                    position: {lat: 0, lng: 0},
                                    map: updateLocationMap,
                                    draggable: true
                                });
                            }
                    
                    
                            copMarker.addListener('mouseout', function() {
                                var newLat = copMarker.getPosition().lat();
                                var newLng = copMarker.getPosition().lng();
                                $('#locationUpdateLat').val(newLat);
                                $('#locationUpdateLng').val(newLng);
                                $('#locationUpdateLat').trigger('change');
                                $('#locationUpdateLng').trigger('change');
                            });
                    
                            autocomplete.addListener('place_changed', function () {
                                infowindow.close();
                                copMarker.setVisible(false);
                                var place = autocomplete.getPlace();
                                
                                if (!place.geometry) {
                                    window.alert('Autocomplete returned place contains no geometry');
                                    return;
                                }
                    
                                if (place.geometry.viewport) {
                                    updateLocationMap.fitBounds(place.geometry.viewport);
                                } else {
                                    updateLocationMap.setCenter(place.geometry.location);
                                    updateLocationMap.setZoom(17);
                                }
                    
                                copMarker.setPosition(place.geometry.location);
                                copMarker.setVisible(true);
                                var location = place.geometry.location;
                    
                               
                                $('#locationUpdateLat').val(location.lat());
                                $('#locationUpdateLng').val(location.lng());
                                $('#locationUpdateLat').trigger('change');
                                $('#locationUpdateLng').trigger('change');
                              
                            });
                            $('#locationModal').modal('show');
                    }
                    </script>";

        return $modal;
    }

    public function checkForRouteWithResources($classDB,$objectArray,$dateTime){

        $date =date_format( date_create_from_format('Y-m-d H:i:s', $dateTime), 'Y-m-d');

        foreach ($objectArray as $object){

            $todayDepartureTime = $date.' '.date_format( date_create_from_format('Y-m-d H:i:s', $object->departureTime), 'H:i:s');

            if(strcmp("$object->nextDepartureTime","")!=0) {
                $todayNextDepartureTime = $date . ' ' . date_format(date_create_from_format('Y-m-d H:i:s', $object->nextDepartureTime), 'H:i:s');
            }else{
                $todayNextDepartureTime = $date . ' ' . date_format(date_create_from_format('Y-m-d H:i:s', $object->departureTime), 'H:i:s');
            }
            $arraySalesPersnonReferInServiceCall = array();
            $stm = $classDB->prepare("SELECT SC_Referred_To.`salesperson_id` FROM `SC_Referred_To`,Service_Call WHERE Service_Call.service_call_id=SC_Referred_To.service_call_id AND Service_Call.service_call_id = '$object->id';");
            $stm->execute();
            $stm->bind_result($salesPersonIDSC);
            while ($stm->fetch()) {
                array_push($arraySalesPersnonReferInServiceCall,$salesPersonIDSC);
            }
            $stm->close();

            $referSalesPersonInfoOverLap = array();
            if (count($arraySalesPersnonReferInServiceCall)>0){
                $arraySalesPersnonRefer = array();
                $stm = $classDB->prepare("SELECT SC_Referred_To.`salesperson_id`,Service_Call.schedule_start_date,Service_Call.schedule_end_date,Service_Call.service_call_code,CONCAT(salesperson_code,' - ',first_name,' ',last_name) 
                                           FROM `SC_Referred_To`,Service_Call,SalesPersons 
                                           WHERE Service_Call.service_call_id=SC_Referred_To.service_call_id AND SalesPersons.salesperson_id = SC_Referred_To.salesperson_id
                                             AND (                                                      
                                             (Service_Call.schedule_start_date<'$todayNextDepartureTime' AND Service_Call.schedule_end_date>'$todayDepartureTime') 
                                             OR                                                   
                                             (Service_Call.schedule_start_date<'$todayNextDepartureTime' AND Service_Call.schedule_end_date>'$todayNextDepartureTime')
                                             )                                                   
                                             AND NOT Service_Call.service_call_id ='$object->id'  ");
                $stm->execute();
                $stm->bind_result($salesPersonID,$startDate,$endDate,$scCode,$salesPersonInfo);
                while ($stm->fetch()) {
                    $infoReferTo = new stdClass();
                    $infoReferTo->salesPersonID = $salesPersonID;
                    $infoReferTo->salesPersonInfo = $salesPersonInfo;
                    $infoReferTo->serviceCallCode = $scCode;
                    $infoReferTo->serviceCallstartDate = $startDate;
                    $infoReferTo->serviceCallendDate = $endDate;
                    array_push($referSalesPersonInfoOverLap,$infoReferTo);
                    array_push($arraySalesPersnonRefer,$salesPersonID);
                }
                $stm->close();

            }else{
                $arraySalesPersnonRefer = array();
            }
            $salesPersonErrorWithResources = array();
            foreach ($referSalesPersonInfoOverLap as $referSalesPerson){
                if (in_array($referSalesPerson->salesPersonID,$arraySalesPersnonReferInServiceCall)){
                    array_push($salesPersonErrorWithResources,$referSalesPerson);
                }
            }
            $result = array_intersect($arraySalesPersnonReferInServiceCall, $arraySalesPersnonRefer);
            if (count($result)>0){
                $object->OccupiedResources = $salesPersonErrorWithResources;
                $this->logErrorOnObject($object,'Resources Occupied',"#fa8072");
            }

        }
    }
}
?>
