<?php

//error_reporting(0);
include_once("../../../../param.php");
require_once (ROOT . "libs/mPDF/vendor/autoload.php");


function isImage($filename) {
    $validExtensions = ['jpg', 'jpeg', 'png', 'gif', 'bmp', 'webp'];

    $lastDotPosition = strrchr($filename, '.');

    if (!$lastDotPosition) {
        return false;
    }
    // remove the dot
    $fileExtension = strtolower(substr($lastDotPosition, 1));

    return in_array($fileExtension, $validExtensions);
}
function getServiceCallPDFForPrinting($orderID)
{
    global $username, $password, $database;
    require_once( ROOT . "concc/dbhelpers/classes/DBCustomer.php");
    require_once( ROOT . "concc/dbhelpers/classes/DBItem.php");

    $db = new mysqli('localhost', $username, $password, $database);
    if (mysqli_connect_errno()) {
        printf("Connect failed: %s\n", mysqli_connect_error());
        exit();
    }
    $db->set_charset("utf8");

    $dbHelbelCustomer= new DBCustomer();
    $dbHelbelItem= new DBItem();

    $stm = $db->prepare("SELECT service_call_id,service_call_code,salesperson_id,assign_to,customer_id,customer_address_id,serial_number_id,source_id,type_id,status_id,priority_id,topic,details,source_name,source_details,date,due_date,timestamp FROM Service_Call WHERE service_call_id='$orderID'");
    $stm->execute();
    $stm->bind_result($serviceCallIDFromQuery,$serviceCallCode,$salespersonID,$assignTo,$customerID,$customerAddressID,$scSerialNumbnerID,$sourceID,$typeID,$statusID,$priorityID,$topic,$details,$sourceName,$sourceDetails,$date,$dueDate, $timestamp);
    while ($stm->fetch()) {

        $customer=$dbHelbelCustomer->getCustomerByID($customerID);
        $db2= new mysqli(localhost,$username,$password,$database);
        if (mysqli_connect_errno())
        {
            printf("Connect failed: %s\n", mysqli_connect_error());
            exit();
        }
        $db2->set_charset("utf8");

        $stm2 = $db2->prepare("SELECT salesperson_code,first_name,last_name FROM SalesPersons WHERE salesperson_id='$salespersonID'");
        $stm2->execute();
        $stm2->bind_result($salespersonCode,$firstName,$lastName);
        while ($stm2->fetch()) {

        }
        $stm2->close();

        $stm2 = $db2->prepare("SELECT salesperson_code,first_name,last_name FROM SalesPersons WHERE salesperson_id='$assignTo'");
        $stm2->execute();
        $stm2->bind_result($salespersonCodeAssign,$firstNameAssign,$lastNameAssign);
        while ($stm2->fetch()) {

        }
        $stm2->close();
    }
    $stm->close();


    $stm = $db->prepare("SELECT priority_code,priority_name,priority_level FROM SC_Priorities WHERE priority_id='$priorityID'");
    $stm-> execute();
    $stm-> bind_result($priorityCode,$priorityName,$priorityLevel);
    while ($stm->fetch()) {


    }
    $stm->close();

    $stm = $db->prepare("SELECT status_code,status_name,position FROM SC_Status WHERE status_id='$statusID'");
    $stm-> execute();
    $stm-> bind_result($statusCode,$statusName,$statusPosition);
    while ($stm->fetch()) {

    }
    $stm->close();

    $stm = $db->prepare("SELECT source_code,source_name FROM SC_Sources WHERE source_id='$sourceID'");
    $stm-> execute();
    $stm-> bind_result($sourceCode,$sourceType);
    while ($stm->fetch()) {

    }
    $stm->close();


    $stm5 = $db2->prepare("SELECT Serial_Numbers.serial_number_id,item_code,name,serial_number FROM Contracts,Items,Serial_Numbers WHERE Items.item_id=Contracts.item_id AND customer_id ='$customerID' AND Serial_Numbers.serial_number_id = Contracts.serial_number_id AND Serial_Numbers.serial_number_id = '$scSerialNumbnerID'");
    $stm5->execute();
    $stm5->bind_result($serialNumbnerID, $itemCode,$name, $serialNumber);
    while ($stm5->fetch()) {

    }
    $stm5->close();

    $date = date_format( date_create_from_format('Y-m-d H:i:s', $date), 'd-m-Y H:i');

    if(strcmp($dueDate,"0000-00-00 00:00:00") == 0)
    {
        $dueDate = "";
    }
    else if (strpos($dueDate, '00:00:00') !== false) {
        $dueDate = date_format(date_create_from_format('Y-m-d H:i:s', $dueDate), 'd-m-Y H:i');
        $dueDate = str_replace("00:00:00", "", $dueDate);
    }
    else {
        $dueDate = date_format(date_create_from_format('Y-m-d H:i:s', $dueDate), 'd-m-Y H:i');
    }


    $stm = $db->prepare("SELECT line1,line2,line3,line4,line5,line6,line7 FROM Companies");
    $stm->execute();
    $stm->bind_result($line1, $line2, $line3, $line4, $line5, $line6, $line7);
    while ($stm->fetch()) {


    }
    $stm->close();


    $stm = $db->prepare("SELECT customer_code,customer_company_name FROM Customers WHERE customer_id='$customerID'");
    $stm->execute();
    $stm->bind_result($customerCode, $customerName);

    while ($stm->fetch()) {


    }
    $stm->close();


    $stm = $db->prepare("SELECT address_line_1,address_line_2,postcode,city,landline FROM CustomerAddress WHERE customer_address_id='$customerAddressID'");
    $stm->execute();
    $stm->bind_result($addressLine1, $addressLine2,$postcode,$city,$landline);

    while ($stm->fetch()) {


    }
    $stm->close();


    $stm = $db->prepare("SELECT CONCAT(salesperson_code,' - ',first_name,' ',last_name) as issuerName FROM SalesPersons WHERE salesperson_id='$salespersonID'");
    $stm->execute();
    $stm->bind_result($issuerName);

    while ($stm->fetch()) {


    }
    $stm->close();

    $stm = $db->prepare("SELECT CONCAT(salesperson_code,' - ',first_name,' ',last_name) FROM SalesPersons WHERE salesperson_id='$assignTo'");
    $stm->execute();
    $stm->bind_result($assignedToName);

    while ($stm->fetch()) {


    }
    $stm->close();




    $result= "



<style>


        body
        {


        }

        p
        {

        }
        
        table td, table th {
            text-align: center; 
            vertical-align: middle; 
}

        #wrapper
        {
            width:180mm;
            margin:0 15mm;
        }

        .page
        {
            height:297mm;
            width:210mm;

            page-break-after:always;
        }

        table.bordered
        {
            border-left: 1px solid #ddd;
            border-top: 1px solid #ddd;

            border-spacing:0;
            border-collapse: collapse;

        }

        table.bordered td
        {
            border-right: 1px solid #ddd;
            border-bottom: 1px solid #ddd;
            padding: 2mm;
        }

        table.heading
        {

        }

        h1.heading
        {
            font-size:14pt;
            color:#000;
            font-weight:normal;
        }

        h2.heading
        {
            font-size:9pt;
            color:#000;
            font-weight:normal;
        }

        hr
        {
            color:#ccc;
            background:#ccc;
        }

        #invoice_body
        {

        }

        td {
          font-family: Helvetica Neue, Helvetica, Arial, sans-serif;
        }

        #invoice_body , #invoice_total, #tableHeader
        {
            width:100%;
        }
        #invoice_body table , #tableHeader table
        {
            width:100%;
            border-left: 1px solid #ccc;
            border-top: 1px solid #ccc;
        }
        

        #invoice_total table {
          width:100%;
        }

        #invoice_body table td , #tableHeader table td
        {
            text-align:center;
            font-size: 11px;
            border-right: 1px solid #ccc;
            border-bottom: 1px solid #ccc;
            padding:2mm 0;
        }

        #invoice_body table td.mono  , #invoice_total table td.mono, #tableHeader table td.mono
        {
            font-family: Helvetica Neue, Helvetica, Arial, sans-serif;
            text-align:right;
            padding-right:3mm;
            font-size:10pt;
        }

        #footer
        {
            width:180mm;
            margin:0 15mm;
            padding-bottom:3mm;
        }
        #footer table
        {
            width:100%;
            background:#eee;

        }
        #footer table td
        {
            width:25%;
            text-align:center;
            font-size:9pt;
        }


        @page
        {
            header: html_myHTMLHeader1;
            footer: html_myFooter1;
        }

        .customer {
           font-family: 'Helvetica Neue', Helvetica, Arial, sans-serif;
           font-weight: 400;
        }

        #table_info td {
           font-size: 12px;
           padding:0;

        }
        
        #responseTable table td {
           font-size:11px;
           
        }

    </style>

<htmlpageheader name='myHTMLHeader1'>
  <table class='heading' style='width:100%'>
  <tr>
  <td valign='top' style='width:33%'>
      <img style='max-width: 200px;' src='//" . HTML_PATH . "/cop/media/pdfimage/logo.png'/>
  </td>
  <td  valign='top' style='width:33%' align='center'>
     <p style='font-weight:bold; font-size:22px;'>Service Call</p>
  </td>
  <td valign='top' style='width:33%' align='right'>
     <h1 class='heading' style='padding-top:2px;padding-bottom:2px;'>$line1</h1>
                <h2 class='heading'>
                    $line2<br/>
                    $line3<br/>
                    $line4<br/>
                    $line5<br/>
                    $line6<br/>
                    $line7
                </h2>
  </td>
   </tr>
  </table>

</htmlpageheader>

<table id='table_info' style='width:100%;margin-top:0;padding-top:0;'>
        <tr>
             <td rowspan='2' valign='top' align='left' style='width:33%'>
                <h3>Service Call Details</h3>
                <table style='margin-top:5px;'>
                    <tr><td>SC No: </td><td>$serviceCallCode</td></tr>
                    <tr><td>SC Date: </td><td>$date</td></tr>
                    <tr><td >Due Date: </td><td>$dueDate</td></tr>
                    <tr><td >Priority: </td><td><b>$priorityName</b></td></tr>
                    <tr><td >Status: </td><td>$statusName</td></tr>    
                    <tr><td >Issued by:  </td><td>$issuerName</td></tr>
                    <tr><td >Assigned to: </td><td>$assignedToName</td></tr>    
                </table>
            </td>
                     <td rowspan='1' valign='top' align='center' style='width:33%'>
                      <h3 >Customer Details</h3>
                <table style='margin-top:5px;'>
                  <tr><td >Account Code: $customerCode</td></tr>
                    <tr><td style='text-align: center'>$customerName</td></tr>
                    <tr><td style='text-align: center'>$addressLine1</td></tr>
                    <tr><td style='text-align: center'>$addressLine2</td></tr>
                    <tr><td style='text-align: center'>$city</td></tr>
                    <tr><td style='text-align: center'>$landline</td></tr>
                </table>
            </td>
             <td rowspan='1' valign='top' align='right' style='width:33%'>
              <h3>Source Info</h3>
                <table style='margin-top:5px;'>
                   <tr><td>Source Type: </td><td style='padding-left:5px;'>$sourceType</td></tr>
                   <tr><td>Source Name: </td><td style='padding-left:5px;'>$sourceName</td></tr>
                   <tr><td>Source Phone: </td><td style='padding-left:5px;'>$sourceDetails</td></tr>     
                </table>
            </td>

        </tr>

    </table>   
   
    
    <br>
    
    <hr style='color:#444444'>
    
    <br>
    
    
    <div style='margin-top:30px;'>
    
         <label style='display: inline;margin: 0 auto;width: 50%'>Description:</label>
         
         <p style='display: inline;font-weight:bold;font-size:19px;'>$topic</p>
         
         <p style='display: inline;font-weight:normal;font-size:16px;'>$details</p>
    
    </div>
    

    <br>   
   
    
    ";


    $customForms=array();

    $stm = $db->prepare("SELECT custom_form_id,custom_form_code,custom_form_name FROM  ZA_Custom_Form_Definition,ZA_Custom_Form_Usage WHERE ZA_Custom_Form_Definition.custom_form_definition_id=ZA_Custom_Form_Usage.custom_form_id  AND linked_table='Service_Call'");
    $stm->execute();
    $stm->bind_result($customFormID,$customFormCode,$customFormName);
    while ($stm->fetch()) {

        $result.= "<table class='custom-form' id='$customFormCode'>";


        $result.= "<tbody>";
        $db3= new mysqli(localhost,$username,$password,$database);
        if (mysqli_connect_errno())
        {
            printf("Connect failed: %s\n", mysqli_connect_error());
            exit();
        }
        $db3->set_charset("utf8");
        $stm3 = $db3->prepare("SELECT ZA_Custom_Field_Definition.custom_field_id,custom_field_name,type,values_range,css_style,position,required,editable,class FROM  ZA_Custom_Field_Definition,ZA_Custom_Form_Custom_Field WHERE ZA_Custom_Field_Definition.custom_field_id=ZA_Custom_Form_Custom_Field.custom_field_id  AND ZA_Custom_Form_Custom_Field.custom_form_id='$customFormID' ORDER BY position");
        $stm3->execute();
        $stm3->bind_result($customFieldID,$customFieldName,$type,$valuesRange,$cssStyle,$position,$required,$editable,$class);
        while ($stm3->fetch()) {



            $lastValue = $dbHelbelCustomer->getLastValueOfCustomForm($customFormID,$customFieldID,"Service_Call",$serviceCallIDFromQuery);

            $result.= "<tr>";
            $result.= "<td><b>$customFieldName: </b></td>";
            $result.= "<td> $lastValue</td>";
            $result.= "</tr>";
        }
        $stm3->close();

        $result.= "</tbody>";
        $result.="</table>";
        $result.="</form>";

        array_push($customForms,$customFormCode);



         }
      $stm->close();



    $result .="<hr style='color:#444444'>";


    if(isset($scSerialNumbnerID) && $scSerialNumbnerID >0) {

        $result .=" 

   <div id='item_table' style='height:200px;'>

   <div style='margin-top:20px;height:200px;'>
   
    <label style='display: inline;margin: 0 auto;width: 50%'>Associated Product:</label>

     <table repeat_header='1' id='tableHeader' style='margin-top:20px;border-top: 1px solid #DBE4F2;border-bottom: 1px solid #DBE4F2;padding:0;background:#E6F0FF;'>
            <tr>                
                <td style='width:33%;text-align: left'><b>Code</b></td>
                <td style='width:33%;text-align: left'><b>Description</b></td>
                <td style='width:33%;text-align: left'><b>Identifier</b></td>      
            </tr>
            </table>


            <table style='overflow:hidden;width:100%'>
               <tr>
                <td style='width:33%;text-align: left'><b>$itemCode</b></td>
                <td style='width:33%;text-align: left'><b>$name</b></td>
                <td style='width:33%;text-align: left'><b>$serialNumber</b></td>      
               </tr>
            ";


        $result .=
            "  </table>

        </div>";

    }

    $first = true;

    $response ="

   <div id='responseTable' style='height:200px;'>

   <div style='margin-top:20px;height:200px;'>
   
    <label style='display: inline;margin: 0 auto;width: 50%'>Responses:</label>

     <table repeat_header='1' id='tableHeader' style='margin-top:20px;border-top: 1px solid #DBE4F2;border-bottom: 1px solid #DBE4F2;padding:0;'>
            <tr>                
                <td style='width:4%'><b></b></td>
                <td style='width:20%'><b>Date</b></td>
                <td style='width:15%'><b>User</b></td>      
                <td style='width:15%'><b>Type</b></td>
                <td style='width:25%'><b>Text</b></td>  
                <td style='width:21%'><b>Image</b></td>  

            </tr>";

    $stm = $db->prepare("SELECT service_call_reply_id,CONCAT(salesperson_code,' - ',last_name) as issuerName,status_id,date,Service_Call_Reply.reply_type_id,sc_reply_name,details,document_id,document_type,salesperson_to,priority_id FROM Service_Call_Reply,SC_Reply_Types,SalesPersons WHERE Service_Call_Reply.reply_type_id = SC_Reply_Types.sc_reply_type_id AND Service_Call_Reply.salesperson_id = SalesPersons.salesperson_id AND Service_Call_Reply.service_call_id='$serviceCallIDFromQuery' ORDER BY date DESC");
    $stm->execute();
    $stm->bind_result($serviceCallReplyID,$salespersonReplier,$replyStatusID,$replyDate,$replyTypeID,$replyTypeName,$replydetails,$documentID,$documentType,$replySalespersonAssignTo,$replyPriorityID);

    while ($stm->fetch()) {
        $icon = "//".HTML_PATH."/cop/backend/themes/".THEME_NAME."/img/";
        $background = "";

        switch ($replyTypeID) {
            case "1":
                $icon .= "infoicontrans.png";
                $background = "#222222";
                break;
            case "2":
                $icon .= "infoicontrans.png";
                $background = "#222222";
                break;
            case "3":
                $icon .= "actionicon.png";
                $background = "#4682B4";
                break;
            case "4":
                $icon .= "flagicon.png";
                $background = "#B34444";
                break;
            case "5":
                $icon .= "replyicon.png";
                $background = "#5A5A8B";
                break;
            case "6":
                $icon .= "internalgroupicon.png";
                $background = "#708090";
                break;
            case "7":
                $icon .= "exclamationmarkicon.png";
                $background = "#B34444";
                break;
            case "8":
                $icon .= "formicon.png";
                $background = "#606060";
                break;
            default:
                $icon .= "infoicontrans.png";
                $background = "#222222";
                break;
        }

        if(strcmp($replyDate,"0000-00-00 00:00:00") == 0)
        {
            $replyDate = "";
        }
        else if (strpos($replyDate, '00:00:00') !== false) {
            $replyDate = date_format(date_create_from_format('Y-m-d H:i:s', $replyDate), 'd-m-Y H:i');
            $replyDate = str_replace("00:00:00", "", $replyDate);
        }
        else {
            $replyDate = date_format(date_create_from_format('Y-m-d H:i:s', $replyDate), 'd-m-Y H:i');
        }

        $documentType = substr($documentType, 0, -1);

        if($first)
        {
            $result.= $response;
            $first = false;
        }

        $result.=
            "
              <tr>
                <td style='width:4%'><img class='custom-rounded-image center-canvas' style='background-color:$background;padding: 4px;' src='".$icon."' width='30' height='30'></td>
                <td style='width:20%'> $replyDate</td>
                <td style='width:15%;'>$salespersonReplier</td>   
                <td style='width:15%'>$replyTypeName</td>
                <td style='width:25%'>$replydetails</td>";

        $db4 = new mysqli(localhost, $username, $password, $database);
        if (mysqli_connect_errno()) {
            printf("Connect failed: %s\n", mysqli_connect_error());
            exit();
        }
        $db4->set_charset("utf8");
        $stm4 = $db4->prepare("SELECT attachment_name FROM Service_Call_Reply_Attachments WHERE service_call_reply_id =? LIMIT 1");
        $stm4-> bind_param('i',$serviceCallReplyID);
        $stm4-> execute();
        $stm4-> bind_result($attachementJpg);
        $stm4->fetch();
        $stm4->close();
        $image =  "//" . HTML_PATH . "/cop/media/serviceCallAttachments/" . $attachementJpg;
        if(!empty($attachementJpg) && isImage($attachementJpg)){
            $result.=" <td style='width:21%'><img class='custom-rounded-image center-canvas' style='padding: 4px;' src='".$image."' width='150' height='150'></td> ";

        }
        else{
            $result.=" <td style='width:21%'></td> ";
        }

        $result.=" </tr> ";
    }
    $stm->close();

    $result.=" </table>";


    $result.=
        "

<htmlpagefooter name='myFooter1' >

        

        <div>
          <p style='margin-top:5px;font-size:10px;font-family: Helvetica Neue, Helvetica, Arial, sans-serif'> Powered by Coprime Mobile Service: 25-311504 </p>
        </div>
      <hr style='color:#444444'> 

            <table width='100%' style='vertical-align: bottom; font-family: Helvetica Neue, Helvetica, Arial, sans-serif; font-size: 8pt;
                color: #000000;  '><tr>
                <td width='33%'><span style=''>{DATE d-m-Y}</span></td>
                <td width='33%' align='center' style=''>{PAGENO} of {nbpg}</td>
                <td width='33%' style='text-align: right; '>$serviceCallCode</td>
                </tr></table>
            </htmlpagefooter>



";


    return $result;
}

function getLastPageFooterForPrinting($serviceCallID){
    global $username, $password, $database;
    $db = new mysqli('localhost', $username, $password, $database);
    if (mysqli_connect_errno()) {
        printf("Connect failed: %s\n", mysqli_connect_error());
        exit();
    }
    $db->set_charset("utf8");
    $stm = $db->prepare("SELECT service_call_code FROM Service_Call WHERE service_call_id = ?");
    $stm-> bind_param('i', $serviceCallID);
    $stm->execute();
    $stm->bind_result($serviceCallCode);
    while ($stm->fetch()) {
    }
    $stm->close();

    return "    <hr style='color:#444444'> 

        <div>
          <p style='margin-top:5px;font-size:10px;font-family: Helvetica Neue, Helvetica, Arial, sans-serif'> Powered by Coprime Mobile Service: 25-311504 </p>
        </div>

        <div style='margin-top:60px;width:100%;'>
           <table style='width:100%;'>
               <tr>
                  <td style='width:50%;'>
                    <table style='width:100%;'>
                       <tr>
                       <td style='width:33%'>

                       </td>
                        <td style='border-top: 1px solid #000000;width:33%;text-align:center'>
                            <p style='font-size:11px;'>Office Signature</p>
                       </td>
                        <td style='width:33%'>

                       </td>
                       </tr>
                    </table>
                  </td>
                 <td style='width:50%;'>
                    <table style='width:100%;'>
                       <tr>
                       <td style='width:33%'>

                       </td>
                        <td style='border-top: 1px solid #000000;width:33%;text-align:center'>
                            <p style='font-size:11px;'>User Signature</p>
                       </td>
                        <td style='width:33%'>

                       </td>
                       </tr>
                    </table>
                  </td>
              </tr>
           </table>

        </div>
 

            <table width='100%' style='vertical-align: bottom; font-family: Helvetica Neue, Helvetica, Arial, sans-serif; font-size: 8pt;
                color: #000000;  '><tr>
                <td width='33%'><span style=''>{DATE d-m-Y}</span></td>
                <td width='33%' align='center' style=''>{PAGENO} of {nbpg}</td>
                <td width='33%' style='text-align: right; '>$serviceCallCode</td>
                </tr></table> ";

}


$serviceCallIDs ="";

if(isset($_POST['multiple']))
{
    $dateFrom=$_POST['dateFrom'];
    $dateTo = $_POST['dateTo'];

    $salespersonIDs = array();
    $salespersonIDs =$_POST['salespersons'];
    $status=$_POST['status'];

    $salespersonIDsForQuery='';
    $counter=0;
    foreach ($salespersonIDs as $salespersonID)
    {
        $salespersonIDsForQuery.="$salespersonID";
        $counter++;
        if($counter!=sizeof($salespersonIDs))
        {
            $salespersonIDsForQuery.=",";
        }

    }

    if(strcmp($salespersonIDsForQuery,"")!=0)
    {
        $assignTo="AND assign_to IN ($salespersonIDsForQuery)";
    }
    else
    {
        $assignTo="";
    }


    $db = new mysqli('localhost', $username, $password, $database);
    if (mysqli_connect_errno()) {
        printf("Connect failed: %s\n", mysqli_connect_error());
        exit();
    }
    $db->set_charset("utf8");
    $counter=0;
    $stm = $db->prepare("SELECT service_call_id FROM Service_Call WHERE date>='$dateFrom' AND date <='$dateTo 23:59:59' AND status_id='$status' $assignTo");
    $stm->execute();
    $stm->bind_result($serviceCallIDTh);
    while ($stm->fetch()) {
        $counter++;
        $serviceCallIDs.=$serviceCallIDTh.",";

    }
    $stm->close();
    $serviceCallIDs = rtrim($serviceCallIDs,",");

     //echo "$dateFrom,$dateTo,$salespersonIDsForQuery,$serviceCallIDs";



}
else{
    $serviceCallIDs =$_POST['serviceCallIDs'];
}


if(strcmp("$serviceCallIDs","")!=0) {
    $serviceCallIDs = explode(",",$serviceCallIDs);
}

$counter=0;
$mpdf=new mPDF();
//$mpdf->SetHTMLHeaderByName('myHTMLHeader1');
$mpdf->setAutoTopMargin='stretch';
$mpdf->setAutoBottomMargin='stretch';
$mpdf->keep_table_proportions=true;
foreach ($serviceCallIDs as $serviceCallID)
{
    if(strcmp($serviceCallID,"")!=0) {
        $result = getServiceCallPDFForPrinting($serviceCallID);
      //  $lastPageFooter = getLastPageFooterForPrinting($serviceCallID); // includes signatures
    }
    else{
        $result="";
    //    $lastPageFooter="";
    }
    $mpdf->WriteHTML($result);
   // $mpdf->SetHTMLFooter($lastPageFooter);
//Mr. Marios Fekkos said to remove signatures


    $counter++;
    if($counter!=sizeof($serviceCallIDs))
    {
        $mpdf->addPage();
    }

}

$mpdf->Output("Service_Call_".$_POST['serviceCallCode'].".pdf","I");
?>