<?php

//error_reporting(0);
include_once("../../../../param.php");
require_once (ROOT . "libs/mPDF/vendor/autoload.php");

function getServiceCallPDFForPrinting($orderID)
{
    global $username, $password, $database;
    require_once( ROOT . "concc/dbhelpers/classes/DBCustomer.php");
    require_once( ROOT . "concc/dbhelpers/classes/DBItem.php");

    $db = new mysqli('localhost', $username, $password, $database);
    if (mysqli_connect_errno()) {
        printf("Connect failed: %s\n", mysqli_connect_error());
        exit();
    }
    $db->set_charset("utf8");

    $dbHelbelCustomer= new DBCustomer();
    $dbHelbelItem= new DBItem();

    $stm = $db->prepare("SELECT service_call_id,service_call_code,salesperson_id,assign_to,customer_id,customer_address_id,serial_number_id,source_id,type_id,status_id,priority_id,topic,details,source_name,source_details,date,due_date,timestamp FROM Service_Call WHERE service_call_id='$orderID'");
    $stm->execute();
    $stm->bind_result($serviceCallIDFromQuery,$serviceCallCode,$salespersonID,$assignTo,$customerID,$customerAddressID,$scSerialNumbnerID,$sourceID,$typeID,$statusID,$priorityID,$topic,$details,$sourceName,$sourceDetails,$date,$dueDate, $timestamp);
    while ($stm->fetch()) {

        $customer=$dbHelbelCustomer->getCustomerByID($customerID);
        $db2= new mysqli(localhost,$username,$password,$database);
        if (mysqli_connect_errno())
        {
            printf("Connect failed: %s\n", mysqli_connect_error());
            exit();
        }
        $db2->set_charset("utf8");

        $stm2 = $db2->prepare("SELECT salesperson_code,first_name,last_name FROM SalesPersons WHERE salesperson_id='$salespersonID'");
        $stm2->execute();
        $stm2->bind_result($salespersonCode,$firstName,$lastName);
        while ($stm2->fetch()) {

        }
        $stm2->close();

        $stm2 = $db2->prepare("SELECT salesperson_code,first_name,last_name FROM SalesPersons WHERE salesperson_id='$assignTo'");
        $stm2->execute();
        $stm2->bind_result($salespersonCodeAssign,$firstNameAssign,$lastNameAssign);
        while ($stm2->fetch()) {

        }
        $stm2->close();
    }
    $stm->close();


    $stm = $db->prepare("SELECT priority_code,priority_name,priority_level FROM SC_Priorities WHERE priority_id='$priorityID'");
    $stm-> execute();
    $stm-> bind_result($priorityCode,$priorityName,$priorityLevel);
    while ($stm->fetch()) {


    }
    $stm->close();

    $stm = $db->prepare("SELECT status_code,status_name,position FROM SC_Status WHERE status_id='$statusID'");
    $stm-> execute();
    $stm-> bind_result($statusCode,$statusName,$statusPosition);
    while ($stm->fetch()) {

    }
    $stm->close();

    $stm = $db->prepare("SELECT source_code,source_name FROM SC_Sources WHERE source_id='$sourceID'");
    $stm-> execute();
    $stm-> bind_result($sourceCode,$sourceType);
    while ($stm->fetch()) {

    }
    $stm->close();


    $stm5 = $db2->prepare("SELECT Serial_Numbers.serial_number_id,item_code,name,serial_number FROM Contracts,Items,Serial_Numbers WHERE Items.item_id=Contracts.item_id AND customer_id ='$customerID' AND Serial_Numbers.serial_number_id = Contracts.serial_number_id AND Serial_Numbers.serial_number_id = '$scSerialNumbnerID'");
    $stm5->execute();
    $stm5->bind_result($serialNumbnerID, $itemCode,$name, $serialNumber);
    while ($stm5->fetch()) {

    }
    $stm5->close();

    $date = date_format( date_create_from_format('Y-m-d H:i:s', $date), 'd-m-Y H:i');

    if(strcmp($dueDate,"0000-00-00 00:00:00") == 0)
    {
        $dueDate = "";
    }
    else if (strpos($dueDate, '00:00:00') !== false) {
        $dueDate = date_format(date_create_from_format('Y-m-d H:i:s', $dueDate), 'd-m-Y H:i');
        $dueDate = str_replace("00:00:00", "", $dueDate);
    }
    else {
        $dueDate = date_format(date_create_from_format('Y-m-d H:i:s', $dueDate), 'd-m-Y H:i');
    }


    $stm = $db->prepare("SELECT line1,line2,line3,line4,line5,line6,line7 FROM Companies");
    $stm->execute();
    $stm->bind_result($line1, $line2, $line3, $line4, $line5, $line6, $line7);
    while ($stm->fetch()) {


    }
    $stm->close();


    $stm = $db->prepare("SELECT customer_code,customer_company_name FROM Customers WHERE customer_id='$customerID'");
    $stm->execute();
    $stm->bind_result($customerCode, $customerName);

    while ($stm->fetch()) {


    }
    $stm->close();


    $stm = $db->prepare("SELECT address_line_1,address_line_2,postcode,city,landline FROM CustomerAddress WHERE customer_address_id='$customerAddressID'");
    $stm->execute();
    $stm->bind_result($addressLine1, $addressLine2,$postcode,$city,$landline);

    while ($stm->fetch()) {


    }
    $stm->close();


    $stm = $db->prepare("SELECT CONCAT(salesperson_code,' - ',first_name,' ',last_name) as issuerName FROM SalesPersons WHERE salesperson_id='$salespersonID'");
    $stm->execute();
    $stm->bind_result($issuerName);

    while ($stm->fetch()) {


    }
    $stm->close();

    $stm = $db->prepare("SELECT CONCAT(salesperson_code,' - ',first_name,' ',last_name) FROM SalesPersons WHERE salesperson_id='$assignTo'");
    $stm->execute();
    $stm->bind_result($assignedToName);

    while ($stm->fetch()) {


    }
    $stm->close();




    $result= "



<style>


        body
        {


        }

        p
        {

        }

        #wrapper
        {
            width:180mm;
            margin:0 15mm;
        }

        .page
        {
            height:297mm;
            width:210mm;

            page-break-after:always;
        }

        table.bordered
        {
            border-left: 1px solid #ddd;
            border-top: 1px solid #ddd;

            border-spacing:0;
            border-collapse: collapse;

        }

        table.bordered td
        {
            border-right: 1px solid #ddd;
            border-bottom: 1px solid #ddd;
            padding: 2mm;
        }

        table.heading
        {

        }

        h1.heading
        {
            font-size:14pt;
            color:#000;
            font-weight:normal;
        }

        h2.heading
        {
            font-size:9pt;
            color:#000;
            font-weight:normal;
        }

        hr
        {
            color:#ccc;
            background:#ccc;
        }

        #invoice_body
        {

        }

        td, th {
          font-family: Helvetica Neue, Helvetica, Arial, sans-serif;
          font-size:10px;
        }

        #invoice_body , #invoice_total, #tableHeader
        {
            width:100%;
        }
        #invoice_body table , #tableHeader table
        {
            width:100%;
            border-left: 1px solid #ccc;
            border-top: 1px solid #ccc;
        }

        #invoice_total table {
          width:100%;
        }

        #invoice_body table td , #tableHeader table td
        {
            text-align:center;
            font-size: 11px;
            border-right: 1px solid #ccc;
            border-bottom: 1px solid #ccc;
            padding:2mm 0;
        }

        #invoice_body table td.mono  , #invoice_total table td.mono, #tableHeader table td.mono
        {
            font-family: Helvetica Neue, Helvetica, Arial, sans-serif;
            text-align:right;
            padding-right:3mm;
            font-size:10pt;
        }

        #footer
        {
            width:180mm;
            margin:0 15mm;
            padding-bottom:3mm;
        }
        #footer table
        {
            width:100%;
            background:#eee;

        }
        #footer table td
        {
            width:25%;
            text-align:center;
            font-size:9pt;
        }


        @page
        {
            header: html_myHTMLHeader1;
            footer: html_myFooter1;
        }

        .customer {
           font-family: 'Helvetica Neue', Helvetica, Arial, sans-serif;
           font-weight: 400;
        }

        #table_info td {
           font-size: 12px;
           padding:0;

        }
        
        #responseTable table td {
           font-size:11px;
           
        }

    </style>

<htmlpageheader name='myHTMLHeader1'>
  <table class='heading' style='width:100%'>
  <tr>
  <td valign='top' style='width:33%'>
      <img style='max-width: 200px;' src='//" . HTML_PATH . "/cop/media/pdfimage/logo.png'/>
  </td>
  <td  valign='top' style='width:33%' align='center'>
     <p style='font-weight:bold; font-size:22px;'>Service Call</p>
  </td>
  <td valign='top' style='width:33%' align='right'>
     <h1 class='heading' style='padding-top:2px;padding-bottom:2px;'>$line1</h1>
                <h2 class='heading'>
                    $line2<br/>
                    $line3<br/>                   
                </h2>
  </td>
   </tr>
  </table>

</htmlpageheader>

<table id='table_info' style='width:100%;margin-top:0;padding-top:0;'>
        <tr>
             <td rowspan='2' valign='top' align='left' style='width:33%'>
                <h3>Service Call Details</h3>
                <table style='margin-top:5px;'>
                    <tr><td>SC No: </td><td>$serviceCallCode</td></tr>
                    <tr><td>SC Date: </td><td>$date</td></tr>
                    <tr><td >Due Date: </td><td>$dueDate</td></tr>
                    <tr><td >Priority: </td><td><b>$priorityName</b></td></tr>
                    <tr><td >Status: </td><td>$statusName</td></tr>    
                    <tr><td >Issued by:  </td><td>$issuerName</td></tr>
                    <tr><td >Assigned to: </td><td>$assignedToName</td></tr>    
                </table>
            </td>
                     <td rowspan='1' valign='top' align='center' style='width:33%'>
                      <h3 >Customer Details</h3>
                <table style='margin-top:5px;'>
                  <tr><td >Account Code: $customerCode</td></tr>
                    <tr><td style='text-align: center'>$customerName</td></tr>
                    <tr><td style='text-align: center'>$addressLine1</td></tr>
                    <tr><td style='text-align: center'>$addressLine2</td></tr>
                    <tr><td style='text-align: center'>$city</td></tr>
                    <tr><td style='text-align: center'>$landline</td></tr>
                </table>
            </td>
             <td rowspan='1' valign='top' align='right' style='width:33%'>
              <h3>Source Info</h3>
                <table style='margin-top:5px;'>
                   <tr><td>Source Type: </td><td style='padding-left:5px;'>$sourceType</td></tr>
                   <tr><td>Source Name: </td><td style='padding-left:5px;'>$sourceName</td></tr>
                   <tr><td>Source Phone: </td><td style='padding-left:5px;'>$sourceDetails</td></tr>     
                </table>
            </td>

        </tr>

    </table>           
   
    
    ";

    $allWaybillTotal = 0;

    $stm = $db->prepare("SELECT waybill_id,waybill_code,waybill_date FROM Waybills WHERE waybill_id IN (SELECT document_id AS waybill_id FROM Service_Call_Reply WHERE reply_type_id=3 AND document_type='Waybills' AND service_call_id='$orderID' )  ORDER BY waybill_date");
    $stm->execute();
    $stm->bind_result($waybillID,$waybillCode,$waybillDate);

    while ($stm->fetch()) {
        $waybillDate = date_format( date_create_from_format('Y-m-d', $waybillDate), 'd-m-Y');

        $result.="<h6 style='margin-bottom:0;padding-bottom:0'>Waybill: $waybillDate - $waybillCode</h6>
                <table style='border: 1px solid #222222;width:100%;margin-top:0;padding-top:0'>
              
                <tr>
                <th style='text-align:left;width:70%'>Name</th>
                <th style='text-align:right;width:10%'>Qty</th>
                <th style='text-align:right;width:10%'>Unit Price</th>
                <th style='text-align:right;width:10%'>Total</th>
                </tr>
               
                ";

        $db2= new mysqli(localhost,$username,$password,$database);
        if (mysqli_connect_errno())
        {
            printf("Connect failed: %s\n", mysqli_connect_error());
            exit();
        }
        $db2->set_charset("utf8");

        $stm2 = $db2->prepare("SELECT item_code,name,qty,unit_price FROM Waybill_Item,Items WHERE Waybill_Item.waybill_id='$waybillID' AND Waybill_Item.item_id=Items.item_id");
        $stm2->execute();
        $stm2->bind_result($itemCode,$name,$qty,$unitPrice);
        while ($stm2->fetch()) {

            $allWaybillTotal = $allWaybillTotal + ($unitPrice * $qty);
            $unitPrice = number_format($unitPrice,2);
            $total = number_format($unitPrice * $qty,2);

            $result.="<tr>
                     <td style='text-align:left'>$name</td>
                     <td style='text-align:right'>$qty</td>
                     <td style='text-align:right'>" . CURRENCY_SYMBOL ."$unitPrice</td>
                     <td style='text-align:right'>" . CURRENCY_SYMBOL ."$total</td>
                     </tr>
                ";


        }
        $stm2->close();

        $result.="</table>
                ";
    }

    $stm->close();


    $result .= "<h6 style='width:100%;text-align:right;'>Total:" . CURRENCY_SYMBOL . number_format($allWaybillTotal,2) ."</h6>";




    return $result;
}




$serviceCallIDs ="";

if(isset($_POST['multiple']))
{
    $dateFrom=$_POST['dateFrom'];
    $dateTo = $_POST['dateTo'];

    $salespersonIDs = array();
    $salespersonIDs =$_POST['salespersons'];
    $status=$_POST['status'];

    $salespersonIDsForQuery='';
    $counter=0;
    foreach ($salespersonIDs as $salespersonID)
    {
        $salespersonIDsForQuery.="$salespersonID";
        $counter++;
        if($counter!=sizeof($salespersonIDs))
        {
            $salespersonIDsForQuery.=",";
        }

    }

    if(strcmp($salespersonIDsForQuery,"")!=0)
    {
        $assignTo="AND assign_to IN ($salespersonIDsForQuery)";
    }
    else
    {
        $assignTo="";
    }


    $db = new mysqli('localhost', $username, $password, $database);
    if (mysqli_connect_errno()) {
        printf("Connect failed: %s\n", mysqli_connect_error());
        exit();
    }
    $db->set_charset("utf8");
    $counter=0;
    $stm = $db->prepare("SELECT service_call_id FROM Service_Call WHERE date>='$dateFrom' AND date <='$dateTo 23:59:59' AND status_id='$status' $assignTo");
    $stm->execute();
    $stm->bind_result($serviceCallIDTh);
    while ($stm->fetch()) {
        $counter++;
        $serviceCallIDs.=$serviceCallIDTh.",";

    }
    $stm->close();
    $serviceCallIDs = rtrim($serviceCallIDs,",");

     //echo "$dateFrom,$dateTo,$salespersonIDsForQuery,$serviceCallIDs";



}
else{
    $serviceCallIDs =$_POST['serviceCallIDs'];
}



$serviceCallIDs = explode(",",$serviceCallIDs);
$counter=0;
$mpdf=new mPDF();
//$mpdf->SetHTMLHeaderByName('myHTMLHeader1');
$mpdf->setAutoTopMargin='stretch';
$mpdf->setAutoBottomMargin='stretch';
$mpdf->keep_table_proportions=true;
foreach ($serviceCallIDs as $serviceCallID)
{
    if(strcmp($serviceCallID,"")!=0) {
        $result = getServiceCallPDFForPrinting($serviceCallID);
    }
    else{
        $result="";
    }
    $mpdf->WriteHTML($result);

    $counter++;
    if($counter!=sizeof($serviceCallIDs))
    {
        $mpdf->addPage();
    }

}

$mpdf->Output("serviceCall.pdf","I");

?>