<?php
include_once('../../../../param.php');
require_once(ROOT . 'libs/phpexcel/vendor/autoload.php');

$filename = "CategoryTreeExport.xlsx";
$table    = getCategoryTree();
$table    =  "<table><tr><td>Main Category</td><td>Sub Category Level 1</td><td>Sub Category Level 2</td><td>Sub Category Level 3</td><td>Sub Category Level 4</td><td>Sub Category Level 5</td></tr>$table</table>" ;


// save $table inside temporary file that will be deleted later
$tmpfile = tempnam(sys_get_temp_dir(), 'html');
file_put_contents($tmpfile, $table);

// insert $table into $objPHPExcel's Active Sheet through $excelHTMLReader
$objPHPExcel     = new PHPExcel();
$excelHTMLReader = PHPExcel_IOFactory::createReader('HTML');
$excelHTMLReader->loadIntoExisting($tmpfile, $objPHPExcel);
$objPHPExcel->getActiveSheet()->setTitle('Excel Export'); // Change sheet's title if you want

foreach(range('B','Z') as $columnID) {
    $objPHPExcel->getActiveSheet()->getColumnDimension($columnID)
        ->setAutoSize(true);
}


unlink($tmpfile); // delete temporary file because it isn't needed anymore

header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet'); // header for .xlxs file
header('Content-Disposition: attachment;filename='.$filename); // specify the download file name
header('Cache-Control: max-age=0');

// Creates a writer to output the $objPHPExcel's content
$writer = PHPExcel_IOFactory::createWriter($objPHPExcel, 'Excel2007');
$writer->save('php://output');






function getCategoryTree($categoryID=-1,$categoryLevel=1)
{
    if($categoryID > 0){
        $subcategoryFilter = "AND  Categories.category_id = '$categoryID'";
    } else {
        $subcategoryFilter = "AND level=1";

    }
    $counter=0;
    $prev='';
    $result = '';
    $hasSubcategory = false;
    global $username, $password, $database;
    $db = new mysqli(localhost, $username, $password, $database);
    if (mysqli_connect_errno()) {
        printf("Connect failed: %s\n", mysqli_connect_error());
        exit();
    }
    $db->set_charset("utf8");
    $stm = $db->prepare("SELECT Categories.category_id, category_code, name, subcategory_id FROM Categories LEFT JOIN Subcategories ON (Categories.category_id=Subcategories.category_id) WHERE 1=1 $subcategoryFilter ORDER BY custom_order,category_code");
    $stm->execute();
    $stm->bind_result($category_id, $categoryCode, $categoryName, $subcategory);
    while ($stm->fetch()) {
        if(strcmp("$categoryCode$categoryName",'')!=0) {

            if ($subcategory > 0 && $prev == $category_id) {
                $hasSubcategory = true;
            }

            if (!$hasSubcategory) {
                $result .= '<tr>';
                $counter++;
                $categoryLevelCounter = $categoryLevel;
                for (; $categoryLevelCounter > 1; $categoryLevelCounter--) {
                    $result .= "<td></td>";
                }

                $result .= "<td>$categoryCode - $categoryName</td>";
                $result .= "</tr>";

            }
            if ($subcategory > 0) {
                $hasSubcategory = true;
                $result .= getCategoryTree($subcategory, $categoryLevel + 1);
            }
            if ($hasSubcategory) {
                if ($prev != $category_id) {
                    $prev = $category_id;
                    $hasSubcategory = false;

                }
            }

        }
    }
    $stm->close();

    return $result;
}






?>