<?php
include_once("../../../../param.php");
require_once(ROOT . "backend/core/model/CustomerAddress.php");
require_once(ROOT . "concc/dbhelpers/classes/DBCustomer.php");
require_once(ROOT . "concc/dbhelpers/classes/DBItem.php");

$dbHelbelCustomer= new DBCustomer();
$dbHelbelItem= new DBItem();

global $username,$password,$database;
$db = new mysqli('localhost',$username,$password,$database);
if (mysqli_connect_errno())
{
    printf("Connect failed: %s\n", mysqli_connect_error());
    exit();
}
$db->set_charset("utf8");

if(isset($_POST['sa_id']))
{

	$stockAdjustmentID=$_POST['sa_id'];
	$edit = true;
}
else{

	if(isset($_GET['sa_id']))
	{

        $stockAdjustmentID=$_GET['sa_id'];
		$edit = true;
	}
	else{
		$edit=false;

	}

}

$convertFromJSON=false;
if(isset($_POST['items_json']))
{
    $JSON = $_POST['items_json'];
    $salespersonID = $_POST['salesperson_json'];
    $edit=false;
    $convertFromJSON=true;
    $jsonItems = json_decode($JSON);
    if($salespersonID > 0) {
        $stm = $db->prepare("SELECT salesperson_code,first_name,last_name FROM SalesPersons WHERE salesperson_id='$salespersonID'");
        $stm->execute();
        $stm->bind_result($salespersonCode, $firstName, $lastName);
        while ($stm->fetch()) {}
        $stm->close();


        $stm = $db->prepare("SELECT warehouse_id,warehouse_code,name FROM Warehouses WHERE salesperson_id='$salespersonID'");
        $stm->execute();
        $stm->bind_result($warehouseID, $warehouseCode, $warehouseName);
        while ($stm->fetch()) {}
        $stm->close();
        

    }


}



if($edit) {

	$stm = $db->prepare("SELECT stock_taking_id,stock_taking_code,warehouse_id,salesperson_id,date,details,timestamp FROM Stock_Adjustment WHERE stock_taking_id='$stockAdjustmentID'");
	$stm->execute();
	$stm->bind_result($stockAdjustmentId, $stockAdjustmentCode, $warehouseID, $salespersonID, $transactionDate, $details, $timestamp);
	while ($stm->fetch()) {


		$db2= new mysqli(localhost,$username,$password,$database);
		if (mysqli_connect_errno())
		{
			printf("Connect failed: %s\n", mysqli_connect_error());
			exit();
		}
		$db2->set_charset("utf8");

		$stm2 = $db2->prepare("SELECT salesperson_code,first_name,last_name FROM SalesPersons WHERE salesperson_id='$salespersonID'");
		$stm2->execute();
		$stm2->bind_result($salespersonCode,$firstName,$lastName);
		while ($stm2->fetch()) {

		}
		$stm2->close();


        $stm2 = $db2->prepare("SELECT warehouse_code,name FROM Warehouses WHERE warehouse_id='$warehouseID'");
        $stm2->execute();
        $stm2->bind_result($warehouseCode,$warehouseName);
        while ($stm2->fetch()) {

        }
        $stm2->close();
	}
	$stm->close();



}
else {
    $salespersonID = $_SESSION['adminID'];
    $stm = $db->prepare("SELECT salesperson_code,first_name,last_name FROM SalesPersons WHERE salesperson_id='$salespersonID'");
    $stm->execute();
    $stm->bind_result($salespersonCode,$firstName,$lastName);
    while ($stm->fetch()) {

    }
    $stm->close();
}




function getVatCode($vatID) {
	global $username;
	global $password;
	global $database;

	$db1 = new mysqli(localhost,$username,$password,$database);
	if (mysqli_connect_errno()) {
		printf("Connect failed: %s\n", mysqli_connect_error());
		exit();
	}
	$db1->set_charset("utf8");

	$stm1 = $db1->prepare("SELECT vat_code FROM Vats WHERE vat_id='$vatID'");
	$stm1-> execute();
	$stm1-> bind_result($percentage);
	while ($stm1->fetch()) {
		return $percentage;
	}
	$stm1->close();
	return $percentage;


}



?>
<div id="main" role="main">

	<!-- Start CUSTOM CODE-->

	<!-- RIBBON -->
	<div id="ribbon" class="bg-color-blue">

				<span class="ribbon-button-alignment"> 
					<span id="refresh" class="btn btn-ribbon2" onclick="location.reload(true);" data-title="refresh" rel="tooltip" data-placement="bottom" data-original-title="<i class='text-warning fa fa-warning'></i> Reload Page?" data-html="true">
						<i class="fa fa-refresh"></i>
					</span> 
				</span>

		<!-- breadcrumb -->
		<ol class="breadcrumb">
			<li class="txt-color-white">Home / Stock Adjustment</li>
		</ol>
		<!-- end breadcrumb -->

	</div>
	<!-- END RIBBON -->

	<!-- MAIN CONTENT -->
	<div id="content">

		<div class="row">
			<div class="col-xs-12 col-sm-8 col-md-9 col-lg-10">
				<h3 class="page-title txt-color-blueDark header-margin">
					<img class="custom-rounded-image-padding order" style="display:inline;" src="//<?php echo HTML_PATH ?>/cop/backend/themes/<?php echo THEME_NAME ?>/img/ordericon.png" width="30" height="30">
                    Stock Adjustment
				</h3>
			</div>


            <?php



            if($edit) {

                echo "<div class='col-xs-12 col-sm-4 col-md-3 col-lg-2'>

                      </div>";

            } else {
                echo "<div class='col-xs-12 col-sm-4 col-md-3 col-lg-2'>   
                         <span class='pull-right show-stat-buttons'> <span > <button id='saveButton' onclick='saveOrder();' class='btn btn-success btn-block'><i class='fa fa-check'></i>&nbsp; Place Adjustment</button> </span>          
                      </div>";
            }
            ?>







		</div>

		<!-- row -->
		<section id="widget-grid" class="">

			<div class="row" >

				<!-- NEW WIDGET START -->
				<article class="col-xs-12 col-sm-12 col-md-12 col-lg-12">

					<div style="margin-bottom:10px;" class="jarviswidget jarviswidget-color-blueDark" id="wid-id-sa-5" data-widget-editbutton="false" data-widget-deletebutton="false">
						<header>
							<span class="widget-icon"> <i class="fa fa-table"></i> </span>
							<h2>Stock Adjustment</h2>

						</header>

						<!-- widget div-->
						<div>

							<!-- widget content -->
							<div class="widget-body no-padding">

								<form action="" id="checkout-form" class="smart-form">
									<fieldset>
										<div class="row">

											<section class="col col-4 no-margin" style="padding-left:20px;border-right:1px dotted #ADD8E6;">
												<section>
													<img style="width:20px;height:20px;" class="custom-rounded-image-padding order" style="display:inline;" src="//<?php echo HTML_PATH ?>/cop/backend/themes/<?php echo THEME_NAME ?>/img/ordericon.png" width="25" height="25">
													<h3 style="display: inline;margin-left:6px;vertical-align: middle"> Stock Adjustment</h3>
												</section>

                                                <table id="detailsTable" class="table" width="100%" border="0" cellpadding="0" cellspacing="0">

                                                    <thead class="height:1px;">

                                                    </thead>
                                                    <tbody>
                                                    <tr style="display:none;">
                                                        <td><label class="label-bold pull-left">Adjustment Number: </label></td>
                                                        <td><input  class='text-center form-control' id='transactionNumber' name='transactionNumber' type='text' value='<?php if($edit){echo $stockAdjustmentCode;} ?>' readonly></td>
                                                        <?php
                                                        if($edit)
                                                        {
                                                            echo"<input  class='text-center form-control slim-input' id='wtID' name='wtID' type='hidden' value='$stockAdjustmentID' readonly></td>";
                                                        }
                                                        ?>
                                                    </tr>
                                                    <tr >
                                                        <td><label class="label-bold pull-left" >Adjustment Date: </label></td>
                                                        <td><input type="text" id="wtDate" value="<?php
                                                            if($edit) {
                                                                $old_date_timestamp = strtotime($transactionDate);
                                                                $transactionDate = date('d/m/Y', $old_date_timestamp);
                                                                echo $transactionDate;
                                                            } else {
                                                                echo date('d/m/Y');
                                                            }?>" data-dateformat="dd/mm/yy" class="form-control text-center slim-input"
                                                                   data-mask="99/99/9999" data-mask-placeholder= "-" disabled readonly>
                                                        </td>

                                                    <tr >
                                                        <td><label class="label-bold pull-left" >Salesperson: </label></td>
                                                        <td>
                                                            <input style='display:inline;' class='text-center form-control' id='salespersonSearch' name='salespersonSearch' type='text' value='<?php if(true){echo "$salespersonCode - $firstName $lastName";}?>' disabled readonly>
                                                            <input  id='salespersonID' name='salespersonID' type='hidden' value='<?php if(true){echo $salespersonID;}?>'>
                                                            <input type='hidden' name='serviceCallID' id="serviceCallID" value='<?php echo $serviceCallID;?>'/>
                                                        </td>
                                                    </tr>

                                                    </select>
                                                    <i></i>
                                                    </label>
                                                    </td>
                                                    </tr>


                                                    </tbody>
                                                </table>



                                            </section>
											<section class="col col-4 no-margin" style="padding-left:20px;border-right:1px dotted #ADD8E6;height: 100%">
                                                <section>
                                                    <img style="display:inline;" src="//<?php echo HTML_PATH ?>/cop/backend/themes/<?php echo THEME_NAME ?>/img/infoicon.png" width="30" height="30">
                                                    <h3 style="display: inline;margin-left:6px;vertical-align: middle"> Warehouse Details</h3>
                                                </section>

                                                <section>
                                                    <label style="display:inline;" class="label-bold form-label-space" >Select Warehouse: </label>
                                                    <input style='display:inline;' class='text-center form-control' id='warehouseSearchTo' name='warehouseSearchTo' type='text' value='<?php if($edit||$fromServiceCall||$convertFromOrder||$convertFromReturn||$convertFromJSON){echo "$warehouseCode - $warehouseName";}?>'>
                                                    <input  id='warehouseIDTo' name='warehouseIDTo' type='hidden' value='<?php if($edit||$fromServiceCall||$convertFromOrder||$convertFromReturn||$convertFromJSON){echo $warehouseID;}?>'>
                                                </section>


                                                <section>
                                                    <label style="display:inline;color:firebrick;" class="label-bold form-label-space" id="zeroQtyLabel"></label>
                                                </section>

											</section>


									</fieldset>
								</form>


								<table id="datatable_fixed_column" class="table table-striped table-hover dataTable" width="100%" border="0" cellpadding="0" cellspacing="0">

									<thead>

									<tr>
										<th class='text-center'></th>
										<th class='text-center'>#</th>
										<th class='text-center' style="display:none">itemID</th>
										<th class='text-center' style="display:none">subUnits</th>
										<th class='text-center' style="display:none">globalDiscount</th>
										<th class='text-center' style="display:none">vatLine</th>
										<th class='text-center' style="display:none">vatPercentage</th>
										<th class='text-center'>Item Code</th>
                                        <th class='text-center'>Details</th>
                                        <th class='text-center'>Notes</th>
										<th class='text-center' style="display:none">PC</th>
										<th class='text-center' style="display:none">UP</th>
										<th class='text-center'>Qty</th>
										<th class='text-center' style="display:none">VAT</C></th>
										<th class='text-center' style="display:none">Extras</C></th>
										<th class='text-center' style="display:none">LD</C></th>
										<th class='text-center' style="display:none">Line Total</th>
                                        <th class='text-center'>Batch Number</th>

                                    </tr>
									</thead>

									<tbody>
									<?php


                                    global $username, $password, $database;

                                    include_once(ROOT . "concc/dbhelpers/functions/subunitsFunctions.php");


                                    if($edit)
									{

										$i=1;
										$lineDiscountTotals=0;
										$db = new mysqli(localhost,$username,$password,$database);
										if (mysqli_connect_errno())
										{
											printf("Connect failed: %s\n", mysqli_connect_error());
											exit();
										}
										$db->set_charset("utf8");


										$stm = $db->prepare("SELECT stock_taking_item_id,item_id,qty,batch_number,description FROM Stock_Adjustment_Item WHERE stock_taking_id ='$stockAdjustmentID'");
										$stm-> execute();
										$stm-> bind_result($warehouseTransactionItemID,$itemID,$qty,$batchNumber,$itemNotes);
										while ($stm->fetch()) {

											$item = $dbHelbelItem->getItemByID($itemID);


											$stockinfo= "<table>
                   <thead>
                      <th>Warehouse</th>
                      <th>Batch</th>
                      <th>Available</th>
                      <th>Reserved</th>
                   </thead>  <tbody> ";

											$stm3 = $db2->prepare("SELECT Stock.warehouse_id,available,reserved,warehouse_code,name,batch_number FROM Stock,Warehouses WHERE Stock.warehouse_id=Warehouses.warehouse_id AND item_id='$itemID'");
											$stm3-> execute();
											$stm3-> bind_result($warehouseIDInfo,$availableInfo,$reservedInfo,$warehouseCodeInfo,$warehouseNameInfo,$batchNumberInfo);
											while ($stm3->fetch()) {

												$stockinfo.=" <tr>
                       <td>$warehouseCodeInfo - $warehouseNameInfo</td>
                       <td>$batchNumberInfo</td>
                       <td>$availableInfo</td>
                       <td>$reservedInfo</td>
                    </tr>";

											}
											$stm3->close();

											$stockinfo.=" </tbody>
                   </table>";


											echo "<tr>";

											echo "<td  >
<img class='deletRowButton' src='//" . HTML_PATH . "/cop/backend/themes/" . THEME_NAME . "/img/deleteicon.png' style='width:20px;height:20px;'/>
												</td>";

											echo "<td class='index text-center' style='width:3%'>
                                                     <strong>$i</strong>
												</td>";

											echo "<td style='display:none;'>
          	    <input   id='itemID' name='itemID' type='hidden' value='$itemID'>
          	    </td>
          	    <td style='display:none;'>

          	    </td>
          	    <td style='display:none;'>
          	    <input  id='globalDiscount' name='globalDiscount' type='hidden' value='$globalDiscount'>
          	    </td>
          	    <td style='display:none;'>
                <input  id='vatLine' name='vatLine' type='hidden' value='$vatAmountLine'>
                </td>
                <td style='display:none;'>
                <input  id='vatPercentage' name='vatPercentage' type='hidden' value='$vatPercentage'>
</td>
<td>

				<input style='width:100%' class='itemCode text-center form-control' id='itemCode' name='itemCode' type='text' value='$item->itemCode'>



        </td>";

											echo "<td style='width:22%' class='text-center'  >

	<input style='width:100%' class='itemCode text-center form-control' id='itemDetails' name='itemDetails' type='text' value='$item->name'>

 </td>";
                                            echo "<td style='width:22%' class='text-center'  >

	<input style='width:100%' class='text-center form-control' id='itemNotes' name='itemNotes' type='text' value='$itemNotes'>

 </td>";




											echo "<td style='display:none;' class='text-center' >

											<select  class='form-control' id='priceCode' name='priceCode'>";





											echo   "</select>
 </td>";

											echo "<td style='display:none;' class='text-center' >

											<input  class='text-center form-control' id='unitPrice' name='unitPrice[]' type='number'  rel='popover' data-trigger='focus'
											      data-placement='bottom' data-original-title='<h4>History Info</h4>'
											      data-content=\"$lastPricesHistory\" data-html='true' value='$unitPrice'>


 </td>";


											if($item->subunits==1)
											{
												echo "<td  style='width:12%' class='text-center' >
                                            <div id='unitsDiv'>
  <input  id='subUnits' name='subUnits' type='hidden' value='$item->subunits'>
											      <input class='text-center form-control' id='qty' name='qty[]' type='number' value='$qty' rel='popover' data-trigger='focus'
											      data-placement='bottom' data-original-title='<h4>Stock Info</h4>'
											      data-content=\"$stockinfo\" data-html='true'>









                                             </div>
                                            <div id='subunitsDiv' style='display: none'>
                                            <input class='text-center form-control' style='display:inline;width:45%' id='qtyUnits' name='qty[]' type='number' value='' placeholder='Units'  rel='popover' data-trigger='focus'
											      data-placement='bottom' data-original-title='<h4>Stock Info</h4>'
											      data-content=\"$stockinfo\" data-html='true' disabled>

											<input class='text-center form-control'  style='display:inline;width:45%' id='qtySubunits' name='qty[]' type='number' value='' placeholder='Subunits'  disabled>

                                             </div>
 </td>";
											}
											else
											{

												$qtyUnits = getUntis($qty,$item->subunits);
												$qtySubUnits = getSub($qty,$item->subunits);
												echo "<td  style='width:12%' class='text-center' >
                                            <div id='unitsDiv' style='display: none'>
  <input  id='subUnits' name='subUnits' type='hidden' value='$item->subunits'>
											      <input class='text-center form-control' id='qty' name='qty[]' type='text' value='' rel='popover' data-trigger='focus'
											      data-placement='bottom' data-original-title='<h4>Stock Info</h4>'
											      data-content=\"\" data-html='true' disabled>









                                             </div>
                                            <div id='subunitsDiv' >
                                            <input class='text-center form-control' style='display:inline;width:45%' id='qtyUnits' name='qty[]' type='text' value='$qtyUnits' placeholder='Units'  rel='popover' data-trigger='focus'
											      data-placement='bottom' data-original-title='<h4>Stock Info</h4>'
											      data-content=\"$stockinfo\" data-html='true' >

											<input class='text-center form-control'  style='display:inline;width:45%'id='qtySubunits' name='qty[]' type='text' value='$qtySubUnits' placeholder='Subunits'  >

                                             </div>
 </td>";
											}


											if($lineDiscountPercentage>0)
											{
												$lineDiscountText = $lineDiscountPercentage."%";
											}
											else{
												$lineDiscountText=$lineDiscount;
											}

											echo "<td  style='display:none;' class='text-center' >

										<label class='text-center' id='vat'>$vatCode</label>


 </td>";
											echo "<td style='display:none;' class='text-center' >

										  <button class='btn btn-info' id='extrasButton' rel='popover' data-trigger='click' data-placement='top' data-original-title='<h4>Stock Info</h4>'
											      data-content=\"$popoverTextExtras\" data-html='true' disabled><i class='fa fa-search'>
												</i></button>


 </td>";


											echo "<td  style='display:none;' class='text-center' >

											<input class='text-center form-control' id='lineDiscount' name='lineDiscount[]' type='text' value='$lineDiscountText'  >


 </td>";

											$lineTotal = ($unitPrice*$qty/$item->subunits) - $lineDiscount;
											echo "<td  style=\"display:none\" class='text-center' >

											<input class='text-center form-control' id='lineTotal' name='lineTotal[]' type='number' value='$lineTotal'  >


 </td>

 ";
                                            echo "<td class='text-center' style='width:12%' >

											<input class='text-center form-control' id='batchnumber' name='batchnumber' type='text' value='$batchNumber'  >


 </td>

 ";

                                            $stm3 = $db2->prepare("SELECT expiry_date FROM Stock WHERE batch_number='$batchNumber' AND item_id='$itemID' ");
                                            $stm3-> execute();
                                            $stm3-> bind_result($expirydate);
                                            while ($stm3->fetch()) {


                                            }
                                            $stm3->close();



											echo "</tr>";






											$i++;

										}
										$stm-> close();









									} else {

										$popoverText = "";
										$popoverTextExtras = "";


										for ($i = 1; $i <= 2; $i++) {

											echo "<tr>";

											echo "<td  >
<img class='deletRowButton' src='//" . HTML_PATH . "/cop/backend/themes/" . THEME_NAME . "/img/deleteicon.png' style='width:20px;height:20px;'/>
												</td>";

											echo "<td class='index text-center' style='width:3%'>
                                                     <strong>$i</strong>
												</td>";

											echo "<td style='display:none;'>
          	    <input   id='itemID' name='itemID' type='hidden' value=''>
          	    </td>
          	    <td style='display:none;'>

          	    </td>
          	    <td style='display:none;'>
          	    <input  id='globalDiscount' name='globalDiscount' type='hidden' value=''>
          	    </td>
          	    <td style='display:none;'>
                <input  id='vatLine' name='vatLine' type='hidden' value=''>
                </td>
                <td style='display:none;'>
                <input  id='vatPercentage' name='vatPercentage' type='hidden' value=''>
</td>
<td>

				<input style='width:100%' class='itemCode text-center form-control' id='itemCode' name='itemCode' type='text' value=''>



        </td>";

											echo "<td style='width:22%' class='text-center'  >

	<input style='width:100%' class='itemCode text-center form-control' id='itemDetails' name='itemDetails' type='text' value='' disabled>

 </td>";

                                            echo "<td style='width:22%' class='text-center'  >

	<input style='width:100%' class='text-center form-control' id='itemNotes' name='itemNotes' type='text' value='$itemNotes'>

 </td>";

											echo "<td style='display:none;' class='text-center' >

											<select  class='form-control' id='priceCode' name='priceCode' type='text' value=''  disabled>

                                             </select>
 </td>";

											echo "<td style='display:none;' class='text-center' >

											<input  class='text-center form-control' id='unitPrice' name='unitPrice[]' type='number' value=''  rel='popover' data-trigger='focus'
											      data-placement='bottom' data-original-title='<h4>History Info</h4>'
											      data-content=\"\" data-html='true' disabled>


 </td>";

											echo "<td  style='width:12%' class='text-center' >
                                            <div id='unitsDiv'>
  <input  id='subUnits' name='subUnits' type='hidden' value=''>
											      <input class='text-center form-control' id='qty' name='qty[]' type='number' value='' rel='popover' data-trigger='focus'
											      data-placement='bottom' data-original-title='<h4>Stock Info</h4>'
											      data-content=\"\" data-html='true' disabled>









                                             </div>
                                            <div id='subunitsDiv' style='display: none'>
                                            <input class='text-center form-control' style='display:inline;width:45%' id='qtyUnits' name='qty[]' type='number' value='' placeholder='Units'  rel='popover' data-trigger='focus'
											      data-placement='bottom' data-original-title='<h4>Stock Info</h4>'
											      data-content=\"$popoverText\" data-html='true' disabled>

											<input class='text-center form-control'  style='display:inline;width:45%'id='qtySubunits' name='qty[]' type='number' value='' placeholder='Subunits'  disabled>

                                             </div>
 </td>";

											echo "<td  style='display:none;'class='text-center' >

										<label class='text-center' id='vat'></label>


 </td>";
											echo "<td  style='display:none;' class='text-center' >

										  <button class='btn btn-info' id='extrasButton' rel='popover' data-trigger='click' data-placement='top' data-original-title='<h4>Stock Info</h4>'
											      data-content=\"$popoverTextExtras\" data-html='true' disabled><i class='fa fa-search'>
												</i></button>


 </td>";
											echo "<td  style='display:none;' class='text-center' >

											<input class='text-center form-control' id='lineDiscount' name='lineDiscount[]' type='text' value=''  disabled>


 </td>";
											echo "<td  class='text-center' style=\"display:none\">

											<input class='text-center form-control' id='lineTotal' name='lineTotal[]' type='number' value=''  disabled>


 </td>

 ";
                                            echo "<td class='text-center' style='width:12%' >

											<input class='text-center form-control' id='batchnumber' name='batchnumber' type='text' value=''  >


 </td>

 ";



											echo "</tr>";
										}

									}


									?>

									</tbody>

								</table>




								<div class="row" style="margin-top:4px;margin-right:3px;">
									<div class="col-sm-9">

										<div class="col-sm-12" style="margin-top:8px;">
									      <span class="col-sm-2" >
											<a target="_blank" id="newLineButton" class="btn btn-primary btn-block">
												<i class="fa fa-plus  ">
												</i>&nbsp; Add Line</a>
										</span>
										</div>
										<div class="col-sm-12" style="margin-top:10px;" >
											<div class='col-sm-8'>
												<label class="label-bold form-label-space">Notes: </label>
												<textarea style='width:100%;' class='form-control custom-textarea' rows='3' id='details'><?php if($edit){echo $details;} ?></textarea><br>
											</div>
										</div>

									</div>
									<div class="col-sm-3" style="display: none;">
										<div>
											<div class="font-md">
												<strong>Subtotal :</strong>
												<span id='subtotal'class="pull-right"><?php if($edit){echo $subtotal -$lineDiscountTotals;;} ?></span>
											</div>
										</div>
										<div>
											<div class="font-md" style="display:inline-block">
												<strong style="display:inline;">Discount :</strong>
												<input style="display:inline;width:45%" class='text-right form-control slim-input pull-right'  id='discount' oninput="this.value = this.value.replace(/[^0-9%.]/g, '').replace(/(\..*?)\..*/g, '$1');" name='discount' type='text' value='<?php if($edit){

													if($globalDiscountPercentage>0)
													{
														$globalDiscountText = $globalDiscountPercentage."%";
													}
													else{
														$globalDiscountText= $discountAmount -$lineDiscountTotals;
													}
													echo $globalDiscountText;
												} ?>'>
											</div>

										</div>
										<div>
											<div class="font-md">
												<strong>Net Amount :</strong>
												<span  id='netAmount' class="pull-right"><?php if($edit){echo $subtotal -$discountAmount;} ?></span>
											</div>

										</div>
										<div>
											<div class="font-md">
												<strong>VAT :</strong>
												<span  id='vatTotal' class="pull-right"><?php if($edit){echo $vatAmount;} ?></span>
											</div>

										</div>

										<div style='margin-top:4px;' class="well well-sm  bg-color-darken txt-color-white no-border">
											<div class="fa-lg">
												Grand Total :
												<span  id='grandTotal' class="pull-right"><?php if($edit){echo $grandTotal;} ?></span>
											</div>
                                        <input type="hidden" id="noZero" value="0">
                                        <input type="hidden" id="blank"  value="yes">
                                        <?php echo $orderIDInput?>
										</div>
										<br>
										<br>
									</div>
								</div>


							</div>
							<!-- end widget content -->

						</div>
						<!-- end widget div -->

					</div>
					<!-- end widget -->
			</div>

			<!-- end row -->



		</section>
	</div>
</div>

<style>

	td input {
		width:100%;
	}

	table#datatable_fixed_column tr td img { display:none;}
	table#datatable_fixed_column tr:hover td img { display:inline-block;}

	table#datatable_fixed_column {
		border: solid 1px #407bad;
	}

	table#datatable_fixed_column thead  {
		border: solid 1px #407bad;
	}

	table#datatable_fixed_column thead th {
		background-color: #4682B4;
		color: white;
		font-family: arial, sans-serif;
	}

	.form-control {
		font-family: arial, sans-serif;
		border-radius: 4px !important;
		color: #000;
		font-weight:400;
		margin: 0px;
		padding: 0px;
	}

	table#datatable_fixed_column tr td {
		padding-left:4px;
		padding-right:4px;
	}

	td.index {
		font-weight:bold;
	}

	.form-control:disabled {
		background-color: #fcfcfc;
	}



	.slim-input {
		height:22px;
		margin-left:8px;
		font-family: Calibri;
	}

	.small-margin {
		margin-bottom: 5px !important;
	}

	#detailsTable thead th {
		background-color: white !important;
		border:none;
		height:0px;
	}

	.align-left {
		text-align: left;
	}

	.popover {
		position: absolute;
		top: 0;
		left: 0;
		z-index: 1010;
		display: none;
		max-width: 600px;
		padding: 1px;
		text-align: left;
		white-space: normal;
		background-color: #ffffff;
		border: 1px solid #ccc;
		border: 1px solid rgba(0, 0, 0, 0.2);
		-webkit-border-radius: 6px;
		-moz-border-radius: 6px;
		border-radius: 6px;
		-webkit-box-shadow: 0 5px 10px rgba(0, 0, 0, 0.2);
		-moz-box-shadow: 0 5px 10px rgba(0, 0, 0, 0.2);
		box-shadow: 0 5px 10px rgba(0, 0, 0, 0.2);
		-webkit-background-clip: padding-box;
		-moz-background-clip: padding;
		background-clip: padding-box;
	}

</style>
<script src="//<?php echo HTML_PATH ?>/cop/backend/themes/<?php echo THEME_NAME ?>/js/jquery.tabletojson.js"></script>
<script type="text/javascript">

	function addGlobalDiscount() {
		//var $itemRow = $($this).closest('tr');
		//var $itemRow = $($this).closest('tr');
		// Calculate the price of the row.  Remove any $ so the calculation doesn't break
		subTotal = $('#subtotal').text();
		globalDiscount = $('#discount').val();

		if (globalDiscount.indexOf("%") >= 0)
		{
			globalDiscount = $('#discount').val().replace("%", "");


		}
		else
		{
			globalDiscount = globalDiscount/subTotal*100;
		}







		if(globalDiscount=='')
		{
			globalDiscount=0;
		}




		$('#datatable_fixed_column tr').each(function (i, row) {

			// reference all the stuff you need first
			var $itemRow = $(row);
			var percentage=  $itemRow.find('#vatPercentage').val();
			lineTotal =$itemRow.find('#lineTotal').val();

			globalDiscountOfLine = lineTotal *globalDiscount/100;
			$itemRow.find('#globalDiscount').val(globalDiscountOfLine);

			vatLine = (lineTotal-globalDiscountOfLine)*percentage/100;
			//    alert(vatLine);
			$itemRow.find('#vatLine').val(vatLine);


		});





		updateTotals();
	}
	function changeLineTotal($itemRow) {
		//var $itemRow = $($this).closest('tr');
		//var $itemRow = $($this).closest('tr');
		// Calculate the price of the row.  Remove any $ so the calculation doesn't break
		var lineTotal =$itemRow.find('#lineTotal').val();
		lineDiscount = $itemRow.find('#lineDiscount').val();


		if(lineDiscount=='') {


			lineTotal = lineTotal - lineDiscount;
			lineTotal = roundNumber(lineTotal, 2);
			var vatTotal = 0;
			var percentage = $itemRow.find('#vatPercentage').val();
			var check = $itemRow.find('#subUnits').val();
			if (check == 1) {
				$itemRow.find('#unitPrice').val(lineTotal / $itemRow.find('#qty').val());
			}
			else {

				if ($itemRow.find('#qtySubunits').val() == '') {
					$itemRow.find('#qtySubunits').val(0)
				}

				$itemRow.find('#unitPrice').val(lineTotal / (+$itemRow.find('#qtyUnits').val() + +($itemRow.find('#qtySubunits').val() / $itemRow.find('#subUnits').val())));

			}
		}

		updateTotals();
	}



	function updateLineTotal($itemRow) {
		//var $itemRow = $($this).closest('tr');
		//var $itemRow = $($this).closest('tr');
		// Calculate the price of the row.  Remove any $ so the calculation doesn't break
		var lineTotal =0;
		var vatTotal =0;
		var percentage=  $itemRow.find('#vatPercentage').val();
		var check=  $itemRow.find('#subUnits').val();

		if(check ==1) {
			lineTotal = $itemRow.find('#unitPrice').val().replace("€", "") * $itemRow.find('#qty').val();
		}
		else
		{
			if($itemRow.find('#qtySubunits').val()=='')
			{
				$itemRow.find('#qtySubunits').val(0)
			}
			lineTotal = $itemRow.find('#unitPrice').val().replace("€", "") * $itemRow.find('#qtyUnits').val()+$itemRow.find('#unitPrice').val().replace("€", "") * $itemRow.find('#qtySubunits').val()/$itemRow.find('#subUnits').val();
		}

		lineDiscount = $itemRow.find('#lineDiscount').val();



		if (lineDiscount.indexOf("%") >= 0)
		{
			lineDiscount = $itemRow.find('#lineDiscount').val().replace("%", "");
			lineDiscount = lineTotal*lineDiscount/100;
		}

		if(lineDiscount=='')
		{
			lineDiscount=0;
		}


		globalLineDiscount = $itemRow.find('#globalDiscount').val();


		if(globalLineDiscount=='')
		{
			globalLineDiscount=0;
		}

		lineTotal = lineTotal -lineDiscount;
		lineTotal = roundNumber(lineTotal, 2);
		vatTotal = (lineTotal-globalLineDiscount)*percentage/100;
		isNaN(lineTotal) ? $itemRow.find('#lineTotal').val("N/A") : $itemRow.find('#lineTotal').val(lineTotal);
		isNaN(vatTotal) ? $itemRow.find('#vatLine').val("N/A") : $itemRow.find('#vatLine').val(vatTotal);
		updateTotals();
	}


	function updateTotals() {
		//var $itemRow = $($this).closest('tr');
		//var $itemRow = $($this).closest('tr');
		// Calculate the price of the row.  Remove any $ so the calculation doesn't break
		var subTotal = 0;
		$('input#lineTotal').each(function (i) {
			lineTotal = $(this).val();
			if (!isNaN(lineTotal)) subTotal += Number(lineTotal);
		});

		$('#subtotal').text(this.roundNumber(subTotal, 2));


		globalDiscount = $('#discount').val();


		if (globalDiscount.indexOf("%") >= 0)
		{
			globalDiscount = $('#discount').val().replace("%", "");
			netAmount = subTotal - subTotal*globalDiscount/100;

		}
		else
		{
			netAmount = subTotal - globalDiscount;
		}



		if(globalDiscount=='')
		{
			globalDiscount=0;
			netAmount = subTotal;
		}




		$('#netAmount').text(this.roundNumber(netAmount, 2));





		var vatTotal = 0;
		$('input#vatLine').each(function (i) {
			vatLine = $(this).val();
			if (!isNaN(vatLine)) vatTotal += Number(vatLine);
		});


		$('#vatTotal').text(this.roundNumber(vatTotal, 2));
		$('#grandTotal').text(this.roundNumber(netAmount+vatTotal, 2));
	}

	function roundNumber (number, decimals) {
		var newString;// The new rounded number
		decimals = Number(decimals);
		if (decimals < 1) {
			newString = (Math.round(number)).toString();
		} else {
			var numString = number.toString();
			if (numString.lastIndexOf(".") == -1) {// If there is no decimal point
				numString += ".";// give it one at the end
			}
			var cutoff = numString.lastIndexOf(".") + decimals;// The point at which to truncate the number
			var d1 = Number(numString.substring(cutoff, cutoff + 1));// The value of the last decimal place that we'll end up with
			var d2 = Number(numString.substring(cutoff + 1, cutoff + 2));// The next decimal, after the last one we want
			if (d2 >= 5) {// Do we need to round up at all? If not, the string will just be truncated
				if (d1 == 9 && cutoff > 0) {// If the last digit is 9, find a new cutoff point
					while (cutoff > 0 && (d1 == 9 || isNaN(d1))) {
						if (d1 != ".") {
							cutoff -= 1;
							d1 = Number(numString.substring(cutoff, cutoff + 1));
						} else {
							cutoff -= 1;
						}
					}
				}
				d1 += 1;
			}
			if (d1 == 10) {
				numString = numString.substring(0, numString.lastIndexOf("."));
				var roundedNum = Number(numString) + 1;
				newString = roundedNum.toString() + '.';
			} else {
				newString = numString.substring(0, cutoff) + d1.toString();
			}
		}
		if (newString.lastIndexOf(".") == -1) {// Do this again, to the new string
			newString += ".";
		}
		var decs = (newString.substring(newString.lastIndexOf(".") + 1)).length;
		for (var i = 0; i < decimals - decs; i++) newString += "0";
		//var newNumber = Number(newString);// make it a number if you like
		return newString; // Output the result to the form field (change for your purposes)
	}

	function updateTrNumbering()
	{
		var $i = 0;
		$('#datatable_fixed_column tr').each(function (i, row) {

			// reference all the stuff you need first
			var $row = $(row);

			$row.find("td.index").text($i);
			$i++;
		});
	}

	function initCustomerCodeAutocomplete()
	{
		$("#customerSearch").autocomplete({
			source: "//<?php echo HTML_PATH ?>/cop/backend/core/controllers/autocomplete/customer_autocomplete.php",
			autoFocus: true,
			select: function (event, ui) {
				$('#customerID').val(ui.item.customer_id);
				$('#customerCode').text(ui.item.customer_code);
				$('#customerName').text(ui.item.customer_company_name);
				$('#balance').text(ui.item.balance);

				var optionsAsString = "";
				for(var i = 0; i < ui.item.addresses.length; i++) {
					if(i==0)
					{
						optionsAsString += "<option value=\"" + ui.item.addresses[i].id + "\" selected>" + ui.item.addresses[i].addressLine1 + "</option>";
					}
					else{
						optionsAsString += "<option value=\"" + ui.item.addresses[i].id + "\">" + ui.item.addresses[i].addressLine1 + "</option>";
					}


				}
				$("select[name='deliveryAddress']").find('option').remove().end().append($(optionsAsString));
				$("select[name='billingAddress']").find('option').remove().end().append($(optionsAsString));
				return true;
			}
		});
	}

	function initSalepersonCodeAutocomplete()
	{
		$("#salespersonSearch").autocomplete({
			source: "//<?php echo HTML_PATH ?>/cop/backend/core/controllers/autocomplete/salesperson_autocomplete.php",
			autoFocus: true,
			minLength:0,
			select: function (event, ui) {

				$('#salespersonID').val(ui.item.salesperson_id);
				return true;
			}
		}).focus(function()
			{
				$(this).autocomplete("search","");
			}


		);
	}

function initSupplierAutocomplete()
	{
		$("#supplierSearch").autocomplete({
			source: "//<?php echo HTML_PATH ?>/cop/backend/core/controllers/autocomplete/supplier_autocomplete.php",
			autoFocus: true,
			minLength:0,
			select: function (event, ui) {

				$('#supplierID').val(ui.item.customer_id);
				return true;
			}
		}).focus(function()
			{
				$(this).autocomplete("search","");
			}


		);
	}

	function initWarehouseCodeAutocomplete()
	{
		$("#warehouseSearchFrom").autocomplete({
			source: "//<?php echo HTML_PATH ?>/cop/backend/core/controllers/autocomplete/warehouse_autocomplete.php",
			autoFocus: true,
			minLength:0,
			select: function (event, ui) {

				$('#warehouseIDFrom').val(ui.item.warehouse_id);
				return true;
			}
		}).focus(function()
			{
				$(this).autocomplete("search","");
			}


		);

        $("#warehouseSearchTo").autocomplete({
            source: "//<?php echo HTML_PATH ?>/cop/backend/core/controllers/autocomplete/warehouse_autocomplete.php",
            autoFocus: true,
            minLength:0,
            select: function (event, ui) {

                $('#warehouseIDTo').val(ui.item.warehouse_id);
                return true;
            }
        }).focus(function()
            {
                $(this).autocomplete("search","");
            }


        );
	}

	function initAutocomplete()
	{
		$(".itemCode").autocomplete({
			source: "//<?php echo HTML_PATH ?>/cop/backend/core/controllers/autocomplete/invoice_autocomplete.php",
			autoFocus: true,
			open: function(){
				$('.ui-autocomplete').css('width', '400px');
			},
			select: function (event, ui) {

				var $itemRow = $(this).closest('tr');

				// Modify this  information to match the information coming from assets/ajax-services/fetch-inventory.php
				$itemRow.find('#itemID').val(ui.item.item_id); // Hidden input on form
				$itemRow.find('#itemCode').val(ui.item.item_code);
				$itemRow.find('#itemDetails').val(ui.item.name);
				$itemRow.find('#vat').text(ui.item.vatCode);
				$itemRow.find('#unitPrice').val(ui.item.price);
				$itemRow.find('#subUnits').val(ui.item.subunits);
				$itemRow.find('#vatPercentage').val(ui.item.percentage);






				$itemRow.find('#itemDetails').prop( "disabled", false );
				$itemRow.find('#unitPrice').prop( "disabled", false );
				$itemRow.find('#priceCode').prop( "disabled", false );
				$itemRow.find('#lineDiscount').prop( "disabled", false );
				$itemRow.find('#qty').prop( "disabled", false );
				$itemRow.find('#lineTotal').prop( "disabled", false );
				$itemRow.find('#qtyUnits').prop( "disabled", false );
				$itemRow.find('#qtySubunits').prop( "disabled", false );
				$itemRow.find('#extrasButton').prop( "disabled", false );

				//$itemRow.find('#itemPrice').val(ui.item.itemPrice);




				$($itemRow.find('#priceCode')).bind("change keyup", function() {

					var newPrice= $($itemRow.find('#priceCode option:selected')).attr("data-price");

					$itemRow.find('#unitPrice').val(newPrice);
					updateLineTotal($itemRow);
				});

				$($itemRow.find('#unitPrice')).bind("change keyup", function() {
					validateNumber($($itemRow.find('#unitPrice')));
					updateLineTotal($itemRow);
				});

				$($itemRow.find('#qty')).bind("change keyup", function() {
					validateNumber($($itemRow.find('#qty')));
					updateLineTotal($itemRow);
				});
				$($itemRow.find('#qtyUnits')).bind("change keyup", function() {
					validateNumber($($itemRow.find('#qtyUnits')));
					updateLineTotal($itemRow);
				});
				$($itemRow.find('#qtySubunits')).bind("change keyup", function() {
					validateNumber($($itemRow.find('#qtySubunits')));
					updateLineTotal($itemRow);
				});

				$($itemRow.find('#lineDiscount')).bind("change keyup", function() {
					updateLineTotal($itemRow);
				});

				$($itemRow.find('#lineTotal')).bind("change keyup", function() {

					validateNumber($($itemRow.find('#lineTotal')));
					changeLineTotal($itemRow);
				});

				updateLineTotal($itemRow);





				var customerID= $('#customerID').val();
				var itemID = ui.item.item_id;
				$.ajax({
					type: "POST",
					url: '//<?php echo HTML_PATH ?>/cop/backend/core/controllers/get/getItemPrices.php',
					data: {
						'customerID':customerID,
						'itemID':itemID
					},
					dataType:"json",

					success: function (result) {

						var options = $itemRow.find('#priceCode');
						$itemRow.find('#priceCode').find('option').remove();
						$.each(result, function() {

							options.append($("<option />").val(this.priceTypeID).text(this.priceCode).attr("data-price",this.price));
						});
						var newPrice= $($itemRow.find('#priceCode option:selected')).attr("data-price");
						$itemRow.find('#unitPrice').val(newPrice);
						updateLineTotal($itemRow);

					}
				});


				$.ajax({
					type: "POST",
					url: '//<?php echo HTML_PATH ?>/cop/backend/core/controllers/get/getItemStock.php',
					data: {
						'itemID':itemID
					},

					success: function (result) {


						$itemRow.find('#qtyUnits').attr("data-content",result);
						$itemRow.find('#qty').attr("data-content",result);

					}
				});

				$.ajax({
					type: "POST",
					url: '//<?php echo HTML_PATH ?>/cop/backend/core/controllers/get/getLastPrices.php',
					data: {
						'itemID':itemID,
						'customerID':customerID
					},

					success: function (result) {



						$itemRow.find('#unitPrice').attr("data-content",result);
						if(ui.item.subunits != 1)
						{
							$itemRow.find('#unitsDiv').hide();
							$itemRow.find('#subunitsDiv').show();
							$itemRow.find('#unitPrice').focus();
						}
						else
						{
							$itemRow.find('#unitsDiv').show();
							$itemRow.find('#subunitsDiv').hide();
							$itemRow.find('#unitPrice').focus();
						}

					}
				});

				return false;
			}
		});
	}

	function validateNumber(element)
	{
		if(!element.val())
		{

			element.css('color','red');
		}
		else{
			element.css('color','black');
		}
	}

	function addNewLine()
	{
		$lastTr = $('tr:last', $('#datatable_fixed_column'));
		$lastTd = $('td:last', $lastTr);
		$newTr = $lastTr.clone();
		$lastTr.after($newTr);
		$newTr.find("input").val("");
		$newTr.find("textarea").text("");
		$newTr.find("label").text("");
		$i = $newTr.find("td.index").text();
		$i++;
		$newTr.find("td.index").text($i);

		$newTr.find('#itemDetails').prop( "disabled", true );
		$newTr.find('#unitPrice').prop( "disabled", true );
		$newTr.find('#priceCode').prop( "disabled", true );
		$newTr.find('#lineDiscount').prop( "disabled", true );
		$newTr.find('#qty').prop( "disabled", true );
		$newTr.find('#lineTotal').prop( "disabled", true );
		$newTr.find('#qtyUnits').prop( "disabled", true );
		$newTr.find('#qtySubunits').prop( "disabled", true );


		$( ".deletRowButton" ).click(function() {
			deleteRow(this);
		});

		initAutocomplete();

	}

	function deleteRow(row)
	{
		var rowCount = $('#datatable_fixed_column tr').length;

		if (rowCount > 2) {
			$(row).parents('tr').remove();
		}
		updateTrNumbering();
		updateTotals();
	}



	function saveOrder()
	{

		$("#saveButton").attr("disabled", true);
        $('#noZero').val('0');
		var wtID =$('#wtID').val();
		var warehouseTransactionCode =$('#transactionNumber').val();
        var serviceCallID = $('#serviceCallID').val();
        var fromOrderID = $('#fromOrderID').val();


        var wtDate = $('#wtDate').val();
		var salespersonSearch = $('#salespersonID').val();
        var warehouseIDTo = $('#warehouseIDTo').val();
        var supplierID = $('#supplierID').val();
        var details = $('#details').val();


		var orderItems = $('#datatable_fixed_column').tableToJSON(
			{
				ignoreColumns: [0,1],
				textExtractor : {
					0 : function(cellIndex, $cell) {
						return $cell.find('input').val();
					},
					1 : function(cellIndex, $cell) {
						return $cell.find('input').val();
					},
					2 : function(cellIndex, $cell) {

                        $('#blank').val($cell.find('#itemID').val());

						return $cell.find('input').val();
					},
					3 : function(cellIndex, $cell) {
						return $cell.find('input').val();
					},
					4 : function(cellIndex, $cell) {
						return $cell.find('input').val();
					},
					5 : function(cellIndex, $cell) {
						return $cell.find('input').val();
					},
					6 : function(cellIndex, $cell) {
						return $cell.find('input').val();
					},
					7 : function(cellIndex, $cell) {
						return $cell.find('input').val();
					},
					8 : function(cellIndex, $cell) {
						return $cell.find('input').val();
					},
                    9 : function(cellIndex, $cell) {
                        return $cell.find('input').val();
                    },
					10: function(cellIndex, $cell) {
						return $cell.find('#priceCode').val();
					},
					11: function(cellIndex, $cell) {
						return $cell.find('input').val();
					},
					12: function(cellIndex, $cell) {

					    var isBlank = $('#blank').val();


						var subUnitsValue=  $cell.find('#subUnits').val();
						if(subUnitsValue==1) {

                            if($cell.find('#qty').val() < 0 &&  isBlank > 0){

                                $('#noZero').val('1');
                                $cell.find('#qty').css("border", " solid 1px");
                                $cell.find('#qty').css("color", "firebrick");
                            }

							return $cell.find('#qty').val();
						}
						else
						{
							var qtySub = parseInt($cell.find('#qtyUnits').val()) || 0;
							var qtySubUnits =parseInt($cell.find('#qtySubunits').val()) || 0;
							var result = subUnitsValue*qtySub +qtySubUnits;

                            if(result < 0 && isBlank > 0){

                                $('#noZero').val('1');
                                $cell.find('#qtyUnits').css("border", " solid 1px");
                                $cell.find('#qtyUnits').css("color", "firebrick");
                                $cell.find('#qtySubunits').css("border", " solid 1px");
                                $cell.find('#qtySubunits').css("color", "firebrick");
                            }
                            return result;
						}

					},
					13: function(cellIndex, $cell) {
						return $cell.find('label').text();
					},
					14: function(cellIndex, $cell) {
						return $cell.find('input').val();
					},
					15: function(cellIndex, $cell) {
						return $cell.find('input').val();
					},
					16: function(cellIndex, $cell) {
						return $cell.find('input').val();
					},
					17: function(cellIndex, $cell) {
						return $cell.find('input').val();
					},
					18: function(cellIndex, $cell) {
						return $cell.find('input').val();
					}
				},
				ignoreHiddenRows: false,
				ignoreEmptyRows: false
			}
		);

		var run=true;
		var noZero = $('#noZero').val();

        if( noZero > 0 ){
            run=false;
            $('#zeroQtyLabel').text('* Negative Quantity Transfers Found');
        }
		if(!wtDate|| !salespersonSearch ||!warehouseIDTo)
		{
			run=false;

		}


		if(run) {
			$.ajax({
				type: "POST",
                url: '//<?php echo HTML_PATH; ?>/cop/backend/core/controllers/add/add_stock_adjustment.php',
				data: {
					'wtID': wtID,
					'warehouseTransactionCode': warehouseTransactionCode,
					'wtDate': wtDate,
					'salespersonSearch': salespersonSearch,
					'warehouseIDTo': warehouseIDTo,
                    'serviceCallID': serviceCallID,
                    'fromOrderID': fromOrderID,
                    'supplierID': supplierID,
                    'details': details,
					'orderItems': orderItems
				},

				success: function (result) {
                    if(result.localeCompare('error')===0){
                        $.smallBox({
                            title: "Warning!",
                            content: "Something Went Wrong Please Try again.",
                            color: '#b22222',
                            timeout: 3000,
                            icon: "fa fa-user swing animated"
                        });
                        $("#saveButton").attr("disabled", false);
                    } else {
                        $.smallBox({
                            title: "Success!",
                            content: "Adjustment successfully entered",
                            color: "#739E73",
                            timeout: 3000,
                            icon: "fa fa-user swing animated"
                        });

                        window.location.replace("//<?php echo HTML_PATH ?>/cop/backend/core/views/view/view_stock_adjustment.php?sa_id=" + result);
                    }

				}

			});

		}
		else
		{
			$.smallBox({
				title: "Error!",
				content: "Please Complete Adjustment data",
				color: "#b22222",
				timeout: 3000,
				icon: "fa fa-user swing animated"
			});
			$("#saveButton").attr("disabled", false);
		}





		//	alert(JSON.stringify(addresses));

		//	alert(JSON.stringify(contractPrices));
	}


	$(document).ready(function() {

		pageSetUp();

		var edit = <?php if($edit){
            echo "true";
            }
            else
            {
            echo "false";

            }?>;

		$('#discount').bind("change keyup", function() {
			addGlobalDiscount();
		});

		$('#datatable_fixed_column').on('keydown', 'input', function (e) {
			var keyCode = e.keyCode;
			if (keyCode !== 9) return;
			var $this = $(this),
				$lastTr = $('tr:last', $('#datatable_fixed_column')),
				$lastTd = $('td:last', $lastTr);
			if (($(e.target).closest('td')).is($lastTd)) {
				$newTr = $lastTr.clone();
				$lastTr.after($newTr);
				$newTr.find("input").val("");
				$newTr.find("textarea").text("");
				$newTr.find("label").text("");
				$i = $newTr.find("td.index").text();
				$i++;
				$newTr.find("td.index").text($i);

				$newTr.find('#itemDetails').prop( "disabled", true );
				$newTr.find('#unitPrice').prop( "disabled", true );
				$newTr.find('#priceCode').prop( "disabled", true );
				$newTr.find('#lineDiscount').prop( "disabled", true );
				$newTr.find('#qty').prop( "disabled", true );
				$newTr.find('#lineTotal').prop( "disabled", true );
				$newTr.find('#qtyUnits').prop( "disabled", true );
				$newTr.find('#qtySubunits').prop( "disabled", true );

				initAutocomplete();
				$( ".deletRowButton" ).click(function() {
					deleteRow(this);
				});
			}
		});

		$('#datatable_fixed_column').on('keydown', 'input', function (e) {
			var keyCode = e.keyCode;
			if (keyCode !== 13) return;
			var $this = $(this);

			var $thisTd = $(e.target).closest('tr');
			$lastTd = $('td:last', $thisTd);

			if (($(e.target).closest('td')).is($lastTd)) {
				$newTr = $thisTd.clone();
				$thisTd.after($newTr);
				$newTr.find("input").val("");
				$newTr.find("textarea").text("");
				$newTr.find("label").text("");
				$i = $newTr.find("td.index").text();
				$i++;
				$newTr.find("td.index").text($i);

				$newTr.find('#itemDetails').prop( "disabled", true );
				$newTr.find('#unitPrice').prop( "disabled", true );
				$newTr.find('#priceCode').prop( "disabled", true );
				$newTr.find('#lineDiscount').prop( "disabled", true );
				$newTr.find('#qty').prop( "disabled", true );
				$newTr.find('#lineTotal').prop( "disabled", true );
				$newTr.find('#qtyUnits').prop( "disabled", true );
				$newTr.find('#qtySubunits').prop( "disabled", true );

				initAutocomplete();
				$(".deletRowButton").click(function () {
					deleteRow(this);
				});
			}
			updateTrNumbering();

		});

		$( "#newLineButton" ).click(function() {
			addNewLine();
		});

		$( ".deletRowButton" ).click(function() {
			deleteRow(this);
		});

		initAutocomplete();
		initCustomerCodeAutocomplete();
        initSupplierAutocomplete();
		initSalepersonCodeAutocomplete();
		initWarehouseCodeAutocomplete();
		var fixHelperModified = function(e, tr) {
				var $originals = tr.children();
				var $helper = tr.clone();
				$helper.children().each(function(tr) {
					$(this).width($originals.eq(tr).width())
				});
				return $helper;
			},
			updateIndex = function(e, ui) {
				$('td.index', ui.item.parent()).each(function (i) {
					$(this).text(i + 1);
				});
			};

		$("#datatable_fixed_column tbody").sortable({
			helper: fixHelperModified,
			stop: updateIndex
		});

		if(edit) {
			$('#datatable_fixed_column tr').each(function (i, row) {

				// reference all the stuff you need first
				var $itemRow = $(row);
				$($itemRow.find('#priceCode')).bind("change keyup", function () {

					var newPrice = $($itemRow.find('#priceCode option:selected')).attr("data-price");

					$itemRow.find('#unitPrice').val(newPrice);
					updateLineTotal($itemRow);
				});

				$($itemRow.find('#unitPrice')).bind("change keyup", function () {
					validateNumber($($itemRow.find('#unitPrice')));
					updateLineTotal($itemRow);
				});

				$($itemRow.find('#qty')).bind("change keyup", function () {
					validateNumber($($itemRow.find('#qty')));
					updateLineTotal($itemRow);
				});
				$($itemRow.find('#qtyUnits')).bind("change keyup", function () {
					validateNumber($($itemRow.find('#qtyUnits')));
					updateLineTotal($itemRow);
				});
				$($itemRow.find('#qtySubunits')).bind("change keyup", function () {
					validateNumber($($itemRow.find('#qtySubunits')));
					updateLineTotal($itemRow);
				});

				$($itemRow.find('#lineDiscount')).bind("change keyup", function () {
					updateLineTotal($itemRow);
				});

				$($itemRow.find('#lineTotal')).bind("change keyup", function () {
					validateNumber($($itemRow.find('#lineTotal')));
					changeLineTotal($itemRow);
				});




			});


		}
	})

</script>

<script src="//<?php echo HTML_PATH ?>/cop/backend/themes/<?php echo THEME_NAME ?>/js/plugin/select2/select2.min.js"></script>
