<?php
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);
include_once("../../../../param.php");
require_once(ROOT . "concc/dbhelpers/classes/DBItem.php");
$dbHelbelItem= new DBItem();
$customerID = 0;


if (isset($_GET['promotionID']) && !empty($_GET['promotionID'])) {
    $promotionID = intval($_GET['promotionID']);
    $edit = true;
} else {
    $promotionID = 0;
    $edit = false;

}
$customers=[];
$salesPersons=[];
$customerGroups=[];

$pricetypeSelection = ''; //check and delete
$primaryItemPrices='';

$promotionCode = '';
$promotionName = '';
$description = '';
$promotype = 0;
$primaryItemID = 0;
$qty = 0;
$fixedDiscountAmount = 0;
$fixedDiscountPercent = 0;
$pricetypeProductID = 0;
$promoPrice = 0;
$discountQty = 0;
$discountPercentOnQty = 0;
$validFrom = '';
$validUntil = '';
$loyaltyPoints = 0;
$allCustomers = '';
$allSalespersons = '';
$promoStatus = '';
$primaryItemCode = '';
$primaryItemName = '';

if($edit) {
    global $username, $password, $database;
    $db = new mysqli(localhost, $username, $password, $database);
    if (mysqli_connect_errno()) {
        printf("Connect failed: %s\n", mysqli_connect_error());
        exit();
    }
    $db->set_charset("utf8");

    // get promotion info
    $stm = $db->prepare("SELECT   promotion_code, promotion_name,description,type,Promotions.item_id,qty,fixed_discount_amount,fixed_discount_percent,pricetype_id,
                                    price,discount_qty, discount_percent_on_qty, printing_layout,color_in_cart,valid_from,valid_until, loyalty_points, all_customers,all_salespersons,Promotions.status,Items.item_code,Items.name
                            FROM    Promotions LEFT JOIN Items ON Promotions.item_id = Items.item_id
                            WHERE   promotion_id  = ? 
                            LIMIT 1");


    $stm->bind_param("i", $promotionID);
    $stm->execute();
    $stm->bind_result($promotionCode, $promotionName, $description, $promotype, $primaryItemID, $qty, $fixedDiscountAmount, $fixedDiscountPercent, $pricetypeProductID, $promoPrice, $discountQty, $discountPercentOnQty, $printingLayout, $colorInCart, $validFrom, $validUntil, $loyaltyPoints, $allCustomers, $allSalespersons, $promoStatus, $primaryItemCode, $primaryItemName);
    while ($stm->fetch()) {
    }

    $stm->close();

    //Get pricetypes
    $stm = $db->prepare("SELECT distinct (pricetype_id), name FROM PriceTypes  ");
    $stm->execute();
    $stm->bind_result($pricetypeID, $pricetypeName);
    while ($stm->fetch()) {
        if ($pricetypeID = $pricetypeProductID)
            $pricetypeSelection .= '<option value="' . $pricetypeID . '">' . $pricetypeName . '</option>';

    }
    $stm->close();
    //end pricetypes DELETE

    $primaryItemPrices = $dbHelbelItem->getDefaultPrice($primaryItemID,$customerID);

    //get customers
    $stm = $db->prepare("SELECT c.customer_id,c.customer_code, c.customer_company_name
                                FROM Promotion_Customer AS pc INNER JOIN Customers AS c ON pc.customer_id = c.customer_id
                                WHERE promotion_id = ? ");
    $stm->bind_param("i", $promotionID);
    $stm->execute();
    $stm->bind_result($customerID, $customerCode, $customerName);
    while ($stm->fetch()) {
        $customers[] = [  'id' => $customerID,'text' => $customerCode . " " . $customerName ];
    }
    $stm->close();

    //get salespersons
    $stm = $db->prepare("SELECT s.salesperson_id,s.salesperson_code, CONCAT(s.first_name, ' - ', s.last_name) 
                                FROM Promotion_Salesperson AS ps INNER JOIN SalesPersons AS s ON ps.salesperson_id= s.salesperson_id
                                WHERE promotion_id = ? ");
    $stm->bind_param("i", $promotionID);
    $stm->execute();
    $stm->bind_result($salesPersonID, $salesPersonCode, $fullName);
    while ($stm->fetch()) {
        $salesPersons[] = [  'id' => $salesPersonID,'text' => $salesPersonCode . " " . $fullName ];
    }
    $stm->close();

    //get customer groups
    $stm = $db->prepare("SELECT c.group_id, c.group_code, c.name
                                FROM Promotion_Customer_Group AS pc INNER JOIN CustomerGroups AS c ON pc.group_id = c.group_id
                                WHERE promotion_id = ? ");
    $stm->bind_param("i", $promotionID);
    $stm->execute();
    $stm->bind_result($customerGroupID, $customerGroupCode, $customerGroupName);
    while ($stm->fetch()) {
        $customerGroups[] = [  'id' => $customerGroupID,'text' => $customerGroupCode . " " . $customerGroupName ];
    }
    $stm->close();


    $db->close();
}


$validFrom = new DateTime($validFrom);
$validFrom = $validFrom->format("Y-m-d");
$validUntil = new DateTime($validUntil);
$validUntil = $validUntil->format("Y-m-d");


?>
<div id="main" role="main">

    <!-- Start CUSTOM CODE-->

    <!-- RIBBON -->
    <div id="ribbon" class="bg-color-blue">

				<span class="ribbon-button-alignment">
					<span id="refresh" class="btn btn-ribbon2" onclick="location.reload(true); " data-title="refresh" rel="tooltip" data-placement="bottom" data-original-title="<i class='text-warning fa fa-warning'></i> Reload Page?" data-html="true">
					<i class="fa fa-refresh"></i>
					</span>
				</span>

        <!-- breadcrumb -->
        <ol class="breadcrumb">
            <li class="txt-color-white">Home / Edit Promotion </li>
        </ol>
        <!-- end breadcrumb -->

    </div>
    <!-- END RIBBON -->

    <!-- MAIN CONTENT -->
    <div id="content">

        <div class="row">
            <div class="col-xs-12 col-sm-8 col-md-9 col-lg-10">
                <h3 class="page-title txt-color-blueDark header-margin">
                    <i class="fa-fw fa fa-info"></i>
                    Promotion
                </h3>
            </div>
            <div class="col-xs-12 col-sm-4 col-md-3 col-lg-2">
		<span class="pull-right show-stat-buttons"> <span ><a target="_blank" onclick="savePromotion();" id ="savePromotionButton" class="btn btn-success btn-block" style = "margin-bottom: 2px"><i class="fa fa-check"></i>&nbsp; Save Promotion</a> </span>
            </div>


        </div>

        <!-- row -->
        <section id="widget-grid" class="">

            <div class="row">

                <!-- NEW WIDGET START -->
                <!-- NEW WIDGET START -->
                <article class="col-xs-12 col-sm-12 col-md-12 col-lg-12">

                    <div class="jarviswidget jarviswidget-color-blueDark no-margin" id="wid-id-0" data-widget-editbutton="false" data-widget-deletebutton="false">
                        <header>
                            <span class="widget-icon"> <i class="fa fa-table"></i> </span>
                            <h2>Promotion Form</h2>

                        </header>

                        <!-- widget div-->
                        <div>

                            <!-- widget content -->
                            <div class="widget-body no-padding">

                                <form action="" id="checkout-form" class="smart-form">
                                    <fieldset>
                                        <div class="row">

                                            <!-- START Promo Details -->
                                            <section class="col col-6 no-margin" style="padding-right:2px">
                                                <section>
                                                    <i class="fa-fw fa fa-money fa-lg"></i>
                                                    <h3 style="display: inline;margin-left:6px;vertical-align: middle"> Promotion Details</h3>
                                                </section>
                                                <table class="table" width="100%" border="0" cellpadding="0" cellspacing="0">
                                                    <tr>
                                                        <td class="custom-td-label"><label class="label-bold align-left">Promotion Code: </label></td>
                                                        <td class="custom-td-input"><input class='text-center form-control ' id='promoCode' name='promoCode' type='text' maxlength="10" value="<?php echo $promotionCode; ?>"></td>
                                                        <td style='display:none;'><input id='promotionID' name='promotionID' type='hidden'  value='<?php echo $promotionID?>' /></td>

                                                    </tr>
                                                    <tr>
                                                        <td class="custom-td-label"><label class="label-bold align-left">Name: </label></td>
                                                        <td class="custom-td-input"><input class='text-center form-control ' id='promoName' name='promoName' type='text' value="<?php echo $promotionName; ?>"></td>
                                                    </tr>
                                                    <tr>
                                                        <td class="custom-td-label"><label class="label-bold align-left">Description: </label></td>
                                                        <td class="custom-td-input"><textarea class='text-center form-control ' id='promoDescription' name='promoDescription'><?php echo $description; ?></textarea></td>
                                                    </tr>
                                                    <tr>
                                                        <td class="custom-td-label"><label class="label-bold align-left">Valid from: </label></td>
                                                        <td class="custom-td-input"><input class='text-center form-control ' id='promoStartDate' name='promoStartDate' type='date' value="<?php echo $validFrom; ?>"></td>
                                                    </tr>
                                                    <tr>
                                                        <td class="custom-td-label"><label class="label-bold align-left">Valid to: </label></td>
                                                        <td class="custom-td-input"><input class='text-center form-control ' id='promoEndDate' name='promoEndDate' type='date' value="<?php echo $validUntil; ?>"></td>
                                                    </tr>
                                                    <tr>
                                                        <td class="custom-td-label"><label class="label-bold align-left">Primary Product: </label></td>
                                                        <td class="custom-td-label"> <input class='text-center ' id="primaryItem" name="primaryItem" </td>
                                                    </tr>
                                                    <tr >
                                                        <td class="custom-td-label"><label class="label-bold align-left">Price Type: </label></td>
                                                        <td class="custom-td-input">
                                                            <select class='text-center form-control ' id='primaryItemPriceType' name='primaryItemPriceType'>
                                                                <?php
                                                                foreach($primaryItemPrices as $pricing) {
                                                                    if($pricetypeProductID == $pricing->priceTypeID){
                                                                        echo "<option value='$pricing->priceTypeID' selected > $pricing->priceCode</option>";
                                                                    }else {
                                                                        echo "<option value='$pricing->priceTypeID' >$pricing->priceCode</option>";
                                                                    }
                                                                }
                                                                ?>
                                                            </select>

                                                    </tr>
                                                    <tr>
                                                        <td class="custom-td-label"><label class="label-bold align-left">Promo Type: </label></td>
                                                        <td class="custom-td-input">
                                                            <select class='text-center form-control ' id='promoType' name='promoType'>
                                                                <option value="0" <?php echo ($promotype == 0) ? 'selected' : ''; ?>>Quantity Discount</option>
                                                                <option value="1" <?php echo ($promotype == 1) ? 'selected' : ''; ?>>Multy Items Promotion</option>
                                                                <option value="3" <?php echo ($promotype == 3) ? 'selected' : ''; ?>>Category promotions</option>
                                                                <option value="7" <?php echo ($promotype == 7) ? 'selected' : ''; ?>>Category promotions with Extra Item</option>
                                                                <option value="5" <?php echo ($promotype == 5) ? 'selected' : ''; ?>>Coupon</option>
                                                                <option value="-1" <?php echo (!in_array($promotype, [0, 1, 3, 7, 5])) ? 'selected' : ''; ?>>Unknown Promotion type</option>
                                                            </select>
                                                        </td>
                                                    </tr>
                                                    <tr>
                                                        <td class="custom-td-label"><label class="label-bold align-left">Status: </label></td>
                                                        <td class="custom-td-input">
                                                            <select class='text-center form-control ' id='promoStatus' name='promoStatus'>
                                                                <option value="yes" selected>Active</option>
                                                                <option value="no" <?php echo ($promoStatus != 'yes') ? 'selected' : ''; ?>>Inactive</option>
                                                            </select>
                                                        </td>
                                                    </tr>
                                                </table>
                                            </section>


                                            <!-- Conditions Section -->
                                            <section class="col col-6 no-margin" style="border-left:1px dotted #ADD8E6;padding-right:2px;">
                                                <section>
                                                    <i class="fa-fw fa fa-bar-chart-o fa-lg"></i>
                                                    <h3 style="display: inline;margin-left:6px;vertical-align: middle"> Conditions</h3>
                                                </section>
                                                <table class="table" width="100%" border="0" cellpadding="0" cellspacing="0">
                                                    <tr style="display: none;" class="promo-fields" id="promoRowQty">
                                                        <td class="custom-td-label"><label class="label-bold align-left">Quantity: </label></td>
                                                        <td class="custom-td-input"><input class='text-center form-control ' id='quantity' name='quantity' type='number'  min="0" value="<?php echo intval($qty); ?>"></td>
                                                    </tr>
                                                    <tr style="display: none;" class="promo-fields" id="promoRowDiscountAmount">
                                                        <td class="custom-td-label"><label class="label-bold align-left">Fixed Discount Amount: </label></td>
                                                        <td class="custom-td-input"><input class='text-center form-control ' id='fixedDiscAmount' name='fixedDiscAmount' type='number'  min="0" step="0.01" value="<?php echo floatval($fixedDiscountAmount); ?>"></td>
                                                    </tr>
                                                    <tr style="display: none;" class="promo-fields" id="promoRowDiscountPercent">
                                                        <td class="custom-td-label"><label class="label-bold align-left">Fixed Discount Percent: </label></td>
                                                        <td class="custom-td-input"><input class='text-center form-control ' id='fixedDiscPercent' name='fixedDiscPercent' type='number' min="0" step="0.01" value="<?php echo floatval($fixedDiscountPercent); ?>"></td>
                                                    </tr>

                                                    <tr style="display: none;" class="promo-fields" id="promoRowPrice">
                                                        <td class="custom-td-label"><label class="label-bold align-left">Price: </label></td>
                                                        <td class="custom-td-input"><input class='text-center form-control ' id='price' name='price' type='number' min="0" step="0.01" value="<?php echo $promoPrice; ?>"></td>
                                                    </tr>
                                                    <tr style="display: none;" class="promo-fields" id="promoRowDiscountQty">
                                                        <td class="custom-td-label"><label class="label-bold align-left">Discount Quantity: </label></td>
                                                        <td class="custom-td-input"><input class='text-center form-control ' id='discountQty' name='discountQty'  min="0" type='number' value="<?php echo intval($discountQty); ?>"></td>
                                                    </tr>
                                                    <tr style="display: none;" class="promo-fields" id="promoRowDiscountPercentQty">
                                                        <td class="custom-td-label"><label class="label-bold align-left">Discount Percent on Quantity: </label></td>
                                                        <td class="custom-td-input"><input class='text-center form-control ' id='discountPercentQty' name='discountPercentQty'  min="0" type='number' step="0.01" value="<?php echo floatval($discountPercentOnQty); ?>"></td>
                                                    </tr>


                                                </table>
                                                <!-- Extra item-->
                                                <section id="extraItemSection" class="promo-fields"  style="display: none; margin-top:30px">
                                                    <i class="fa-fw fa fa-gift fa-lg"></i>
                                                    <h3 style="display: inline;margin-left:6px;vertical-align: middle"> Promotion Extra Item</h3>
                                                </section>

                                                <div style="width:100%;" id="extraItemContainer" class="promo-fields" >
                                                    <table id="extra_item_table" class="table table-striped table-hover dataTable" width="100%" border="0" cellpadding="0" cellspacing="0">

                                                        <thead>

                                                        <tr>
                                                            <th class='text-center'></th>
                                                            <th class='text-center'>#</th>
                                                            <th class='text-center' style="display:none">itemID</th>
                                                            <th class='text-center'>Item Code</th>
                                                            <th class='text-center'>Item Name</th>
                                                            <th class='text-center'>PC</th>
                                                        </tr>
                                                        </thead>
                                                        <tbody>
                                                        <?php

                                                       $hasRows = false;
                                                        if($edit){
                                                            $i=1;
                                                            global $username, $password, $database;
                                                            $db = new mysqli(localhost,$username,$password,$database);
                                                            if (mysqli_connect_errno())
                                                            {
                                                                printf("Connect failed: %s\n", mysqli_connect_error());
                                                                exit();
                                                            }
                                                            $db->set_charset("utf8");

                                                            $stm = $db->prepare("SELECT p.item_id, p.pricetype_id , i.item_code, i.name
                                                                                        FROM Promotion_Extra_Item AS p LEFT  JOIN Items as i ON p.item_id = i.item_id
                                                                                        WHERE p.promotion_id = ?");
                                                            $stm->bind_param("i", $promotionID);
                                                            $stm-> execute();
                                                            $stm-> bind_result($itemID,$priceTypeID,$itemCode,$itemName);
                                                            while ($stm->fetch()) {
                                                                $hasRows = true;
                                                                $customerID=0;
                                                                $prices = $dbHelbelItem->getDefaultPrice($itemID,$customerID);
                                                                echo "<tr>";

                                                                echo "<td  style='width:5%' >
                                                                    <img class='deletRowButton' src='//" . HTML_PATH . "/cop/backend/themes/" . THEME_NAME . "/img/deleteicon.png' style='width:15px; height:15px;' />
                                                                  </td>";

                                                                echo "<td class='index text-center' style='width:2%;'>
                                                                    <strong>$i</strong>
                                                                  </td>";

                                                                echo "<td style='display:none;'>
                                                                    <input id='extraItemID' name='extraItemID' type='hidden'  value='$itemID' />
                                                                  </td>";

                                                                echo "<td style='width:30%' class='text-center'>
                                                                        <input style='width:100%' class='itemCode text-center form-control' id='extraItemCode' name='extraItemCode' type='text'  value='$itemCode' />
                                                                      </td>";

                                                                echo "<td style='width:45%' class='text-center'>
                                                                       <input style='width:100%' class=' text-center form-control' id='extraItemDetails' name='extraItemDetails' type='text' value='$itemName' disabled>
                                                                      </td>";

                                                                echo "<td style='width:15%' class='text-center'>
                                                                         <select  class='form-control' id='extraItemPriceCode' name='extraItemPriceCode' type='text'  >";

                                                                foreach($prices as $pricing) {

                                                                    if($pricing->priceTypeID==$priceTypeID)
                                                                    {
                                                                        echo "<option value='$pricing->priceTypeID' selected >$pricing->priceCode</option>";
                                                                    }
                                                                    else
                                                                    {
                                                                        echo "<option value='$pricing->priceTypeID' >$pricing->priceCode</option>";
                                                                    }
                                                                }

                                                                echo "</select></td>";

                                                                echo "</tr>";
                                                            }

                                                            $stm->close();
                                                            $db->close();

                                                        }
                                                       if(!$hasRows) {
                                                            for ($i = 1; $i < 2; $i++) {
                                                                echo "<tr>";

                                                                echo "<td style='width:5%' >
                                                                    <img class='deletRowButton' src='//" . HTML_PATH . "/cop/backend/themes/" . THEME_NAME . "/img/deleteicon.png' style='width:15px; height:15px;' />
                                                                  </td>";

                                                                echo "<td class='index text-center' style='width:2%;'>
                                                                    <strong>$i</strong>
                                                                  </td>";

                                                                echo "<td style='display:none;'>
                                                                    <input id='extraItemID' name='extraItemID' type='hidden' value='' />
                                                                  </td>";

                                                                echo "<td  style='width:30%' class='text-center''>
                                                                    <input style='width:100%' class='itemCode text-center form-control' id='extraItemCode' name='extraItemCode' type='text' value='' />
                                                                  </td>";

                                                                echo "<td style='width:45%' class='text-center'>
                                                                    <input style='width:100%' class=' text-center form-control' id='extraItemDetails' name='extraItemDetails' type='text' value='' disabled />
                                                                  </td>";

                                                                echo "<td style='width:15%' class='text-center'>
                                                                        <select  class='form-control' id='extraItemPriceCode' name='extraItemPriceCode' type='text'   disabled>
                                                                        </select>   
                                                                       </td>";

                                                                echo "</tr>";
                                                            }

                                                        }
                                                       ?>

                                                        </tbody>

                                                    </table>
                                                        <a target="_blank" id="newLineButton_1" style="background-color: #f3f3f3;"  class="btn btn-block"  onclick="addNewLine('extra_item_table')">
                                                            <i class="fa fa-plus  "></i>&nbsp; Add Line
                                                        </a>
                                                </div>




                                            <!-- Promotion Matching Rule-->
                                            <section id="matchingRuleSection" class="promo-fields"  style="display: none; margin-top:30px;">
                                                <i class="fa-fw fa fa-gift fa-lg"></i>
                                                <h3 style="display: inline;margin-left:6px;vertical-align: middle"> Promotion Matching Rule</h3>
                                            </section>
                                                <div style="width:100%;" id = "matchingRuleContainer" class="promo-fields">
                                                    <table id="matching_rule_table" class="table table-striped table-hover dataTable" width="100%" border="0" cellpadding="0" cellspacing="0">

                                                        <thead>

                                                        <tr>
                                                            <th class='text-center'></th>
                                                            <th class='text-center'>#</th>
                                                            <th class='text-center'>Category Code</th>
                                                            <th class='text-center'>Category Name</th>
                                                            <th class='text-center'>Item Code</th>
                                                            <th class='text-center'>Item Name</th>
                                                            <th class='text-center'>Credit Limit</th>
                                                            <th class='text-center'>Value</th>
                                                        </tr>
                                                        </thead>
                                                        <tbody>
                                                        <?php

                                                        $hasRows = false;
                                                        if($edit){
                                                            $i=1;
                                                            global $username, $password, $database;
                                                            $db = new mysqli(localhost,$username,$password,$database);
                                                            if (mysqli_connect_errno())
                                                            {
                                                                printf("Connect failed: %s\n", mysqli_connect_error());
                                                                exit();
                                                            }
                                                            $db->set_charset("utf8");

                                                            $stm = $db->prepare("SELECT p.item_id, p.category_id , i.item_code, i.name , c.name, c.category_code,p.credit_limit, p.value
                                                                                        FROM Promotion_Matching_Rule AS p LEFT JOIN Items as i ON p.item_id = i.item_id
                                                                                                                          LEFT JOIN Categories as c ON p.category_id = c.category_id
                                                                                        WHERE p.promotion_id = ? LIMIT 1");
                                                            $stm->bind_param("i", $promotionID);
                                                            $stm-> execute();
                                                            $stm-> bind_result($itemID,$categoryID,$itemCode,$itemName,$categoryName,$categoryCode,$creditLimit,$matchingRuleValue);
                                                            while ($stm->fetch()) {
                                                                $hasRows = true;
                                                                $customerID=0;
                                                                echo "<tr>";

                                                                echo "<td style='width:5%' >
                                                                    <img class='deletRowButton' src='//" . HTML_PATH . "/cop/backend/themes/" . THEME_NAME . "/img/deleteicon.png' style='width:15px; height:15px;' />
                                                                  </td>";

                                                                echo "<td class='index text-center' style='width:2%;'>
                                                                    <strong>$i</strong>
                                                                  </td>";

                                                                echo "<td style='display:none;'>
                                                                    <input id='categoryID' name='categoryID' type='hidden'  value='$categoryID' />
                                                                  </td>";

                                                                echo "<td style='display:none;'>
                                                                    <input id='mRuleItemID' name='mRuleitemID' type='hidden'  value='$itemID' />
                                                                  </td>";

                                                                echo "<td style='width:10%' class='text-center'>
                                                                        <input style='width:100%' class=' text-center form-control' id='categoryCode' name='categoryCode' type='text'  value='$categoryCode' />
                                                                      </td>";

                                                                echo "<td style='width:25%' class='text-center'>
                                                                        <input style='width:100%' class=' text-center form-control' id='categoryName' name='categoryName' type='text'  value='$categoryName' disabled/>
                                                                      </td>";

                                                                echo "<td style='width:10%' class='text-center'>
                                                                        <input style='width:100%' class='itemCode text-center form-control' id='mRuleItemCode' name='mRuleItemCode' type='text'  value='$itemCode' />
                                                                      </td>";

                                                                echo "<td style='width:25%' class='text-center'>
                                                                       <input style='width:100%' class=' text-center form-control' id='mRuleItemDetails' name='mRuleItemDetails' type='text' value='$itemName' disabled>
                                                                      </td>";

                                                                echo "<td style='width:5%' class='text-center'>
                                                                         <input  class='form-control' id='creditLimit' name='creditLimit' type='number' min = '0' value='$creditLimit' disabled>
                                                                      </td>";

                                                                echo "<td style='width:5%' class='text-center'>
                                                                         <input  class='form-control' id='matchingRuleValue' name='matchingRuleValue' type='number'  value='$matchingRuleValue' disabled>
                                                                      </td>";

                                                              

                                                                echo "</tr>";
                                                            }

                                                            $stm->close();
                                                            $db->close();

                                                        }
                                                        if(!$hasRows) {
                                                            for ($i = 1; $i < 2; $i++) {
                                                                echo "<tr>";

                                                                echo "<td style='width:5%' >
                                                                    <img class='deletRowButton' src='//" . HTML_PATH . "/cop/backend/themes/" . THEME_NAME . "/img/deleteicon.png' style='width:15px; height:15px;' />
                                                                  </td>";

                                                                echo "<td class='index text-center' style='width:2%;'>
                                                                    <strong>$i</strong>
                                                                  </td>";

                                                                echo "<td style='display:none;'>
                                                                    <input id='categoryID' name='categoryID' type='hidden'  value='' >
                                                                  </td>";

                                                                echo "<td style='display:none;'>
                                                                    <input id='mRuleItemID' name='mRuleItemID' type='hidden'  value='' >
                                                                  </td>";

                                                                echo "<td style='width:10%' class='text-center'>
                                                                        <input style='width:100%' class=' text-center form-control' id='categoryCode' name='categoryCode' type='text'  value='' >
                                                                      </td>";

                                                                echo "<td style='width:25%' class='text-center'>
                                                                        <input style='width:100%' class=' text-center form-control' id='categoryName' name='categoryName' type='text'  value='' disabled >
                                                                      </td>";

                                                                echo "<td style='width:10%' class='text-center'>
                                                                        <input style='width:100%' class='itemCode text-center form-control' id='mRuleItemCode' name='mRuleItemCode' type='text'  value='' >
                                                                      </td>";

                                                                echo "<td style='width:25%' class='text-center'>
                                                                       <input style='width:100%' class=' text-center form-control' id='mRuleItemDetails' name='mRuleItemDetails' type='text' value='' disabled>
                                                                      </td>";

                                                                echo "<td style='width:5%' class='text-center'>
                                                                         <input  class='form-control' id='creditLimit' name='creditLimit' type='number' min = '0' value='' disabled>
                                                                      </td>";

                                                                echo "<td style='width:5%' class='text-center'>
                                                                         <input  class='form-control' id='matchingRuleValue' name='matchingRuleValue' type='number'  value='' disabled>
                                                                      </td>";



                                                                echo "</tr>";
                                                            }

                                                        }
                                                        ?>
                                                        <!---->
                                                        </tbody>

                                                    </table>
                                                        <a target="_blank" id="newLineButton_2" style="background-color: #f3f3f3;" class="btn btn-block" onclick="addNewLine('matching_rule_table')">
                                                            <i class="fa fa-plus"></i>&nbsp;Add Line
                                                        </a>

                                                </div>

                                        </section>
                                        </div>

                                            <!-- Applies To Section -->
                                            <div class="row" style="margin-top: 20px;">

                                                <section class="col col-sm-12 no-margin" style="padding-right:1px">
                                                    <section>
                                                        <i class="fa-fw fa fa-user fa-lg"></i>
                                                        <h3 style="display: inline;margin-left:6px;vertical-align: middle"> Applies To:</h3>
                                                    </section>
                                                    <table class="table" width="100%" border="0" cellpadding="0" cellspacing="0">
                                                        <tr>
                                                            <td class="custom-td-label"><label class="label-bold align-left">Customers: </label></td>
                                                            <td class="custom-td-input"><input id='customerSelection' name='customerSelection' style="overflow: hidden; height: auto;" >
                                                            </td>
                                                        </tr>
                                                        <tr>
                                                            <td class="custom-td-label"><label class="label-bold align-left">Customer Groups: </label></td>
                                                            <td class="custom-td-input"><input  id='customerGroupSelection' name='customerGroupSelection' style="overflow: hidden; height: auto;"></td>
                                                        </tr>
                                                        <tr>
                                                            <td class="custom-td-label"><label class="label-bold align-left">Salespersons: </label></td>
                                                            <td class="custom-td-input"><input id='salespersonSelection' name='salespersonSelection' style="overflow: hidden; height: auto;"></td>
                                                        </tr>


                                                    </table>
                                                </section>
                                            </div>

                                    </fieldset>
                                </form>

                            </div>
                            <!-- end widget content -->

                        </div>
                        <!-- end widget div -->

                    </div>
                    <!-- end widget -->
                </article>


            </div>

            <!-- end row -->

        </section>
    </div>
</div>

<style>
    table tr td img { display:none;}
    table tr:hover td img { display:inline-block;}

    .select2-container {
        width: 100% !important;
        box-sizing: border-box;
        margin: 0;
        padding: 0;

    }
    .select2-container .select2-choice>.select2-chosen{
        color: #000000;
        font-weight: 400;
        font-family:"verdana", "sans-serif";
    }


    .select2-container .select2-choice,
    .select2-search input,
    .select2-drop-active ,
    .select2-container-multi .select2-choices,
    .select2-container-multi .select2-search input,
    .select2-container-multi .select2-choices li,
    .select2-container-multi .select2-drop-active {
        border-radius: 4px !important;

    }






</style>


<script src="//<?php echo HTML_PATH ?>/cop/backend/themes/<?php echo THEME_NAME ?>/js/plugin/select2/select2.min.js"></script>

<script type="text/javascript">

    function savePromotion(){
        $('#savePromotionButton').prop("disabled", true);

        var promotionID = $('#promotionID').val();
        var promotionCode = $('#promoCode').val().trim();
        var promotionName = $('#promoName').val().trim();
        var promotionDescription = $('#promoDescription').val().trim();
        var promoStartDate = $('#promoStartDate').val();
        var promoEndDate = $('#promoEndDate').val();
        var primaryItemID = $('#primaryItem').val();
        var primaryItemPriceType = $('#primaryItemPriceType').val();
        var promoType = $('#promoType').val();
        var promoStatus = $('#promoStatus').val();
        var quantity = $('#quantity').val();
        var fixedDiscAmount = $('#fixedDiscAmount').val();
        var fixedDiscPercent = $('#fixedDiscPercent').val();
        var price = $('#price').val();
        var discountQty = $('#discountQty').val();
        var discountPercentQty = $('#discountPercentQty').val();
        var customers = $('#customerSelection').val();
        var customerGroups = $('#customerGroupSelection').val();
        var salesPersons = $('#salespersonSelection').val();


        var extraItems = [];
        $('#extra_item_table tbody tr').each(function () {
            var $row = $(this);
            var extraItem = {
                'itemID': $row.find('#extraItemID').val(),
                'priceTypeID': $row.find('#extraItemPriceCode').val()
            };
            extraItems.push(extraItem);
        });

        var matchingRules = [];
        $('#matching_rule_table tr').each(function () {
            var $row = $(this);
            var matchingRule = {
                'categoryID': $row.find('#categoryID').val(),
                'itemID': $row.find('#mRuleItemID').val(),
                'creditLimit': $row.find('#creditLimit').val(),
                'matchingRuleValue': $row.find('#matchingRuleValue').val(),
            };
            matchingRules.push(matchingRule);
        });

        $.ajax({
            type: "POST",
        <?php
        if($edit){
            echo "url: '//" . HTML_PATH . "/cop/backend/core/controllers/edit/edit_promotion.php',";
        }
        else{
            echo "url: '//" . HTML_PATH . "/cop/backend/core/controllers/add/add_promotion.php',";
        }
        ?>
        data: {
            'promotionID': promotionID,
            'promotionCode': promotionCode,
            'promotionName': promotionName,
            'promoStartDate': promoStartDate,
            'promoEndDate': promoEndDate,
            'promotionDescription': promotionDescription,
            'primaryItemID': primaryItemID,
            'primaryItemPriceType': primaryItemPriceType,
            'promoType': promoType,
            'promoStatus': promoStatus,
            'quantity': quantity,
            'fixedDiscAmount': fixedDiscAmount,
            'fixedDiscPercent': fixedDiscPercent,
            'price': price,
            'discountQty': discountQty,
            'discountPercentQty': discountPercentQty,
            'extraItems': extraItems,
            'matchingRules': matchingRules,
            'customers': customers,
            'customerGroups': customerGroups,
            'salesPersons':  salesPersons
        },


        success: function (result) {
            if (result.localeCompare('existingCode') === 0) {
                highlightDataError($('#promoCode'),"Code already exists");
                $('#savePromotionButton').prop("disabled", false);

            } else {
               // window.location.replace("//<?php echo HTML_PATH ?>/cop/backend/core/views/addedit/new_promotion.php?promotionID=" + result);

                $.smallBox({
                    title: "Success!",
                    content: "Promotion successfully entered.",
                    color: "#739E73",
                    timeout: 3000,
                    icon: "fa fa-user swing animated"
                });
            }

        }
    });
}

    function highlightDataError(element,text){
        element.css('border-color','firebrick').css('background-color','#ffd0bd');
        element.siblings('.error-message').remove();
        element.after('<span class="error-message" style="color: firebrick; font-size: 12px;">'+text+'</span>');
        window.setTimeout(function(){
            element.css('border-color','').css('background-color','');
            element.next('.error-message').fadeOut(700);

        },3000);
    }

    function initCustomerSelection(){

        $('#customerSelection').select2({
            minimumInputLength: 3,
            allowClear: true,
            multiple: true,
            ajax:{
                url:"//<?php echo HTML_PATH ?>/cop/backend/core/controllers/search/customerSearch.php",
                    dataType:"json",
                    type:"GET",
                    data:function(term,page){
                        return{
                            query:term

                        };
                    },
                    results:function(data){
                        const selectAllOption = {
                            id: 'all_customers',
                            text: 'Select All'
                        };

                        const results = $.map(data, function (item) {
                            return {
                                text: item.name,
                                id: item.id
                            };
                        });
                        results.unshift(selectAllOption);

                        return {
                            results: results
                        };
                    }
                }
            });


        $('#customerSelection').select2('data', <?php echo json_encode($customers);  ?>);

    }

    function initCustomerGroupSelection(){
        $('#customerGroupSelection').select2({
            minimumInputLength: 3,
            allowClear: true,
            multiple: true,
            ajax:{
                url:"//<?php echo HTML_PATH ?>/cop/backend/core/controllers/search/customerGroupSearch.php",
                dataType:"json",
                type:"GET",
                data:function(term,page){
                    return{
                        query:term

                    };
                },
                results:function(data){
                    return{
                        results:$.map(data,function(item){
                            return{
                                text:item.name,
                                id:item.id
                            }
                        })
                    };
                }
            }
        });

        $('#customerGroupSelection').select2('data', <?php echo json_encode($customerGroups);  ?>);

    }

    function initSalespersonSelection(){
        $('#salespersonSelection').select2({
            minimumInputLength: 3,
            allowClear: true,
            multiple: true,
            ajax:{
                url:"//<?php echo HTML_PATH ?>/cop/backend/core/controllers/search/salespersonSearch.php",
                dataType:"json",
                type:"GET",
                data:function(term,page){
                    return{
                        query:term

                    };
                },
                results:function(data){
                    const selectAllOption = {
                        id: 'all_salespersons',
                        text: 'Select All'
                    };

                    const results = $.map(data, function (item) {
                        return {
                            text: item.name,
                            id: item.id
                        };
                    });
                    results.unshift(selectAllOption);

                    return {
                        results: results
                    };
                }
            }
        });


        $('#salespersonSelection').select2('data', <?php echo json_encode($salesPersons);  ?>);


    }

    function initItemSelection(){
        $('#primaryItem').select2({
            minimumInputLength: 4,
            ajax:{
                url:"//<?php echo HTML_PATH ?>/cop/backend/core/controllers/search/productSearch.php",
                dataType:"json",
                type:"GET",
                data:function(term,page){
                    return{
                        query:term

                    };
                },
                results:function(data){
                    return{
                        results:$.map(data,function(item){
                            return{
                                text:item.name,
                                id:item.id
                            }
                        })
                    };
                }
            }
        });

        $('#primaryItem').select2('data', { id: <?php echo json_encode($primaryItemID); ?>,  text: <?php echo json_encode($primaryItemCode . " " . $primaryItemName); ?>});

        $('#primaryItem').on('change', function() {
            var customerID = $('#customerID').val();
            var itemID = $(this).val();
            $.ajax({
                type: "POST",
                url: '//<?php echo HTML_PATH ?>/cop/backend/core/controllers/get/getItemPrices.php',
                data: {
                    'customerID': customerID,
                    'itemID': itemID
                },
                dataType: "json",
                success: function (result) {
                    $('#primaryItemPriceType').empty();
                    $.each(result, function() {
                        $('#primaryItemPriceType').append($("<option />").val(this.priceTypeID).text(this.priceCode).attr("data-price", this.price));
                    });

                }
            });
        });

    }

    function showPromoFieldsByType(){
        $('#fixedDiscAmount').trigger('input');
        $('#fixedDiscPercent').trigger('input');
        $('#discountQty').trigger('input');
        $('#discountPercentQty').trigger('input');
        
        var promoType =  $('#promoType').val();
        $('.promo-fields').hide();

        if (promoType == 0) {  //Quantity Discount
            $('#promoRowQty, #promoRowDiscountPercent, #promoRowDiscountAmount').show();
        }
        else if (promoType == 1) {  // Multi Items Promotion
            $('#promoRowQty, #promoRowDiscountQty, #promoRowDiscountPercentQty,#promoRowPriceType,#extraItemSection,#extraItemContainer').show();
        }
        else if (promoType == 3) {  // Category Promotions
            $('#promoRowQty, #promoRowDiscountQty, #promoRowDiscountPercentQty,#matchingRuleSection,#matchingRuleContainer').show();
        }
        else if (promoType == 7) {  // Category Promotions with Extra Item
            $('#promoRowQty, #promoRowDiscountQty, #promoRowDiscountPercentQty,#matchingRuleSection,#matchingRuleContainer, #extraItemSection,#extraItemContainer').show();
        }

    }

    function toggleFieldState(triggerField, dependentField, type = 'readonly', resetValue = 0) {
        var value = parseFloat($(triggerField).val());
        if (value > 0) {
            $(dependentField).prop(type, true).val(resetValue);

        } else {
                $(dependentField).prop(type, false);
        }
    }

    function initItemAutocomplete() {
        $(".itemCode").autocomplete({
            source: "//<?php echo HTML_PATH ?>/cop/backend/core/controllers/autocomplete/item_autocomplete.php",
            autoFocus: true,
            open: function(){
                $('.ui-autocomplete').css('width', '400px');
            },
            select: function (event, ui) {
                var $itemRow = $(this).closest('tr');
                var tableID = $itemRow.closest('table').attr('id');
                var [itemCode, itemName] = ui.item.label.split(":");

                if(tableID === "extra_item_table"){
                    $itemRow.find('#extraItemID').val(ui.item.id);
                    $itemRow.find('#extraItemCode').val(itemCode);
                    $itemRow.find('#extraItemDetails').val(itemName);
                    $itemRow.find('#extraItemPriceCode').prop("disabled", false);

                    var customerID = $('#customerID').val();
                    var itemID = ui.item.id;
                    $.ajax({
                        type: "POST",
                        url: '//<?php echo HTML_PATH ?>/cop/backend/core/controllers/get/getItemPrices.php',
                        data: {
                            'customerID': customerID,
                            'itemID': itemID
                        },
                        dataType: "json",
                        success: function (result) {
                            var options = $itemRow.find('#extraItemPriceCode');
                            $itemRow.find('#extraItemPriceCode').find('option').remove();
                            $.each(result, function() {
                                options.append($("<option />").val(this.priceTypeID).text(this.priceCode).attr("data-price", this.price));
                            });

                        }
                    });

                }
                else if(tableID === "matching_rule_table"){
                    $itemRow.find('#mRuleItemID').val(ui.item.id);
                    $itemRow.find('#mRuleItemCode').val(itemCode);
                    $itemRow.find('#mRuleItemDetails').val(itemName);
                }



            }
        });
    }

    function initCategoryAutocomplete() {
        $("#categoryCode").autocomplete({
            source: "//<?php echo HTML_PATH ?>/cop/backend/core/controllers/autocomplete/category_autocomplete.php",
            autoFocus: true,
            open: function(){
                $('.ui-autocomplete').css('width', '400px');
            },
            select: function (event, ui) {
                var $itemRow = $(this).closest('tr');
                var [categoryCode, categoryName] = ui.item.label.split(":");
                $itemRow.find('#categoryID').val(ui.item.id);
                $itemRow.find('#categoryCode').val(categoryCode);
                $itemRow.find('#categoryName').val(categoryName);
                $itemRow.find('#creditLimit').prop("disabled", false);
                $itemRow.find('#matchingRuleValue').prop("disabled", false);

            }
        });

    }

    function updateTrNumbering(tableId) {
        var $i = 0;
        $('#' + tableId +' tr').each(function (i, row) {
            // reference all the stuff you need first
            var $row = $(row);
            $row.find("td.index").text($i);
            $i++;
        });
    }

    function deleteRow(row){
        var tableId = $(row).closest('table').attr('id');
        var rowCount = $('#' + tableId +' tr').length;
        if (rowCount > 2) {
            $(row).closest('tr').remove();
            updateTrNumbering(tableId);
        }
    }

    function addNewLine(tableID)  {
        $lastTr = $('tr:last', $('#'+tableID));

        $lastTd = $('td:last', $lastTr);
        $newTr = $lastTr.clone();
        $lastTr.after($newTr);
        $newTr.find("input").val("");
        $newTr.find("textarea").text("");
        $newTr.find("label").text("");
        $i = $newTr.find("td.index").text();
        $i++;
        $newTr.find("td.index").text($i);

        $newTr.find('#itemDetails').prop( "disabled", true );
        $newTr.find('#priceCode').prop( "disabled", true );

        $( ".deletRowButton" ).click(function() {
            deleteRow(this);
        });
        initItemAutocomplete();
        initCategoryAutocomplete();

    }

    $(document).ready(function() {

        pageSetUp();
        initCustomerSelection();
        initCustomerGroupSelection();
        initSalespersonSelection();
        initItemSelection();
        showPromoFieldsByType();
        initCategoryAutocomplete();
        initItemAutocomplete();



        $( ".deletRowButton" ).click(function() {
            deleteRow(this);
        });
           

        $('#promoType').change(function() {
            showPromoFieldsByType();
        });


        $('#fixedDiscAmount').on('input', function () {
            toggleFieldState('#fixedDiscAmount', '#fixedDiscPercent');
        });

        $('#fixedDiscPercent').on('input', function () {
            toggleFieldState('#fixedDiscPercent', '#fixedDiscAmount');
        });

        $('#discountQty').on('input', function () {
            toggleFieldState('#discountQty', '#discountPercentQty');
        });

        $('#discountPercentQty').on('input', function () {
            toggleFieldState('#discountPercentQty', '#discountQty');
        });

        var fixHelperModified = function(e, tr) {
                var $originals = tr.children();
                var $helper = tr.clone();
                $helper.children().each(function(tr) {
                    $(this).width($originals.eq(tr).width())
                });
                return $helper;
            },
            updateIndex = function(e, ui) {
                $('td.index', ui.item.parent()).each(function (i) {
                    $(this).text(i + 1);
                });
            };

        <?php
        global $isMobile;
        if($isMobile){echo "var isMobile = true;\n";}else{echo "var isMobile = false;\n";}
        ?>

        if (isMobile){
            $('#extra_item_table #matching_rule_table  td img').css('display','block');
        } else {
            $("#extra_item_table #matching_rule_table tbody").sortable({
                helper: fixHelperModified,
                stop: updateIndex
            });
        }



    });



</script>


