<?php

require_once("../../../../param.php");

if(isset($_POST['vatID']) || isset($_GET['vatID'])) {
	$edit = true;

	if (isset($_POST['vatID'])) {
		$vatID = $_POST['vatID'];
	} else if (isset($_GET['vatID'])) {
	    $vatID = $_GET['vatID'];
    } else {
        $vatID = 0 ;  
    }

	$db = new mysqli(localhost,username,password,database);
	if (mysqli_connect_errno())
	{
		printf("Connect failed: %s\n", mysqli_connect_error());
		exit();
	}
	$db->set_charset("utf8");
    $stm = $db->prepare("SELECT vat_code, vat_display_name, percentage FROM Vats WHERE vat_id = ?");
    $stm->bind_param("i", $vatID); 
	$stm-> execute();    

	$stm-> bind_result($vatCode,$vatName,$percentage);
	while ($stm->fetch()) {
	      
	}
	$stm-> close();


}
else
{
	$edit=false;
	$vatID = 0;

}

?>
<div id="main" role="main">

	<!-- Start CUSTOM CODE-->
	<!-- RIBBON -->
	<div id="ribbon" class="bg-color-blue">

				<span class="ribbon-button-alignment"> 
					<span id="refresh" class="btn btn-ribbon2" onclick="location.reload(true);" data-title="refresh" rel="tooltip" data-placement="bottom" data-original-title="<i class='text-warning fa fa-warning'></i> Reload Page?" data-html="true">
						<i class="fa fa-refresh"></i>
					</span> 
				</span>
		<!-- breadcrumb -->
		<ol class="breadcrumb">
			<?php if($edit)
			{
				echo "<li class='txt-color-white'>Home / Edit Vat</li>";
			}
			else
			{ 
				echo "<li class='txt-color-white'>Home / New Vat</li>";
			}
			?>

		</ol>
		<!-- end breadcrumb -->
	</div>
	<!-- END RIBBON -->

	<!-- MAIN CONTENT -->
	<div id="content">

		<div class="row">

			<div class="col-xs-12 col-sm-6 col-md-6 col-lg-8">
				<h3 class="page-title txt-color-blueDark header-margin">&#65285 
					<?php if($edit)
					{
						echo "Edit Vat";
					
					}
					else
					{
						echo "New Vat";
					}
					?>

				</h3>
			</div>



		</div>

		<!-- row -->
		<section id="widget-grid" class="">

			<div class="row">

				<!-- NEW WIDGET START -->
				<!-- NEW WIDGET START -->
				<article class="col-xs-12 col-sm-5 col-md-5 col-lg-5">

					<div class="jarviswidget jarviswidget-color-blueDark no-margin" id="wid-id-0" data-widget-editbutton="false" data-widget-deletebutton="false">
						<header>
							<span class="widget-icon"> <i class="fa fa-table"></i> </span>
							<h2>Vat Form</h2>

						</header>
						<!-- widget div-->
						<div>
							<!-- widget content -->
							<div class="widget-body no-padding" >

								<form action="" id="checkout-form" class="smart-form">
									<fieldset style="padding-top:10px;">
										<div class="row">
										    
										    
										    											<!--<section class="col-xs-12 col-sm-12 col-md-12 col-lg-12"  style="padding-right:2px" ></section>-->

										    
											<section class="col-xs-12 col-sm-12 col-md-12 col-lg-12" style="padding-right:10px ;padding-left: 15px ; box-sizing: border-box;" >
												<section>
													 &#65285 
													<h3 style="display: inline;margin-left:6px;vertical-align: middle"> Basic Details</h3>
												</section>
												
												

												
												<table id="basicDetailsTable" class="table" width="100%" border="0" cellpadding="0" cellspacing="0">
													<thead >
													</thead>
													<tbody >
													<tr >
														<input  class='text-center form-control slim-input' id='vatID' name='vatID' type='hidden' value='<?php if($edit){echo $vatID;}?>'>
                                                        <td class="custom-td-label-medium"><label class="label-bold  align-left"><b>Vat Code: </b></label></td>
														<td class="custom-td-input-medium"><input  class='text-center form-control slim-input' id='vatCode' name='vatCode' type='text' value='<?php if($edit){echo $vatCode;}?>'></td>

													</tr>
													<tr >
                                                        <td class="custom-td-label-medium"><label class="label-bold  align-left" ><b>Vat Name: </b></label></td>
                                                        <td class="custom-td-input-medium"><input  class='text-center form-control slim-input' id='vatName' name='vatName' type='text' value='<?php if($edit){echo $vatName;}?>'></td>
													</tr>
													<tr >
                                                         <td class="custom-td-label-medium"><label class="label-bold  align-left"><b>Percentage: </b></label></td>
														<td class="custom-td-input-medium"><input  class='text-center form-control slim-input' id='percentage' name='percentage' type='number'  min="0" step="0.01" value='<?php if($edit){echo $percentage;}?>'></td>
													</tr>
													
											
													
													</tbody>
												</table>
												
											

											</section>
										

										</div>
									</fieldset>
								</form>
								
								
								<?php if($edit)
                                        {
                                        echo "  <footer style='margin-top: 30px;'>
                                        	        <div class='col-xs-12 col-sm-6 col-md-6 col-lg-4' style='float:right' >
                                                		<span class='pull-right show-stat-buttons'  style='padding-bottom: 10px;'> <span> <a id='saveVatButton' onclick='saveVat()' class='btn btn-success btn-block'><i class='fa fa-check'></i>&nbsp; Save Vat</a> </span>
                                                	</div>
                                                	<div class='col-xs-12 col-sm-6  col-md-6 col-lg-4' style='float:left'>
                                                		<span class='pull-right show-stat-buttons' style='padding-bottom: 10px;' > <span> <a href='new_vat.php' id='saveVatButton' class='btn btn-primary btn-block'><i class='fa fa-plus'></i>&nbsp; New Vat</a> </span>
                                                	</div>
                                                
                                                </footer>";
                                        }
                                    else
                                    {
                                        echo "<footer style='margin-top: 30px;'>
                                                <div class='col-xs-12 col-sm-6 col-md-6 col-lg-4' style='float:right'>
                            		                <span class='pull-right show-stat-buttons' style='padding-bottom: 10px;'> <span> <a id='saveVatButton' onclick='saveVat()' class='btn btn-success btn-block'><i class='fa fa-check'></i>&nbsp; Save Vat</a> </span>
                            			        </div>
                        			        </footer>";
                                    }
                                    ?>


							</div>
							<!-- end widget content -->

						</div>
						<!-- end widget div -->

					</div>
					<!-- end widget -->
				</article>





			</div>

			<!-- end row -->






		</section>
	</div>
</div>

<style>

	td input {
		width:100%;
	}

	table#datatable_fixed_column tr td img { display:none;}
	table#datatable_fixed_column tr:hover td img { display:inline-block;}

	table#datatable_fixed_column {
		border: solid 1px #f8f8f8;
	}

	table#datatable_fixed_column thead  {
		border: solid 1px #f8f8f8;
	}

	table#datatable_fixed_column thead th {
		background-color: #f8f8f8;

		font-family: arial, sans-serif;
	}

	table#datatable_fixed_column tr td {
		padding-left:4px;
		padding-right:4px;
	}

	td.index {
		font-weight:bold;
	}

	tr td textarea {
		white-space: normal;
		text-align: justify;
		-moz-text-align-last: center; /* Firefox 12+ */
		text-align-last: center;
	}

	#detailsTable thead th {
		background-color: white !important;
		border:none;
		height:0px;
	}
	


</style>

<script src="//<?php echo HTML_PATH ?>/cop/backend/themes/<?php echo THEME_NAME ?>/js/DataTables/datatables.js"></script>
<script src="//<?php echo HTML_PATH ?>/cop/backend/themes/<?php echo THEME_NAME ?>/js/plugin/datatables/dataTables.colVis.min.js"></script>
<script src="//<?php echo HTML_PATH ?>/cop/backend/themes/<?php echo THEME_NAME ?>/js/plugin/datatables/dataTables.tableTools.min.js"></script>
<script src="//<?php echo HTML_PATH ?>/cop/backend/themes/<?php echo THEME_NAME ?>/js/plugin/datatables/dataTables.bootstrap.min.js"></script>
<script src="//<?php echo HTML_PATH ?>/cop/backend/themes/<?php echo THEME_NAME ?>/js/plugin/datatable-responsive/datatables.responsive.min.js"></script>
<script type="text/javascript">
	var showAll=1;
	var otable;

	function saveVat()
	{
        $('#saveVatButton').hide();
        $('#saveVatButton').prop("disabled",true);

		var vatID = $('#vatID').val().trim();
		var vatCode = $('#vatCode').val().trim();
		
        if(!vatCode)
        {
            $.smallBox({
                title : "Vat Code Missing!",
                content : "Please enter a Vat Code",
                color : "#b22222",
                timeout: 3000,
                icon : "fa fa-user swing animated"
            });
            
            highlightDataError($('#vatCode'));

            $('#saveVatButton').show();
            $('#saveVatButton').prop("disabled",false);

            return;
        }

		var vatName = $('#vatName').val().trim();
        if(!vatName)
        {
            $.smallBox({
                title : "Vat Name Missing!",
                content : "Please enter a Vat Code",
                color : "#b22222",
                timeout: 3000,
                icon : "fa fa-user swing animated"
            });
            
            highlightDataError($('#vatName'));

            $('#saveVatButton').show();
            $('#saveVatButton').prop("disabled",false);

            return;
        }
        
        var percentage = $('#percentage').val().trim();
        if(!percentage)
        {
            $.smallBox({
                title : "percentage Missing!",
                content : "Please enter the percentage",
                color : "#b22222",
                timeout: 3000,
                icon : "fa fa-user swing animated"
            });
            
            highlightDataError($('#percentage'));

            $('#saveVatButton').show();
            $('#saveVatButton').prop("disabled",false);

            return;
        }


		$.ajax({
			type: "POST",

			<?php
            if($edit){
                echo "url: '//" . HTML_PATH . "/cop/backend/core/controllers/edit/edit_vat.php',";
            } else {
                echo "url: '//" . HTML_PATH . "/cop/backend/core/controllers/add/add_vat.php',";
            }
           ?>
           data: {
                'vatID':vatID,
                'vatCode':vatCode,
                'vatName':vatName,
                'percentage':percentage
            },
			success: function (result) {
			    
                if(result.localeCompare('existingCode') == 0){
                    
                    $.smallBox({
                       title: "Warning!",
                       content: "Existing Vat Code.",
                       color: '#b22222',
                       timeout: 3000,
                       icon: "fa fa-user swing animated"
                    });
                   
                    highlightDataError($('#vatCode'));
                   
                    $('#saveVatButton').show();
                    $('#saveVatButton').prop("disabled",false);
                   
                } else {
                    
    				$.smallBox({
    					title : "Success!",
    					content : "Vat successfully entered",
    					color : "#739E73",
    					timeout: 3000,
    					icon : "fa fa-user swing animated"
    				});
                    
                    
                    window.location.replace("//<?php echo HTML_PATH ?>/cop/backend/core/views/addedit/new_vat.php?vatID=" + result);
                    
    				
                }
			}
			
			
		});

	}

    function highlightDataError(element){
        element.css('border-color','firebrick').css('background-color','#ffd0bd');
        window.setTimeout(function(){element.css('border-color','').css('background-color','');
        },2500);
    }

</script>