<?php
include_once("../../../../param.php");
?>

		<div id="main" role="main">
			<!-- Start CUSTOM CODE-->

			<!-- RIBBON -->
			<div id="ribbon" class="bg-color-blue">

				<span class="ribbon-button-alignment"> 
					<span id="refresh" class="btn btn-ribbon2" onclick="location.reload(true);" data-title="refresh" rel="tooltip" data-placement="bottom" data-original-title="<i class='text-warning fa fa-warning'></i> Reload Page?" data-html="true">
						<i class="fa fa-refresh"></i>
					</span> 
				</span>
				<!-- breadcrumb -->
				<ol class="breadcrumb">
					<li class="txt-color-white">Home / CRM Types</li>
				</ol>
				<!-- end breadcrumb -->
			</div>
			<!-- END RIBBON -->

			<!-- MAIN CONTENT -->
			<div id="content">

				<div class="row">
					<div class="col-xs-12 col-sm-8 col-md-8 col-lg-10">
                        <i class="fa fa-lg fa-tasks"></i>&nbsp;
						<h3 class="page-title txt-color-blueDark" style="margin-top: 5px;margin-bottom: 15px;display: inline-block;" >
							 CRM Types
						</h3>
				</div>

					<div class="col-xs-12 col-sm-4 col-md-4 col-lg-2">
		<span class="pull-right show-stat-buttons"> <span > <a onclick = "$('#newCrmType').modal('show');" class="btn btn-primary btn-block"><i class="fa fa-plus"></i>&nbsp; New CRM Type</a> </span>

					</div>
				</div>




			<!-- row -->
			<section id="widget-grid" class="">

					<!-- row -->
					<div class="row">
						<!-- NEW WIDGET START -->
						<article class="col-xs-12 col-sm-12 col-md-12 col-lg-12">

							<div class="jarviswidget jarviswidget-color-blueDark" id="wid-id-1" data-widget-editbutton="false" data-widget-deletebutton="false">
								<header>
									<span class="widget-icon"> <i class="fa fa-table"></i> </span>
									<h2>CRM Types Table </h2>
								</header>
								<!-- widget div-->
								<div>

									<!-- widget content -->
									<div class="widget-body no-padding">
										<table id="datatable_fixed_column" class="table table-striped table-hover dataTabl" width="100%">

									        <thead>
												<tr>
												  
													<th class="hasinput" >
														<input type="text" class="form-control text-center" placeholder="Filter Name" />
													</th>

													<th class="hasinput" >
														<input type="text" class="form-control text-center" placeholder="Filter Icon" />
													</th>
													<th class="hasinput" >
														<input type="text" class="form-control text-center" placeholder="Filter Visible" />
													</th>
													<th class="hasinput" >
													</th>

												</tr>
									            <tr>
           									    <th class='text-center'>Name</th>
            									<th class='text-center'>Icon</th>
                                                <th class='text-center'>Visible</th>
                                                <th class='text-center'>Color</th>


									            </tr>
									        </thead>

									        <tbody></tbody>
										</table>

									</div>
									<!-- end widget content -->

								</div>
								<!-- end widget div -->

							</div>
							<!-- end widget -->
			</article>
			<!-- WIDGET END -->
		</div>
        <!-- end row -->
	</section>

	</div>
</div>



<!-- Modal (New CRM type)-->
<div class="modal fade" id="newCrmType" tabindex="-1" role="dialog" aria-labelledby="myModalLabel" >
    <div class="modal-dialog" role="document" >
        <div class="modal-content">
            <div class="modal-header">
                <center>
                        <button type="button" class="close" data-dismiss="modal" aria-label="Close" style="font-size: 30px;">
                            <span aria-hidden="true">&times;</span>
                        </button>
                   <i class=" fa fa-lg fa-tasks"></i> &nbsp;
                        <h4 class="modal-title"  style="display: inline-block;"><strong >New CRM Type</strong></h4>
                </center>


            </div>
                <div class="modal-body">

                    <table class="table table-bordered">
                        <tr>
                            <td>Type Name:</td>
                            <td><input class="form-control text-center" type="text" id="typeName"></td>
                        </tr>
                        <tr>
                            <td>Icon:</td>
                            <td><input class="form-control text-center" type="text" id="typeIcon"></td>
                        </tr>

                        <tr>
                            <td>Visible:</td>
                            <td>
                                <select class="form-control text-center" id="typeVisible">
                                    <option value="yes" selected>yes</option>
                                    <option value="no">no</option>
                                </select>
                            </td>
                        </tr>
                         <tr>
                            <td>Type Color:</td>
                            <td >
                                <span id="typeSelectedColor">
                                    <label>No Color:<input type="checkbox" id="noColor" style="margin: 0 5px;vertical-align: middle;width:35px;height:20px;' " > </label>
                                    <input type="color" id="typeColor" class="form-control" style="margin-left:10px;vertical-align: middle;width:20%; display: inline">
                                </span>
                            </td>

                        </tr>
                    </table>

                    <br>
                    <center>
                    <button type="button" id = "saveButton" class="btn btn-success" onclick="saveType()">Save Type</button>
                    </center>
                </div>

        </div>
    </div>
</div>



 <script src="//<?php echo HTML_PATH ?>/cop/backend/themes/<?php echo THEME_NAME ?>/js/DataTables/datatables.js"></script>
<script src="//<?php echo HTML_PATH ?>/cop/backend/themes/<?php echo THEME_NAME ?>/js/plugin/datatables/dataTables.colVis.min.js"></script>
<script src="//<?php echo HTML_PATH ?>/cop/backend/themes/<?php echo THEME_NAME ?>/js/plugin/datatables/dataTables.tableTools.min.js"></script>
<script src="//<?php echo HTML_PATH ?>/cop/backend/themes/<?php echo THEME_NAME ?>/js/plugin/datatables/dataTables.bootstrap.min.js"></script>
<script src="//<?php echo HTML_PATH ?>/cop/backend/themes/<?php echo THEME_NAME ?>/js/plugin/datatable-responsive/datatables.responsive.min.js"></script>
 <script src="//<?php echo HTML_PATH ?>/cop/backend/themes/<?php echo THEME_NAME ?>/js/plugin/select2/select2.min.js"></script>

<script type="text/javascript">


    function saveTypeField(id, elementName, newValue, suffix) {

        

        if(elementName==="name" && newValue === ""){
            $.smallBox({
                title: "Warning!",
                content: "The Type Name cannot be empty.",
                color: '#b22222',
                timeout: 3000,
                icon: "fa fa-exclamation-triangle swing animated"
            });
            closeEditFields(suffix);
            return;
        }

        $.ajax({
            type: "POST",
            url: "//<?php echo HTML_PATH; ?>/cop/backend/core/controllers/edit/edit_crm_type.php",
            data: {
                'id': id,
                'fieldName': elementName,
                'fieldValue': newValue
            }
            ,
            success: function(result) {
                if (result.localeCompare('existingName') == 0 ) {
                    $.smallBox({
                        title: "Warning!",
                        content: "Existing Type Name.",
                        color: '#b22222',
                        timeout: 3000,
                        icon: "fa fa-exclamation-triangle swing animated"
                    });
                    $('#input' + suffix).focus();



                } else {
                    $.smallBox({
                        title: "Success!",
                        content: "Field successfully updated.",
                        color: "#739E73",
                        timeout: 2000,
                        icon: "fa fa-check swing animated"
                    });

                    $('#value' + suffix).html(newValue);
                    closeEditFields(suffix);
                    $('#datatable_fixed_column').DataTable().draw(null, false);

                }
            }
        });
    }
    function  closeEditFields(suffix){
        $('#input' + suffix).hide();
        $('#inputDiv' + suffix).hide();
        $('#value' + suffix).show();
        $('#pen' + suffix).show();
        $('#save' + suffix).hide();

    }



    function openEditField(id, elementName){

        var suffix = '-' + elementName + '-' + id;
        var value  = $('#value' + suffix).html();

        var initialCheckboxChecked = $('#noColor' + suffix).is(':checked');
        var initialColorValue = $('#typeColor' + suffix).val();

        if (value === '&nbsp;' ) {
            value = '';
        }

        $('#value' + suffix).hide();
        $('#pen' + suffix).hide();

        $('#input' + suffix).val(value);
        $('#input' + suffix).show();
        $('#input' + suffix).focus();


        $('#inputDiv' + suffix).show();

        $('#typeColor' + suffix).focus();
        $('#noColor' + suffix).focus();

        $('#save' + suffix).show();

        $('#save' + suffix).unbind().on('click', function() {
            var newValue = $('#input' + suffix).val().trim();
            if(value.localeCompare(newValue)!=0 ){
                saveTypeField(id, elementName, newValue,suffix);
            }
            else {
                closeEditFields(suffix);
            }

        });


        $('#input' + suffix).focusout(function(){
            if (!$(event.relatedTarget).is($('#save' + suffix))) {
                closeEditFields(suffix);
            }
        });


        $('#typeColor' + suffix).focusout(function(){
            if (!$(event.relatedTarget).is($('#save' + suffix)) && !$(event.relatedTarget).is($('#noColor' + suffix)) ) {
                $('#noColor' + suffix).prop('checked', initialCheckboxChecked);
                $('#typeColor' + suffix).val(initialColorValue);
                closeEditFields(suffix);
            }
        });

        $('#noColor' + suffix).focusout(function(){
            if (!$(event.relatedTarget).is($('#save' + suffix)) && !$(event.relatedTarget).is($('#typeColor' + suffix)) ) {
                $('#noColor' + suffix).prop('checked', initialCheckboxChecked);
                $('#typeColor' + suffix).val(initialColorValue);
                closeEditFields(suffix);
            }
        });

    }


    function saveType(){

        $('#saveButton').hide();

        var typeName = $('#typeName').val().trim();
        var typeIcon =  $('#typeIcon').val().trim();
        var typeVisible =  $('#typeVisible').val().trim();
        var selectedColor = $('#typeSelectedColor').val();


        if(!typeName)
        {
            $.smallBox({
                title : "Type Name Missing!",
                content : "Please enter a Type Name.",
                color : "#b22222",
                timeout: 2000,
                icon : "fa fa-user swing animated"
            });

            highlightDataError($('#typeName'));

            $('#saveButton').show();

            return;
        }


        $.ajax({
            type: "POST",

            <?php
            echo "url: '//" . HTML_PATH . "/cop/backend/core/controllers/add/add_crm_type.php',";

            ?>
            data: {
                'typeName':typeName,
                'typeIcon':typeIcon,
                'typeVisible':typeVisible,
                'typeColor':selectedColor
            },
            success: function (result) {

                if(result.localeCompare('existingName') == 0){

                    $.smallBox({
                        title: "Warning!",
                        content: "Existing Type Name.",
                        color: '#b22222',
                        timeout: 3000,
                        icon: "fa fa-exclamation-triangle swing animated"
                    });

                    highlightDataError($('#typeName'));


                } else {

                    $.smallBox({
                        title : "Success!",
                        content : "Type successfully entered.",
                        color : "#739E73",
                        timeout: 2000,
                        icon : "fa fa-check swing animated"
                    });

                    $('#newCrmType').modal('hide');
                    $('#datatable_fixed_column').DataTable().draw(null, false);

                }
                $('#saveButton').show();

            },
            error: function (){
                $('#saveButton').show();
            }
        });
    }


    $(document).ready(function() {

        pageSetUp();


        var responsiveHelper_datatable_fixed_column = undefined;

        var breakpointDefinition = {
            tablet : 1024,
            phone : 480
        };

        /* COLUMN FILTER  */
        var otable = $('#datatable_fixed_column').DataTable({
            "sDom": "<'dt-toolbar'<'col-xs-6 col-sm-6'f><'col-sm-6 col-xs-6 hidden-xs' B C l>r>"+
                "t"+
                "<'dt-toolbar-footer'<'col-sm-6 col-xs-12 hidden-xs'i><'col-sm-6 col-xs-12'p>>",
            "autoWidth" : true,
            "processing": false,

            "serverSide": true,

            "ajax": {
                "type": "GET",
                "url": "//<?php echo HTML_PATH ?>/cop/backend/core/controllers/getAll/getAllCRMTypes.php",

            },
            "columns": [

                { "data": "name" },
                { "data": "icon" },
                { "data": "visible" },
                { "data": "color" }
            ],
            "deferRender": true,
            "autoWidth" : true,
            "buttons": ["copyHtml5",
                "excelHtml5",
                "csvHtml5",
                {
                    extend: 'pdfHtml5',
                    orientation: 'landscape',
                    pageSize: 'LEGAL'
                }
            ],
            "preDrawCallback" : function() {
                // Initialize the responsive datatables helper once.
                if (!responsiveHelper_datatable_fixed_column) {
                    responsiveHelper_datatable_fixed_column = new ResponsiveDatatablesHelper($('#datatable_fixed_column'), breakpointDefinition);
                }
            },
            "rowCallback" : function(nRow) {
                responsiveHelper_datatable_fixed_column.createExpandIcon(nRow);
            },
            "drawCallback" : function(oSettings) {
                responsiveHelper_datatable_fixed_column.respond();
            }

        });


        // Apply the filter
        $("#datatable_fixed_column thead th input[type=text]").on( 'keyup change', function () {

            otable
                .column( $(this).parent().index()+':visible' )
                .search( this.value )
                .draw();

        });

        initColorChange('noColor','typeColor','typeSelectedColor');

    })


    function highlightDataError(element){
        element.css('border-color','firebrick').css('background-color','#ffd0bd');
        window.setTimeout(function(){element.css('border-color','').css('background-color','');
        },2500);
    }

    function initColorChange(checkboxElementID,colorElementID,selectionElementID){
        var noColorCheckbox = $('#' + checkboxElementID);
        var colorInput = $('#' + colorElementID);
        var colorSelected = $('#' + selectionElementID);


        if (noColorCheckbox.is(':checked')) {
            colorSelected.val('');
            colorInput.hide();
        }

        if (!noColorCheckbox.is(':checked')) {
            colorInput.show();
            colorSelected.val(colorInput.val());
        }


        noColorCheckbox.unbind().on('change', function() {
            if (noColorCheckbox.is(':checked')) {
                colorSelected.val('');
                colorInput.hide();
            } else {
                colorInput.show();
                colorSelected.val(colorInput.val());
            }
        });

        //When a color is selected save it to the 'colorSelected' variable
        colorInput.unbind().on('change', function() {
            if (!noColorCheckbox.is(':checked')) {
                colorSelected.val(colorInput.val());
            }
        });
    }

</script>

     
    
     



