<?php
include_once("../../../../param.php");

global $username, $password, $database;

$db = new mysqli(localhost, $username, $password, $database);
if (mysqli_connect_errno()) {
    printf("Connect failed: %s\n", mysqli_connect_error());
    exit();
}
$db->set_charset("utf8");

$customersArray = array();
$stm = $db->prepare("SELECT customer_id,customer_code,customer_company_name FROM Customers");
$stm-> execute();
$stm-> bind_result($id,$code,$name);
while ($stm->fetch()) {
    $customersArray["$id"] = "$code - $name";
}
$stm->close();

$salesPersonsArray = array();
$stm = $db->prepare("SELECT salesperson_id,salesperson_code,CONCAT(first_name, ' ',last_name) FROM SalesPersons");
$stm-> execute();
$stm-> bind_result($id,$code,$name);
while ($stm->fetch()) {
    $salesPersonsArray["$id"] = "$code - $name";
}
$stm->close();




?>


<div id="main" role="main">
    <!-- Start CUSTOM CODE-->

    <!-- RIBBON -->
    <div id="ribbon" class="bg-color-blue">
        <span class="ribbon-button-alignment">
            <span id="refresh" class="btn btn-ribbon2" onclick="location.reload(true);" data-title="refresh" rel="tooltip" data-placement="bottom" data-original-title="<i class='text-warning fa fa-warning'></i> Reload Page?" data-html="true">
                <i class="fa fa-refresh"></i>
            </span>
        </span>
        <!-- breadcrumb -->
        <ol class="breadcrumb">
            <li class="txt-color-white">Home / Manage Promotions</li>
        </ol>
        <!-- end breadcrumb -->
    </div>
    <!-- END RIBBON -->





    <!-- MAIN CONTENT -->
    <div id="content">

        <div class="row">
            <div class="col-xs-12 col-sm-8 col-md-9 col-lg-8">
                <h3 class="page-title txt-color-blueDark" style="margin-top: 5px; margin-bottom: 15px;">
                    <i class="fa fa-money" ></i> Promotions
                </h3>
            </div>
            <div class="col-xs-12 col-sm-4 col-md-3 col-lg-2">
                <span class="pull-right show-stat-buttons"> <span > <a onclick = "$('#filterModal').modal('show');" class="btn btn-success btn-block" id="filterModalButton"><i class="fa fa-filter"></i>&nbsp; Filter By</a> </span></span>
            </div>
            <div class="col-xs-12 col-sm-4 col-md-3 col-lg-2">
                <span class="pull-right show-stat-buttons"><span> <a  href="//<?php echo HTML_PATH ?>/cop/backend/core/views/addedit/new_promotion.php" class="btn btn-primary btn-block"> <i class="fa fa-plus"></i>&nbsp; New Promotion</a> </span> </span>

            </div>

        </div>

        <!-- row -->
        <section id="widget-grid" class="">

            <!-- row -->
            <div class="row">
                <!-- NEW WIDGET START -->
                <article class="col-xs-12 col-sm-12 col-md-12 col-lg-12">

                    <div class="jarviswidget jarviswidget-color-blueDark" id="wid-id-1" data-widget-editbutton="false" data-widget-deletebutton="false">
                        <header>
                            <span class="widget-icon"> <i class="fa fa-table"></i> </span>
                            <h2>Promotions Table </h2>
                        </header>
                        <!-- widget div-->
                        <div>

                            <!-- widget content -->
                            <div class="widget-body no-padding">
                                <table id="datatable_fixed_column" class="table table-striped table-hover dataTabl" width="100%">
                                    <thead>
                                    <tr>
                                        <th class="hasinput">
                                            <input type="text" class="form-control text-center" placeholder="Filter Code" />
                                        </th>
                                        <th class="hasinput">
                                            <input type="text" class="form-control text-center" placeholder="Filter Name" />
                                        </th>
                                        <th class="hasinput">
                                            <input type="text" class="form-control text-center" placeholder="Filter Type" />
                                        </th>
                                        <th class="hasinput">
                                            <input type="text" class="form-control text-center" placeholder="Filter Product" />
                                        </th>
                                        <th class="hasinput">
                                            <input type="text" class="form-control text-center" placeholder="Filter Valid from" />
                                        </th>
                                        <th class="hasinput">
                                            <input type="text" class="form-control text-center" placeholder="Filter Valid until" />
                                        </th>
                                        <th>

                                        </th>
                                    </tr>
                                    <tr>
                                        <th class="text-center" style="width:8%">Promo Code</th>
                                        <th class="text-center" style="width:16%">Promo Name</th>
                                        <th class="text-center" style="width:13%">Type</th>
                                        <th class="text-center" style="width:19%">Primary Product</th>
                                        <th class="text-center" style="width:12%">Valid From</th>
                                        <th class="text-center" style="width:12%">Valid Until</th>
                                        <th class="text-center" style="width:20%">Actions</th>
                                    </tr>
                                    </thead>
                                </table>
                            </div>
                            <!-- end widget content -->

                        </div>
                        <!-- end widget div -->

                    </div>
                    <!-- end widget -->
                </article>
                <!-- WIDGET END -->
            </div>
            <!-- end row -->
        </section>

    </div>
</div>



<!-- Modal (Filter By)-->
<div class="modal fade" id="filterModal" tabindex="-1" role="dialog" aria-labelledby="myModalLabel" >
    <div class="modal-dialog modal-lg" role="document" >
        <div class="modal-content">
            <div class="modal-header">
                <center>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close" style="font-size: 30px;">
                        <span aria-hidden="true">&times;</span>
                    </button>

                </center>
            </div>
            <div class="modal-body">
                <table class="table table-bordered">
                    <tr>
                        <td style="width: 30%;">Customers:</td>
                        <td style="width: 70%;">
                            <input style="overflow: hidden; height: auto;width:100%" id="customerFilter" multiple="multiple" >
                        </td>
                    </tr>
                    <tr>
                        <td>Customer Groups:</td>
                        <td>
                            <input style="overflow: hidden; height: auto;width:100%" id="customerGroupFilter" >
                        </td>

                    </tr>
                    <tr>
                        <td>SalesPersons:</td>
                        <td>
                            <input style="overflow: hidden; height: auto;width:100%;" id="salesPersonFilter" >
                        </td>
                    </tr>

                    <tr>
                        <td>Items from promotions:</td>
                        <td>
                            <input  style="overflow: hidden; height: auto;width:100%;"  id="extraItemFilter" type="text" i>
                        </td>
                    </tr>
                </table>

                <br>
                <center>
                    <button type="button" id = "filterButton" class="btn btn-success" onclick="filterPromotions()">Filter</button>
                    <div id="filterActions" style="display: inline-block; margin-left: 10px;"></div>
                </center>


            </div>

        </div>
    </div>
</div>

<style>

    .select2-container {
        width: 100% !important;
        box-sizing: border-box;
        margin: 0;
        padding: 0;

    }
    .select2-container .select2-choice>.select2-chosen{
        color: #000000;
        font-weight: 400;
        font-family:"verdana", "sans-serif";
    }


    .select2-container .select2-choice,
    .select2-search input,
    .select2-drop-active ,
    .select2-container-multi .select2-choices,
    .select2-container-multi .select2-search input,
    .select2-container-multi .select2-choices li,
    .select2-container-multi .select2-drop-active {
        border-radius: 4px !important;

    }






</style>

<script src="//<?php echo HTML_PATH ?>/cop/backend/themes/<?php echo THEME_NAME ?>/js/DataTables/datatables.js"></script>
<script src="//<?php echo HTML_PATH ?>/cop/backend/themes/<?php echo THEME_NAME ?>/js/plugin/datatables/dataTables.colVis.min.js"></script>
<script src="//<?php echo HTML_PATH ?>/cop/backend/themes/<?php echo THEME_NAME ?>/js/plugin/datatables/dataTables.tableTools.min.js"></script>
<script src="//<?php echo HTML_PATH ?>/cop/backend/themes/<?php echo THEME_NAME ?>/js/plugin/datatables/dataTables.bootstrap.min.js"></script>
<script src="//<?php echo HTML_PATH ?>/cop/backend/themes/<?php echo THEME_NAME ?>/js/plugin/datatable-responsive/datatables.responsive.min.js"></script>
<script src="//<?php echo HTML_PATH ?>/cop/backend/themes/<?php echo THEME_NAME ?>/js/plugin/select2/select2.min.js"></script>

<script type="text/javascript">

    function activateButtonClicked(promotionID) {
        $.ajax({
            type: "POST",
            url: '//<?php echo HTML_PATH . "/cop/backend/core/controllers/change/changePromotionStatus.php" ?>',
            data: {
                'promotionID': promotionID,
                'active': "yes"
            },
            success: function(result) {
                $('#a' + promotionID).text('Deactivate')
                    .removeClass('btn-success')
                    .addClass('btn-danger')
                    .unbind('click')
                    .click(function() {
                        deactivateButtonClicked(promotionID);
                    });


            }
        });
    }

    function deactivateButtonClicked(promotionID) {
        $.ajax({
            type: "POST",
            url: '//<?php echo HTML_PATH . "/cop/backend/core/controllers/change/changePromotionStatus.php" ?>',
            data: {
                'promotionID': promotionID,
                'active': "no"
            },
            success: function(result) {
                $('#a' + promotionID).text('Activate')
                    .removeClass('btn-danger')
                    .addClass('btn-success')
                    .unbind('click')
                    .click(function() {
                        activateButtonClicked(promotionID);
                    });
            }
        });
    }

    function filterPromotions(){
        if ($('#filterModalButton').hasClass('btn-success')) {
            $('#filterModalButton')
                .html('<i class="fa fa-filter"></i>&nbsp; Filtered')
                .removeClass('btn-success')
                .addClass('btn-warning');

            if (!$("#removeFilterButton").length) {
                $("#filterActions").append(' <button type="button" id="removeFilterButton" class="btn btn-danger" onclick="removeFiltered()">Remove Filter</button>');
            }
        }

        $('#filterModal').modal('hide');
        $('#datatable_fixed_column').DataTable().draw(null, false);

    }

    function removeFiltered() {

        $("#customerFilter").select2("val", "");
        $("#customerGroupFilter").select2("val", "");
        $("#salesPersonFilter").select2("val", "");
        $("#extraItemFilter").select2("val", "");
        $("#removeFilterButton").remove();
        $('#filterModalButton').html('<i class="fa fa-filter"></i>&nbsp; Filter by').removeClass('btn-warning').addClass('btn-success');
        $('#filterModal').modal('hide');
        $('#datatable_fixed_column').DataTable().draw(null, false);
    }

    function initCustomerSelection(){
            $("#customerFilter").select2({
                multiple: true,
                minimumInputLength: 3,
                ajax: {
                    url: "//<?php echo HTML_PATH ?>/cop/backend/core/controllers/search/customerSearch.php",
                    dataType: "json",
                    type: "GET",
                    data: function (term, page) {
                        return {
                            query: term
                        };
                    },
                    results: function (data) {
                        return {
                            results: $.map(data, function (item) {
                                return {
                                    text: item.name,
                                    id: item.id
                                };
                            })
                        };
                    }
                }
            });

    }

    function iniSalesPersonSelection(){
        $("#salesPersonFilter").select2({
            multiple: true,
            minimumInputLength: 3,
            ajax: {
                url: "//<?php echo HTML_PATH ?>/cop/backend/core/controllers/search/salespersonSearch.php",
                dataType: "json",
                type: "GET",
                data: function (term, page) {
                    return {
                        query: term
                    };
                },
                results: function (data) {
                    return {
                        results: $.map(data, function (item) {
                            return {
                                text: item.name,
                                id: item.id
                            };
                        })
                    };
                }
            }
        });


    }

    function iniCustomerGroupSelection(){
        $("#customerGroupFilter").select2({
            multiple: true,
            minimumInputLength: 3,
            ajax: {
                url: "//<?php echo HTML_PATH ?>/cop/backend/core/controllers/search/customerGroupSearch.php",
                dataType: "json",
                type: "GET",
                data: function (term, page) {
                    return {
                        query: term
                    };
                },
                results: function (data) {
                    return {
                        results: $.map(data, function (item) {
                            return {
                                text: item.name,
                                id: item.id
                            };
                        })
                    };
                }
            }
        });


    }

    function iniItemSelection(){
        $("#extraItemFilter").select2({
            multiple: true,
            minimumInputLength: 3,
            ajax: {
                url: "//<?php echo HTML_PATH ?>/cop/backend/core/controllers/search/productSearch.php",
                dataType: "json",
                type: "GET",
                data: function (term, page) {
                    return {
                        query: term
                    };
                },
                results: function (data) {
                    return {
                        results: $.map(data, function (item) {
                            return {
                                text: item.name,
                                id: item.id
                            };
                        })
                    };
                }
            }
        });


    }


    $(document).ready(function() {

        pageSetUp();
        initCustomerSelection();
        iniSalesPersonSelection();
        iniCustomerGroupSelection();
        iniItemSelection();


        var responsiveHelper_datatable_fixed_column = undefined;

        var breakpointDefinition = {
            tablet: 1024,
            phone: 480
        };

        /* COLUMN FILTER  */
        var otable = $('#datatable_fixed_column').DataTable({
            "sDom": "<'dt-toolbar'<'col-xs-6 col-sm-6'f><'col-sm-6 col-xs-6 hidden-xs' B C l>r>" +
                "t" +
                "<'dt-toolbar-footer'<'col-sm-6 col-xs-12 hidden-xs'i><'col-sm-6 col-xs-12'p>>",
            "autoWidth": true,
            "processing": false,
            "serverSide": true,
            "ajax": {
                "type": "GET",
                "url": "//<?php echo HTML_PATH ?>/cop/backend/core/controllers/get/getPromotions.php",
                "data": function(data){
                    data.salesPersonFilter = $('#salesPersonFilter').val();
                    data.customerFilter = $('#customerFilter').val();
                    data.customerGroupFilter = $('#customerGroupFilter').val();
                    data.extraItemFilter = $('#extraItemFilter').val();

                }
            },
            "columns": [
                { "data": "code" },
                { "data": "name" },
                { "data": "type" },
                { "data": "item" },
                { "data": "valid_from" },
                { "data": "valid_until" },
                { "data": "form" }

            ],
            "deferRender": true,
            "autoWidth": true,
            "buttons": [
                "copyHtml5",
                "excelHtml5",
                "csvHtml5",
                {
                    extend: 'pdfHtml5',
                    orientation: 'landscape',
                    pageSize: 'LEGAL'
                }
            ],
            "preDrawCallback": function() {
                // Initialize the responsive datatables helper once.
                if (!responsiveHelper_datatable_fixed_column) {
                    responsiveHelper_datatable_fixed_column = new ResponsiveDatatablesHelper($('#datatable_fixed_column'), breakpointDefinition);
                }
            },
            "rowCallback": function(nRow) {
                responsiveHelper_datatable_fixed_column.createExpandIcon(nRow);
            },
            "drawCallback": function(oSettings) {
                responsiveHelper_datatable_fixed_column.respond();
            }
        });

        // Apply the filter
        $("#datatable_fixed_column thead th input[type=text]").on('keyup change', function() {
            otable
                .column($(this).parent().index() + ':visible')
                .search(this.value)
                .draw();
        });
    });
</script>


