<?php
include_once("../../../../param.php");
$todayDBFormat = date("Y-m-d");

?>

<div class="container" id="main" role="main">

    <div class="row" style="margin-left:10px;margin-top:10px;">
        <div class="col-xs-12 col-sm-8 col-md-9 col-lg-2">
            <h4 class="page-title txt-color-blueDark" style="margin-top: 5px;margin-bottom: 15px;" id="currentDateText">
                <i class="fa-fw fa fa-map-marker"></i>
                Item Sale Locations
            </h4>
        </div>

        <div class="col-xs-12 col-sm-4 col-md-3 col-lg-4">
            <input id='itemID' type='hidden' >
            <input style='display:inline;' class='text-center form-control' id='itemSearch' name='itemSearch' type='text' >


        </div>

        <div class="col-xs-12 col-sm-4 col-md-3 col-lg-1">
            <div class="hasinput ">
                <input id="dateFrom" type="text" placeholder="Select Date" class="form-control datepicker text-center" data-dateformat="yy-mm-dd" value="<?php echo $todayDBFormat ?>">
            </div>
        </div>
        <div class="col-xs-12 col-sm-4 col-md-3 col-lg-1">
            <div class="hasinput ">
                <input id="dateTo" type="text" placeholder="Select Date" class="form-control datepicker text-center" data-dateformat="yy-mm-dd" value="<?php echo $todayDBFormat ?>">
            </div>
        </div>
        <div class="col-xs-12 col-sm-4 col-md-3 col-lg-2">
            <select id="salespersonSelect" class="js-example-basic-single form-control" style="margin-left:20px;display: inline">
                <option value='all'>All Salespersons</option>
                <?php

                global $username, $password, $database;

                $db = new mysqli(localhost,$username,$password,$database);
                if (mysqli_connect_errno()) {
                    printf("Connect failed: %s\n", mysqli_connect_error());
                    exit();
                }
                $db->set_charset("utf8");
                // WHERE compani code in  Session
                $stm = $db->prepare("SELECT salesperson_id,salesperson_code,first_name,last_name FROM SalesPersons");
                $stm-> execute();
                $stm-> bind_result($salespersonID,$code,$first_name,$last_name);
                while ($stm->fetch()) {

                    echo "<option value='$salespersonID'>$code $first_name $last_name</option>";
                }
                $stm-> close();
                ?>
            </select>

        </div>






    </div>

    <!-- MAIN CONTENT -->

    <div class="map" id="map_coprime" ></div>

</div>

<script
        src="https://maps.googleapis.com/maps/api/js?key=AIzaSyAonEryABOdRQBcgEfH51-nOoXTca3XlWs">
</script>

<style>

    html { height: 100% }
    body { height: 100%; margin: 0px; padding: 0px }
    .container { width: 100%; height: 100% }
    #nav { z-index: 100; position: absolute;
        margin: 10px 0px 0px 200px; background-color: #fff;
        border: 1px #000 Solid; padding: 5px; }
    .map { width: 100%; height: 100% }
</style>


<script type="text/javascript">

    var copMap;
    var markers=[];

    var customerMarkers = [];

    var showCustomers = false;
    var showLines = false;

    var currentMarkerPosition = 0;
    var flightPath;
    var latlngs = [];

    function initMap() {
        copMap = new google.maps.Map(document.getElementById('map_coprime'), {
            center: {lat: 34.92, lng: 33.63},
            zoom: 8
        });
    }

    function updateMarkers()
    {
        currentMarkerPosition = 0;


        var itemID = $('#itemID').val();



        var salespersonID = $('#salespersonSelect').val();
        var dateFrom = $('#dateFrom').val();
        var dateTo = $('#dateTo').val();


        if(flightPath != null) {
            flightPath.setMap(null);
        }
        if(latlngs != null)
        {
            latlngs = [];
        }


        $.ajax({
            type:"POST",
            dataType: "json",
            url: '//<?php echo HTML_PATH ?>/cop/backend/core/controllers/get/getItemSalesMarkers.php',
            data: {itemID:itemID,salespersonID:salespersonID, dateFrom: dateFrom, dateTo: dateTo},
            success: function(data) {



                var bounds = new google.maps.LatLngBounds();

                var counter = 0;

                for (var i = 0; i < markers.length; i++) {
                    markers[i].setMap(null);
                }

                $.each(data, function(index,value)
                {

                    counter = counter +1;

                    var marker = new google.maps.Marker({
                        position: new google.maps.LatLng(value.lat,value.lng),
                        map: copMap,
                        title: value.label,
                        label: value.totalQty.toString()
                    });

                    markers[index] = marker;
                    latlngs[index] = marker.position;

                    bounds.extend(markers[index].position);

                });
                copMap.fitBounds(bounds);

                if(showLines) {
                    flightPath = new google.maps.Polyline({
                        path: latlngs,
                        geodesic: true,
                        strokeColor: '#FF0000',
                        strokeOpacity: 1.0,
                        strokeWeight: 2
                    });
                    flightPath.setMap(copMap);
                }
            }
        });
    }

    function initAutocomplete()
    {
        $("#itemSearch").autocomplete({
            source: "//<?php echo HTML_PATH ?>/cop/backend/core.controllers/autocomplete/item_autocomplete.php",
            autoFocus: true,
            open: function(){
                $('.ui-autocomplete').css('width', '500px');
            },
            select: function (event, ui) {
                // Modify this  information to match the information coming from assets/ajax-services/fetch-inventory.php
                $('#itemID').val(ui.item.item_id); // Hidden input on form
                $('#itemCode').text(ui.item.item_code);
                $('#itemDetails').text(ui.item.name);
            }
        });
    }

    $(document).ready(function() {

        pageSetUp();

        initAutocomplete();

        initMap();

        updateMarkers();

        $( "#salespersonSelect" ).change(function() {
            updateMarkers();
        });

        $( "#itemSearch").change(function() {
            updateMarkers();
        });

        $( "#dateFrom" ).change(function() {
            updateMarkers();
        });

        $( "#dateTo" ).change(function() {
            updateMarkers();
        });



    })

</script>

<script src="//<?php echo HTML_PATH ?>/cop/backend/themes/<?php echo THEME_NAME ?>/js/plugin/select2/select2.min.js"></script>