<?php
include_once("../../../../param.php");

global $username, $password, $database;
$db = new mysqli(localhost, $username, $password, $database);
if (mysqli_connect_errno()) {
    printf("Connect failed: %s\n", mysqli_connect_error());
    exit();
}
$db->set_charset("utf8");

$categorySelection = "<option value='' selected>All</option>";
$stm = $db->prepare("SELECT CONCAT(category_code, ' - ',name), category_id FROM Categories  ORDER BY category_code ASC");
$stm-> execute();
$stm-> bind_result($categoryInfo, $categoryID);
while ($stm->fetch()) {
    $categorySelection .= "<option value='$categoryID'>$categoryInfo</option>";
}
$stm-> close();


?>

<div id="main" role="main" class="background-color-whitish">

    <!-- Start CUSTOM CODE-->


    <!-- RIBBON -->
    <div id="ribbon" class="bg-color-blue">

				<span class="ribbon-button-alignment">
					<span id="refresh" class="btn btn-ribbon2" onclick="location.reload(true);" data-title="refresh" rel="tooltip" data-placement="bottom" data-original-title="<i class='text-warning fa fa-warning'></i> Reload Page?" data-html="true">
						<i class="fa fa-refresh"></i>
					</span>
				</span>

        <!-- breadcrumb -->
        <ol class="breadcrumb">
            <li class="txt-color-white">Home / Reports / Business Review</li>
        </ol>
        <!-- end breadcrumb -->

    </div>
    <!-- END RIBBON -->

    <!-- MAIN CONTENT -->
    <div id="content">

        <div class="row">
            <div class="col-xs-12 col-sm-6 col-md-6 col-lg-6">
                <span>  <a onclick="backToReports()" class="btn btn-primary"><i class="fa fa-arrow-left"></i>&nbsp; Back to Reports</a> </span>
                <h3 style="display:inline;margin-left:10px;" class="page-title txt-color-blueDark header-margin">
                    <i class="fa-fw fa fa-signal"></i>
                    Reports
                </h3>
            </div>
        </div>

        <!-- row -->
        <section id="widget-grid" class="" style="margin-top:10px;">
            <!-- row -->
            <div class="row">

                <!-- NEW WIDGET START -->
                <article class="col-xs-12 col-sm-12 col-md-12 col-lg-12">

                    <div class="jarviswidget jarviswidget-color-blueDark" data-widget-editbutton="false" data-widget-deletebutton="false">
                        <header>
                            <span class="widget-icon"> <i class="fa fa fa-table"></i> </span>
                            <h2>Business Review</h2>
                        </header>
                        <!-- widget div-->
                        <div>
                            <!-- widget content -->
                            <div class="widget-body" style="overflow-x:scroll">


                                <label style="display: block; margin-top: 10px"><b> Time Period&nbsp;&nbsp;</b></label>
                                <select class="text-center form-control" id="timePeriod" name="timePeriod" style="width:30%;display:block;"  title="Select Item Code first" >
                                    <option value="daily" >Daily</option>
                                    <option value="weekly" >Weekly</option>
                                    <option value="monthly" >Monthly</option>
                                    <option value="yearly">Yearly</option>
                                    <option value="date-range">Date Range</option>
                                </select>


                                <!-- Date Range -->
                                <span id="dateRangeInputs" style="display:none;">
                                    <label  style="display: block; margin-top: 10px"><b>Start Date:</b></label>
                                    <input type="date" id="startDateRange" name="startDateRange" class="form-control"  style="width:30%;" value="<?php echo date('Y-m-d'); ?>" >

                                    <label style="display: block; margin-top: 10px"><b>End Date:</b></label>
                                    <input type="date" id="endDateRange" name="endDateRange" class="form-control" style="width:30%;" value="<?php echo date('Y-m-d'); ?>" >
                                </span>

                                <!-- Day Selection -->
                                <span id="dateDayInput" style="display:none">
                                    <label style="display: block; margin-top: 10px"><b>Select Day:</b></label>
                                    <input type="date" id="startDateDay" name="startDateDay" class="form-control" style="width:30%;" value="<?php echo date('Y-m-d'); ?>">
                                </span>

                                <!-- Start Week Day -->
                                <span id="dateWeekInput" style="display:none">
                                    <label style="display: block; margin-top: 10px"><b>Week:</b></label>
                                    <input type="week" id="startDateWeek" name="startDateWeek" class="form-control" style="width:30%;" value="<?php
                                        echo  date('Y').'-W'. date("W", strtotime(date('Y-m-d')));
                                    ?>">
                                </span>

                                <!-- Month Selection -->
                                <span id="dateMonthInput" style="display:none">
                                    <label style="display: block; margin-top: 10px"><b>Month:</b></label>
                                    <input type="month" id="startDateMonth" name="startDateMonth" class="form-control" style="width:30%;" value="<?php echo date('Y-m'); ?>">
                                </span>

                                <!-- Year Selection -->
                                <span id="dateYearInput" style="display:none">
                                        <label style="display: block; margin-top: 10px"><b>Year:</b></label>
                                        <select id="startDateYear" name="startDateYear" class="form-control" style="width: 30%;">
                                            <?php
                                            $currentYear = date('Y');
                                            for ($i = 0; $i < 20; $i++) {
                                                $year = $currentYear - $i;
                                                echo "<option value='$year' style='text-align:center;' >$year</option>";
                                            }
                                            ?>
                                        </select>
                                </span>


                               
                                <br><br>
                                <button type="button" name="generateReport" id="generateReport" class="btn btn-primary" onclick="getReport()" >Generate Report</button>
                                <button type="button" name="generateExcel"  id="generateExcel"  class="btn btn-waybill" onclick="exportXLS()" >Export to Excel</button>
                                <button type="button" name="generatePDF"    id="generatePDF"    class="btn btn-danger"  onclick="exportPDF()" >Export PDF</button>

                            </div>
                            <!-- end widget content -->

                        </div>
                        <!-- end widget div -->

                    </div>
                    <!-- end widget -->
                </article>
                <!-- NEW WIDGET END -->

                <!-- NEW WIDGET START -->
                <article class="col-xs-12 col-sm-12 col-md-12 col-lg-12">

                    <div class="jarviswidget jarviswidget-color-blueDark" data-widget-editbutton="false" data-widget-deletebutton="false">
                        <header>
                            <span class="widget-icon"> <i class="fa fa fa-table"></i> </span>
                            <h2>Business Review Report</h2>
                        </header>
                        <!-- widget div-->
                        <div>
                            <!-- widget content -->
                            <div class="widget-body" style="overflow-x:scroll">

                                <div name="reportResult" id="reportResult"></div>
                                <form method="POST" action="#" name="xlsForm" id="xlsForm" >
                                    <input type="hidden" name="inputResult" id="inputResult" value=""/>
                                    <input type="hidden" name="orientation" id="orientation" value="landscape"/>
                                    <input type="hidden" name="inputTitle" id="inputTitle" value="SingleProductSalesPurchases"/>
                                </form>

                            </div>
                            <!-- end widget content -->

                        </div>
                        <!-- end widget div -->

                    </div>
                    <!-- end widget -->
                </article>
                <!-- NEW WIDGET END -->

            </div>


    </div>
    <!-- end widget content -->

    <!-- end row -->
    </section>

</div>

<script type="text/javascript">


    $(document).ready(function() {
        $("#categoryID").select2({
        });
        pageSetUp();
        showDateInputs();

        $('#timePeriod').change(function() {
            showDateInputs();
        });
        

    });

    function getReport(){

        var dateRange = getSelectedDateRange();

        var startDate = dateRange.startDate;
        var endDate = dateRange.endDate;
        var selectedPeriod = $('#timePeriod').val();
        var categoryID = $('#categoryID').val();

        $('#reportResult').html('<center><b>Generating Report..</b></center>');

        $.ajax({
            type: "POST",
            url: '//<?php echo HTML_PATH ?>/cop/backend/core/views/reports/generateBusinessReviewReport.php',
            data: {

                'timePeriod':selectedPeriod,
                'startDate':startDate,
                'endDate':endDate,
                'categoryID':categoryID

            },

            success: function (result) {
                $('#reportResult').html(result);
            }
        });

    }

    function exportXLS(){



        var typeReport = 'excel';
        var dateRange = getSelectedDateRange();

        var startDate = dateRange.startDate;
        var endDate = dateRange.endDate;
        var selectedPeriod = $('#timePeriod').val();
        var categoryID = $('#categoryID').val();

        $('#reportResult').html('<center><b>Generating Report..</b></center>');

        $.ajax({
            type: "POST",
            url: '//<?php echo HTML_PATH ?>/cop/backend/core/views/reports/generateBusinessReviewReport.php',
            data: {

                'categoryID':categoryID,
                'typeReport':typeReport,
                'timePeriod':selectedPeriod,
                'startDate':startDate,
                'endDate':endDate

            },

            success: function (result) {
                $('#reportResult').html(result);
                $('#inputResult').val(result);
                $('#xlsForm').attr('action','//<?php echo HTML_PATH ?>/cop/backend/core/templates/xls/generateGeneralXLS.php').submit();
            }
        });


    }

    function exportPDF(){

        var dateRange = getSelectedDateRange();

        var startDate = dateRange.startDate;
        var endDate = dateRange.endDate;
        var selectedPeriod = $('#timePeriod').val();
        var categoryID = $('#categoryID').val();

        $('#reportResult').html('<center><b>Generating Report..</b></center>');

        $.ajax({
            type: "POST",
            url: '//<?php echo HTML_PATH ?>/cop/backend/core/views/reports/generateBusinessReviewReport.php',
            data: {
                'timePeriod':selectedPeriod,
                'startDate':startDate,
                'endDate':endDate,
                'categoryID':categoryID
            },

            success: function (result) {
                $('#reportResult').html(result);
                $('#inputResult').val(result);
                $('#xlsForm').attr('action','//<?php echo HTML_PATH ?>/cop/backend/core/templates/pdf/generatePDFFromHTML.php').submit();
            }
        });


    }

    function backToReports() {
        try {
            $(".swLinkMenu")[0].click();
        }
        catch(err)
        {

        }

        setTimeout(function() {
            window.location = "reports_list.php";
        }, 1000);


    }

    function showDateInputs(){
        $('#dateRangeInputs').hide();
        $('#dateDayInput').hide();
        $('#dateWeekInput').hide();
        $('#dateMonthInput').hide();
        $('#dateYearInput').hide();
        $('#dateDayInput').hide();

        var selectedTimePeriod = $('#timePeriod').val();
        if (selectedTimePeriod === 'date-range') {
            $('#dateRangeInputs').show();
        } else if (selectedTimePeriod === 'daily') {
            $('#dateDayInput').show();
        } else if (selectedTimePeriod === 'weekly') {
            $('#dateWeekInput').show();
        } else if (selectedTimePeriod === 'monthly') {
            $('#dateMonthInput').show();
        } else if (selectedTimePeriod === 'yearly') {
            $('#dateYearInput').show();
        }
        else{
            $('#dateDayInput').show();
        }
    }

    function getSelectedDateRange() {
        var selectedPeriod = $('#timePeriod').val();
        var startDate, endDate;

        if (selectedPeriod === "daily") {
            startDate = $('#startDateDay').val();
            endDate = startDate;
        }
        else if (selectedPeriod === "weekly") {
            var startDateStr = $('#startDateWeek').val();
            var [year, week] = startDateStr.split("-W").map(Number);
            startDate = new Date(year, 0, 1 + (week - 1) * 7); //get start of the week
            startDate.setDate(startDate.getDate() - startDate.getDay() + 1); //get monday
            endDate = new Date(startDate);
            endDate.setDate(startDate.getDate() + 6); // get last day of week
             startDate = startDate.toISOString().split("T")[0]; // format date
             endDate = endDate.toISOString().split("T")[0];


        }
        else if (selectedPeriod === "monthly") {
            startDate = $('#startDateMonth').val() + '-01';
            var startYear = parseInt(startDate.split('-')[0]); // year
            var startMonth = parseInt(startDate.split('-')[1]) - 1; // month (zero-based)
            var endDateObj = new Date(startYear, startMonth + 1, 0); // last day of the month
            endDate = endDateObj.toISOString().split('T')[0]; // format to YYYY-MM-DD
        }
        else if (selectedPeriod === "yearly") {
            var startYear = parseInt($('#startDateYear').val());
            startDate = startYear + '-01-01';
            endDate = startYear + '-12-31';
        }
        else if (selectedPeriod === "date-range") {
            startDate = $('#startDateRange').val();
            endDate = $('#endDateRange').val();
        }

        return { startDate, endDate };
    }


</script>


