<?php
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ERROR);
ob_start();

include_once("../../../../param.php");
$typeReport = $_POST['typeReport'];
if (strcmp($typeReport,'excel')==0){
    $report = " <htmlpageheader name='myHTMLHeader1'></htmlpageheader>";
}else{
    $report = "<style>


        body
        {
           font-family: Helvetica Neue, Helvetica, Arial, sans-serif;
           

        }

        p
        {

        }

        #wrapper
        {
            width:180mm;
            margin:0 15mm;
        }

        .page
        {
            height:297mm;
            width:210mm;

            page-break-after:always;
        }
        

        table.bordered
        {
            border-left: 1px solid #ddd;
            border-top: 1px solid #ddd;

            border-spacing:0;
            border-collapse: collapse;

        }
       

        table.bordered td
        {
            border-right: 1px solid #ddd;
            border-bottom: 1px solid #ddd;
            padding: 2mm;
        }

        table.heading
        {

        }

        h1.heading
        {
            font-size:14pt;
            color:#000;
            font-weight:normal;
        }

        h2.heading
        {
            font-size:9pt;
            color:#000;
            font-weight:normal;
        }

        hr
        {
            color:#ccc;
            background:#ccc;
        }
        
        

        #invoice_body
        {

        }

        td {
          font-family: Helvetica Neue, Helvetica, Arial, sans-serif;
        }

        #invoice_body , #invoice_total, #tableHeader
        {
            width:100%;
        }
        #invoice_body table , #tableHeader table
        {
            width:100%;
            border-left: 1px solid #ccc;
            border-top: 1px solid #ccc;
        }

        #invoice_total table {
          width:100%;
        }

        #invoice_body table td , #tableHeader table td
        {
            text-align:center;
            font-size: 11px;
            border-right: 1px solid #ccc;
            border-bottom: 1px solid #ccc;
            padding:2mm 0;
        }
        
        .positive {
            color: #008000;
        }
        
        .negative {
            color: #d60000; 
        }

        #invoice_body table td.mono  , #invoice_total table td.mono, #tableHeader table td.mono
        {
            font-family: Helvetica Neue, Helvetica, Arial, sans-serif;
            text-align:right;
            padding-right:3mm;
            font-size:10pt;
        }

        #footer
        {
            width:180mm;
            margin:0 15mm;
            padding-bottom:3mm;
        }
        #footer table
        {
            width:100%;
            background:#eee;

        }
        #footer table td
        {
            width:25%;
            text-align:center;
            font-size:9pt;
        }


        @page
        {
        
             margin-left: 1.4cm;
             margin-right: 1.4cm;
        
            header: html_myHTMLHeader1;
            footer: html_myFooter1;
        }

        

        #table_info td {
           font-size: 12px;
           padding:0;

        }
        

    </style>
    <htmlpageheader name='myHTMLHeader1'></htmlpageheader>

";
}

$timePeriod    = trim(''.$_POST['timePeriod']);
$startDate          = trim(''.$_POST['startDate']);
$endDate    = trim(''.$_POST['endDate']);
$dateFrom       = trim(''.$_POST['dateFrom']);




if( ( isset($startDate) && strcmp($startDate,'')!=0) && (isset($endDate) && strcmp($endDate,'')!=0 ) && (isset($timePeriod) && strcmp($timePeriod,'')!=0 )){

    $start = new DateTime($startDate);
    $end = new DateTime($endDate);
    $interval = $start->diff($end);
    if ($interval->y > 1 || ($interval->y == 1 && $interval->m > 0)) {
        $report .= "<center><b>The interval between start date and end date cannot be more than one year.</b></center>";
        echo $report;
        return $report;
    }





    global $username, $password, $database;
    $db = new mysqli('localhost',$username,$password,$database);
    if (mysqli_connect_errno()) {
        printf("Connect failed: %s\n", mysqli_connect_error());
        exit();
}


    $currentPeriod = "o.order_date >= '$startDate' AND o.order_date <= '$endDate'";
    $previousPeriod = "o.order_date >= DATE_SUB('$startDate', INTERVAL (DATEDIFF('$endDate', '$startDate') + 1) DAY) 
                   AND o.order_date <= DATE_SUB('$endDate', INTERVAL (DATEDIFF('$endDate', '$startDate') + 1) DAY)";
    $lastYearPeriod = "o.order_date >= DATE_SUB('$startDate', INTERVAL 1 YEAR) 
                   AND o.order_date <= DATE_SUB('$endDate', INTERVAL 1 YEAR)";

    $data = new stdClass();

    $query = " SELECT 
                    COUNT(DISTINCT CASE WHEN o.status <> 'Canceled' THEN o.order_id END) AS total_orders,
                    SUM(CASE WHEN o.status <> 'Canceled' THEN o.grand_total END) AS total_grand_total,
                    SUM(CASE WHEN o.status <> 'Canceled' THEN o.subtotal END) AS total_net,
                    SUM(CASE WHEN o.status IN ('Fully Delivered', 'Delivered') THEN o.subtotal END) AS total_delivered_revenue,
                    COUNT(CASE WHEN o.status = 'Canceled' THEN o.order_id END) AS total_cancelled_orders,
                    SUM(CASE WHEN o.status <> 'Canceled' THEN oi.unique_items END) AS total_unique_items,
                    SUM(CASE WHEN o.status <> 'Canceled' THEN oi.delivered_qty END) AS total_delivered_qty,
                    COUNT(DISTINCT o.customer_id) AS customers
                FROM Orders AS o
                INNER JOIN (
                    SELECT 
                        oi.order_id, 
                        COUNT(DISTINCT oi.item_id) AS unique_items,
                        SUM(CASE WHEN o.status LIKE '%Delivered%' THEN oi.qty END) AS delivered_qty
                    FROM Order_Item oi  
                    INNER JOIN Orders o ON oi.order_id = o.order_id 
                    WHERE $currentPeriod 
                    GROUP BY o.order_id
                ) AS oi ON o.order_id = oi.order_id 
                WHERE $currentPeriod  
           ";

    $stm = $db->prepare($query);
    $stm->execute();
    $stm->bind_result($currentOrdersCount,$currentAmmount, $currentNet, $currentDeliveredRevenue, $currentCancelledOrders, $currentItemsCount, $currentDeliveredQty,$currentCustomersCount);
    while($stm->fetch()) {
        $data->currentOrdersCount = intval($currentOrdersCount);
        $data->currentAmmount = floatval($currentAmmount);
        $data->currentNet = floatval($currentNet);
        $data->currentDeliveredRevenue = floatval($currentDeliveredRevenue);
        if($data->currentOrdersCount == 0){
            $data->currentCancelledOrders = 0;
        }
        else{
            $data->currentCancelledOrders = $currentCancelledOrders /   $data->currentOrdersCount * 100 ;
        }
        $data->currentItemsCount = intval($currentItemsCount);

        $data->currentDeliveredQty = intval($currentDeliveredQty);
        $data->currentCustomersCount = intval($currentCustomersCount);

    }

    $stm->close();

    $query = " SELECT 
                    COUNT(DISTINCT CASE WHEN o.status <> 'Canceled' THEN o.order_id END) AS total_orders,
                    SUM(CASE WHEN o.status <> 'Canceled' THEN o.grand_total END) AS total_grand_total,
                    SUM(CASE WHEN o.status <> 'Canceled' THEN o.subtotal END) AS total_net,
                    SUM(CASE WHEN o.status IN ('Fully Delivered', 'Delivered') THEN o.subtotal END) AS total_delivered_revenue,
                    COUNT(CASE WHEN o.status = 'Canceled' THEN o.order_id END) AS total_cancelled_orders,
                    SUM(CASE WHEN o.status <> 'Canceled' THEN oi.unique_items END) AS total_unique_items,
                    SUM(CASE WHEN o.status <> 'Canceled' THEN oi.delivered_qty END) AS total_delivered_qty,
                    COUNT(DISTINCT o.customer_id) AS customers
                FROM Orders AS o
                INNER JOIN (
                    SELECT 
                        oi.order_id, 
                        COUNT(DISTINCT oi.item_id) AS unique_items,
                        SUM(CASE WHEN o.status LIKE '%Delivered%' THEN oi.qty END) AS delivered_qty
                    FROM Order_Item oi
                    INNER JOIN Orders o ON oi.order_id = o.order_id 
                    WHERE $previousPeriod 
                    GROUP BY o.order_id
                ) AS oi ON o.order_id = oi.order_id 
                WHERE $previousPeriod  

           ";

    $stm = $db->prepare($query);
    $stm->execute();
    $stm->bind_result($previousOrdersCount,$previousAmmount, $previousNet, $previousDeliveredRevenue, $previousCancelledOrders, $previousItemsCount, $previousDeliveredQty,$previousCustomersCount);
    while($stm->fetch()) {
        $data->previousOrdersCount = intval($previousOrdersCount);
        $data->previousAmmount = floatval($previousAmmount);
        $data->previousNet = floatval($previousNet);
        $data->previousDeliveredRevenue = floatval($previousDeliveredRevenue);
        if( $data->previousOrdersCount == 0){
            $data->previousCancelledOrders = 0;
        }else{
            $data->previousCancelledOrders = intval($previousCancelledOrders) /   $data->previousOrdersCount * 100 ;
        }
        $data->previousItemsCount = intval($previousItemsCount);
        $data->previousDeliveredQty = intval($previousDeliveredQty);
        $data->previousCustomersCount = intval($previousCustomersCount);


    }
    $stm->close();

    $query = " SELECT 
                    COUNT(DISTINCT CASE WHEN o.status <> 'Canceled' THEN o.order_id END) AS total_orders,
                    SUM(CASE WHEN o.status <> 'Canceled' THEN o.grand_total END) AS total_grand_total,
                    SUM(CASE WHEN o.status <> 'Canceled' THEN o.subtotal END) AS total_net,
                    SUM(CASE WHEN o.status IN ('Fully Delivered', 'Delivered') THEN o.subtotal END) AS total_delivered_revenue,
                    COUNT(CASE WHEN o.status = 'Canceled' THEN o.order_id END) AS total_cancelled_orders,
                    SUM(CASE WHEN o.status <> 'Canceled' THEN oi.unique_items END) AS total_unique_items,
                    SUM(CASE WHEN o.status <> 'Canceled' THEN oi.delivered_qty END) AS total_delivered_qty,
                    COUNT(DISTINCT o.customer_id) AS customers
                FROM Orders AS o
                INNER JOIN (
                    SELECT 
                        oi.order_id, 
                        COUNT(DISTINCT oi.item_id) AS unique_items,
                        SUM(CASE WHEN o.status LIKE '%Delivered%' THEN oi.qty END) AS delivered_qty
                    FROM Order_Item oi
                    INNER JOIN Orders o ON oi.order_id = o.order_id 
                    WHERE $lastYearPeriod  
                    GROUP BY o.order_id
                ) AS oi ON o.order_id = oi.order_id 
                WHERE $lastYearPeriod 

           ";

    $stm = $db->prepare($query);
    $stm->execute();
    $stm->bind_result($lastYearOrdersCount,$lastYearAmmount, $lastYearNet, $lastYearDeliveredRevenue, $lastYearCancelledOrders, $lastYearItemsCount, $lastYearDeliveredQty,$lastYearCustomersCount);
    while($stm->fetch()) {
        $data->lastYearOrdersCount = intval($lastYearOrdersCount);
        $data->lastYearAmmount = floatval($lastYearAmmount);
        $data->lastYearNet = floatval($lastYearNet);
        $data->lastYearDeliveredRevenue = floatval($lastYearDeliveredRevenue);
        if( $data->lastYearOrdersCount == 0){
            $data->lastYearCancelledOrders = 0;
        }else{
            $data->lastYearCancelledOrders = intval($lastYearCancelledOrders) / $data->lastYearOrdersCount * 100 ;
        }
        $data->lastYearItemsCount = intval($lastYearItemsCount);
        $data->lastYearDeliveredQty = intval($lastYearDeliveredQty);
        $data->lastYearCustomersCount = intval($lastYearCustomersCount);

    }
    $stm->close();

// Average order items
    $data->averageOrderItems = safe_division($data->currentItemsCount, $data->currentOrdersCount);
    $data->previousAverageOrderItems = safe_division($data->previousItemsCount, $data->previousOrdersCount);
    $data->lastYearAverageOrderItems = safe_division($data->lastYearItemsCount, $data->lastYearOrdersCount);

// Average order amount
    $data->averageOrderAmount = safe_division($data->currentAmmount, $data->currentOrdersCount);
    $data->previousAverageOrderAmount = safe_division($data->previousAmmount, $data->previousOrdersCount);
    $data->lastYearAverageOrderAmount = safe_division($data->lastYearAmmount, $data->lastYearOrdersCount);

// Order frequency
    $data->currentOrderFrequency = safe_division($data->currentOrdersCount, $data->currentCustomersCount);
    $data->previousOrderFrequency = safe_division($data->previousOrdersCount, $data->previousCustomersCount);
    $data->lastYearOrderFrequency = safe_division($data->lastYearOrdersCount, $data->lastYearCustomersCount);

// Period over period growth calculations
    $data->popOrdersCount = safe_division($currentOrdersCount - $previousOrdersCount, $previousOrdersCount) * 100;
    $data->popAmmount = safe_division($currentAmmount - $previousAmmount, $previousAmmount) * 100;
    $data->popNet = safe_division($currentNet - $previousNet, $previousNet) * 100;
    $data->popDeliveredRevenue = safe_division($currentDeliveredRevenue - $previousDeliveredRevenue, $previousDeliveredRevenue) * 100;
    $data->popCancelledOrders = safe_division($currentCancelledOrders - $previousCancelledOrders, $previousCancelledOrders) * 100;
    $data->popItemsCount = safe_division($currentItemsCount - $previousItemsCount, $previousItemsCount) * 100;
    $data->popDeliveredQty = safe_division($currentDeliveredQty - $previousDeliveredQty, $previousDeliveredQty) * 100;
    $data->popCustomersCount = safe_division($currentCustomersCount - $previousCustomersCount, $previousCustomersCount) * 100;
    $data->popAverageOrderItems = safe_division($data->averageOrderItems - $data->previousAverageOrderItems, $data->previousAverageOrderItems) * 100;
    $data->popAverageOrderAmount = safe_division($data->averageOrderAmount - $data->previousAverageOrderAmount, $data->previousAverageOrderAmount) * 100;
    $data->popOrderFrequency = safe_division($data->currentOrderFrequency - $data->previousOrderFrequency, $data->previousOrderFrequency) * 100;

// Year over year growth calculations
    $data->yoyOrdersCount = safe_division($currentOrdersCount - $lastYearOrdersCount, $lastYearOrdersCount) * 100;
    $data->yoyAmmount = safe_division($currentAmmount - $lastYearAmmount, $lastYearAmmount) * 100;
    $data->yoyNet = safe_division($currentNet - $lastYearNet, $lastYearNet) * 100;
    $data->yoyDeliveredRevenue = safe_division($currentDeliveredRevenue - $lastYearDeliveredRevenue, $lastYearDeliveredRevenue) * 100;
    $data->yoyCancelledOrders = safe_division($currentCancelledOrders - $lastYearCancelledOrders, $lastYearCancelledOrders) * 100;
    $data->yoyItemsCount = safe_division($currentItemsCount - $lastYearItemsCount, $lastYearItemsCount) * 100;
    $data->yoyDeliveredQty = safe_division($currentDeliveredQty - $lastYearDeliveredQty, $lastYearDeliveredQty) * 100;
    $data->yoyCustomersCount = safe_division($currentCustomersCount - $lastYearCustomersCount, $lastYearCustomersCount) * 100;
    $data->yoyAverageOrderItems = safe_division($data->averageOrderItems - $data->lastYearAverageOrderItems, $data->lastYearAverageOrderItems) * 100;
    $data->yoyAverageOrderAmount = safe_division($data->averageOrderAmount - $data->lastYearAverageOrderAmount, $data->lastYearAverageOrderAmount) * 100;
    $data->yoyOrderFrequency = safe_division($data->currentOrderFrequency - $data->lastYearOrderFrequency, $data->lastYearOrderFrequency) * 100;


    $db->close();

    $formattedStartDate = date('d/m/y', strtotime($startDate));
    $formattedEndDate = date('d/m/y', strtotime($endDate));
    $title = "Report for dates $formattedStartDate - $formattedEndDate";
    $tdStyle = '';


    if ($timePeriod == 'daily') {
        $columnTitle1 = date('d M Y', strtotime($startDate));
        $columnTitle2 = "Day-over-Day % Change";
        $title ="Report for  $columnTitle1";

    } elseif ($timePeriod == 'weekly') {
        $columnTitle1 ="Week, ". date('d M Y', strtotime($startDate));
        $columnTitle2 = "Week-over-Week % Change";
        $title = "Report for Week: $formattedStartDate - $formattedEndDate";

    } elseif ($timePeriod == 'monthly') {
        $columnTitle1 = date('M Y', strtotime($startDate));
        $columnTitle2 = "Month-over-Month % Change";
        $title = "Report for Month $columnTitle1";

    }
    elseif ($timePeriod == 'yearly') {
        $columnTitle1 = date('Y', strtotime($startDate));
        $columnTitle2 = "Year-over-Year % Change";
        $title = "Report for Year $columnTitle1";
        $tdStyle = 'display:none;';

    }
    else{
        $columnTitle1 = $formattedStartDate ." - ". $formattedEndDate;
        $columnTitle2 = "Period-over-Period % Change";
        $tdStyle = 'display:none;';
    }




    $report .= "<b>$title </b><br><br>";

    $report .= "<table class='table table-bordered' style='border-collapse: collapse; width: 100%;'>";
    $report .= "
        <tr style='border-top: 1px solid #a7c6f9; border-bottom: 1px solid #a7c6f9; padding:0; background:#cadbf7;'>
            <td style='border: 1px solid lightgray;'></td>
            <td style='text-align: center;border: 1px solid lightgray !important;'><b>$columnTitle1</b></td>
            <td style='text-align: center;border: 1px solid lightgray !important;$tdStyle'><b>$columnTitle2</b></td>
            <td style='text-align: center;border: 1px solid lightgray !important;'><b>Year-over-Year % Change</b></td>
        </tr>
  ";


    $report .= "<tr>
            <td style='text-align: left !important;border: 1px solid lightgray;'>No Of Items</td>
            <td align='center' style='border: 1px solid lightgray;'>$data->currentItemsCount</td>
            <td align='center' style='border: 1px solid lightgray;$tdStyle' class='".getClass($data->popItemsCount )."'>".formatPercentage($data->popItemsCount)."</td>
            <td align='center' style='border: 1px solid lightgray;' class='".getClass($data->yoyItemsCount )."'>".formatPercentage($data->yoyItemsCount)."</td>
        </tr>";

    $report .= "<tr >
            <td style='text-align: left !important;border: 1px solid lightgray;'>No Of Orders</td>
            <td align='center' style='border: 1px solid lightgray;' >$data->currentOrdersCount</td>
            <td align='center' style='border: 1px solid lightgray;$tdStyle'  class='".getClass($data->popOrdersCount )."'>".formatPercentage($data->popOrdersCount)."</td>
            <td align='center' style='border: 1px solid lightgray;'  class='".getClass($data->yoyOrdersCount )."'>".formatPercentage($data->yoyOrdersCount)."</td>
        </tr>";

    $report .= "<tr>
            <td style='text-align: left !important;border: 1px solid lightgray;'>No Of Customers</td>
            <td align='center' style='border: 1px solid lightgray;' >$data->currentCustomersCount</td>
            <td align='center' style='border: 1px solid lightgray;$tdStyle'  class='".getClass($data->popCustomersCount )."'>".formatPercentage($data->popCustomersCount)."</td>
            <td  align='center' style='border: 1px solid lightgray;'  class='".getClass($data->yoyCustomersCount )."'>".formatPercentage($data->yoyCustomersCount)."</td>
        </tr>";

    $report .= "<tr>
            <td style='text-align: left !important;border: 1px solid lightgray;'>Average Order Items</td>
            <td align='center' style='border: 1px solid lightgray;' >".formatNumber($data->averageOrderItems )."</td>
            <td align='center' style='border: 1px solid lightgray;$tdStyle'  class='".getClass($data->popAverageOrderItems )."'>".formatPercentage($data->popAverageOrderItems)."</td>
            <td align='center' style='border: 1px solid lightgray;'  class='".getClass($data->yoyAverageOrderItems )."'>".formatPercentage($data->yoyAverageOrderItems)."</td>
        </tr>";

    $report .= "<tr>
            <td style='text-align: left !important;border: 1px solid lightgray;'>Average Order Amount</td>
            <td align='center' style='border: 1px solid lightgray;' >€".formatNumber($data->averageOrderAmount)."</td>
            <td align='center' style='border: 1px solid lightgray;$tdStyle'  class='".getClass($data->popAverageOrderAmount )."'>".formatPercentage($data->popAverageOrderAmount)."</td>
            <td  align='center' style='border: 1px solid lightgray;' class='".getClass($data->yoyAverageOrderAmount )."'>".formatPercentage($data->yoyAverageOrderAmount)."</td>
        </tr>";

    $report .= "<tr>
            <td style='text-align: left !important;border: 1px solid lightgray;'>Total Net Sales</td>
            <td align='center' style='border: 1px solid lightgray;' >€".formatNumber($data->currentAmmount)."</td>
            <td align='center' style='border: 1px solid lightgray;$tdStyle'  class='".getClass($data->popAmmount )."'>".formatPercentage($data->popAmmount)."</td>
            <td align='center' style='border: 1px solid lightgray;'  class='".getClass($data->yoyAmmount )."'>".formatPercentage($data->yoyAmmount)."</td>
        </tr>";

    $report .= "<tr>
            <td style='text-align: left !important;border: 1px solid lightgray;'>Delivery Quantity</td>
            <td align='center' style='border: 1px solid lightgray;' >$data->currentDeliveredQty</td>
            <td align='center' style='border: 1px solid lightgray;$tdStyle'  class='".getClass($data->popDeliveredQty )."'>".formatPercentage($data->popDeliveredQty)."</td>
            <td align='center' style='border: 1px solid lightgray;'  class='".getClass($data->yoyDeliveredQty )."'>".formatPercentage($data->yoyDeliveredQty)."</td>
        </tr>";

    $report .= "<tr>
            <td style='text-align: left !important;border: 1px solid lightgray;'>Delivery Net Revenue</td>
            <td align='center' style='border: 1px solid lightgray;' >€".formatNumber($data->currentDeliveredRevenue)."</td>
            <td align='center' style='border: 1px solid lightgray;$tdStyle'  class='".getClass($data->popDeliveredRevenue )."'>".formatPercentage($data->popDeliveredRevenue)."</td>
            <td align='center' style='border: 1px solid lightgray;'  class='".getClass($data->yoyDeliveredRevenue )."'>".formatPercentage($data->yoyDeliveredRevenue)."</td>
        </tr>";

    $report .= "<tr>
            <td style='text-align: left !important;border: 1px solid lightgray;'>Order Frequency (No of Orders / No of Customers)</td>
            <td align='center' style='border: 1px solid lightgray;' >".formatNumber($data->currentOrderFrequency)."</td>
            <td align='center' style='border: 1px solid lightgray;$tdStyle'  class='".getClass($data->popOrderFrequency )."'>".formatPercentage($data->popOrderFrequency)."</td>
            <td align='center' style='border: 1px solid lightgray;'  class='".getClass($data->yoyOrderFrequency )."'>".formatPercentage($data->yoyOrderFrequency)."</td>
        </tr>";

    $report .= "<tr>
            <td style='text-align: left !important;border: 1px solid lightgray;'>Cancelled Orders </td>
            <td align='center' style='border: 1px solid lightgray;' >".formatNumber($data->currentCancelledOrders)."%</td>
            <td align='center' style='border: 1px solid lightgray;$tdStyle'  class='".getClass($data->popCancelledOrders )."'>".formatPercentage($data->popCancelledOrders)."</td>
            <td align='center' style='border: 1px solid lightgray;'  class='".getClass($data->yoyCancelledOrders )."'>".formatPercentage($data->yoyCancelledOrders)."</td>
        </tr>";

    $report .= "</table>";



} else {
    $report .= "<center><b>Please Select Filters</b></center>";
}

echo $report;
return $report;

function getClass($value){
    if($value>0){
        return "positive";
    }
    else if($value<0){
        return "negative";
    }
    else{
        return "";
    }
}

function formatPercentage($value) {
    $formatedValue = formatNumber($value)."%";
    if($value > 0) {
        return "+".$formatedValue;
    }else{
      return  $formatedValue;
    }
}

function formatNumber($value) {
    if (floor($value) == $value) { //if no decimals exist
        return number_format($value);
    } else {
        return number_format($value, 2);
    }
}

function safe_division($numerator, $denominator) {
    if ($denominator != 0) {
        return floatval($numerator / $denominator);
    } else {
        return 0;
    }
}
?>

