<?php
include_once("../../../../param.php");
include_once (ROOT . "concc/dbhelpers/functions/subunitsFunctions.php");
include_once (ROOT . "concc/dbhelpers/functions/statementFunctions.php");
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ERROR);


$report = '';
$customers    = $_POST['customerSearch'];
$dateFrom     = trim($_POST['dateFrom']);
$dateTo       = trim($_POST['dateTo']);

if(strcmp($dateTo,'')==0){$dateTo = date('Y-m-d');}
if(strcmp($dateFrom,'')==0){$dateFrom = date('Y-m-d');}

if(strcmp($customers,'')!=0){$where = " AND Customers.customer_id IN ($customers) ";}

$displayDateTo = date_format( date_create_from_format('Y-m-d', $dateTo), 'd/m/Y');
$displayDateFrom = date_format( date_create_from_format('Y-m-d', $dateFrom), 'd/m/Y');

global $username,$password,$database;
$db = new mysqli('localhost',$username,$password,$database);
if (mysqli_connect_errno()) {
    printf("Connect failed: %s\n", mysqli_connect_error());
    exit();
}
$db->set_charset("utf8");

$invoicesArray = array();
$customersArray = array();
$stm = $db->prepare("SELECT invoice_id,customer_code,customer_company_name FROM Invoices,Customers WHERE Invoices.customer_id=Customers.customer_id AND NOT status = 'Canceled' AND invoice_date >= '$dateFrom' AND invoice_date <= '$dateTo' $where");
$stm->execute();
$stm->bind_result($invoiceID,$customerCode,$customerCompanyName);
while ($stm->fetch()) {
    array_push($customersArray,"$customerCode - $customerCompanyName");
    array_push($invoicesArray,$invoiceID);
}
$stm->close();

if(count($invoicesArray)>0 && strcmp($customers,'')!=0) {

    $invoicesArrayImp = implode(',',$invoicesArray);
    $customersArrayImp = implode('<br>',array_unique($customersArray));
    $report .= "<p><b>Date Range: $displayDateFrom - $displayDateTo<br>$customersArrayImp</b><br></p>
                <table class='table table-bordered' style='border-collapse: collapse; width: 100%;border: 1px solid silver'>
                    <tr style='border-top: 1px solid #a7c6f9;border-bottom: 1px solid #a7c6f9;padding:0;background:#cadbf7;'>
                        <!--<th style='border: 1px solid silver;'><b><center>Image</center></b></th>-->
                        <th style='border: 1px solid silver;padding: 10px;'><b><center>Code</center></b></th>
                        <th style='border: 1px solid silver;padding: 10px;'><b><center>Barcode</center></b></th>
                        <th style='border: 1px solid silver;padding: 10px;'><b><center>Name</center></b></th>
                        <th style='border: 1px solid silver;padding: 10px;'><b><center>Unit Price</center></b></th>
                        <th style='border: 1px solid silver;padding: 10px;'><b><center>Discount</center></b></th>
                        <th style='border: 1px solid silver;padding: 10px;'><b><center>Quantity</center></b></th>
                        <th style='border: 1px solid silver;padding: 10px;'><b><center>VAT</center></b></th>
                        <th style='border: 1px solid silver;padding: 10px;'><b><center>Date</center></b></th>
                    </tr>        
                    <tbody >";


        $items = array();
        $stm = $db->prepare("SELECT Items.item_id,item_code,name,Invoice_Item.description,qty,subunits,unit_price,line_discount,Invoice_Item.vat_id,thumbnail_url,invoice_date FROM Invoice_Item,Invoices,Items WHERE Invoice_Item.item_id=Items.item_id AND Invoice_Item.invoice_id=Invoices.invoice_id AND Invoice_Item.invoice_id IN($invoicesArrayImp) ORDER BY Invoice_Item.item_id ASC,Invoices.invoice_date ASC");
        $stm->execute();
        $stm->bind_result($itemID,$itemCode,$itemName,$lineNotes,$qty,$subunits,$unitPrice,$discount,$vatID,$imgName,$date);
        while ($stm->fetch()) {
            $item = new stdClass();
            $item->id = $itemID;
            $item->code = $itemCode;
            $item->name = $itemName;
            $item->notes = $lineNotes;
            $item->qty = $qty/$subunits;
            $item->price = $unitPrice;
            $item->discount = $discount;
            $item->vat = $vatID;
            $item->img = $imgName;
            $item->date = $date;

            $items["$itemID"] = $item;
        }
        $stm->close();

        usort($items, 'dateCompare');

        foreach($items as $item){

            $itemID=$item->id;
            $itemCode=$item->code;
            $itemName=$item->name;
            $lineNotes=$item->notes;
            $qty=$item->qty;
            $unitPrice=$item->price;
            $discount=$item->discount;
            $vatID=$item->vat;
            $imgName=$item->img;
            $date=$item->date;

            $date = date_format( date_create_from_format('Y-m-d', $date), 'd-m-Y');

            $subTotal = $qty*$unitPrice;
            $netTotal = $subTotal - $discount;

            $discountPercent = round((1-($netTotal/$subTotal))*100,2);

            if(file_exists(ROOT . "media/productImages/$imgName.jpg")) {
                $d = "//" . HTML_PATH . "/cop/media/productImages/$imgName.jpg";
            } else {
                $d = "//" . HTML_PATH . "/cop/backend/themes/" . THEME_NAME . "/img/itemdefaulticon.jpg";
            }

            $vatPercent = getVatPercentage($vatID);
            $barcode = getItemBarcode($itemID);
            $formattedUnitPrice = number_format($unitPrice, 2, '.', ',');
            $formattedDiscount = number_format($discount, 2, '.', ',');
            $formattedSubTotal = number_format($subTotal, 2, '.', ',');

            if(strcmp($formattedDiscount,'0.00')==0){$formattedDiscount = '-';} else { $formattedDiscount = " $discountPercent%";}
            $itemImage = "<img  src='$d' style='padding:0;margin:0;height: 80px;width: auto'/>";

            $report .= "<tr>
                            <!--<td style='border: 1px solid silver;padding: 10px;'><center>$date</td>-->
                            <td style='border: 1px solid silver;padding: 10px;'><center>$itemCode</td>
                            <td style='border: 1px solid silver;padding: 10px;'><center>$barcode</td>
                            <td style='border: 1px solid silver;padding: 10px;'>$itemName $lineNotes</td>
                            <td style='border: 1px solid silver;padding: 10px;'><center>$formattedUnitPrice</td>
                            <td style='border: 1px solid silver;padding: 10px;'><center>$formattedDiscount</td>
                            <td style='border: 1px solid silver;padding: 10px;'><center>$qty</td>
                            <td style='border: 1px solid silver;padding: 10px;'><center>$vatPercent%</td>
                            <td style='border: 1px solid silver;padding: 10px;'><center>$date</td>
                         </tr>";
        }


    $report .= "</table>";
} else {
    if(strcmp($customers,'')==0){
        $report = "<center><h2><b>Please Select Customer(s)</b></h2></center>";

    } else {
        $report = "<center><h2>No Data Found..</h2></center>";

    }
}



echo $report;
return $report;


function dateCompare($object1, $object2) {
    return $object2->date > $object1->date;
}


function getItemBarcode($itemID) {
    global $username, $password, $database;

    $db1 = new mysqli(localhost,$username,$password,$database);
    if (mysqli_connect_errno()) {
        printf("Connect failed: %s\n", mysqli_connect_error());
        exit();
    }
    $db1->set_charset("utf8");

    $stm1 = $db1->prepare("SELECT barcode FROM Item_Barcode WHERE item_id='$itemID' ORDER BY default_barcode DESC ,timestamp DESC LIMIT 1");
    $stm1-> execute();
    $stm1-> bind_result($code);
    while ($stm1->fetch()) {
        return $code;
    }
    $stm1->close();
    return $code;


}
?>

