<?php
include_once("../../../../param.php");
include_once (ROOT . "concc/dbhelpers/functions/subunitsFunctions.php");
include_once (ROOT . "concc/dbhelpers/functions/statementFunctions.php");
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ERROR);


$report = '';
$customers    = $_POST['customerSearch'];
$dateFrom     = trim($_POST['dateFrom']);
$dateTo       = trim($_POST['dateTo']);

if(strcmp($dateTo,'')==0){$dateTo = date('Y-m-d');}
if(strcmp($dateFrom,'')==0){$dateFrom = date('Y-m-d');}

if(strcmp($customers,'')!=0){$where = " AND Customers.customer_id IN ($customers) ";}

$displayDateTo = date_format( date_create_from_format('Y-m-d', $dateTo), 'd/m/Y');
$displayDateFrom = date_format( date_create_from_format('Y-m-d', $dateFrom), 'd/m/Y');

global $username,$password,$database;
$db = new mysqli('localhost',$username,$password,$database);
if (mysqli_connect_errno()) {
    printf("Connect failed: %s\n", mysqli_connect_error());
    exit();
}
$db->set_charset("utf8");

$ordersArray = array();
$customersArray = array();
$stm = $db->prepare("SELECT order_id,customer_code,customer_company_name FROM Orders,Customers WHERE Orders.customer_id=Customers.customer_id AND NOT status = 'Canceled' AND order_date >= '$dateFrom' AND order_date <= '$dateTo' $where");
$stm->execute();
$stm->bind_result($orderID,$customerCode,$customerCompanyName);
while ($stm->fetch()) {
    array_push($customersArray,"$customerCode - $customerCompanyName");
    array_push($ordersArray,$orderID);
}
$stm->close();

if(count($ordersArray)>0 && strcmp($customers,'')!=0) {

    $ordersArrayImp = implode(',',$ordersArray);
    $customersArrayImp = implode('<br>',array_unique($customersArray));
    $report .= "<p><b>Date Range: $displayDateFrom - $displayDateTo<br>$customersArrayImp</b><br></p>
                <table class='table table-bordered' style='border-collapse: collapse; width: 100%;border: 1px solid silver'>
                    <tr style='border-top: 1px solid #a7c6f9;border-bottom: 1px solid #a7c6f9;padding:0;background:#cadbf7;'>
                        <th style='border: 1px solid silver;'><b><center>Image</center></b></th>
                        <th style='border: 1px solid silver;padding: 10px;'><b><center>Code</center></b></th>
                        <th style='border: 1px solid silver;padding: 10px;'><b><center>Barcode</center></b></th>
                        <th style='border: 1px solid silver;padding: 10px;'><b><center>Name</center></b></th>
                        <th style='border: 1px solid silver;padding: 10px;'><b><center>Price</center></b></th>
                        <th style='border: 1px solid silver;padding: 10px;'><b><center>VAT</center></b></th>
                        <th style='border: 1px solid silver;padding: 10px;'><b><center>Quantity</center></b></th>
                    </tr>        
                    <tbody >";



        $stm = $db->prepare("SELECT Items.item_id,item_code,name,Order_Item.description,SUM(qty),unit_price,Order_Item.vat_id,thumbnail_url FROM Order_Item,Items WHERE Order_Item.item_id=Items.item_id AND Order_Item.order_id IN($ordersArrayImp) GROUP BY Items.item_id,Order_Item.description,unit_price ORDER BY Items.item_id,SUM(qty) DESC");
        $stm->execute();
        $stm->bind_result($itemID,$itemCode,$itemName,$lineNotes,$qty,$unitPrice,$vatID,$imgName);
        while ($stm->fetch()) {

            if(file_exists(ROOT . "media/productImages/$imgName.jpg")) {
                $d = "//" . HTML_PATH . "/cop/media/productImages/$imgName.jpg";
            } else {
                $d = "//" . HTML_PATH . "/cop/backend/themes/" . THEME_NAME . "/img/itemdefaulticon.jpg";
            }

            $vatPercent = getVatPercentage($vatID);
            $barcode = getItemBarcode($itemID);
            $formattedUnitPrice = number_format($unitPrice, 2, '.', ',');
            $itemImage = "<img  src='$d' style='padding:0;margin:0;height: 80px;width: auto'/>";

            $report .= "<tr>
                            <td style='border: 1px solid silver;padding: 10px;'><center>$itemImage</td>
                            <td style='border: 1px solid silver;padding: 10px;'><center>$itemCode</td>
                            <td style='border: 1px solid silver;padding: 10px;'><center>$barcode</td>
                            <td style='border: 1px solid silver;padding: 10px;'>$itemName $lineNotes</td>
                            <td style='border: 1px solid silver;padding: 10px;'><center>$formattedUnitPrice</td>
                            <td style='border: 1px solid silver;padding: 10px;'><center>$vatPercent%</td>
                            <td style='border: 1px solid silver;padding: 10px;'><center>$qty</td>
                         </tr>";
        }
        $stm->close();


    $report .= "</table>";
} else {
    if(strcmp($customers,'')==0){
        $report = "<center><h2><b>Please Select Customer(s)</b></h2></center>";

    } else {
        $report = "<center><h2>No Data Found..</h2></center>";

    }
}



echo $report;
return $report;


function getItemBarcode($itemID) {
    global $username, $password, $database;

    $db1 = new mysqli(localhost,$username,$password,$database);
    if (mysqli_connect_errno()) {
        printf("Connect failed: %s\n", mysqli_connect_error());
        exit();
    }
    $db1->set_charset("utf8");

    $stm1 = $db1->prepare("SELECT barcode FROM Item_Barcode WHERE item_id='$itemID' ORDER BY default_barcode DESC ,timestamp DESC LIMIT 1");
    $stm1-> execute();
    $stm1-> bind_result($code);
    while ($stm1->fetch()) {
        return $code;
    }
    $stm1->close();
    return $code;


}
?>

