<?php
include_once("../../../../param.php");

ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ERROR);

$where   = "";

$dateFrom     = trim($_POST['dateFrom']);
$dateTo       = trim($_POST['dateTo']);
$dateFilterType  = trim($_POST['dateFilterType']);
$analyticOrSummary = trim($_POST['analyticOrSummary']);
$customerSearch  = $_POST['customerSearch'];
$itemSearch  = $_POST['itemSearch'];
$salespersonSearch  = $_POST['salespersonSearch'];
$statusSelection  = $_POST['statusSelection'];



if(strcmp($analyticOrSummary,'all')==0){
    $showAnalytic = true;
    $showSummary = true;
} else if(strcmp($analyticOrSummary,'summary')==0){
    $showAnalytic = false;
    $showSummary = true;
} else if(strcmp($analyticOrSummary,'analytic')==0){
    $showAnalytic = true;
    $showSummary = false;
}

if(strcmp($salespersonSearch,'')!=0) {
    $formSalesperson = explode(',', $salespersonSearch)[0];
}


if(strcmp($dateFrom,'')==0){
    $dateFrom = date('Y-m-d');
}

if(strcmp($dateTo,'')==0){
    $dateTo = date('Y-m-d');
}


if(strcmp($dateFilterType,'dueDate')==0){
    $where .= " AND Invoices.due_date BETWEEN '$dateFrom' AND '$dateTo'";
} else {
    $where .= " AND Invoices.invoice_date BETWEEN '$dateFrom' AND '$dateTo'";
}


if(strcmp($customerSearch,'')!=0){$where .= " AND Invoices.customer_id IN ($customerSearch)";}
if(strcmp($itemSearch,'')!=0){$where .= " AND Invoice_Item.item_id IN ($itemSearch)";}
if(strcmp($salespersonSearch,'')!=0){$where .= " AND Invoices.salesperson_id IN ($salespersonSearch)";}
if(strcmp($statusSelection,'')!=0){$where .= " AND Invoices.status = '$statusSelection'";}

global $username,$password,$database;
$db = new mysqli('localhost',$username,$password,$database);
if (mysqli_connect_errno()) {
    printf("Connect failed: %s\n", mysqli_connect_error());
    exit();
}
$db->set_charset("utf8");

$vats = array();
$stm = $db->prepare("SELECT vat_id,vat_code,vat_display_name,percentage FROM Vats ");
$stm->execute();
$stm->bind_result($id,$code,$name,$percent);
while ($stm->fetch()) {
    $vatObject = new stdClass();
    $vatObject->id = $id;
    $vatObject->code = $code;
    $vatObject->name = $name;
    $vatObject->percent = $percent;
    array_push($vats,$vatObject);
}

$vatAmounts = array();
$invoices = array();
$totals = array();
$prevInvoiceID = 0;
$stm = $db->prepare(" SELECT Invoices.invoice_id,customer_id,salesperson_id,invoice_code,invoice_date,Invoices.details,Invoices.status,subtotal,Invoices.vat_amount,discount_amount,grand_total,Invoice_Item.vat_amount,vat_id,unit_price,qty,line_discount,global_discount_percentage
                            FROM Invoices,Invoice_Item
                            WHERE Invoices.invoice_id=Invoice_Item.invoice_id
                            AND NOT Invoices.status = 'Canceled'
                            $where
                            ");
$stm->execute();
$stm->bind_result($invoiceID,$customerID,$salespersonID,$invoiceCode,$invoiceDate,$invoiceNotes,$invoiceStatus,$invoiceSubtotal,$invoiceVAT,$invoiceDiscount,$invoiceTotal,$lineVat,$vatID,$unitPrice,$qty,$lineDiscount,$globalDiscount);
while ($stm->fetch()) {

    $invoices[$invoiceID]['id'] = $invoiceID;
    $invoices[$invoiceID]['customer'] = $customerID;
    $invoices[$invoiceID]['salesperson'] = $salespersonID;
    $invoices[$invoiceID]['code'] = $invoiceCode;
    $invoices[$invoiceID]['date'] = $invoiceDate;
    $invoices[$invoiceID]['notes'] = $invoiceNotes;
    $invoices[$invoiceID]['status'] = $invoiceStatus;
    $invoices[$invoiceID]['subtotal'] = $invoiceSubtotal;
    $invoices[$invoiceID]['vatTotal'] = $invoiceVAT;
    $invoices[$invoiceID]['discount'] = $invoiceDiscount;
    $invoices[$invoiceID]['total'] = $invoiceTotal;
    $invoices[$invoiceID]['vats'][$vatID]['amount'] += $lineVat;
    $invoices[$invoiceID]['vats'][$vatID]['goods'] += ($unitPrice*$qty) - $lineDiscount - $globalDiscount;

    $totals['vats'][$vatID]['amount'] += $lineVat;
    $totals['vats'][$vatID]['goods'] += ($unitPrice*$qty) - $lineDiscount - $globalDiscount;

}
$stm->close();


if(count($invoices) > 0) {

    $reportAnalyticVATs  = "<table class='table table-striped bordered' style='margin-top: 5px !important;'>";
    $reportAnalyticVATs .= "<tr>";
    $reportAnalyticVATs .= "<td style='background-color: #cadbf7 !important;'>Code</td>";
    $reportAnalyticVATs .= "<td style='background-color: #cadbf7 !important;'>Customer</td>";
    $reportAnalyticVATs .= "<td style='background-color: #cadbf7 !important;'>Date</td>";
    $reportAnalyticVATs .= "<td style='background-color: #cadbf7 !important;'>Salesperson</td>";
    $reportAnalyticVATs .= "<td style='background-color: #cadbf7 !important;'>Notes</td>";
    $reportAnalyticVATs .= "<td style='background-color: #cadbf7 !important;'>Status</td>";
    $reportAnalyticVATs .= "<td style='background-color: #cadbf7 !important;'>Net Amount</td>";
    $reportAnalyticVATs .= "<td style='background-color: #cadbf7 !important;'>Discount</td>";
    foreach ($vats as $vat) {
        $reportAnalyticVATs .= "<td style='background-color: #cadbf7 !important;'>VAT $vat->code ($vat->percent%)</td>";
    }
    $reportAnalyticVATs .= "<td style='background-color: #cadbf7 !important;'>VAT Total</td>";
    $reportAnalyticVATs .= "<td style='background-color: #cadbf7 !important;'>Grand Total</td>";
    $reportAnalyticVATs .= "</tr>";


    foreach ($invoices as $invoice) {

        $totals['subtotal'] += $invoice['subtotal'];
        $totals['vatTotal'] += $invoice['vatTotal'];
        $totals['discount'] += $invoice['discount'];
        $totals['total'] += $invoice['total'];

        $stm = $db->prepare("SELECT CONCAT(customer_code,' - ',customer_company_name) FROM Customers WHERE customer_id='" . $invoice['customer'] . "' LIMIT 1");
        $stm->execute();
        $stm->bind_result($customerName);
        while ($stm->fetch()) {
        }
        $stm->close();

        $stm = $db->prepare("SELECT CONCAT(salesperson_code,' - ',first_name,' ',last_name) FROM SalesPersons WHERE salesperson_id='" . $invoice['salesperson'] . "' LIMIT 1");
        $stm->execute();
        $stm->bind_result($salespersonName);
        while ($stm->fetch()) {
        }
        $stm->close();

        $reportAnalyticVATs .= "<tr style='border-bottom: 1px solid silver'>";
        $reportAnalyticVATs .= "<td style='text-align: left !important;'>" . $invoice['code'] . "</td>";
        $reportAnalyticVATs .= "<td style='text-align: left !important;'>" . $customerName . "</td>";
        $reportAnalyticVATs .= "<td style='text-align: center !important;'>" . date_format(date_create_from_format('Y-m-d', $invoice['date']), 'd-m-Y') . "</td>";
        $reportAnalyticVATs .= "<td style='text-align: center !important;'>" . $salespersonName . "</td>";
        $reportAnalyticVATs .= "<td style='text-align: left !important;'>" . $invoice['notes'] . "</td>";
        $reportAnalyticVATs .= "<td style='text-align: left !important;'> " . $invoice['status'] . "</td>";
        $reportAnalyticVATs .= "<td style='text-align: right !important;'>" . number_format($invoice['subtotal'], 2, '.', ',') . "</td>";
        $reportAnalyticVATs .= "<td style='text-align: right !important;'>" . number_format($invoice['discount'], 2, '.', ',') . "</td>";
        foreach ($vats as $vat) {
            $reportAnalyticVATs .= "<td style='text-align: right !important;'>" . number_format($invoice['vats'][$vat->id]['amount'], 2, '.', ',') . "</td>";
        }
        $reportAnalyticVATs .= "<td style='text-align: right !important;'>" . number_format($invoice['vatTotal'], 2, '.', ',') . "</td>";
        $reportAnalyticVATs .= "<td style='text-align: right !important;'>" . number_format($invoice['total'], 2, '.', ',') . "</td>";
        $reportAnalyticVATs .= "</tr>";
    }
    $reportAnalyticVATs .= "<tr>";
    $reportAnalyticVATs .= "<td style='background-color: #cadbf7 !important;font-weight: bold;'></td>";
    $reportAnalyticVATs .= "<td style='background-color: #cadbf7 !important;font-weight: bold;'></td>";
    $reportAnalyticVATs .= "<td style='background-color: #cadbf7 !important;font-weight: bold;'></td>";
    $reportAnalyticVATs .= "<td style='background-color: #cadbf7 !important;font-weight: bold;'></td>";
    $reportAnalyticVATs .= "<td style='background-color: #cadbf7 !important;font-weight: bold;'></td>";
    $reportAnalyticVATs .= "<td style='background-color: #cadbf7 !important;font-weight: bold;'>Totals:</td>";
    $reportAnalyticVATs .= "<td style='background-color: #cadbf7 !important;font-weight: bold;text-align: right !important;'>" . number_format($totals['subtotal'], 2, '.', ',') . "</td>";
    $reportAnalyticVATs .= "<td style='background-color: #cadbf7 !important;font-weight: bold;text-align: right !important;'>" . number_format($totals['discount'], 2, '.', ',') . "</td>";
    foreach ($vats as $vat) {
        $reportAnalyticVATs .= "<td style='background-color: #cadbf7 !important;font-weight: bold;text-align: right !important;'>" . number_format($totals['vats'][$vat->id]['amount'], 2, '.', ',') . "</td>";
    }
    $reportAnalyticVATs .= "<td style='background-color: #cadbf7 !important;font-weight: bold;text-align: right !important;'>" . number_format($totals['vatTotal'], 2, '.', ',') . "</td>";
    $reportAnalyticVATs .= "<td style='background-color: #cadbf7 !important;font-weight: bold;text-align: right !important;'>" . number_format($totals['total'], 2, '.', ',') . "</td>";
    $reportAnalyticVATs .= "</tr>";
    $reportAnalyticVATs .= "</table>";


    $reportTotalVATs  = "<table class='table table-striped bordered' style='margin-top: 5px !important;'>";
    $reportTotalVATs .= "<tr>";
    $reportTotalVATs .= "<td style='background-color: #cadbf7 !important;'>Code</td>";
    $reportTotalVATs .= "<td style='background-color: #cadbf7 !important;'>Name</td>";
    $reportTotalVATs .= "<td style='background-color: #cadbf7 !important;'>Percent (%)</td>";
    $reportTotalVATs .= "<td style='background-color: #cadbf7 !important;'>Goods</td>";
    $reportTotalVATs .= "<td style='background-color: #cadbf7 !important;'>VAT</td>";
    foreach ($vats as $vat) {
        $reportTotalVATs .= "<tr>";
        $reportTotalVATs .= "<td style='text-align: center !important;'>" . $vat->code . "</td>";
        $reportTotalVATs .= "<td style='text-align: center !important;'>" . $vat->name . "</td>";
        $reportTotalVATs .= "<td style='text-align: center !important;'>" . $vat->percent . "</td>";
        $reportTotalVATs .= "<td style='text-align: center !important;'>" . number_format($totals['vats'][$vat->id]['goods'], 2, '.', ',') . "</td>";
        $reportTotalVATs .= "<td style='text-align: center !important;'>" . number_format($totals['vats'][$vat->id]['amount'], 2, '.', ',') . "</td>";
        $reportTotalVATs .= "</tr>";
    }
    $reportTotalVATs .= "</tr>";
    $reportTotalVATs .= "</table>";


    $reportFilters = "<div style='width: 100%;background-color: rgba(192,192,192,0.4);font-weight: bold;padding: 5px;margin-bottom: 5px !important;'>Date Range: " . date_format(date_create_from_format('Y-m-d', $dateFrom), 'd-m-Y') . ' - ' . date_format(date_create_from_format('Y-m-d', $dateTo), 'd-m-Y') . "</div>";

    $report = $reportFilters;
    if($showSummary){
        $report .= $reportTotalVATs;
    }
    if($showAnalytic){
        $report .= $reportAnalyticVATs;
    }

}
if(strcmp($report,'')==0) {
    $report = "<center><b>No Data found </b></center>";
}



$report = "<style>


        body
        {
           font-family: Helvetica Neue, Helvetica, Arial, sans-serif;
           

        }

        p
        {

        }

        #wrapper
        {
            width:180mm;
            margin:0 15mm;
        }

        .page
        {
            height:297mm;
            width:210mm;

            page-break-after:always;
        }
        

        table.bordered
        {
            border-left: 1px solid #ddd;
            border-top: 1px solid #ddd;

            border-spacing:0;
            border-collapse: collapse;

        }
       

        table.bordered td
        {
            border-right: 1px solid #ddd;
            border-bottom: 1px solid #ddd;
            padding: 2mm;
        }

        table.heading
        {

        }

        h1.heading
        {
            font-size:14pt;
            color:#000;
            font-weight:normal;
        }

        h2.heading
        {
            font-size:9pt;
            color:#000;
            font-weight:normal;
        }

        hr
        {
            color:#ccc;
            background:#ccc;
        }

        #invoice_body
        {

        }

        

        #invoice_body , #invoice_total, #tableHeader
        {
            width:100%;
        }
        #invoice_body table , #tableHeader table
        {
            width:100%;
            border-left: 1px solid #ccc;
            border-top: 1px solid #ccc;
        }

        #invoice_total table {
          width:100%;
        }

        #invoice_body table td , #tableHeader table td
        {
            text-align:center;
            font-size: 11px;
            border-right: 1px solid #ccc;
            border-bottom: 1px solid #ccc;
            padding:2mm 0;
        }

        #invoice_body table td.mono  , #invoice_total table td.mono, #tableHeader table td.mono
        {
            font-family: Helvetica Neue, Helvetica, Arial, sans-serif;
            text-align:right;
            padding-right:3mm;
            font-size:10pt;
        }

        #footer
        {
            width:180mm;
            margin:0 15mm;
            padding-bottom:3mm;
        }
        #footer table
        {
            width:100%;
            background:#eee;

        }
        #footer table td
        {
            width:25%;
            text-align:center;
            font-size:9pt;
        }


        @page
        {
        
             margin-left: 1.4cm;
             margin-right: 1.4cm;
        
            header: html_myHTMLHeader1;
            footer: html_myFooter1;
        }

        .customer {
           font-family: 'Helvetica Neue', Helvetica, Arial, sans-serif;
           font-weight: 400;
        }

        #table_info td {
           font-size: 12px;
           padding:0;

        }

    </style>
    <htmlpageheader name='myHTMLHeader1'></htmlpageheader>

".$report;

echo $report;
return $report;

function getSalespersonDetails($salespersonID){
    $z = '';
    global $username,$password,$database;
    $db1 = new mysqli('localhost',$username,$password,$database);
    if (mysqli_connect_errno()) {
        printf("Connect failed: %s\n", mysqli_connect_error());
        exit();
    }

    $db1->set_charset("utf8");
    $stm21 = $db1->prepare(" SELECT CONCAT(first_name,' ',last_name) FROM SalesPersons WHERE salesperson_id='$salespersonID' LIMIT 1");
    $stm21->execute();
    $stm21->bind_result($value);
    while ($stm21->fetch()) {if(strcmp($value,'')!=0 && $salespersonID > 0){$z = $value;}}
    $stm21->close();

    return $z;

}

?>

