<?php
include_once("../../../../param.php");
include_once (ROOT . "concc/dbhelpers/functions/subunitsFunctions.php");
include_once (ROOT . "concc/dbhelpers/functions/statementFunctions.php");
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ERROR);


$report = '';
$suppliers    = $_POST['supplier'];
$dateFrom     = trim($_POST['dateFrom']);
$dateTo       = trim($_POST['dateTo']);
$suppliers = implode(',',array_values($suppliers));
if(strcmp($dateTo,'')==0){$dateTo = date('Y-m-d');}
if(strcmp($dateFrom,'')==0){$dateFrom = date('Y-m-d');}

if(strcmp($suppliers,'')!=0){$where = " AND supplier_id IN ($suppliers) ";}

$displayDateTo = date_format( date_create_from_format('Y-m-d', $dateTo), 'd/m/Y');
$displayDateFrom = date_format( date_create_from_format('Y-m-d', $dateFrom), 'd/m/Y');

global $username,$password,$database;
$db = new mysqli('localhost',$username,$password,$database);
if (mysqli_connect_errno()) {
    printf("Connect failed: %s\n", mysqli_connect_error());
    exit();
}
$db->set_charset("utf8");

$supplierItemID = 0;
$supplierItems= array();
$supplierItemIDs = array();

$stm = $db->prepare("SELECT supplier_id,item_id FROM Item_Supplier WHERE 1=1 $where");
$stm->execute();
$stm->bind_result($supplierID,$supplierItemID);
while ($stm->fetch()) {
    $supplierID = intval($supplierID);
    if(!isset($supplierItems["$supplierID"])){$supplierItems["$supplierID"] = array();}
    array_push($supplierItems["$supplierID"],intval($supplierItemID));
    array_push($supplierItemIDs,intval($supplierItemID));
}
$stm->close();

$ItemIDsFilter = implode(',',array_values($supplierItemIDs));
if(count($supplierItemIDs)==0){$ItemIDsFilter = '0';}
$stockTakingIDs = array();
$stocktakingItemInfo = array();
$stm = $db->prepare("SELECT item_id, GROUP_CONCAT(DISTINCT(stock_taking_code)) FROM Stock_Taking,Stock_Taking_Item WHERE Stock_Taking.stock_taking_id = Stock_Taking_Item.stock_taking_id AND Stock_Taking.date >= ? AND Stock_Taking.date <= ? AND Stock_Taking_Item.item_id IN ($ItemIDsFilter) GROUP BY Stock_Taking_Item.item_id");
$stm->bind_param('ss',$dateFrom,$dateTo);
$stm->execute();
$stm->bind_result($stockTakingItemID,$stockTakingCodes);
while ($stm->fetch()) {
    $stocktakingItemInfo["$stockTakingItemID"]=$stockTakingCodes;
    array_push($stockTakingIDs,intval($stockTakingItemID));
}
$stm->close();

$itemsInfo = array();
$result = '';
foreach ($supplierItems as $supplierID => $supplierItemIDs) {
    $supplierID = intval($supplierID);
    $supplierInfo = getSupplierInfo($supplierID,$db);
    $result .= "<table style='width: 100%;border: 1px solid silver'>";
    $result .= "<tr><td colspan='2' style='background-color: #add8e7'><h3 style='margin: 3px !important;'>$supplierInfo->code - $supplierInfo->name</h3></td></tr>";
    $result .= "<tr>";
    $result .= "<td style='width:20%;padding:5px;background-color: #d9d9d9;border: 1px solid silver' ><b>Item Code</b></td>";
    $result .= "<td style='text-align: left !important;padding:5px;background-color: #d9d9d9;border: 1px solid silver'><b>Item Name</b></td>";
    $result .= "</tr>";


    foreach ($supplierItemIDs as $supplierItemID) {
        $supplierItemID = intval($supplierItemID);
        $itemsInfo = getItemInfo($itemsInfo,$supplierItemID,$db);
        $itemInfo = $itemsInfo["$supplierItemID"];

        if (!in_array($supplierItemID, $stockTakingIDs)) {
            $result .= "<tr style='border-bottom: 1px solid silver'>";
            $result .= "<td style='border-bottom: 1px solid silver;padding:5px;border-right: 1px solid silver;'>$itemInfo->code</td>";
            $result .= "<td style='border-bottom: 1px solid silver;text-align: left !important;padding:5px;'>$itemInfo->name</td>";
            $result .= "</tr>";
        } else {

        }
    }
    $result .= "</table><br>";
}

if(strcmp($result,'')==0){
    $result = "<div style='text-align: center'><h3>No Data Found</h3></div>";
} else {
    $result = "<div style='text-align: center'><h3>Supplier Items not in Stock Taking <br> $displayDateFrom - $displayDateTo</h3></div>" . $result;
}

echo $result;

function getSupplierInfo($supplierID,$db){

    $supplierCode = '';
    $supplierName = '';

    $stm = $db->prepare("SELECT customer_code, customer_company_name FROM Suppliers WHERE customer_id = ? LIMIT 1");
    $stm->bind_param('i',$supplierID);
    $stm->execute();
    $stm->bind_result($supplierCode,$supplierName);
    $stm->fetch();
    $stm->close();

    $supplier = new stdClass();
    $supplier->code = $supplierCode;
    $supplier->name = $supplierName;

    return $supplier;
}


function getItemInfo($items,$itemID,$db){

    $itemCode = '';
    $itemName = '';

    $stm = $db->prepare("SELECT item_code, name FROM Items WHERE item_id = ? LIMIT 1");
    $stm->bind_param('i',$itemID);
    $stm->execute();
    $stm->bind_result($itemCode,$itemName);
    $stm->fetch();
    $stm->close();

    $item = new stdClass();
    $item->code = $itemCode;
    $item->name = $itemName;

    $items["$itemID"] = $item;

    return $items;
}
?>

