<?php
include_once("../../../../param.php");

if (isset($_GET['from_report']) && strcmp($_GET['from_report'],'no')==0){
    $fromReport = false;
}else{
    $fromReport = true;
}

$db = new mysqli('localhost',$username,$password,$database);
if (mysqli_connect_errno()) {
    printf("Connect failed: %s\n", mysqli_connect_error());
    exit();
}
$db->set_charset("utf8");

$salespersonSelection = "<option value='0'>- All Salespersons -</option>";
$stm = $db->prepare("SELECT CONCAT(salesperson_code, ' - ',first_name, ' ', last_name), salesperson_id FROM SalesPersons WHERE salesperson_id > 0 $whereSP");
$stm-> execute();
$stm-> bind_result($salespersonName, $salespersonID);
while ($stm->fetch()) {
    $salespersonSelection .= "<option value='$salespersonID'>$salespersonName</option>";
}
$stm-> close();


$warehousesSelection = "<option value='0'>- All Warehouses -</option>";
$stm = $db->prepare("SELECT CONCAT(warehouse_code, ' - ',name), warehouse_id FROM Warehouses ");
$stm-> execute();
$stm-> bind_result($warehouseInfo, $warehouseID);
while ($stm->fetch()) {
    $warehousesSelection .= "<option value='$warehouseID'>$warehouseInfo</option>";
}
$stm-> close();

?>

<div id="main" role="main" class="background-color-whitish">

    <!-- Start CUSTOM CODE-->


    <!-- RIBBON -->
    <div id="ribbon" class="bg-color-blue">

				<span class="ribbon-button-alignment">
					<span id="refresh" class="btn btn-ribbon2" onclick="location.reload(true);" data-title="refresh" rel="tooltip" data-placement="bottom" data-original-title="<i class='text-warning fa fa-warning'></i> Reload Page?" data-html="true">
						<i class="fa fa-refresh"></i>
					</span>
				</span>

        <!-- breadcrumb -->
        <?php
        if($fromReport){
            echo "
                 <ol class=\"breadcrumb\">
                    <li class=\"txt-color-white\">Home / Reports / Single  Report</li>
                </ol>
            ";
        }else{
            echo "
                 <ol class=\"breadcrumb\">
                    <li class=\"txt-color-white\">Home / Export Schedules</li>
                </ol>
            ";
        }

        ?>

        <!-- end breadcrumb -->

    </div>
    <!-- END RIBBON -->

    <!-- MAIN CONTENT -->
    <div id="content">

        <div class="row">
            <div class="col-xs-12 col-sm-6 col-md-6 col-lg-6">
                <?php
                if($fromReport){
                    echo "
                        <span>  <a onclick=\"backToReports()\" class=\"btn btn-primary\"><i class=\"fa fa-arrow-left\"></i>&nbsp; Back to Reports</a> </span>
                            <h3 style=\"display:inline;margin-left:10px;\" class=\"page-title txt-color-blueDark header-margin\">
                                <i class=\"fa-fw fa fa-signal\"></i>
                                Warehouse Transfer Report
                            </h3>
                     ";
                }else{
                    echo "
                        <h3 style=\"display:inline;margin-left:10px;\" class=\"page-title txt-color-blueDark header-margin\">
                                <i class=\"fa-fw fa fa-signal\"></i>
                                Export Report
                            </h3>
                     ";
                }

                ?>

            </div>
        </div>

        <!-- row -->
        <section id="widget-grid" class="" style="margin-top:10px;">
            <!-- row -->
            <div class="row">

                <!-- NEW WIDGET START -->
                <article class="col-xs-12 col-sm-12 col-md-12 col-lg-12">

                    <div class="jarviswidget jarviswidget-color-blueDark" id="wid-id-0" data-widget-editbutton="false" data-widget-deletebutton="false">
                        <header>
                            <span class="widget-icon"> <i class="fa fa fa-table"></i> </span>
                            <h2>Schedule Report Criteria</h2>
                        </header>
                        <!-- widget div-->
                        <div>
                            <!-- widget content -->
                            <div class="widget-body" style="overflow-x:scroll;" >
                                <div style="display: flex">
                                    <div style="width: 50%">
                                        <label style="display: block"><b>Select Date Range:</b></label>
                                        <input type="date" name="dateFrom" id="dateFrom" class="form-control" style="display: inline-block;width: 25%" value="<?php echo date('Y-m-d')?>" >
                                        <input type="date" name="dateTo" id="dateTo" class="form-control" style="display: inline-block;width: 25%" value="<?php echo date('Y-m-d')?>">
                                        <br>
                                        <div style="display: flex;width: 50%">
                                            <div style="width: 50%">
                                                <label style="display: block; margin-top: 10px"><b>From W/H:</b></label>
                                                <select name="fromWH" id="fromWH" class="form-control" style="display: inline-block;">
                                                    <?php echo $warehousesSelection; ?>
                                                </select>
                                            </div>
                                            <div style="width: 50%">
                                                <label style="display: block; margin-top: 10px"><b>To W/H:</b></label>
                                                <select name="toWH" id="toWH" class="form-control" style="display: inline-block;">
                                                    <?php echo $warehousesSelection; ?>
                                                </select>
                                            </div>
                                        </div>
                                        <label style="display: block; margin-top: 10px"><b>Select Sales Person:</b></label>
                                        <select name="salesPerson" id="salesPerson" class="form-control" style="width: 50%">
                                            <?php echo $salespersonSelection; ?>
                                        </select>
                                        <label style="display: block; margin-top: 10px"><b>Select Transfer Type:</b></label>
                                        <select name="transferType" id="transferType" class="form-control" style="width: 50%">
                                            <option value="all">ALL</option>
                                            <option value="Load">Load</option>
                                            <option value="Load Request">Load Request</option>
                                            <option value="Transfer">Transfer</option>
                                            <option value="Transfer Request">Transfer Request</option>
                                            <option value="Unload">Unload</option>
                                            <option value="Unload Non-Sellable">Unload Non-Sellable</option>
                                            <option value="Unload Request">Unload Request</option>
                                            <option value="Bin Location Transfer">Bin Location Transfer</option>
                                            <option value="Discard">Discard</option>
                                        </select>
                                        <label style="display: block; margin-top: 10px"><b>Show Item:</b></label>
                                        <select name="showItem" id="showItem" class="form-control" style="width: 50%">
                                            <option value="yes">Yes</option>
                                            <option value="no">No</option>
                                        </select>
                                        <label style="display: block; margin-top: 10px"><b>Select Item:</b></label>
                                        <div style="display: flex;">
                                        <input type="text" name="productSearch" id="productSearch" class="form-control" style="width: 40%">
                                        <button type="button" name="clearProduct" id="clearProduct" class="btn btn-primary" style="width: 10%" onclick="$('#productSearch').select2('data', null);">Clear</button>
                                        </div>
                                        </div>
                                    </div>



                                <br><br><br>

                                <button type="button" name="generateReport" id="generateReport" class="btn btn-primary" onclick="getReport()" >Generate Report</button>
                                <button type="button" name="generateExcel"  id="generateExcel"  class="btn btn-waybill" onclick="exportXLS()" >Export to Excel</button>
                            </div>
                            <!-- end widget content -->

                        </div>
                        <!-- end widget div -->

                    </div>
                    <!-- end widget -->
                </article>
                <!-- NEW WIDGET END -->

                <!-- NEW WIDGET START -->
                <article class="col-xs-12 col-sm-12 col-md-12 col-lg-12">

                    <div class="jarviswidget jarviswidget-color-blueDark" id="wid-id-1" data-widget-editbutton="false" data-widget-deletebutton="false">
                        <header>
                            <span class="widget-icon"> <i class="fa fa fa-table"></i> </span>
                            <h2>Schedule Report</h2>
                        </header>
                        <!-- widget div-->
                        <div>
                            <!-- widget content -->
                            <div class="widget-body" style="overflow-x:scroll">

                                <div name="reportResult" id="reportResult"></div>
                                <form method="POST" action="#" name="xlsForm" id="xlsForm" >
                                    <input type="hidden" name="inputResult" id="inputResult" value=""/>
                                    <input type="hidden" name="inputTitle" id="inputTitle" value="WarehouseTransaction"/>
                                </form>

                            </div>
                            <!-- end widget content -->

                        </div>
                        <!-- end widget div -->

                    </div>
                    <!-- end widget -->
                </article>
                <!-- NEW WIDGET END -->

            </div>


    </div>
    <!-- end widget content -->

    <!-- end row -->
    </section>

</div>

<script type="text/javascript">

    $(document).ready(function() {
        pageSetUp();
        $("#productSearch").select2({
            allowClear: true,
            multiple: false,
            minimumInputLength: 2,
            minimumResultsForSearch: 1,
            ajax: {
                url: "//<?php echo HTML_PATH ?>/cop/backend/core/controllers/search/productSearch.php",
                dataType: "json",
                type: "GET",
                data: function (term, page) {
                    return {
                        query: term
                        //page: page,
                        // pageLimit: 25
                    };
                },
                results: function (data) {
                    return {
                        results: $.map(data, function (item) {
                            return {
                                text: item.name,
                                id: item.id
                            }
                        })
                    };
                }
            }
        });
        $('#schedule').select2();
        $('#salesPerson').select2();

    });


    function getReport(){
        var dateFrom        = $('#dateFrom').val();
        var dateTo          = $('#dateTo').val();
        var salesPerson     = $('#salesPerson').val();
        var transferType    = $('#transferType').val();
        var fromWH          = $('#fromWH').val();
        var toWH            = $('#toWH').val();
        var showItem        = $('#showItem').val();
        var productSearch   = $('#productSearch').val();
        console.log(productSearch);
        $('#reportResult').html('<center><b>Generating Report..</b></center>');
        $.ajax({
            type: "POST",
            url: '//<?php echo HTML_PATH ?>/cop/backend/core/views/reports/generateWarehouseTransferReport.php',
            data: {
                'dateFrom':dateFrom,
                'dateTo':dateTo,
                'salesPerson':salesPerson,
                'transferType':transferType,
                'fromWH':fromWH,
                'toWH':toWH,
                'showItem':showItem,
                'itemIDFind':productSearch
            },
            success: function (result) {
                $('#reportResult').html(result);
            }
        });

    }

    function exportXLS(){

        var dateFrom        = $('#dateFrom').val();
        var dateTo          = $('#dateTo').val();
        var salesPerson     = $('#salesPerson').val();
        var transferType    = $('#transferType').val();
        var fromWH          = $('#fromWH').val();
        var toWH            = $('#toWH').val();
        var showItem        = $('#showItem').val();
        var productSearch   = $('#productSearch').val();

        $('#reportResult').html('<center><b>Generating Report..</b></center>');

        $.ajax({
            type: "POST",
            url: '//<?php echo HTML_PATH ?>/cop/backend/core/views/reports/generateWarehouseTransferReport.php',
            data: {
                'dateFrom':dateFrom,
                'dateTo':dateTo,
                'salesPerson':salesPerson,
                'transferType':transferType,
                'fromWH':fromWH,
                'toWH':toWH,
                'showItem':showItem,
                'itemIDFind':productSearch
            },

            success: function (result) {
                $('#reportResult').html(result);
                $('#inputResult').val(result);
                $('#xlsForm').attr('action','//<?php echo HTML_PATH ?>/cop/backend/core/templates/xls/generateGeneralXLS.php').submit();
            }
        });

    }


    function backToReports() {
        try {
            $(".swLinkMenu")[0].click();
        }
        catch(err)
        {

        }
        setTimeout(function() {
            window.location = "//<?php echo HTML_PATH ?>/cop/backend/core/views/reports/reports_list.php";
        }, 1000);


    }

</script>


