<?php
include_once("../../../../param.php");
require_once(ROOT . "backend/core/model/CustomForm.php");


if(isset($_GET['visit_id']))
{

    $visitID=$_GET['visit_id'];
    $_POST['visit_id'] = $visitID;
    $edit = true;
}

if(isset($_POST['visit_id']))
{

    $visitID=$_POST['visit_id'];
    $_SESSION['visit_id'] = $visitID;
    $edit = true;
} else {
    $edit = false;
}

$db = new mysqli(localhost,$username,$password,$database);
if (mysqli_connect_errno()) {
    printf("Connect failed: %s\n", mysqli_connect_error());
    exit();
}

if($edit) {

    $db->set_charset("utf8");
    $stm = $db->prepare("SELECT visit_id, visit_code, customer_id, company_id, salesperson_id, notes, visit_date FROM Visits WHERE visit_id='$visitID'");
    $stm->execute();
    $stm->bind_result($visitID, $visitCode, $customerID, $companyID, $salepersonID, $visitNotes, $visitDate);
    while ($stm->fetch()) {

        $db2 = new mysqli(localhost, $username, $password, $database);
        if (mysqli_connect_errno()) {
            printf("Connect failed: %s\n", mysqli_connect_error());
            exit();
        }
        $db2->set_charset("utf8");


        $stm3 = $db2->prepare("SELECT customer_code,customer_company_name,balance FROM Customers WHERE customer_id='$customerID'");
        $stm3->execute();
        $stm3->bind_result($customerCode, $customerName, $customerBalance);
        while ($stm3->fetch()) {


        }
        $stm3->close();

        $stm4 = $db2->prepare("SELECT customer_address_id,address_code,customer_id,country,city,address_line_1,address_line_2,postcode,region,lat,lng,pobox,landline,fax,primary_address,timestamp FROM CustomerAddress WHERE customer_id ='$customerID' AND primary_address = 'yes'");
        $stm4->execute();
        $stm4->bind_result($customerAddressID, $addressCode, $customerID, $country, $city, $addressLine1, $addressLine2, $postcode, $region, $lat, $lng, $pobox, $landline, $fax, $primaryAddress, $timestamp);
        while ($stm4->fetch()) {

            $address = $addressLine1;
            if(strcmp($addressLine2,'') != 0){$address .=  ", " . $addressLine2;}
            if(strcmp($postcode,'')     != 0){$address .=  ", " . $postcode;}
            if(strcmp($city,'')         != 0){$address .=  ", " . $city;}
            if(strcmp($country,'')      != 0){$address .=  ", " . $country;}

            $address = ltrim($address,",");
            $address = rtrim($address,",");

        }
        $stm4->close();

        $stm5 = $db2->prepare("SELECT CONCAT(salesperson_code ,' - ',first_name,' ',last_name) FROM SalesPersons WHERE salesperson_id ='$salepersonID'");
        $stm5->execute();
        $stm5->bind_result($salesPersonName);
        while ($stm5->fetch()) {

        }
        $stm5->close();

        $banks = "<option value='$bank' selected>$bank</option>";
        $salesPersons = "<option value='$salepersonID' selected>$salesPersonName</option>";

    }
    $stm->close();


    $db2->set_charset("utf8");
    $stm3 = $db2->prepare("SELECT lat,lng FROM Schedule_Object_Actions WHERE action_id='$visitCode' AND action_type='Visit' LIMIT 1");
    $stm3-> execute();
    $stm3-> bind_result($scheduleLat,$scheduleLng);
    while ($stm3->fetch()) {
        if($scheduleLat > 0 && $scheduleLng > 0){
            $map = '<section>
                        <label class="label-bold form-label-space" >Tablet Location: </label>
                        <div class="google_maps " style="height:180px;display: inline-block" id="map_coprime" ></div>
                    </section>
                    <script src="https://maps.googleapis.com/maps/api/js?key=AIzaSyAonEryABOdRQBcgEfH51-nOoXTca3XlWs"></script>
                    <script type="text/javascript">
                        $(document).ready(function() {
                             copMap = new google.maps.Map(document.getElementById(\'map_coprime\'), {
                                center: {lat: '.$scheduleLat.', lng: '.$scheduleLng.'},
                               mapTypeControl: false,
                               draggable: true,
                               scaleControl: true,
                               scrollwheel: true,
                               navigationControl: false,
                               streetViewControl: false,
                                zoom: 17
                             });
                             marker = new google.maps.Marker({
                                position: new google.maps.LatLng('.$scheduleLat.','.$scheduleLng.'),
                                map: copMap,
                                url: "https://www.google.com/maps/search/?api=1&query='.$scheduleLat.','.$scheduleLng.'"
                            });
                            google.maps.event.addListener(marker, \'click\', function() {window.open( marker.url,\'_blank\');});
                         });
                    </script>';
        }
    }
    $stm3-> close();

}


$stm = $db->prepare("SELECT company_id FROM Companies LIMIT 1");
$stm->execute();
$stm->bind_result($companyID);
while ($stm->fetch()) {}
$stm->close();



function redirect($url)
{
    if (headers_sent())
    {
        die('<script type="text/javascript">window.location.href="' . $url . '";</script>');
    }
    else
    {
        header('Location: ' . $url);
        die();
    }
}

$visitDate = date_format( date_create_from_format('Y-m-d H:i:s', $visitDate), 'd-m-Y - H:i');

$custForm= new CustomForm('Visit',$visitID);

?>

<div id="main" role="main">

    <!-- Start CUSTOM CODE-->


    <!-- RIBBON -->
    <div id="ribbon" class="bg-color-blue">

				<span class="ribbon-button-alignment">
					<span id="refresh" class="btn btn-ribbon2" onclick="location.reload(true);" data-title="refresh" rel="tooltip" data-placement="bottom" data-original-title="<i class='text-warning fa fa-warning'></i> Reload Page?" data-html="true">
						<i class="fa fa-refresh"></i>
					</span>
				</span>

        <!-- breadcrumb -->
        <ol class="breadcrumb">
            <li class="txt-color-white">Home /
                <?php
                if($edit){
                    echo ' Edit Visit';
                } else {
                    echo ' Add Visit';
                }
                ?>
            </li>
        </ol>
        <!-- end breadcrumb -->


    </div>
    <!-- END RIBBON -->

    <!-- MAIN CONTENT -->
    <div id="content">

        <div class="row">
            <div class="col-xs-12 col-sm-8 col-md-9 col-lg-10">
                <h3 class="page-title txt-color-blueDark header-margin">
                    <img class="custom-rounded-image yearly" style="display:inline;" src="//<?php echo HTML_PATH ?>/cop/backend/themes/<?php echo THEME_NAME ?>/img/visiticon.png" width="30" height="30">
                    <?php
                    if($edit){
                        echo ' View Visit';
                    } else {
                        echo ' Add Visit';
                    }
                    ?>
                </h3>
            </div>

        </div>

        <!-- row -->
        <section id="widget-grid" class="">
            <!-- row -->
            <div class="row">
                <!-- NEW WIDGET START -->
                <article class="col-xs-10 col-sm-10 col-md-10 col-lg-12">

                    <div class="jarviswidget jarviswidget-color-blueDark" id="wid-id-0" data-widget-editbutton="false" data-widget-deletebutton="false">

                        <header>
                            <span class="widget-icon"> <i class="fa fa-table"></i> </span>
                            <h2>Visit Details</h2>
                        </header>

                        <!-- widget div-->
                        <div>
                            <!-- widget content -->
                            <div class="widget-body">

                                <form action="" id="checkout-form" class="smart-form">
                                    <fieldset>

                                        <div class="row">
                                            <section class="col col-4">
                                                <section>
                                                    <img class="custom-rounded-image yearly" style="display:inline;" src="//<?php echo HTML_PATH ?>/cop/backend/themes/<?php echo THEME_NAME ?>/img/visiticon.png" width="30" height="30">
                                                    <h1 style="display: inline;margin-left:6px;vertical-align: middle">Visit Details</h1>
                                                    <?php

                                                    if(isset($visitCode) && strcmp($visitCode,'')!=0){
                                                        require_once(ROOT . "backend/core/model/CopNavigation.php");

                                                        $where='';
                                                        if(isset($_SESSION['Allow_Customers']) && strcmp($_SESSION['Allow_Customers'],'')!=0){
                                                            $where .= "customer_id IN (".$_SESSION['Allow_Customers'].")";
                                                        }

                                                        $navigation = new CopNavigation("Visits","view_visit","$visitCode","$where");
                                                        $navigation->simpleNavigationTable();
                                                    }


                                                    ?>
                                                </section>
                                                <section >
                                                    <label class="label-bold form-label-space" >Visit Code: </label>
                                                    <label class="label-text"><?php if($edit) {echo $visitCode;}?></label>
                                                </section>
                                                <section >
                                                    <label class="label-bold form-label-space" >Visit Date/Time:</label>
                                                    <label class="label-text"><?php if($edit) {echo $visitDate;} else {echo date('Y-m-d\TH:i:s');}?></label>
                                                </section>
                                                <section >
                                                    <label class="label-bold form-label-space" >Sales Person: </label>
                                                    <label class="label-text">
                                                        <?php echo $salesPersons ?>
                                                    </label>
                                                </section>
                                                <section >
                                                    <label class="label-bold form-label-space"> Notes:</label>
                                                    <label class="label-text"><?php if($edit) {echo str_replace("null","",$visitNotes);}?></label>
                                                </section>
                                                <?php if(isset($map)){echo $map;}?>


                                            </section>
                                            <section class="col col-4" style="padding-left:20px;border-left:1px dotted #ADD8E6;border-right:1px dotted #ADD8E6;">
                                                <section>
                                                    <img style="display:inline;" src="//<?php echo HTML_PATH ?>/cop/backend/themes/<?php echo THEME_NAME ?>/img/customerdefault.jpg" width="40" height="40">
                                                    <h1 style="display: inline;margin-left:6px;vertical-align: middle"> Customer Details</h1>
                                                </section>
                                                <section style="display: none;">
                                                    <label class="label-bold form-label-space" >Find Customer:  </label>
                                                    <input style='display:inline;' class='text-center form-control' id='customerSearch' name='customerSearch' type='text' value='<?php if($edit) { echo "$customerCode - $customerName";}?>'  <?php echo $disabled?>>
                                                    <input type="hidden" id="customerID" value="<?php if($edit) {echo $customerID;}?>" />
                                                </section>
                                                <section >
                                                    <label class="label-bold form-label-space" >Customer Code: </label>
                                                    <label class="label-text"><?php if($edit) {echo $customerCode;}?> </label>
                                                </section>

                                                <section >
                                                    <label class="label-bold form-label-space"> Customer Name: </label>
                                                    <label class="label-text" id="customerName"> <?php if($edit) {echo $customerName;}?> </label>
                                                </section>
                                                <section >
                                                    <label class="label-bold form-label-space"> Customer Balance: </label>
                                                    <label class="label-text" id="customerBalance"> <?php if($edit) {echo number_format($customerBalance,2);}?> </label>
                                                </section>
                                                <section >
                                                    <label class="label-bold" style="margin-right: 20px;">Primary Address: </label>
                                                    <label class="label-text" id="primaryAddress"><?php if($edit) {echo $address;}?></label>
                                                    </select>
                                                </section>
                                            </section>
                                            <section class="col col-4" style="padding-left:20px;border-left:1px dotted #ADD8E6;border-right:1px dotted #ADD8E6;">
                                                <?php
                                                $custForm->viewCustomFormValues();

                                                ?>
                                            </section>
                                        </div>

                                    </fieldset>
                                </form>

                            </div>
                            <!-- end widget content -->


                        </div>
                        <!-- end widget div -->

                        <?php
                            if($visitID > 0){
                                require_once(ROOT . "backend/core/model/ActionReplies.php");
                                $actionReplies = new ActionReplies('Visit',$visitID);
                                echo $actionReplies->toggleButton();
                                echo $actionReplies->repliesForm();
                            }
                        ?>

                    </div>
                    <!-- end widget -->

                </article>
            </div>

            <!-- end row -->


        </section>

    </div>
</div>

<script src="//<?php echo HTML_PATH ?>/cop/backend/themes/<?php echo THEME_NAME ?>/js/jquery.tabletojson.js"></script>
<script src="//<?php echo HTML_PATH ?>/cop/backend/themes/<?php echo THEME_NAME ?>/js/plugin/select2/select2.min.js"></script>
<script src="//<?php echo HTML_PATH ?>/cop/backend/themes/<?php echo THEME_NAME ?>/js/plugin/datatables/jquery.dataTables.min.js"></script>
<script src="//<?php echo HTML_PATH ?>/cop/backend/themes/<?php echo THEME_NAME ?>/js/plugin/datatables/dataTables.colVis.min.js"></script>
<script src="//<?php echo HTML_PATH ?>/cop/backend/themes/<?php echo THEME_NAME ?>/js/plugin/datatables/dataTables.tableTools.min.js"></script>
<script src="//<?php echo HTML_PATH ?>/cop/backend/themes/<?php echo THEME_NAME ?>/js/plugin/datatables/dataTables.bootstrap.min.js"></script>
<script src="//<?php echo HTML_PATH ?>/cop/backend/themes/<?php echo THEME_NAME ?>/js/plugin/datatable-responsive/datatables.responsive.min.js"></script>

<script type="text/javascript">



    function initCustomerCodeAutocomplete()
    {
        $("#customerSearch").autocomplete({
            source: "//<?php echo HTML_PATH ?>/cop/backend/core/controllers/autocomplete/customer_autocomplete.php",
            autoFocus: true,
            select: function (event, ui) {

                var bal = parseFloat(ui.item.balance).toFixed( 2 );

                $('#customerID').val(ui.item.id);
                $('#datatable_fixed_column').DataTable().ajax.reload();
                $('#customerCode').text(ui.item.customer_code);
                $('#customerName').text(ui.item.customer_company_name);
                $('#customerBalance').text(bal);

                var optionsAsString = "";
                for(var i = 0; i < ui.item.addresses.length; i++) {
                    if(i==0)
                    {
                        optionsAsString =  ui.item.addresses[i].addressLine1;
                        if(ui.item.addresses[i].addressLine2){ optionsAsString += ", " + ui.item.addresses[i].addressLine2;}
                        if(ui.item.addresses[i].postalCode){   optionsAsString += ", " + ui.item.addresses[i].postalCode;}
                        if(ui.item.addresses[i].city){         optionsAsString += ", " + ui.item.addresses[i].city;}
                        if(ui.item.addresses[i].country){      optionsAsString += ", " + ui.item.addresses[i].country;}

                    }

                }
                $('#primaryAddress').text(optionsAsString);
                return true;
            }

        });
    }

    function viewPDF(url)
    {
        if(urlExists(url))
        {
            window.open(url, '_blank');
        }
        else
        {
            alert("PDF not created on the Mobile Device, please create the PDF and then sync to the Cloud");
        }
    }

    function urlExists(url)
    {
        var http = new XMLHttpRequest();
        http.open('HEAD', url, false);
        http.send();
        return http.status!=404;
    }



    $(document).ready(function() {

        pageSetUp();
        initCustomerCodeAutocomplete();


    })

</script>



