<?php
// Andreas Spanos @ 25/07/2019 Insert Allowed Categories for user from B2B Categories
// Andreas Spanos @ 25/07/2019 Added Show Stock variable
// Andreas Spanos @ 25/07/2019 Added Username Uniqueness Check



session_start();
require("dbinfo.php");
require("dbhelper.php");


$customerID= trim($_POST['customerID']);
$delete= trim($_POST['forDelete']);

$db = new mysqli(localhost,$username,$password,$database);
if (mysqli_connect_errno())
{
    printf("Connect failed: %s\n", mysqli_connect_error());
    exit();
}

if(strcmp($delete,'delete') == 0)
{
    $b2bUserID = $_POST['userID'];
    $db->set_charset("utf8");
    $stmt = $db->prepare("DELETE FROM B2B_Allow_Categories_User WHERE b2b_user_id=?");
    $stmt->bind_param('i', $b2bUserID);
    $stmt->execute();
    $stmt->close();

    $db->set_charset("utf8");
    $stmt = $db->prepare("DELETE FROM B2B_User WHERE b2b_user_id=?");
    $stmt->bind_param('i', $b2bUserID);
    $stmt->execute();
    $stmt->close();
}
else if(strcmp($_POST['username'],"")!=0 && strcmp($_POST['identifier'],"")!=0 )
{
    $user = $_POST['username'];
    $b2bUserID = $_POST['userID'];
    $identifier = $_POST['identifier'];
    $firstName = $_POST['firstName'];
    $lastName = $_POST['lastName'];
    $mobile = $_POST['mobile'];
    $email = $_POST['email'];
    $stock = $_POST['showStock'];
    $prices = $_POST['showPrices'];
    $showPromotions = $_POST['showPromotions'];


    if(strcmp($email,"")==0)
     {
         $email=null;
     }


     $db = new mysqli(localhost, $username, $password, $database);
     if (mysqli_connect_errno()) {
         printf("Connect failed: %s\n", mysqli_connect_error());
         exit();
     }


     if(strcmp($b2bUserID,'') == 0){
         $b2bUserID = getNextKey("B2B_User","b2b_user_id");
         $db->set_charset("utf8");
         $stmt = $db->prepare("INSERT INTO B2B_User (b2b_user_id,customer_id,username,identifier,email,first_name,last_name,mobile,show_stock, show_prices,show_promo, timestamp) VALUES(?,?,?,?,?,?,?,?,?,?,?,NOW())");
         $stmt->bind_param('iisssssssss', $b2bUserID, $customerID, $user, $identifier, $email, $firstName, $lastName, $mobile, $stock, $prices,$showPromotions);
         $stmt->execute();
         $stmt->close();


         $db->set_charset("utf8");
         $stmt = $db->prepare("INSERT INTO B2B_Allow_Categories_User (category_id, b2b_user_id, timestamp) SELECT category_id, ?, NOW() FROM B2B_Categories");
         $stmt->bind_param('i', $b2bUserID);
         $stmt->execute();
         $stmt->close();

     } else {

         $db->set_charset("utf8");
         $stm = $db->prepare("SELECT B2C_User  FROM B2B_User WHERE b2b_user_id=$b2bUserID");
         $stm->execute();
         $stm->bind_result( $B2CUser );
         while ($stm->fetch()) {}
         $stm->close();

         if(strcmp($B2CUser,'yes')==0){
             $isB2C = true;
         } else {
             $isB2C = false;
         }

         if($isB2C){
             $db->set_charset("utf8");
             $stmt = $db->prepare("UPDATE B2B_User SET  customer_id=?,show_stock=?, show_prices=?,show_promo=?, timestamp=NOW() WHERE b2b_user_id=$b2bUserID");
             $stmt->bind_param('isss',  $customerID,  $stock, $prices,$showPromotions);
             $stmt->execute();
             $stmt->close();
         } else {
             $db->set_charset("utf8");
             $stmt = $db->prepare("UPDATE B2B_User SET  customer_id=?,username=?,identifier=?,email=?,first_name=?,last_name=?,mobile=?,show_stock=?, show_prices=?,show_promo=?, timestamp=NOW() WHERE b2b_user_id=$b2bUserID");
             $stmt->bind_param('isssssisss',  $customerID, $user, $identifier, $email, $firstName, $lastName, $mobile, $stock, $prices,$showPromotions);
             $stmt->execute();
             $stmt->close();
         }

     }

     echo "?id=$b2bUserID&cid=$customerID";

    if(isset($_POST['b2bAccountRequest']) && (int)$_POST['b2bAccountRequest'] > 0) {
         $db->set_charset("utf8");
         $stmt = $db->prepare("DELETE FROM B2B_User_Account_Request WHERE request_id=?");
         $stmt->bind_param('i', $_POST['b2bAccountRequest']);
         $stmt->execute();
         $stmt->close();
    }
}




?>