<?php
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ERROR);
require("dbinfo.php");
require("dbhelper.php");

global $username,$password,$database;
$db = new mysqli('localhost',$username,$password,$database);
if (mysqli_connect_errno())
{
    printf("Connect failed: %s\n", mysqli_connect_error());
    exit();
}
$db->set_charset("utf8");

$filterName = trim($_POST['filterName']);
$category = trim($_POST['categorySearch']);

if(intval($category) > 1) {
    $categoryID = intval($category);
    $categoriesFilter = " AND Filter_Category.category_id = $category ";
} else {
    $categoryID = 1;
    $categoriesFilter = "";
}

$linkUrlResult = array();

echo "<center>";
echo "<table class='table table-bordered' style='width: fit-content;white-space: nowrap'>";
echo "<tr><td><b>Category</b></td><td><b>Filter</b></td><td><b>Option</b></td></tr>";

$stmt = $db->prepare("
SELECT 
Filter_Options.option_name,
Filters.type,
Filters.filter_code,
Filters.name,
Filter_Category.category_id,
Categories.category_code,
Categories.name,
Filters.filter_id,
Filter_Options.filter_option_id,
CONCAT(Filters.type,'-',Filters.filter_id,'-',Filter_Options.filter_option_id) AS option_string
FROM Filter_Options,Filters,Filter_Category, Categories 
WHERE Filter_Options.filter_id=Filters.filter_id 
  AND Filters.filter_id=Filter_Category.filter_id
  AND Filter_Category.category_id=Categories.category_id
  AND Filters.active='yes' 
  AND Filter_Options.active='yes' 
  $categoriesFilter
  AND Filter_Options.option_name LIKE ? ");
$stmt->bind_param('s', $filterName);
$stmt->execute();
$stmt-> bind_result($option_name,$type,$filter_code,$filter_name,$category_id,$category_code,$category_name,$filter_id,$filter_option_id,$option_string);
while ($stmt->fetch()) {

    $option_string = str_replace("range","R","$option_string");
    $option_string = str_replace("checkbox","M","$option_string");
    $option_string = str_replace("radio","S","$option_string");

    echo "<tr><td>$category_code - $category_name</td><td>$filter_name</td><td>$option_name</td></tr>";

    $linkUrlResult[$filter_id][$filter_option_id] = $option_string;
}
$stmt->close();

foreach ($linkUrlResult as $filter_id => $filterOptions) {
    $filterOptionsString = implode(",",$filterOptions);
    $linkUrlResult[$filter_id] = $filterOptionsString;
}
$urlString = implode(",",$linkUrlResult);

if(strcmp($urlString,"") != 0) {
    $urlString = "C-$categoryID,$urlString";
    echo "<tr><td colspan='3'><b>Filter URL:</b></td></tr>";
    echo "<tr><td colspan='3'><b style='color: blue'>https://".HTML_PATH."/cop/b2b/index.php?urlOptionFilters=$urlString</b></td></tr>";
} else {
    echo "<tr><td colspan='3'>No filters found</td></tr>";
}
echo "</center>";
?>