<?php
 
/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 * Easy set variables
 */
 include_once('dbinfo.php');
include_once('dbhelper.php');
// DB table to use
$table = 'B2B_User_Account_Request';
 
// Table's primary key
$primaryKey = "request_id";
 
// Array of database columns which should be read and sent back to DataTables.
// The `db` parameter represents the column name in the database, while the `dt`
// parameter represents the DataTables column identifier. In this case object
// parameter names
$columns = array(
    array( 'db' => '`r`.`request_id`', 'dt' => 'img', 'formatter' => function( $d, $row ) {

        return '<img class="custom-rounded-image center-canvas" src="./img/usericon.png" width="30" height="30"></td>';
    }, 'field' => 'order_code' ),
    array( 'db' => '`r`.`customer_code`', 'dt' =>  'code', 'field' =>'customer_code' ),
    array( 'db' => '`r`.`customer_company_name`', 'dt' =>  'company', 'field' =>'customer_company_name' ),
    array( 'db' => '`r`.`user_first_name`', 'dt' =>  'name', 'field' =>'user_first_name' ),
    array( 'db' => '`r`.`user_last_name`' , 'dt' =>  'last', 'field' =>'user_last_name' ),
    array( 'db' => '`r`.`email`' , 'dt' =>  'email' , 'field' =>'email' ),
    array( 'db' => '`r`.`lat`' , 'dt' =>  'lat' , 'field' =>'lat' ),
    array( 'db' => '`r`.`lng`' , 'dt' =>  'lng' , 'field' =>'lng' ),
    array( 'db' => '`r`.`mobile`' , 'dt' =>  'mobile' , 'field' =>'mobile' ),
    array( 'db' => '`r`.`address_line_2`' , 'dt' =>  'address_line_2' , 'formatter' => function( $d, $row ) {$GLOBALS['address_line_2']=$d;return $d;}, 'field' =>'address_line_2' ),
    array( 'db' => '`r`.`postcode`' , 'dt' =>  'postcode' , 'formatter' => function( $d, $row ) {$GLOBALS['postcode']=$d;return $d;}, 'field' =>'postcode' ),
    array( 'db' => '`r`.`region`' , 'dt' =>  'region' , 'formatter' => function( $d, $row ) {$GLOBALS['region']=$d;return $d;}, 'field' =>'region' ),
    array( 'db' => '`r`.`city`' , 'dt' =>  'city' , 'formatter' => function( $d, $row ) {$GLOBALS['city']=$d;return $d;}, 'field' =>'city' ),
    array( 'db' => '`r`.`country`' , 'dt' =>  'country' , 'formatter' => function( $d, $row ) {$GLOBALS['country']=$d;return $d;}, 'field' =>'country' ),
    array( 'db' => '`r`.`address_line_1`' , 'dt' =>  'address' , 'formatter' => function( $d, $row ) {
        $addressLine1 = $d;
        $addressLine2 = $GLOBALS['address_line_2'];
        $postcode = $GLOBALS['postcode'];
        $region = $GLOBALS['region'];
        $city = $GLOBALS['city'];
        $country = $GLOBALS['country'];

        $return = "$addressLine1";

        if(strcmp($return,'')!=0 && strcmp($postcode,'')!=0){$return .= ",<br>$postcode";}
        if(strcmp($return,'')!=0 && strcmp($addressLine2,'')!=0  && strcmp($addressLine2,$city)!=0){$return .= ", $addressLine2";}
        if(strcmp($return,'')!=0 && strcmp($region,'')!=0){$return .= ", $region";}
        if(strcmp($return,'')!=0 && strcmp($city,'')!=0){$return .= ", $city";}
        if(strcmp($return,'')!=0 && strcmp($country,'')!=0){$return .= ", $country";}

        return $return;

    }, 'field' =>'address_line_1' ),

         
     array( 'db' => '`r`.`request_id`', 'dt' => 'form', 'formatter' => function( $d, $row ) {
         $buttons  = '';
         $buttons .= '<button type="button" style="font-size:13px;"  class="btn btn-primary btn-block" onclick="createUser('.$d.');"><i class="fa fa-plus"></i>&nbsp; Create Account </button>';
         $buttons .= '<button type="button" style="font-size:13px;"  class="btn btn-danger btn-block" onclick="deleteRequest('.$d.');"><i class="fa fa-times"></i>&nbsp; Delete Request </button>';

         return $buttons;
     }, 'field' => 'request_id' )
);
 
// SQL server connection information
$sql_details = array(
    'user' => $username,
    'pass' => $password,
    'db'   => $database ,
    'host' => 'localhost'
);
 
 
/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 * If you just want to use the basic configuration for DataTables with PHP
 * server-side, there is no need to edit below this line.
 */


$joinQuery = "FROM `B2B_User_Account_Request` AS `r` ";
$where = 'NOT `r`.customer_type = \'Deleted\'';
require( 'ssp2.class.php' );
 
echo json_encode(
       SSP::simple( $_GET, $sql_details, $table, $primaryKey, $columns,$joinQuery,$where)
     );
     
     ?>