<?php
 
/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 * Easy set variables
 */
include_once('dbinfo.php');
// DB table to use
$table = 'Customers';
 
// Table's primary key
$primaryKey = "customer_code";
 
// Array of database columns which should be read and sent back to DataTables.
// The `db` parameter represents the column name in the database, while the `dt`
// parameter represents the DataTables column identifier. In this case object
// parameter names
$columns = array(
       array( 'db' => '`c`.`logo`', 'dt' => 'logo', 'formatter' => function( $d, $row ) {
              if(isset($d) && strcmp($d, '') != 0) {

              } else {
                  $d = "./img/customerdefault.jpg";
              }
                return '<img class="img-rounded img-responsive center-canvas" src="'.$d.'" width="25" height="25"></td>';},
            'field' => 'logo' ),
     array( 'db' => '`c`.`customer_code`',       'dt' =>  'code', 'field' =>'customer_code' ),
    array( 'db' => '`c`.`type_of_business`',       'dt' => 'type_of_business','formatter' => function( $d, $row ) {$GLOBALS['type_of_business']=$d;return $d;}, 'field' => 'type_of_business' ),
    array( 'db' => '`c`.`customer_company_name`',       'dt' => 'name','formatter' => function( $d, $row ) {
        $status = $GLOBALS['type_of_business'];
        $result = $d;

        if(strcmp($status,'Inactive')==0){
            $result .= " <b style='color:firebrick'> (Inactive Customer)</b>";
        }

        return $result;

    }, 'field' => 'customer_company_name' ),
    array( 'db' => '`c`.`customer_id`',       'dt' => 'customer_id' ,'formatter' => function( $d, $row ) {
        $GLOBALS['customer_id'] = $d;
        return $d;
    },'field' => 'customer_id' ),

    array( 'db' => 'COUNT(`u`.`b2b_user_id`)',       'dt' => 'users' ,'formatter' => function( $d, $row ) {

         $c = $GLOBALS['customer_id'];
         global $username, $password, $database;
         $db = new mysqli(localhost, $username, $password, $database);
         if (mysqli_connect_errno()) {
             printf("Connect failed: %s\n", mysqli_connect_error());
             exit();
         }
         $db->set_charset("utf8");
         $stm = $db->prepare("SELECT COUNT(*)FROM B2B_User WHERE customer_id='$c'");
         $stm->execute();
         $stm->bind_result($counter);

         while ($stm->fetch()) {


         }
         $stm->close();

        return "$counter";},
         'field' => 'COUNT(`u`.`b2b_user_id`)', 'as'=>'noOfUsers' ),
    array( 'db' => 'COUNT(`u`.`b2b_user_id`)',       'dt' => 'active' ,'formatter' => function( $d, $row ) {

        $c = $GLOBALS['customer_id'];
        $status = $GLOBALS['type_of_business'];

        global $username, $password, $database;
        $db = new mysqli(localhost, $username, $password, $database);
        if (mysqli_connect_errno()) {
            printf("Connect failed: %s\n", mysqli_connect_error());
            exit();
        }
        $db->set_charset("utf8");
        $stm = $db->prepare("SELECT COUNT(*)FROM B2B_User WHERE customer_id='$c'");
        $stm->execute();
        $stm->bind_result($counter);
        while ($stm->fetch()) {}
        $stm->close();

        if($counter>0 && strcmp($status,'Inactive')!=0) {
            return "<b>Yes</b>";
        } else {
            return "No";
        }

        },
        'field' => 'COUNT(`u`.`b2b_user_id`)', 'as'=> 'activeUsers' ),

     array( 'db' => '`c`.`customer_id`', 'dt' => 'form', 'formatter' => function( $d, $row ) {
                return '<form id="'.$d.'"action="edit_b2b_users.php" method="post">
           		<input type="hidden" name="customer_id" value="'.$d.'">	           			                   
			<input style="font-size:13px;" type="submit" class="btn btn-primary" formtarget="_blank" value="View" style="width:60px">
			</form>';},
            'field' => 'customer_id' )
);
 
// SQL server connection information
$sql_details = array(
    'user' => $username,
    'pass' => $password,
    'db'   => $database ,
    'host' => 'localhost'
);
 
 
/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 * If you just want to use the basic configuration for DataTables with PHP
 * server-side, there is no need to edit below this line.
 */
$joinQuery = "FROM `Customers` AS `c` LEFT JOIN B2B_User AS u ON (c.customer_id=u.customer_id)";
$where = '';
$groupBy = 'c.customer_id';
require( 'ssp2.class.php' );
 
echo json_encode(
       SSP::simple( $_GET, $sql_details, $table, $primaryKey, $columns,$joinQuery,$where,$groupBy)
     );
     
     ?>