<?php
//ini_set('display_errors', 1);
//ini_set('display_startup_errors', 1);
//error_reporting(E_ALL);
include_once("../../../../param.php");
/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 * Easy set variables
 */
include_once('dbinfo.php');
// DB table to use
$table = 'ZZ_Daily_Time_Slots';

// Table's primary key
$primaryKey = "daily_slots_id";

// Array of database columns which should be read and sent back to DataTables.
// The `db` parameter represents the column name in the database, while the `dt`
// parameter represents the DataTables column identifier. In this case object
// parameter names
$columns = array(
    array('db' => '`d`.`day`', 'dt' => 'dayTimeSlot', 'formatter' => function ($d, $row) {
        $arrayOfDays = array("1"=>'Monday', "2"=>'Tuesday', "3"=>'Wednesday', "4"=>'Thursday', "5"=>'Friday', "6"=>'Saturday',"0"=>'Sunday',"-1"=>'Holiday');
        return $arrayOfDays[$d];
    }, 'field' => 'day'),

    array('db' => '`d`.`daily_slots_id`', 'dt' => 'dailyID', 'formatter' => function ($d, $row) {
        $GLOBALS['daily_slots_id'] = $d;
        return $d;
    }, 'field' => 'daily_slots_id'),

    array('db' => '`z`.`zip_code_region`','dt' => 'zip_code_region','formatter' => function ($d, $row) {
        return $d;
    },'field' => 'zip_code_region'),


    array('db' => '`d`.`time_slots`',                    'dt' => 'timeSlots',       'formatter' => function ($d, $row) {
        return str_replace(',','<br>',$d);
    },'field' => 'time_slots'),
//
    array('db' => '`d`.`next_day_delivery_after_time`',  'dt' => 'nextDayAfterTime', 'field' => 'next_day_delivery_after_time'),
    array('db' => '`d`.`disable_slot_hours_before`',     'dt' => 'hours',         'field' => 'disable_slot_hours_before'),
    array('db' => '`d`.`next_day_only_time_slots`',                    'dt' => 'nextDaySlots',       'formatter' => function ($d, $row) {
        return str_replace(',','<br>',$d);
    },'field' => 'next_day_only_time_slots'),

    array('db' => '`d`.`enable_timeslots`','dt' => 'enableTimesSlots','formatter' => function( $d, $row ) {
        $id = $GLOBALS['daily_slots_id'];
        if(strcmp("$d","yes")==0){
            return "<input type='checkbox' onclick=\"enableDisableTimeslotsDaily($(this),'$id')\" style='width: 30px; height: 30px;accent-color: #0b76cc;' checked>";
        } else {
            return "<input type='checkbox' onclick=\"enableDisableTimeslotsDaily($(this),'$id')\" style='width: 30px; height: 30px;accent-color: #0b76cc;'>";
        }

        return $result;
    }, 'field' => 'enable_timeslots' ),

    array('db' => '`d`.`enable_delivery_approval`','dt' => 'enableDeliveryApproval','formatter' => function( $d, $row ) {
        $id = $GLOBALS['daily_slots_id'];
        if(strcmp("$d","yes")==0){
            return "<input type='checkbox' onclick=\"enableDisableDeliveryApprovalDaily($(this),'$id')\" style='width: 30px; height: 30px;accent-color: green' checked>";
        } else {
            return "<input type='checkbox' onclick=\"enableDisableDeliveryApprovalDaily($(this),'$id')\" style='width: 30px; height: 30px;accent-color: green;'>";
        }

        return $result;
    }, 'field' => 'enable_delivery_approval' ),


    array('db' => '`d`.`daily_slots_id`', 'dt' => 'form','formatter' => function( $d, $row ) {
        $result = " <form action='edit_daily_time_slots.php' target='_blank' method='post'>
                        <input type='hidden' name='dailyTimeSlotID' value=$d>
                        <button class='btn btn-primary' type='submit' >Edit Daily Slots</button>
                    </form>";
        return $result;
    }, 'field' => 'daily_slots_id' )

);
global $username,$password,$database;
// SQL server connection information
$sql_details = array(
    'user' => $username,
    'pass' => $password,
    'db' => $database,
    'host' => 'localhost'
);


/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 * If you just want to use the basic configuration for DataTables with PHP
 * server-side, there is no need to edit below this line.
 */
$joinQuery = "FROM `ZZ_Daily_Time_Slots` AS `d` LEFT JOIN `ZZ_Zip_Codes` AS `z` ON (`d`.`zip_code_id`=`z`.`zip_code_id`)";
require('ssp2.class.php');

echo json_encode(
    SSP::simple($_GET, $sql_details, $table, $primaryKey, $columns, $joinQuery)
);

