<?php

include_once("../../../../param.php");
/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 * Easy set variables
 */
include_once('dbinfo.php');
// DB table to use
$table = 'B2B_Featured_Slider';

// Table's primary key
$primaryKey = "featured_id";

// Array of database columns which should be read and sent back to DataTables.
// The `db` parameter represents the column name in the database, while the `dt`
// parameter represents the DataTables column identifier. In this case object
// parameter names
$columns = array(
    array('db' => '`s`.`featured_image_url`', 'dt' => 'image', 'formatter' => function ($d, $row) {
        if (!isset($d) || $d == '') {
            $d = "noImage.png";
        }
        return '<img class="img-rounded img-responsive center-canvas" src="//' . HTML_PATH . '/cop/b2b/assets/promoslider/'. $d .'" width="60" height="auto"></td>';
    }, 'field' => 'featured_image_url'),
    array('db' => '`s`.`featured_code`',        'dt' => 'code','formatter' => function( $d, $row ) {return "<a href='//".HTML_PATH."/cop/b2b/promo-page.php?promo=$d' target='_blank'>$d</a>";},     'field' => 'featured_code'),
    array('db' => '`s`.`featured_title`',       'dt' => 'title',     'field' => 'featured_title'),
    array('db' => '`s`.`featured_text`',        'dt' => 'text','formatter' => function( $d, $row ) {return "<div class='summernote' style='max-height: 100px;overflow: scroll;'>$d</div>";},     'field' => 'featured_text'),
    array('db' => '`s`.`position`',             'dt' => 'position',  'field' => 'position'),
    array('db' => '`s`.`active`',               'dt' => 'active',    'field' => 'active'),
    array('db' => '`s`.`slider_number`',               'dt' => 'slider',    'field' => 'slider_number'),
    array('db' => '`s`.`featured_width`',               'dt' => 'width',    'field' => 'featured_width'),
    array('db' => '`s`.`featured_height`',               'dt' => 'height',    'field' => 'featured_height'),
    array('db' => '`s`.`iframe`',               'dt' => 'iframe',  'formatter' => function( $d, $row ) {
        $GLOBALS['iframe'] = $d;
        return $d;
    },    'field' => 'iframe'),
    array('db' => '`s`.`featured_link_url`',    'dt' => 'link',  'formatter' => function( $d, $row ) {
        $i = $GLOBALS['iframe'];
        if(strcmp($i,'')==0){
            return '<a href="'.$d.'" target="_blank">'.$d.'<a>';
        } else if(strcmp($i,'login')==0) {
            global $username,$password,$database;
            $db = new mysqli('localhost',$username,$password,$database);
            if (mysqli_connect_errno()) {
                printf("Connect failed: %s\n", mysqli_connect_error());
                exit();
            }
            $today = date('Y-m-d');
            $db->set_charset("utf8");
            $stm = $db->prepare("SELECT count(promotion_id),type,promotion_id FROM Promotions WHERE DATE(valid_from) <= DATE('$today') AND DATE(valid_until) >= DATE('$today') AND status='yes' AND (description='' OR description IS NULL) AND promotion_name='$d' GROUP BY promotion_name");
            $stm-> execute();
            $stm-> bind_result($promoCount,$promoType,$competitionID);
            while ($stm->fetch()) {

            }
            $stm-> close();

            if($promoType == 9){
                $db->set_charset("utf8");
                $stm = $db->prepare("SELECT count(promotion_id) FROM Promotions WHERE status=$competitionID AND type='9999' GROUP BY promotion_name");
                $stm-> execute();
                $stm-> bind_result($contestantsCount);
                while ($stm->fetch()) {}
                $stm-> close();
                $validCoupons = "<button type='button' class='btn btn-primary' onclick='viewCompetitionPromo($competitionID)'>$contestantsCount Contestants</button>";
            } else {
                $validCoupons = "($promoCount Valid Coupons)";
            }

            return "$d<br>$validCoupons";
        } else {
            return $d;
        }

        },       'field' => 'featured_link_url'),

    array('db' => '`s`.`timestamp`',            'dt' => 'time',      'field' => 'timestamp'),

    array('db' => '`s`.`valid_from`',  'dt' => 'valid_from', 'formatter' => function( $d, $row ) {
        if(strcmp($d,'0000-00-00 00:00:00')==0){
            $date = '-';
        } else {
            $date = date_format( date_create_from_format('Y-m-d H:i:s', $d), 'd-m-Y H:i');
        }
    return $date;
    }, 'field' => 'valid_from'),
    array('db' => '`s`.`valid_until`', 'dt' => 'valid_until', 'formatter' => function( $d, $row ) {
        if(strcmp($d,'0000-00-00 00:00:00')==0){
            $date = '-';
        } else {
            $date = date_format( date_create_from_format('Y-m-d H:i:s', $d), 'd-m-Y H:i');
        }
        return $date;
    }, 'field' => 'valid_until'),

    array('db' => '`s`.`featured_id`', 'dt' => 'form', 'formatter' => function( $d, $row ) {

        require("dbinfo.php");
        $db = new mysqli(localhost, $username, $password, $database);
        if (mysqli_connect_errno()) {
            printf("Connect failed: %s\n", mysqli_connect_error());
            exit();
        }
        $db->set_charset("utf8");
        $stm = $db->prepare("SELECT active FROM B2B_Promotion_Page WHERE featured_id='$d'");
        $stm->execute();
        $stm->bind_result($check);

        while ($stm->fetch()) {}
        $stm->close();

        if($check == "yes") {
            $button = '<button type="button"  id="b'.$d.'" class="btn btn-danger" onclick="deactivateButtonClicked('.$d.');" style="width:60px; display: inline;">Hide</button>';
        } else {
            $button = '<button type="button" id="b'.$d.'"  class="btn btn-success" onclick="activateButtonClicked('.$d.');"  style="width:60px; display: inline;">Show</button>';
        }
        return '<form id="'.$d.'"action="edit_promo_section.php" method="post" target="_blank">
           		<input type="hidden" name="featured_id" value="'.$d.'">	           			                   
			<input style="font-size:13px;" type="submit" class="btn btn-primary" value="Edit" style="width:60px display: inline;">
			'.$button.'
			</form>';},
        'field' => 'featured_id' )

);

// SQL server connection information
$sql_details = array(
    'user' => $username,
    'pass' => $password,
    'db' => $database,
    'host' => 'localhost'
);


/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 * If you just want to use the basic configuration for DataTables with PHP
 * server-side, there is no need to edit below this line.
 */
$joinQuery = "FROM `B2B_Promotion_Page` AS `s` ";
require('ssp2.class.php');

echo json_encode(
    SSP::simple($_GET, $sql_details, $table, $primaryKey, $columns, $joinQuery)
);

