<?php

include_once("../../../../param.php");
/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 * Easy set variables
 */
include_once('dbinfo.php');
// DB table to use
$table = 'B2B_Delivery_Approval_Schedules';

// Table's primary key
$primaryKey = "delivery_approval_schedule_id";

// Array of database columns which should be read and sent back to DataTables.
// The `db` parameter represents the column name in the database, while the `dt`
// parameter represents the DataTables column identifier. In this case object
// parameter names
$columns = array(



    array('db' => '`d`.`delivery_approval_schedule_id`',  'dt' => 'delivery_approval_schedule_id','formatter' => function ($d, $row) {
      $GLOBALS['schedule_id']  = $d;
    },  'field' => 'delivery_approval_schedule_id'),


    array('db' => '`d`.`description`',  'dt' => 'description', 'field' => 'description'),

    array('db' => '`d`.`day`', 'dt' => 'day', 'formatter' => function ($d, $row) {
        $arrayOfDays = array("1"=>'Monday', "2"=>'Tuesday', "3"=>'Wednesday', "4"=>'Thursday', "5"=>'Friday', "6"=>'Saturday',"0"=>'Sunday',"-1"=>'Holiday');
        return $arrayOfDays[$d];
    }, 'field' => 'day'),

    array('db' => '`d`.`from_time`',  'dt' => 'from_time', 'field' => 'from_time'),
    array('db' => '`d`.`to_time`',  'dt' => 'to_time', 'field' => 'to_time'),
    array('db' => '`d`.`holiday_schedule_date`',  'dt' => 'holidayDate',     'formatter' => function( $d, $row ) {
      return date('d-m-Y',strtotime($d));
    },'field' => 'holiday_schedule_date'),
    array('db' => '`d`.`ignore_regions`',  'dt' => 'ignore_regions', 'field' => 'ignore_regions'),
    array('db' => '`d`.`status`',  'dt' => 'status',   'formatter' => function( $d, $row ) {
        $scheduleID = $GLOBALS['schedule_id'];
        if(strcmp("$d","yes")==0){
            return "<input type='checkbox' onclick=\"changeStatusSchedule($(this),'$scheduleID')\" style='width: 30px; height: 30px;accent-color: green' checked>";
        } else {
            return "<input type='checkbox' onclick=\"changeStatusSchedule($(this),'$scheduleID')\" style='width: 30px; height: 30px;accent-color: green;'>";
        }
    },        'field' => 'status'),
    array('db' => '`d`.`delivery_approval_schedule_id`',                   'dt' => 'form',        'formatter' => function( $d, $row ) {
        $result = " <form action='createDeliveryApprovalSchedules.php' target='_blank' method='post'>
                        <input type='hidden' name='scheduleID' value='$d'>
                        <button class='btn btn-primary' type='submit' >Edit Instant Delivery</button>
                    </form>";
        return $result;
    }, 'field' => 'delivery_approval_schedule_id' )
);

// SQL server connection information
$sql_details = array(
    'user' => $username,
    'pass' => $password,
    'db' => $database,
    'host' => 'localhost'
);


/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 * If you just want to use the basic configuration for DataTables with PHP
 * server-side, there is no need to edit below this line.
 */
if (isset($_GET['holyday']) && $_GET['holyday']>0){
    $filterQuery = ' WHERE day<0';
}else{
    $filterQuery='WHERE day>0';
}
$joinQuery = "FROM `B2B_Delivery_Approval_Schedules` AS `d`  $filterQuery ORDER BY day ASC;";
require('ssp2.class.php');



echo json_encode(
    SSP::simple($_GET, $sql_details, $table, $primaryKey, $columns, $joinQuery)
);

