<?php
require("./concc/dbinfo.php");
if(!isset($_SESSION['adminID']) ) {
    redirect("login.php");
}


function redirect($url)
{
    if (headers_sent())
    {
        die('<script type="text/javascript">window.location.href="' . $url . '";</script>');
    }
    else
    {
        header('Location: ' . $url);
        die();
    }
}

function endsWith($haystack, $needle)
{
    $length = strlen($needle);
    if ($length == 0) {
        return true;
    }

    return (substr($haystack, -$length) === $needle);
}

if(isset($_POST['scheduleID'])){

    $isEdit      = true;
    $scheduleID      = trim($_POST['scheduleID']);
    $pageStatus  = 'Edit';
    $postURL     = 'edit_deliveryApprovalSchedules.php';

    global $username,$password,$database;
    $db = new mysqli('localhost',$username,$password,$database);
    if (mysqli_connect_errno()) {
        printf("Connect failed: %s\n", mysqli_connect_error());
        exit();
    }
    $db->set_charset("utf8");
    $stm = $db->prepare("SELECT delivery_approval_schedule_id,description,day,from_time,to_time,ignore_regions,status,holiday_schedule_date FROM B2B_Delivery_Approval_Schedules WHERE delivery_approval_schedule_id='$scheduleID'");
    $stm-> execute();
    $stm-> bind_result($scheduleID,$description,$dayDB,$fromTime,$toTime,$ignoreRegions,$status,$dateHoliday);
    while ($stm->fetch()) {}
    $stm-> close();
    if ($dayDB<1){
        $styleElementHoliday = 'opacity:1';
    }else{
        $styleElementHoliday = 'opacity:0.3';
    }
} else {
    $styleElementHoliday = 'opacity:0.3';
    $isEdit      = false;
    $pageStatus  = 'New';
    $postURL     = 'add_deliveryApprovalSchedules.php';
    $fromTime= '08:00';
    $toTime= '23:59';
    $scheduleID = 0;
}

$arrayOfDays = array("1"=>'Monday', "2"=>'Tuesday', "3"=>'Wednesday', "4"=>'Thursday', "5"=>'Friday', "6"=>'Saturday',"0"=>'Sunday',"-1"=>'- Holiday -');
?>

<div id="main" role="main">

    <!-- Start CUSTOM CODE-->


    <!-- RIBBON -->
    <div id="ribbon" class="bg-color-blue">

				<span class="ribbon-button-alignment">
					<span id="refresh" class="btn btn-ribbon2" onclick="location.reload(true);" data-title="refresh" rel="tooltip" data-placement="bottom" data-original-title="<i class='text-warning fa fa-warning'></i> Reload Page?" data-html="true">
						<i class="fa fa-refresh"></i>
					</span>
				</span>

        <!-- breadcrumb -->
        <ol class="breadcrumb">
            <li class="txt-color-white"> <?php echo $pageStatus?> Schedule</li>
        </ol>
        <!-- end breadcrumb -->


    </div>
    <!-- END RIBBON -->

    <!-- MAIN CONTENT -->
    <div id="content">
        <!-- row -->
        <div class="row">
            <article class="col-xs-12 col-sm-12 col-md-12 col-lg-6">
                <!-- new widget -->
                <div class="jarviswidget" id="wid-id-0" data-widget-togglebutton="false" data-widget-editbutton="false" data-widget-fullscreenbutton="false" data-widget-colorbutton="false" data-widget-deletebutton="false">

                    <header>
                        <span class="widget-icon"> <i class="fa fa-edit"></i> </span>
                        <h2><?php echo $pageStatus?> Delivery Approval Schedule</h2>
                    </header>

                    <div class="widget-body">

                        <div class="row">

                            <div class="col-sm-12">

                                <form id="pageForm" method="post" class="smart-form" enctype="multipart/form-data">

                                    <fieldset style="padding-top:0px">
                                        <section>
                                            <h2 style="font-weight:bold;"></h2>
                                        </section>
                                        <div class="row">

                                            <section class="col-sm-11">
                                                <section>
                                                    <label class="label-bold align-left"><b>Schedule Name : </b></label>
                                                    <input type="text"  class="form-control"  id="descriptionSchedule" value="<?php if($isEdit){echo "$description";} ?>">
                                                </section>
                                                <section>
                                                   <section class="col-sm-5">
                                                       <label class="label-bold align-left"><b>Schedule Day : </b></label>
                                                        <select class='form-control' id='dateSelection'>
                                                        <?php
                                                            foreach ($arrayOfDays as $key=>$day){
                                                                if ($dayDB==$key){
                                                                    echo "<option value='$key' selected>$day</option>";
                                                                }else{
                                                                    echo "<option value='$key'>$day</option>";
                                                                }
                                                            }
                                                        ?>
                                                        </select>
                                                    </section>
                                                    <section class="col-sm-2"></section>
                                                    <section class="col-sm-5" id="sectionDateHoliday" style="<?php echo $styleElementHoliday; ?>" >
                                                            <label class="label-bold align-left" ><b>Date Holiday: </b></label>
                                                            <input type="date" class="form-control" id="dateHolidate"  value="<?php echo $dateHoliday; ?>"/>
                                                    </section>
                                                </section>

                                                <section>
                                                    <section class="col-sm-5">
                                                        <label class="label-bold align-left"><b>From Time: </b></label>
                                                        <input type="time" class="form-control"  id="fromTime"  value="<?php echo $fromTime; ?>"/>
                                                    </section>
                                                    <section class="col-sm-2"></section>
                                                    <section class="col-sm-5">
                                                        <label class="label-bold align-left"><b>To Time: </b></label>
                                                        <input type="time" class="form-control"  id="toTime"  value="<?php echo $toTime; ?>"/>
                                                    </section>
                                                </section>
                                                <section>
                                                    <section class="col-sm-5">
                                                        <label class="label-bold align-left"><b>Ignore Cities/Areas: </b></label>
                                                        <?php if($isEdit){
                                                            $ignoreRegionsYes = '';
                                                            $ignoreRegionsNo = '';
                                                            if (strcmp($ignoreRegions,'yes')==0){
                                                                $ignoreRegionsYes = 'selected';
                                                            }else{
                                                                $ignoreRegionsNo = 'selected';
                                                            }
                                                        } ?>
                                                        <select id="ignoreRegions" class="form-control">
                                                            <option value="no" <?php echo $ignoreRegionsNo ?>>no</option>
                                                            <option value="yes" <?php echo $ignoreRegionsYes ?>>yes</option>
                                                        </select>
                                                    </section>
                                                    <section class="col-sm-2"></section>
                                                    <section class="col-sm-5">
                                                        <label class="label-bold align-left"><b>Active: </b></label>
                                                        <?php if($isEdit){
                                                                $statusYes = '';
                                                                $statusNo = '';
                                                                if (strcmp($status,'yes')==0){
                                                                    $statusYes = 'selected';
                                                                }else{
                                                                    $statusNo = 'selected';
                                                                }
                                                            } ?>
                                                        <select id="status" class="form-control">
                                                            <option value="yes" <?php echo $statusYes ?>>yes</option>
                                                            <option value="no" <?php echo $statusNo ?>>no</option>
                                                        </select>
                                                    </section>
                                                </section>
                                            </section>

                                        </div>
                                    </fieldset>
                                </form>

                                <input type="hidden" id="scheduleID" value="<?php echo  $scheduleID; ?>">
                                <footer>
                                    <?php if($isEdit){echo '<input type="button" id="deleteScedule" class="btn btn-danger pull-left"  style="font-weight:400;font-size:15px;margin-top:30px;float:right;margin-right:10px;width:250px;" value="Delete Schedule" onclick="deleteSchedule()">';}?>
                                    <input type="button" id="PostSubmit" class="btn btn-primary"  style="font-weight:400;font-size:15px;margin-top:30px;float:right;margin-right:10px;width:250px;" value="Save Schedule" onclick="saveSchedule()">
                                </footer>

                            </div>

                        </div>

                    </div>
                    <!-- end widget div -->
                </div>
                <!-- end widget -->

            </article>

        </div>
        <!-- end row -->
    </div>






</div>





<script type="text/javascript">
    $('#dateSelection').on('change', function() {
        if(this.value<0){
            $("#dateHolidate").attr( 'readOnly' ,false);
            $('#sectionDateHoliday').css('opacity', '1');
        }else{
            $("#dateHolidate").attr( 'readOnly' ,true);
            $('#dateHolidate').val('');
            $('#sectionDateHoliday').css('opacity', '0.3');
        }
    });

    function deleteSchedule(){
        var scheduleID       = $('#scheduleID').val();

        if(scheduleID > 0) {
            $.ajax({
                type: 'POST',
                url: './concc/remove_scheduleDeliveryApproval.php',
                dataType: 'html',
                data: {
                    'scheduleID': scheduleID
                },
                success: function (result) {
                   console.log(result);
                    $.smallBox({
                        title: 'Page Deleted!',
                        content: "Post successfully entered",
                        color: "#B22222",
                        timeout: 3000,
                        icon: "fa fa-user swing animated"
                    });
                    setTimeout(function(){window.close();}, 1000);
                }
            });
        }
    }

    function saveSchedule() {
        var description = $('#descriptionSchedule').val();
        var daySchedule = $('#dateSelection').val();
        var fromTime =$('#fromTime').val();
        var toTime = $('#toTime').val();
        var ignoreRegions = $('#ignoreRegions').val();
        var status =$('#status').val();
        var scheduleID = $('#scheduleID').val();
        var checkSchedule = true;
        var dateHoliday = $('#dateHolidate').val();
        var content = '';
        if (description===''){
            checkSchedule = false;
            content = 'Schedule Name';
        }else if(dateHoliday==='' && daySchedule<0){
            checkSchedule = false;
            content = 'Holiday Date';
        }
        if(checkSchedule) {
            $.ajax({
                type: 'POST',
                url: './concc/<?php echo $postURL?>',
                dataType: 'html',
                data: {
                    'description': description,
                    'daySchedule': daySchedule,
                    'fromTime': fromTime,
                    'toTime': toTime,
                    'ignoreRegions': ignoreRegions,
                    'scheduleID': scheduleID,
                    'status': status,
                    'dateHoliday':dateHoliday
                },
                success: function (result) {
                    console.log(result);
                    $.smallBox({
                        title: 'Success!',
                        content: "Schedule successfully entered",
                        color: "#739E73",
                        timeout: 3000,
                        icon: "fa fa-user swing animated"
                    });
                }
            });
        } else {
            $.smallBox({
                title: 'Incomplete Data!',
                content: "Please Complete "+content,
                color: "firebrick",
                timeout: 3000,
                icon: "fa fa-user swing animated"
            });
        }
    }

    $(document).ready(function() {

        pageSetUp();

    });
</script>

<script src="js/plugin/select2/select2.min.js"></script>



?>