<?php
// Andreas Spanos @ 09/07/2019 Added action_code Button in summernote
// Andreas Spanos @ 11/07/2019 Added filter to Email Type Selection

include_once("../../../param.php");
require("./concc/dbinfo.php");
require("./concc/dbhelper.php");
if(!isset($_SESSION['adminID']) ) {
    redirect("../../../login.php");
}

$edit=false;


function redirect($url)
{
    if (headers_sent())
    {
        die('<script type="text/javascript">window.location.href="' . $url . '";</script>');
    }
    else
    {
        header('Location: ' . $url);
        die();
    }
}

$db = new mysqli('localhost', $username, $password, $database);
if (mysqli_connect_errno()) {
    printf("Connect failed: %s\n", mysqli_connect_error());
    exit();
}


if(isset($_GET['id'])) {

    $isEdit       = true;
    $pageStatus   = 'Edit';
    $postURL      = 'edit_email_template_post.php';
    $templateID   = trim($_GET['id']);

    $db->set_charset("utf8");
    $stm = $db->prepare("SELECT cc_emails, email_type, default_template, email_text FROM B2B_Email_Templates WHERE email_template_id=" . $templateID);
    $stm->execute();
    $stm->bind_result($ccEmails, $emailType, $defaultTemplate, $emailText);
    while ($stm->fetch()) {}
    $stm->close();

    if(strcmp($defaultTemplate, "yes")==0){
        $selected = 'selected';
    }

    $selectedTypeOption = "<option value='$emailType'>$emailType</option>";


} else {

    $isEdit      = false;
    $pageStatus  = 'New';
    $postURL     = 'add_email_template_post.php';
    $selectedTypeOption = '';
    $emailType = '';
}

$emailText = str_replace("'","’",$emailText);
$emailText = str_replace("\n","<br>",$emailText);


$db->set_charset("utf8");
$stm = $db->prepare("SELECT email_type FROM B2B_Email_Templates WHERE email_type NOT LIKE '$emailType'");
$stm->execute();
$stm->bind_result($emailTypes);
while ($stm->fetch()) {
    $emailTypeOptions .= "<option value='$emailTypes'>$emailTypes</option>";
}
$stm->close();

if(strpos($emailTypeOptions, 'Welcome'           ) !== false){}else{$emailTypeOptions .= "<option value='Welcome'>Welcome</option>";}
if(strpos($emailTypeOptions, 'Forgot Password'   ) !== false){}else{$emailTypeOptions .= "<option value='Forgot Password'>Forgot Password</option>";}
if(strpos($emailTypeOptions, 'Order Confirmation') !== false){}else{$emailTypeOptions .= "<option value='Order Confirmation'>Order Confirmation</option>";}
if(strpos($emailTypeOptions, 'Receipt Confirmation') !== false){}else{$emailTypeOptions .= "<option value='Receipt Confirmation'>Receipt Confirmation</option>";}



if(strpos($emailTypeOptions, $selectedTypeOption) !== false){
    $emailTypeOptions = str_replace($selectedTypeOption,'',$emailTypeOptions);
}
?>
<div id="main" role="main">

    <!-- Start CUSTOM CODE-->
    <!-- RIBBON -->
    <div id="ribbon" class="bg-color-blue">

				<span class="ribbon-button-alignment">
					<span id="refresh" class="btn btn-ribbon2" onclick="location.reload(true);" data-title="refresh" rel="tooltip" data-placement="bottom" data-original-title="<i class='text-warning fa fa-warning'></i> Reload Page?" data-html="true">
						<i class="fa fa-refresh"></i>
					</span>
				</span>
        <!-- breadcrumb -->
        <ol class="breadcrumb">
            <li class='txt-color-white'>Home / B2B <?php echo $pageStatus?> Email Template</li>";
        </ol>
        <!-- end breadcrumb -->
    </div>
    <!-- END RIBBON -->

    <!-- MAIN CONTENT -->
    <article id="content">


        <div class="row">
            <div class="col-xs-12 col-sm-6 col-md-6 col-lg-10">
                <h3 class="page-title txt-color-blueDark header-margin">
                    <i class="fa-fw fa fa-info-circle"></i>
                    B2B <?php echo $pageStatus?> Email Template
                </h3>
            </div>
        </div>

        <!-- NEW WIDGET START -->
        <section id="widget-grid" class="col-xs-12 col-sm-12 col-md-12 col-lg-12">

            <div class="widget-body">


                <div class="jarviswidget jarviswidget-color-blueDark" id="wid-id-1" data-widget-editbutton="false" data-widget-deletebutton="false">
                    <header>
                        <span class="widget-icon"> <i class="fa fa-edit"></i> </span>
                        <h2><?php echo $pageStatus?> Email Template</h2>
                    </header>

                    <!-- row -->
                    <div class="row">
                    <article class="">

                        <form method="post" class="smart-form" enctype="multipart/form-data">
                            <section class="col-sm-12">
                                <section>

                                    <label class="label-bold align-left">Email Type:</label>
                                    <select id="emailType" name="emailType" class="form-control">
                                        <?php echo $selectedTypeOption?>
                                        <?php echo $emailTypeOptions?>
                                    </select>
                                </section>
                                <section>
                                    <label class="label-bold align-left">Default Template:</label>
                                    <select id="defaultTemplate" name="defaultTemplate" class="form-control">
                                        <option value="no">No</option>
                                        <option value="yes" <?php echo $selected?>>Yes</option>
                                    </select>
                                </section>
                                <section>
                                    <label class="label-bold align-left">CC Email:</label>
                                    <input type="text" class="form-control" style=" width: 100%" id="ccEmails" name="ccEmails" placeholder="first@example.com;second@example.com;..." value="<?php echo $ccEmails?>" />
                                </section>
                                <section>
                                    <label class="label-bold align-left">Email Content: </label>
                                    <textarea class="form-control" id="summernote" name="emailText" ></textarea>
                                </section>



                        </form>
                        <footer>
                        <input type="button" id="PostSubmit" class="btn btn-success"  style="font-weight:400;font-size:15px;margin-top:30px;float:right;margin-right:10px;width:200px;" value="Save Email Template" onclick="savePost()">
                            <?php if($isEdit == true){
                                echo '<button id="deleteEmail" type="button" class="btn btn-danger" onclick="deleteTemplate()" style="font-weight:400;font-size:15px;margin-top:30px;float:left;margin-left:1px;width:200px;" >Delete Email Template</button>';
                            }?>

                        </footer>
                    </article>
                </div>
            </div>
            <!-- end row -->
            </div>
        </section>

</div>





<script type="text/javascript">




    function deleteTemplate(){

        var templateID  = '<?php echo $templateID;?>';

        if(templateID.length > 0) {

            $.ajax({
                type: 'POST',
                url: './concc/remove_email_template.php',
                dataType: 'html',
                data: {
                    'templateID': templateID


                },
                success: function (result) {

                    $.smallBox({
                        title: 'Template Deleted!',
                        content: "Post successfully entered",
                        color: "#B22222",
                        timeout: 3000,
                        icon: "fa fa-user swing animated"
                    });
                    setTimeout(function(){window.location.assign('email_templates.php');}, 1000);
                }
            });
        }
    }

    function savePost()
    {
        var templateStr  = $('#summernote').summernote('code');
        var emailType   = $('#emailType').val();
        var defaultTemplate      = $('#defaultTemplate').val();
        var templateID = '<?php echo $templateID?>';
        var ccEmails  = $('#ccEmails').val();

        $.ajax({
            type: "POST",
            url: './concc/<?php echo $postURL?>',
            data: {
                'templateID':templateID,
                'defaultTemplate':defaultTemplate,
                'emailType':emailType,
                'ccEmails':ccEmails,
                'templateStr':templateStr
            },

            success: function (result) {

                $.smallBox({
                    title : "Success!",
                    content : "Post successfully saved",
                    color : "#739E73",
                    timeout: 3000,
                    icon : "fa fa-gift swing animated"
                });
                setTimeout(function(){window.location.assign('email_templates.php');}, 1000);
            }

        });
    }

    $(document).ready(function() {

        pageSetUp();


        $('#summernote').summernote({
            height: 200,                 // set editor height
            minHeight: 200,             // set minimum height of editor
            maxHeight: null,            // set maximum height of editor
            focus: true,                // set focus to editable area after initializing summernote
                toolbar: [
                    ['style', ['style']],
                    ['font', ['bold', 'underline', 'clear']],
                    ['fontname', ['fontname']],
                    ['color', ['color']],
                    ['para', ['ul', 'ol', 'paragraph']],
                    ['table', ['table']],
                    ['view', ['fullscreen', 'codeview', 'help']],
                    ['insert', ['b2b_user_name','b2b_username','b2b_user_password','reset_password_link','notification_acceptance_link','customer_company_name','customer_code','company_name','company_logo','action_date','delivery_date','action_code','action_details','grand_total']]
                ],
            table: 'table table-striped'

        });

        $('#summernote').summernote('code', '<?php echo $emailText ?>');


    });



</script>


<script src="js/notification/SmartNotification.min.js"></script>



<!-- include summernote css/js -->
<link rel="stylesheet" href="//<?php echo HTML_PATH ?>/cop/libs/summernote/dist/summernote.css">
<script type="text/javascript" src="//<?php echo HTML_PATH ?>/cop/libs/summernote/dist/summernote.js"></script>
<script type="text/javascript" src="//<?php echo HTML_PATH ?>/cop/libs/summernote/plugin/hello/summernote-ext-hello.js"></script

>