<?php
// Email template file VERSION 1.0 [09/07/2019]
// Implemented for general AJAX Call (Email Contend Preconfigured)
// Implemented for AJAX call for actions (ORDER)

// Andreas Spanos @ 10/07/2019 Implimented action (WELCOME)

error_reporting(0);
session_start();
include_once("../../../param.php");
require("./concc/dbinfo.php");
require("./concc/dbhelper.php");

use PHPMailer\PHPMailer\PHPMailer;
use PHPMailer\PHPMailer\Exception;

include_once(ROOT . "libs/emailer/PHPMailer8/vendor/autoload.php");

//include_once(ROOT . "libs/emailer/PHPMailer/PHPMailer.php");
//include_once(ROOT . "libs/emailer/PHPMailer/Exception.php");
//include_once(ROOT . "libs/emailer/PHPMailer/SMTP.php");

// general AJAX call
$email=$_POST["email"];
$emailCC=$_POST["emailCC"];
$emailHtml=$_POST["emailHTML"];
$emailSubject=$_POST["emailSubject"];

if(strcmp($email, '')!=0 && strcmp($emailHtml, '')!=0 && strcmp($emailSubject, '')!=0 ) {
    sendEmail($email, $emailCC, $emailHtml, $emailSubject);
}

// AJAX call for actions (order, welcome, etc.)
if(isset($_POST['ID']) && isset($_POST['action'])){

    $ID      = trim($_POST['ID']);
    $action  = trim($_POST['action']);

    sendActionAsEmail($action,$ID);
}

if(isset($_POST['test']) && strcmp($_POST['test'],'yes')==0){
    $emailHost = $_POST['emailHost'];
    $emailFrom = $_POST['emailSender'];
    $emailTo = $_POST['emailTest'];
    $emailUsername = $_POST['emailUsername'];
    $emailPassword = $_POST['emailPassword'];
    testHost($emailHost,$emailFrom,$emailTo,$emailUsername,$emailPassword);
}

function sendActionAsEmail($action, $ID){

    global $username, $password, $database;

    $db = new mysqli('localhost',$username,$password,$database);
    if (mysqli_connect_errno()) {
        printf("Connect failed: %s\n", mysqli_connect_error());
        exit();
    }
    $db->set_charset("utf8");

    // Selecting an action (order, welcome, etc.)
    switch ($action) {
        case 'ORDER':

            $userID        = $_SESSION['userID'];
            $actionDetails = generateOrder($ID);

            $stm = $db->prepare("SELECT order_code,order_date,grand_total,customer_code,customer_company_name
                                        FROM Orders, Customers 
                                        WHERE Orders.customer_id = Customers.customer_id 
                                        AND order_id='$ID'");
            $stm->execute();
            $stm->bind_result($actionCode, $actionDate, $grandTotal,$customerCode,$customerCompanyName);
            while ($stm->fetch()) {}
            $stm->close();

            $stm = $db->prepare("SELECT CONCAT(last_name,' ',first_name),email FROM B2B_User WHERE b2b_user_id='$userID'");
            $stm-> execute();
            $stm-> bind_result($userName,$email);
            while ($stm->fetch()) {}
            $stm-> close();

            $db->set_charset("utf8");
            $stm = $db->prepare("SELECT email_template_id, email_text, cc_emails,email_type FROM B2B_Email_Templates WHERE email_type = 'Order Confirmation' AND default_template = 'yes' AND active = 'yes' LIMIT 1");
            $stm-> execute();
            $stm-> bind_result($emailTemplateID, $emailContent, $emailCC, $emailSubject);
            while ($stm->fetch()) {}
            $stm-> close();

            // If not exist Create Template
            if(empty($emailTemplateID)){

                $emailContent = "<html><head></head><body><div>{action_details}</body></html>";
                $emailSubject = "Order Confirmation";
                $emailCC      = "";

            } else {

                $emailContent = "<html><head></head><body><div>".$emailContent."</body></html>";

            }

            $actionDate = date_format( date_create_from_format('Y-m-d', $actionDate), 'd-m-Y');
            $grandTotal = number_format($grandTotal,2);
            break;
        case 'WELCOME':

            $stm = $db->prepare("SELECT CONCAT(last_name,' ',first_name),username, identifier, email, customer_id FROM B2B_User WHERE b2b_user_id='$ID'");
            $stm-> execute();
            $stm-> bind_result($b2bUser,$b2bUsername,$b2bPass,$userEmail, $customerID);
            while ($stm->fetch()) {}
            $stm-> close();

            $stm = $db->prepare("SELECT customer_company_name,customer_code,email FROM Customers WHERE customer_id='$customerID'");
            $stm-> execute();
            $stm-> bind_result($customerCompanyName,$customerCode,$companyEmail);
            while ($stm->fetch()) {}
            $stm-> close();

            $stm = $db->prepare("SELECT email_template_id, email_text, cc_emails,email_type FROM B2B_Email_Templates WHERE email_type = 'Welcome' AND default_template = 'yes' AND active = 'yes' LIMIT 1");
            $stm-> execute();
            $stm-> bind_result($emailTemplateID, $emailContent, $emailCC, $emailSubject);
            while ($stm->fetch()) {}
            $stm-> close();

            // If not exist Create Template
            if(empty($emailTemplateID)){

                $emailContent = "<html>
                                    <head></head>
                                    <body><div>
                                           <br />
                                           Dear {b2b_user_name}, <br />
                                           <br />
                                           Welcome to {company_name} B2B Commerce.<br />
                                           You are registered as a user of {customer_company_name}<br />
                                           <br />
                                           Username: {b2b_username}<br />
                                           Password: {b2b_user_password}<br />
                                           <br />
                                           If any data is Incorrect please contact us.<br />
                                           <br />
                                           Best Regards,<br />
                                           {company_name}
                                    </body></html>";
                $emailSubject = "Welcome to B2B Commerce";
                $emailCC      = "";

            } else {
                $emailContent = "<html><head></head><body><div>".$emailContent."</body></html>";
            }

            //If user has email, send to User email ELSE email send to company email
            if(empty($userEmail)){
                $email = $companyEmail;
            } else {
                $email = $userEmail;
            }
            break;
        case 'PASSWORD_RESET':

            $stm = $db->prepare("SELECT username, identifier, CONCAT(first_name, ' ', last_name), token FROM B2B_User WHERE email = '$ID'");
            $stm-> execute();
            $stm-> bind_result($b2bUsername, $b2bPass, $b2bUser, $token);
            while ($stm->fetch()) {}
            $stm-> close();

            $stm = $db->prepare("SELECT email_template_id, email_text, cc_emails FROM B2B_Email_Templates WHERE email_type = 'Forgot Password'AND default_template = 'yes' AND active = 'yes'");
            $stm-> execute();
            $stm-> bind_result($emailTemplateID, $emailContent, $emailCC);
            while ($stm->fetch()) {}
            $stm-> close();

            if(empty($emailTemplateID)){

                $emailContent = "<html>
                                    <head></head>
                                    <body><div>
                                           <br />
                                           Dear {b2b_user_name}, <br />
                                           <br />
                                           You have requested a Password Reset for {company_name} B2B Commerce.<br />
                                           To set a new password please follow the link Below.<br />
                                           <br />
                                           Link: {reset_password_link}<br />
                                           <br />
                                           If you haven’t requested a new password, please ignore this email. <br />
                                           Your account is safe because the person who has made this request<br />
                                           will not be able to use your credentials to log into our site.<br />
                                           <br />
                                           Best Regards,<br />
                                           {company_name}
                                    </body></html>";
                $emailCC      = "";

            } else {
                $emailContent = "<html><head></head><body><div>".$emailContent."</body></html>";
            }

            $emailSubject = "B2B Commerce - Password Reset";
            $passwordLink = "<a href='http://".$_SERVER['HTTP_HOST']."/b2b/resetpass.php?token=".$token."'>Reset Password</a>";

            break;
    };

    $emailContent = str_replace("{action_details}"       ,$actionDetails      ,$emailContent);
    $emailContent = str_replace("{action_date}"          ,$actionDate         ,$emailContent);
    $emailContent = str_replace("{grand_total}"          ,$grandTotal         ,$emailContent);
    $emailContent = str_replace("{b2b_user_name}"        ,$b2bUser            ,$emailContent);
    $emailContent = str_replace("{b2b_username}"         ,$b2bUsername        ,$emailContent);
    $emailContent = str_replace("{b2b_user_password}"    ,$b2bPass            ,$emailContent);
    $emailContent = str_replace("{reset_password_link}"  ,$passwordLink       ,$emailContent);
    $emailContent = str_replace("{customer_company_name}",$customerCompanyName,$emailContent);
    $emailContent = str_replace("{customer_code}"        ,$customerCode       ,$emailContent);
    $emailContent = str_replace("{action_code}"          ,$actionCode         ,$emailContent);

    sendEmail($email,$emailCC,$emailContent,$emailSubject);

}

function sendEmail($email,$emailCC,$emailHtml,$emailSubject)
{
    global $username;
    global $password;
    global $database;

    $db = new mysqli('localhost',$username,$password,$database);
    if (mysqli_connect_errno()) {
        printf("Connect failed: %s\n", mysqli_connect_error());
        exit();
    }
    $db->set_charset("utf8");
    $stm = $db->prepare("SELECT email_host, email_from, email_username, email_password, company_name FROM B2B_Configuration");
    $stm-> execute();
    $stm-> bind_result($emailHost,$emailFrom,$emailUsername,$emailPassword,$companyName);
    while ($stm->fetch()) {}
    $stm-> close();

    //If Company Logo variable exists replace variable with image element
    if (strpos($emailHtml, "{company_logo}") !== false) {
        $Companylogo = "<img src='http://".$_SERVER['HTTP_HOST']."/backend/pdfimage/logo.png' width='20%' height='20%'>";
        $emailHtml = str_replace("{company_logo}",$Companylogo,$emailHtml);
    }

    //If Company Name variable exists replace variable
    if (strpos($emailHtml, "{company_name}") !== false) {
        $emailHtml = str_replace("{company_name}",$companyName,$emailHtml);
    }
    //If email does not exist send email to sender
    if(strcmp($email,'') == 0){
        $emailSubject = "No Receiver Email found - ".$emailSubject;
        $email = $emailFrom;
    }


    $mail = new PHPMailer(true);                              // Passing `true` enables exceptions
    try {
//        echo "entering try";
        //Server settings
//        $mail->SMTPDebug = 2;                               // Enable verbose debug output
        $mail->isSMTP();                                      // Set mailer to use SMTP
        $mail->Host = $emailHost;                             // Specify main and backup SMTP servers
        $mail->SMTPAuth = true;                               // Enable SMTP authentication
        $mail->Username = $emailUsername;                     // SMTP username
        $mail->Password = $emailPassword;                     // SMTP password
        $mail->SMTPSecure = 'tls';                            // Enable TLS encryption, `ssl` also accepted
        $mail->Port = 587;                                    // TCP port to connect to

        //Recipients
        $mail->setFrom($emailFrom, $companyName);

        $mail->addAddress($email, $email);

        $ccArray = explode(';',$emailCC);

        foreach ($ccArray as $cc){
            if(strcmp($cc,'') != 0) {
                $mail->addCC($cc);
            }
        }

        //  $mail->addAddress('ellen@example.com');               // Name is optional
        //  $mail->addReplyTo('info@example.com', 'Information');
        //  $mail->addBCC('bcc@example.com');

        //Attachments
        //  $pdf = "./pdfs/orders/Order" . $orderCode . ".pdf";
        //  if(file_exists($pdf))
        //  {
        //      $mail->addAttachment($pdf);         // Add attachments
        //      $mail->addAttachment('/tmp/image.jpg', 'new.jpg');    // Optional name
        //  }

        //Content
        $mail->CharSet = 'UTF-8';
        $mail->Encoding = "base64";
        $mail->isHTML(true);                                  // Set email format to HTML
        $mail->Subject = $emailSubject;
        $mail->Body = $emailHtml;
        // $mail->AltBody = 'This is the body in plain text for non-HTML mail clients';

        $mail->send();


//        echo 'Email has been sent to '.$email;

        //	$db3 = new mysqli(localhost,$username,$password,$database);
        //	 if (mysqli_connect_errno())
        // 	{
        //  	   printf("Connect failed: %s\n", mysqli_connect_error());
        //  	   exit();
        // 	}
        //	 $db3->set_charset("utf8");
        //	   $stmt3 = $db3->prepare("INSERT INTO Order_Email (order_id,email,timestamp) VALUES(?,?,NOW())");
        //  $stmt3->bind_param('is', $orderID, $clientEmail);
        //  $stmt3->execute();
        //  $stmt3->close();
        //    }
        //} catch (Exception $e) {
        //    echo 'Message could not be sent.';
        //    echo 'Mailer Error: ' . $mail->ErrorInfo;
        //}


        //	}
        //	$stm-> close();


    }catch (Exception $ex){
//        echo " - exception ".$ex;

        $fp = fopen('email_function_error.txt', 'w');
        fwrite($fp, "\nException: ".$ex);
        fclose($fp);

    }
}

function testHost($emailHost,$emailFrom,$emailTo,$emailUsername,$emailPassword){
    ini_set('display_errors', 1);
    ini_set('display_startup_errors', 1);
    error_reporting(E_ALL);
    $mail = new PHPMailer(true);                              // Passing `true` enables exceptions
    try {

        $mail->SMTPDebug = 3;                                 // Enable verbose debug output
        $mail->isSMTP();                                      // Set mailer to use SMTP
        $mail->Host = $emailHost;                             // Specify main and backup SMTP servers
        $mail->SMTPAuth = true;                               // Enable SMTP authentication
        $mail->Username = $emailUsername;                     // SMTP username
        $mail->Password = $emailPassword;                     // SMTP password
        $mail->SMTPSecure = 'tls';                            // Enable TLS encryption, `ssl` also accepted
        $mail->Port = 587;                                    // TCP port to connect to
        $mail->Timeout = 10;
        $mail->getSMTPInstance()->Timelimit = 10;
        //Recipients
        $mail->setFrom($emailFrom, $emailFrom);
        $mail->addAddress($emailTo, $emailTo);

        //Content
        $mail->CharSet = 'UTF-8';
        $mail->Encoding = "base64";
        $mail->isHTML(true);                                  // Set email format to HTML
        $mail->Subject = 'Configuration Test Complete';
        $mail->Body = '--Automatic Configuration Test Email--';
        // $mail->AltBody = 'This is the body in plain text for non-HTML mail clients';
        if (!$mail->send()){echo "Mail Error: " . $mail->ErrorInfo;}
        else{echo "Email Send.";}

    }catch (phpmailerException $ex){echo $ex;}
}

//actions functions
function generateOrder($orderID){

    global $username;
    global $password;
    global $database;

    $db = new mysqli('localhost', $username, $password, $database);
    if (mysqli_connect_errno()) {
        printf("Connect failed: %s\n", mysqli_connect_error());
        exit();
    }
    $db->set_charset("utf8");

    $stm = $db->prepare("SELECT order_code,order_date,subtotal,grand_total,vat_amount,customer_id,company_id,order_address_id FROM Orders WHERE order_id='$orderID'");
    $stm->execute();
    $stm->bind_result($orderCode, $orderDate, $subtotal, $grandTotal, $vatAmount, $customerID, $companyID, $orderAddressID);

    while ($stm->fetch()) {


    }
    $stm->close();

    $orderDate = date_format( date_create_from_format('Y-m-d', $orderDate), 'd-m-Y');

    $subtotal = number_format($subtotal,2);
    $grandTotal = number_format($grandTotal,2);
    $vatAmount = number_format($vatAmount,2);


    $stm = $db->prepare("SELECT line1,line2,line3,line4,line5,line6,line7 FROM Companies WHERE company_id='$companyID'");
    $stm->execute();
    $stm->bind_result($line1, $line2, $line3, $line4, $line5, $line6, $line7);

    while ($stm->fetch()) {


    }
    $stm->close();


    $stm = $db->prepare("SELECT customer_code,customer_company_name FROM Customers WHERE customer_id='$customerID'");
    $stm->execute();
    $stm->bind_result($customerCode, $customerName);

    while ($stm->fetch()) {


    }
    $stm->close();


    $stm = $db->prepare("SELECT address_line_1,address_line_2 FROM CustomerAddress WHERE customer_address_id='$orderAddressID'");
    $stm->execute();
    $stm->bind_result($addressLine1, $addressLine2);

    while ($stm->fetch()) {


    }
    $stm->close();
    $displayDate = $orderDate;


    $counter = 0;
    $stm = $db->prepare("SELECT COUNT(*) FROM Order_Item WHERE order_id='$orderID'");
    $stm->execute();
    $stm->bind_result($counter);

    $maxLoop=0;
    while ($stm->fetch()) {

        $maxLoop = intval($counter / 20);
        if ($counter % 20 > 0) {
            $maxLoop++;

        }

    }

    $stm->close();
    $result= "
        <div class='row'>
<div  class='col-sm-8 col-sm-offset-2'>

<style>




        *
        {
            margin:0;
            padding:0;
            font-family:Arial;
            font-size:10pt;
            color:#000;
        }
        body
        {
            width:100%;
            font-family:Arial;
            font-size:10pt;
            margin:0;
            padding:0;
        }

        p
        {
            margin:0;
            padding:0;
        }

        #wrapper
        {
            width:180mm;
            margin:0 15mm;
        }

        .page
        {
            height:297mm;
            width:210mm;

            page-break-after:always;
        }

        table.bordered
        {
            border-left: 1px solid #ddd;
            border-top: 1px solid #ddd;

            border-spacing:0;
            border-collapse: collapse;

        }

        table.bordered td
        {
            border-right: 1px solid #ddd;
            border-bottom: 1px solid #ddd;
            padding: 2mm;
        }

        table.heading
        {
            height:50mm;
        }

        h1.heading
        {
            font-size:14pt;
            color:#000;
            font-weight:normal;
        }

        h2.heading
        {
            font-size:9pt;
            color:#000;
            font-weight:normal;
        }

        hr
        {
            color:#ccc;
            background:#ccc;
        }

        #invoice_bodyr
        {
            height: 149mm;
        }

        #invoice_body , #invoice_total, #tableHeader
        {
            width:100%;
        }
        #invoice_body table , #tableHeader table
        {
            width:100%;
            border-left: 1px solid #ccc;
            border-top: 1px solid #ccc;

            border-spacing:0;
            border-collapse: collapse;
            margin-left: 3px;


        }

        #invoice_total table {
          width:100%;
        }

        #invoice_body table td , #tableHeader table td
        {
            text-align:center;
            font-size:9pt;
  border-right: 1px solid #ccc;
            border-bottom: 1px solid #ccc;
            padding:2mm 0;
        }

        #invoice_body table td.mono  , #invoice_total table td.mono, #tableHeader table td.mono
        {
            font-family:monospace;
            text-align:right;
            padding-right:3mm;
            font-size:10pt;
        }

        #footer
        {
            width:180mm;
            margin:0 15mm;
            padding-bottom:3mm;
        }
        #footer table
        {
            width:100%;
            background:#eee;

        }
        #footer table td
        {
            width:25%;
            text-align:center;
            font-size:9pt;
        }


       @page {
            header: html_myHTMLHeader1;
            footer: html_myFooter1;
        }

        .customer {
           font-family: 'Helvetica Neue', Helvetica, Arial, sans-serif;
           font-weight: 400;
        }

    </style>";

    $counter = 0;
    for ($i = 0; $i < $maxLoop; $i++) {

        $result.="

    <p style='text-align:center; font-weight:bold; font-size:22px;padding-top:10px;'>Online Order</p>
    <br/>
    <table class='heading' style='width:100%; margin-bottom: 5px;'>
        <tr>
            <td style='width:100mm;'>
                <h1 class='heading' style='padding-top:2px;padding-bottom:2px;'>$line1</h1>
                <h2 class='heading'>
                    $line2<br/>
                    $line3<br/>
                    $line4<br/>
                    $line5<br/>
                    $line6<br/>
                    $line7
                </h2>
            </td>
            <td rowspan='2' valign='top' align='right' style='padding:3mm;'>
                <table>
                    <tr><td style='font-weight:bold'>Order No: </td><td> $orderCode</td></tr>
                    <tr><td style='font-weight:bold'>Date: </td><td> $displayDate</td></tr>
                    <tr><td style='font-weight:bold'>Type : </td><td>Online Order</td></tr>
                </table>
            </td>
        </tr>
        <tr>
            <td>
                <b>Customer</b> :<br />
                $customerCode -  $customerName<br />
               $addressLine1
                <br />
               $addressLine2<br />
            </td>
        </tr>
    </table>
    <br />



    <div id='content'>

        <div id='invoice_body' style='margin-top:10px;'>
            <table>
            <tr style='background:#eee;'>
                <td style='width:8%;'><b>No.</b></td>
                <td><b>Code</b></td>
                 <td><b>Description</b></td>
                <td style='width:15%;'><b>Quantity</b></td>
                <td style='width:15%;'><b>Unit Price</b></td>
                <td style='width:15%;'><b>Total</b></td>
            </tr>

            ";


        $pageStart = ($i) * 20;

        $stm = $db->prepare("SELECT Order_Item.item_id,qty,unit_price,Items.vat_id,item_code,name FROM Order_Item,Items WHERE Order_Item.item_id=Items.item_id AND Order_Item.order_id='$orderID' ORDER BY Order_Item.order_item_id  LIMIT $pageStart,20");
        $stm->execute();
        $stm->bind_result($itemID, $qty, $unitPrice, $vatID, $itemCode, $name);

        $unitPrice = number_format($unitPrice,2);

        while ($stm->fetch()) {
            $counter++;
            $lineTotal = $unitPrice * $qty;

            $lineTotal = number_format($lineTotal,2);

            $result .= "<tr>
                <td style = 'width:8%;' > $counter</td >
                <td style = 'text-align:left; padding-left:10px;' > $itemCode  </td >
                <td style = 'text-align:left; padding-left:10px;' > $name </td >
                <td class='mono' style = 'width:15%;' > $qty</td >
                <td style = 'width:15%;' class='mono' > $unitPrice</td >
                <td style = 'width:15%;' class='mono' > $lineTotal</td >
            </tr >";

        }
        $stm->close();


        if($i+1==$maxLoop) {


            $result .=
                "


        </table>
        </div>
        <br />
        <div id='invoice_total' style='margin-top:10px;'>
            <table>
                <tr>
                    <td style='text-align:left; padding-left:10px;'></td>
                    <td style='width:15%;'> Subtotal</td>
                    <td style='width:15%;' class='mono'>$subtotal</td>
                </tr>
                <tr>
                    <td style='text-align:left; padding-left:10px;'></td>
                    <td style='width:15%;'> Vat</td>
                    <td style='width:15%;' class='mono'>$vatAmount</td>
                </tr>
                <tr>
                    <td style='text-align:left; padding-left:10px;'></td>
                    <td style='width:15%;'> Grand Total</td>
                    <td style='width:15%;' class='mono'>$grandTotal</td>
                </tr>
            </table>
        </div>
        <br />
        <hr />
        <br />

    </div>

    <br />

    </div>

</div>

<pagebreak/>

";
        }
        else{
            $result .=
                "


        </table>
          </div>
        <pagebreak/>
        ";
        }



    }
    return $result;
}



?>