<?php

include_once('../../../../param.php');
include_once(ROOT . "concc/dbhelpers/dbhelper.php");

$scheduleMonths     = $_POST['scheduleMonths'];
$scheduleDays       = $_POST['scheduleDays'];
$daysOfMonth        = $_POST['scheduleDaysOfMonth'];
$scheduleScReferred = $_POST['scheduleScReferred'];
$scheduleType       = ''.$_POST['scheduleType'];
$scheduleStartDate  = ''.$_POST['scheduleStartDate'];
$scheduleStartTime  = ''.$_POST['scheduleStartTime'];
$scheduleEndTime    = ''.$_POST['scheduleEndTime'];
$scheduleStatus     = ''.$_POST['scheduleStatus'];
$scheduleName       = ''.$_POST['scheduleName'];
$nextExecutionDate  = ''.$_POST['scheduleNextExecutionDate'];
$contractID         = intval($_POST['contractID']);
$salespersonID      = intval($_POST['scheduleSalesperson']);
$contractScheduleID = intval($_POST['contractScheduleID']);
$scheduleScType     = intval($_POST['scheduleScType']);


if(is_array($scheduleMonths)){
    $scheduleMonths = implode(",",$scheduleMonths);
}
if(is_array($scheduleDays)){
    $scheduleDays = implode(",",$scheduleDays);
}
if(is_array($daysOfMonth)){
    $daysOfMonth = implode(",",$daysOfMonth);
}

if(is_array($scheduleScReferred)){
    $scheduleScReferred = implode(",",$scheduleScReferred);
} else {
    $scheduleScReferred = '';
}

if(strcmp($scheduleEndTime,'00:00') == 0){
    $scheduleEndTime = '23:59';
}
if(strcmp($scheduleStartTime,'00:00') == 0){
    $scheduleStartTime = '00:01';
}

$nextExecutionDateTime = "$nextExecutionDate $scheduleStartTime";
$scheduleStartDateTime = "$nextExecutionDate $scheduleStartTime";
$scheduleEndDateTime   = "$nextExecutionDate $scheduleEndTime";

$lastRunDate = "";
$serviceCallID = 0;

global $username,$password,$database;
$db = new mysqli(localhost,$username,$password,$database);
if (mysqli_connect_errno())
{
    printf("Connect failed: %s\n", mysqli_connect_error());
    exit();
}
$db->set_charset("utf8");

if($contractScheduleID > 0){
    $stm =$db->prepare("SELECT service_call_id FROM Contract_Schedules WHERE contract_schedule_id = ? LIMIT 1");
    $stm->bind_param('i',$contractScheduleID);
    $stm-> execute();
    $stm-> bind_result($service_call_id);
    while ($stm->fetch()) {}
    $stm-> close();
    $serviceCallID = intval($service_call_id);
}

if($contractID > 0){
    $stm =$db->prepare("SELECT contract_type_id FROM Contracts WHERE contract_id = ? LIMIT 1");
    $stm->bind_param('i',$contractID);
    $stm-> execute();
    $stm-> bind_result($contract_type_id);
    while ($stm->fetch()) {}
    $stm-> close();
    $contractTypeID = intval($contract_type_id);
}



if($contractScheduleID == 0){
    $contractScheduleID = getNextKeySingleTransaction("Contract_Schedules", "contract_schedule_id",$db);
    $stmt = $db->prepare("INSERT INTO Contract_Schedules (contract_schedule_id, contract_id, service_call_id, contract_type_id, assign_salesperson_id, referred_salespersons, type_of_schedule, start_date, start_time, end_time, days, months, days_of_month, last_run_date, next_run_date, details, schedule_status,service_call_type_id, timestamp) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,NOW())");
    $stmt->bind_param('iiissssssssssssssi', $contractScheduleID, $contractID, $serviceCallID, $contractTypeID, $salespersonID,$scheduleScReferred, $scheduleType, $scheduleStartDate, $scheduleStartDateTime, $scheduleEndDateTime, $scheduleDays, $scheduleMonths, $daysOfMonth, $lastRunDate, $nextExecutionDateTime, $scheduleName, $scheduleStatus,$scheduleScType);
    $stmt->execute();
    $error = $stmt->error;
    $stmt->close();
} else {
    $stmt = $db->prepare("UPDATE Contract_Schedules SET contract_id=?, service_call_id=?, contract_type_id=?, assign_salesperson_id=?,referred_salespersons=?, type_of_schedule=?, start_date=?, start_time=?, end_time=?, days=?, months=?, days_of_month=?, next_run_date=?, details=?, schedule_status=?, service_call_type_id=?, timestamp=NOW() WHERE contract_schedule_id=?");
    $stmt->bind_param('iiiisssssssssssii', $contractID, $serviceCallID, $contractTypeID, $salespersonID,$scheduleScReferred, $scheduleType, $scheduleStartDate, $scheduleStartDateTime, $scheduleEndDateTime, $scheduleDays, $scheduleMonths, $daysOfMonth, $nextExecutionDateTime, $scheduleName, $scheduleStatus,$scheduleScType, $contractScheduleID);
    $stmt->execute();
    $error = $stmt->error;
    $stmt->close();
}


$response = new stdClass();
$response->status = 1;
$response->error = '';

if(strcmp($error,'')!=0){
    $response->status = 0;
    $response->error = "$error";
}

echo json_encode($response);
?>

