<?php

/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 * Easy set variables
 */
include_once('../../../../param.php');

// DB table to use
$table = 'ZC_Menu';

// Table's primary key
$primaryKey = "menu_id";

// Array of database columns which should be read and sent back to DataTables.
// The dbparameter represents the column name in the database, while the dt
// parameter represents the DataTables column identifier. In this case object
// parameter names
$columns = array(
    array(
        'db' => 'z.menu_id',
        'dt' => 'menu_id',
        'field' => 'menu_id'
    ),
    array(
        'db' => 'z.menu_name',
        'dt' => 'name',
        'formatter' => function( $d, $row ) {
            $menuID = $row['menu_id'];
            $menuField = 'name';
           return "
           <div 
           id='editable-$menuID' 
           data-field-name='status_code' 
           data-id='$menuID' 
           style='position: relative; cursor: pointer;'
           onmouseover='$(this).find(\".fa-pencil\").show();'
           onmouseleave='$(this).find(\".fa-pencil\").hide();'
           onclick='openEditField($menuID, \"$menuField\", this);'>
               <span id='value-$menuField-$menuID'>$d</span>
               <span id='pen-$menuField-$menuID' ><i class='fa fa-pencil' style='display:none; cursor:pointer; margin-left:4px;'></i></span>
           </div>
           <input type='text' class='form-control text-center' id='input-$menuField-$menuID' value='' style='display:none;'>
           <button id='save-$menuField-$menuID' class='btn btn-success' style='display:none;'><i class='fa fa-save' style='cursor:pointer; margin-left:4px;'></i></button>";
        },

        'field' => 'menu_name'
    ),
    
  
    
    array(
    'db' => 'z.menu_id',
    'dt' => 'form',
    'formatter' => function ($d, $row) {
        return  '<a href="//' . HTML_PATH . '/cop/backend/modules/customMenu/views/edit_custom_menu.php?menuID=' . $row['menu_id'] .'" class="btn btn-primary" style="margin-top:5px;padding-top:2px;">Edit</a>';
        
    },
    'field' => 'menu_id'
    )

 
    
);

// SQL server connection information
$sql_details = array(
    'user' => $username,
    'pass' => $password,
    'db'   => $database,
    'host' => 'localhost'
);

/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 * If you just want to use the basic configuration for DataTables with PHP
 * server-side, there is no need to edit below this line.
 */
$joinQuery = "FROM ZC_Menu AS z";  // No joins needed for menus table in this case
$where = ''; // Add any specific where clauses if needed


require( ROOT.'backend/core/controllers/ssp2.class.php' );

echo json_encode(
    SSP::simple( $_GET, $sql_details, $table, $primaryKey, $columns, $joinQuery, $where )
);

?>