<?php

/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 * Easy set variables
 */
include_once("../../../../param.php");

// DB table to use
$table = 'ZC_Menu_Item_Definition';  // The table with all available menu items

// Table's primary key
$primaryKey = "menu_item_definition_id";


$columns = array(
    array(
        'db' => 'd.name',
        'dt' => 'menu_item',
        'field' => 'name'
    ),
    array(
        'db' => 'd.icon',
        'dt' => 'icon',
        'formatter' => function($d, $row) {
           $params =  $row['params'];
           if ((strpos($d, 'fa-') === 0) ){
                 $displayValue="<span class='btn btn-default' style='width:45px !important;'><i class='fa $d' ></i></span>" ;
            }
            else if((strpos($d, 'btn-') === 0)){
                $displayValue="<span class='btn $d' style='height: 30px;margin-top: -7px !important;'>
                                   <img src='//".  HTML_PATH ."/cop/backend/themes/".  THEME_NAME ."/img/$params' width='18' height='18'>
                                 </span>";
            }
            else{
                $displayValue=$d;
            }
            
        return $displayValue;
            
        },

        'field' => 'icon'
    ),
    array(
        'db' => 'd.name',
        'dt' => 'name',
        'formatter' => function($d, $row) {return '';},
        'field' => 'name'
    ),
    array(
        'db' => 'd.menu_item_definition_id',
        'dt' => 'parent',
        'formatter' => function($d, $row) {return '';},
        'field' => 'menu_item_definition_id'
    ),
    array(
        'db' => 'd.menu_item_definition_id',
        'dt' => 'position',
        'formatter' => function($d, $row)  {return '';},
        'field' => 'menu_item_definition_id'
    ),
    array(
        'db' => 'd.params',
        'dt' => 'params',
        'field' => 'params'
    ),
    array(
        'db' => 'd.menu_item_definition_id',
        'dt' => 'form',
        'formatter' => function($d, $row) {
            global $username, $password, $database;
            $db = new mysqli(localhost, $username, $password, $database);
            if (mysqli_connect_errno()) {
                printf("Connect failed: %s\n", mysqli_connect_error());
                exit();
            }
            $db->set_charset("utf8");
            $menuID = trim($_GET['menuID']);
            $stm = $db->prepare("SELECT COUNT(*) FROM ZC_Menu_Item_Object WHERE menu_id = ? AND menu_item_definition_id = ?");
            $stm->bind_param("ii", $menuID, $d);
            $stm->execute();
            $stm->bind_result($counter);
            $stm->fetch();
            $stm->close();

            if ($counter > 0) {
                return '<button  id="action-btn-'.$menuID.'-'.$d.'" class="btn btn-danger" onclick="removeMenuItem('.$menuID.','. $d.')" style="width:100px">Remove</button>';
            } else {
                return '<button  id="action-btn-'.$menuID.'-'.$d.'" class="btn btn-success" onclick="addMenuItem('. $menuID.','.$d.')" style="width:100px">Add</button>';
            }
        },
        'field' => 'menu_item_definition_id'
    ),
);

// SQL server connection information
$sql_details = array(
    'user' => $username,
    'pass' => $password,
    'db'   => $database,
    'host' => 'localhost'
);

/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 * If you just want to use the basic configuration for DataTables with PHP
 * server-side, there is no need to edit below this line.
 */
$joinQuery = "FROM ZC_Menu_Item_Definition AS d";  // No joins needed for ZC_Menu_Item_Object table in this case
$where = ''; // Add any specific where clauses if needed


require( ROOT.'backend/core/controllers/ssp2.class.php' );

echo json_encode(
    SSP::simple( $_GET, $sql_details, $table, $primaryKey, $columns, $joinQuery, $where )
);


?>