<?php

/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 * Easy set variables
 */

include_once("../../../../param.php");

global $username, $password, $database;
$db3 = new mysqli(localhost, $username, $password, $database);
if (mysqli_connect_errno()) {
    printf("Connect failed: %s\n", mysqli_connect_error());
    exit();
}
$db3->set_charset("utf8");

// DB table to use
$table = 'ZC_Menu_Item_Object';  // The table with all available menu items

$primaryKey = "menu_item_object_id";

$menuID = trim($_GET['menuID']);
$icons = ["fa-bar-chart-o", "fa-user", "fa-gift", "fa-sitemap", "fa-money",
          "fa-archive", "fa-mobile", "fa-calendar", "fa-signal", "fa-file-text",
          "fa-envelope", "fa-ban", "fa-wrench", "fa-refresh", "fa-tasks",
          "fa-shopping-cart", "fa-book", "fa-gear", "fa-credit-card", "fa-truck",
          "fa-sliders", "fa-bank", "fa-gears"];

$columns = array(
    array(
        'db' => 'o.menu_item_definition_id',
        'dt' => 'menu_item_definition_id',
        'field' => 'menu_item_definition_id'
    ),
    array(
        'db' => 'o.menu_item_object_id',
        'dt' => 'menu_item_object_id',
        'field' => 'menu_item_object_id'
    ),
    array(
        'db' => 'd.name',
        'dt' => 'menu_item',
        'field' => 'name'
    ),
    array(
        'db' => 'd.icon',
        'dt' => 'icon',
        'field' => 'dIcon',
        'as' => 'dIcon'
    ),
    array(
        'db' => 'o.icon',
        'dt' => 'icon',
         'formatter' => function( $d, $row ) use ($db3,$icons) {
            $menuItemObjID = $row['menu_item_object_id'];
            $params =  $row['params'];
            $menuItemField = 'icon';
            $defaultIcon = $row['dIcon'];
            
            if(empty($d) && (strpos($defaultIcon, 'fa-') === 0) ){
                $displayValue="<span class='btn btn-default' style='margin-left:-40px;width:45px !important;'><i class='fa $defaultIcon' ></i></span>" ;
            }
            else if(empty($d) && (strpos($defaultIcon, 'btn-') === 0)){
                $displayValue="<span class='btn $defaultIcon' style='height: 30px;margin-top: -7px !important;margin-left:-40px'>
                                   <img src='//".  HTML_PATH ."/cop/backend/themes/".  THEME_NAME ."/img/$params' width='18' height='18'>
                                 </span>";
                
            }
            else if ((strpos($d, 'fa-') === 0) ){
                $displayValue="<span class='btn btn-default' style='margin-left:-40px;width:45px !important;'><i class='fa $d' ></i></span>" ;
            }
            else  if ((strpos($d, 'btn-') === 0)){
                $displayValue="<span class='btn $d' style='height: 30px;margin-top: -7px !important;margin-left:-40px'>
                                   <img src='//".  HTML_PATH ."/cop/backend/themes/".  THEME_NAME ."/img/$params' width='18' height='18'>
                                 </span>";
            }
            else{
                $displayValue=$d;
            }
          
            
            $dropdown="";
        
           $dropdown .= "<div id='icon-preview-$menuItemField-$menuItemObjID' style='float: left; margin-top: 8px; margin-left: 40px'></div>";  

            $dropdown .= "<div style='position: relative; cursor: pointer;'  
             onmouseover='$(this).find(\".fa-pencil\").show();' 
             onmouseleave='$(this).find(\".fa-pencil\").hide();' 
              onclick='openEditField(" . $menuItemObjID . ", \"" . $menuItemField . "\", this);'>
                 <span id='value-$menuItemField-$menuItemObjID'>$displayValue</span>
                 <input type='hidden' id='hiddenValue-$menuItemField-$menuItemObjID' value='$d'> 
                 <span id='pen-$menuItemField-$menuItemObjID'>
                    <i class='fa fa-pencil' style='display:none; cursor:pointer; margin-left:4px;'></i>
                 </span>
                 </div>";
                 

            $dropdown .= "<select class='form-control text-center' id='input-$menuItemField-$menuItemObjID' style='display:none;width:120px;'>";
             if(empty($d)){
                $dropdown .= "<option value='' selected>- Default -</option>"; 
            }
            else{
                $dropdown .= "<option value='' >- Default -</option>"; 
            }
            
            if(intval($row['menu_item_definition_id']) < 100 ){
                $stm = $db3->prepare("SELECT DISTINCT icon FROM ZC_Menu_Item_Definition WHERE menu_item_definition_id < 100 ORDER BY icon DESC");
                $stm->execute();
                $stm->bind_result($icon);
                $dataIcon = $params;
                while ($stm->fetch()) {
                    $selected='';
                    if($d == $icon){
                        $selected ='selected';
                    }
                    
                    $iconName = str_replace('btn-','',$icon);
                    $iconName = str_replace('-',' ',$iconName);
                    $iconName = ucwords($iconName);
                    
                    $dropdown .= "<option data-icon ='$dataIcon' value='$icon'  $selected>$iconName</option>";
                }
                $stm->close();

            }
            else{
                foreach ($icons as $icon) {
                    if($d == $icon){$selected ='selected';}
                    else{$selected='';}
                    $iconName = str_replace('fa-','',$icon);
                    $iconName = str_replace('-',' ',$iconName);
                    $iconName = ucwords($iconName);
                    $dropdown .= "<option value='$icon' $selected>$iconName</option>";
                }
            }
            
      
    
            
            $dropdown .= "</select> <button id='save-$menuItemField-$menuItemObjID' class='btn btn-success' style='display:none;'>
                                      <i class='fa fa-save' style='cursor:pointer; margin-left:4px;'></i>
                                  </button>";
                            
            return $dropdown;
                        
        },

        'field' => 'icon'
    ),
    array(
        'db' => 'o.name',
        'dt' => 'name',
        'formatter' => function( $d, $row ) {
            $menuItemObjID = $row['menu_item_object_id'];
            $menuItemField = 'name';
            $displayValue = !empty($d) ? $d :'&nbsp;';
           return "
           <div 
           style='position: relative; cursor: pointer;'
           onmouseover='$(this).find(\".fa-pencil\").show();'
           onmouseleave='$(this).find(\".fa-pencil\").hide();'
           onclick='openEditField($menuItemObjID, \"$menuItemField\", this);'>
               <span id='value-$menuItemField-$menuItemObjID'>$displayValue</span>
               <span id='pen-$menuItemField-$menuItemObjID' ><i class='fa fa-pencil' style='display:none; cursor:pointer; margin-left:4px;'></i></span>
           </div>
           <input type='text' class='form-control text-center' id='input-$menuItemField-$menuItemObjID' value='' style='display:none;'>
           <button id='save-$menuItemField-$menuItemObjID' class='btn btn-success' style='display:none;'><i class='fa fa-save' style='cursor:pointer; margin-left:4px;'></i></button>";
        },
        'field' => 'oName',
        'as' => 'oName'
    ),
    
    array(
        'db' => 'o.position',
        'dt' => 'position',
        'formatter' => function( $d, $row ) {
            $menuItemObjID = $row['menu_item_object_id'];
            $menuItemField = 'position';
            $displayValue = !empty($d) ? $d :'&nbsp;';
           return "
           <div 
           style='position: relative; cursor: pointer;'
           onmouseover='$(this).find(\".fa-pencil\").show();'
           onmouseleave='$(this).find(\".fa-pencil\").hide();'
           onclick='openEditField($menuItemObjID, \"$menuItemField\", this);'>
               <span id='value-$menuItemField-$menuItemObjID'>$displayValue</span>
               <span id='pen-$menuItemField-$menuItemObjID' ><i class='fa fa-pencil' style='display:none; cursor:pointer; margin-left:4px;'></i></span>
           </div>
           <input type='number' class='form-control text-center' id='input-$menuItemField-$menuItemObjID' value='' style='display:none;'>
           <button id='save-$menuItemField-$menuItemObjID' class='btn btn-success' style='display:none;'><i class='fa fa-save' style='cursor:pointer; margin-left:4px;'></i></button>";
        },
        'field' => 'position'
    ),
     array(
        'db' => 'd.params',
        'dt' => 'params',
        'field' => 'params'
    ),
    
    
     array(
        'db' => 'o.menu_item_object_id',
        'dt' => 'parent',
        'formatter' =>function($d, $row) use ($db3,$menuID) {
            $menuItemObjID = $row['menu_item_object_id'];
            $menuItemField = 'parent';
            $defaultIcon = $row['dIcon'];

            $stm = $db3->prepare("SELECT menu_item_object_id FROM ZC_Menu_Item_Object WHERE parent_id=? LIMIT 1 ");
            $stm->bind_param("i",  $d);
            $stm->execute();
            $stm->bind_result($objectAsParentID);
            $stm->fetch();
            $stm->close();
            

            if(intval($objectAsParentID) > 0){
                $parentTree = "<table class='table table-bordered'><thead><tr><td>Icon</td><td>Name</td></tr></thead><tbody>";
                $stm = $db3->prepare("SELECT o.icon, o.name,d.name FROM ZC_Menu_Item_Object AS o 
                                        INNER JOIN ZC_Menu_Item_Definition AS d ON o.menu_item_definition_id = d.menu_item_definition_id
                                        WHERE o.parent_id = ? ORDER BY o.position ASC, o.menu_item_object_id ASC"
                                    );
                $stm->bind_param("i", $d);
                $stm->execute();
                $stm->bind_result($childIcon, $childName,$childDefaultName);
                
                while ($stm->fetch()) {
                    if(empty($childName)){
                        $childName = $childDefaultName;
                    }
                    if((strpos($childIcon, 'fa-') === 0) ){
                        $parentTree .= "<tr><td><i class='fa $childIcon'></i></td><td>{$childName}</td></tr>";

                    }else if(empty($childIcon)){
                         $parentTree .= "<tr><td><i class='fa $defaultIcon'></i></td><td>{$childName}</td></tr>"; 
                    }
                    else{
                        $parentTree .= "<tr><td>{$childIcon}</td><td>{$childName}</td></tr>";

                    }
                }
                $parentTree .= "</tbody></table>";
                $stm->close();

                return "<b style='color:goldenrod;' rel='popover' data-trigger='hover' data-placement='bottom' data-original-title='<h4>Children Menu Items</h4>' data-content=\"$parentTree\" data-html='true'>Parent Element</b>";
            }
            
             if(intval($row['menu_item_definition_id']) < 100 ){
                 return "<b style='color:salmon'> Header Element</b>";
             }
            
            
            $stm = $db3->prepare("SELECT menu_item_object_id FROM ZC_Menu_Item_Object WHERE parent_id=? LIMIT 1 ");
            $stm->bind_param("i",  $d);
            $stm->execute();
            $stm->bind_result($objectAsParentID);
            $stm->fetch();
            $stm->close();
            

            if(intval($objectAsParentID) > 0){
                $parentTree = "<table class='table table-bordered'><thead><tr><td>Icon</td><td>Name</td></tr></thead><tbody>";
                $stm = $db3->prepare("SELECT icon, name FROM ZC_Menu_Item_Object  WHERE parent_id = ? ORDER BY menu_item_object_id DESC");
                $stm->bind_param("i", $d);
                $stm->execute();
                $stm->bind_result($childIcon, $childName);
                while ($stm->fetch()) {
                    if((strpos($childIcon, 'fa-') === 0) ){
                        $parentTree .= "<tr><td><i class='fa $childIcon'></i></td><td>{$childName}</td></tr>";

                    }else if(empty($childIcon)){
                         $parentTree .= "<tr><td><i class='fa $defaultIcon'></i></td><td>{$childName}</td></tr>";
                    }
                    else{
                        $parentTree .= "<tr><td>{$childIcon}</td><td>{$childName}</td></tr>";

                    }
                }
                $parentTree .= "</tbody></table>";
                $stm->close();

                return "<b style='color:goldenrod;' rel='popover' data-trigger='hover' data-placement='bottom' data-original-title='<h4>Children Menu Items</h4>' data-content=\"$parentTree\" data-html='true'>Parent Element</b>";

            }
            
            $stm = $db3->prepare(" SELECT p.parent_id, p2.name FROM ZC_Menu_Item_Object p LEFT JOIN ZC_Menu_Item_Object p2 ON p.parent_id = p2.menu_item_object_id WHERE p.menu_item_object_id = ? LIMIT 1");          
            $stm->bind_param("i",  $d);
            $stm->execute();
            $stm->bind_result($currentParentID,$parentName);
            $stm->fetch();
            $stm->close();
            if(intval($currentParentID) == 0){
                $displayValue =  '-';
            }else if(!empty($parentName)){
                $displayValue = trim($parentName);
            }else{
                $stm = $db3->prepare("SELECT d.name  FROM ZC_Menu_Item_Object o INNER JOIN ZC_Menu_Item_Definition d ON o.menu_item_definition_id = d.menu_item_definition_id WHERE o.menu_item_object_id = ?;");   
                $stm->bind_param("i",  $currentParentID);
                $stm->execute();
                $stm->bind_result($defaultParentName);
                $stm->fetch();
                $stm->close();
                $displayValue=$defaultParentName;
            }


            //$dropdown  = "";
            $dropdown = "<div style='position: relative; cursor: pointer;' 
                     onmouseover='$(this).find(\".fa-pencil\").show();' 
                     onmouseleave='$(this).find(\".fa-pencil\").hide();' 
                     onclick='openEditField($menuItemObjID, \"$menuItemField\", this);'>
                         <span id='value-$menuItemField-$menuItemObjID'>$displayValue</span>
                         <input type='hidden' id='hiddenValue-$menuItemField-$menuItemObjID' value='$currentParentID'>
                         <span id='pen-$menuItemField-$menuItemObjID'>
                            <i class='fa fa-pencil' style='display:none; cursor:pointer; margin-left:4px;'></i>
                         </span>
                         </div>";

            $dropdown .= "<select class='form-control text-center' id='input-$menuItemField-$menuItemObjID' style='display:none;width:200px;'>";
            $dropdown .= "<option value='0' >-</option>";
            
            $stm = $db3->prepare(" SELECT o.menu_item_object_id, o.name, d.name FROM ZC_Menu_Item_Object o
                                INNER JOIN  ZC_Menu_Item_Definition d ON   o.menu_item_definition_id = d.menu_item_definition_id
                                WHERE NOT o.menu_item_object_id=? AND NOT o.parent_id=? AND o.parent_id=0 AND o.menu_id=? AND o.menu_item_definition_id>=100") ;
            $stm->bind_param("iii", $d,$d, $menuID);
            $stm->execute();
            $stm->bind_result($parentID,$name,$defaultName);
            while ($stm->fetch()) {
               $selected='';
                if($d ==$name){
                     $selected='selected';
                }
                if(empty($name)){
                    $name=$defaultName;
                }
               
                $dropdown .= "<option value='$parentID' $selected>" . htmlspecialchars($name) . "</option>";
                
            }
            $stm->close();
    
            $dropdown .= "</select>
                        <button id='save-$menuItemField-$menuItemObjID' class='btn btn-success' style='display:none;'>
                            <i class='fa fa-save' style='cursor:pointer; margin-left:4px;'></i>
                        </button>";
 
            return $dropdown;
            
        },
        'field' => 'menu_item_object_id'
    ),
    
    
    array(
        'db' => 'o.menu_item_definition_id',
        'dt' => 'form',
        'formatter' => function($d, $row) use ($menuID) {
    

            return '<button  id="action-btn-'.$menuID.'-'.$d.'" class="btn btn-danger" onclick="removeMenuItem('.$menuID.','. $d.')" style="width:100px">Remove</button>';
            
        },
        'field' => 'menu_item_definition_id'
    ),
);

// SQL server connection information
$sql_details = array(
    'user' => $username,
    'pass' => $password,
    'db'   => $database,
    'host' => 'localhost'
);

/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 * If you just want to use the basic configuration for DataTables with PHP
 * server-side, there is no need to edit below this line.
 */
$joinQuery = "FROM ZC_Menu_Item_Object AS o INNER JOIN ZC_Menu_Item_Definition AS d ON (o.menu_item_definition_id=d.menu_item_definition_id)";  
$where = 'menu_id = ' . intval($menuID);// Add any specific where clauses if needed

if (isset($_GET['parentItemFilter']) && strcmp($_GET['parentItemFilter'], "") != 0) {
    $filter = strtolower($_GET['parentItemFilter']);
    $parentElementsIds = [];
    $headerElementsIds = [];
    $childsMenuIds = [];
    $hasResults = false;

    if (strpos(strtolower("Parent"), $filter) !== false || strpos(strtolower("Element"), $filter) !== false) {
        $stm = $db3->prepare("SELECT DISTINCT parent.menu_item_object_id FROM ZC_Menu_Item_Object AS parent
                              INNER JOIN ZC_Menu_Item_Object AS child ON child.parent_id = parent.menu_item_object_id
                              WHERE parent.menu_id = ?");
        $stm->bind_param("i", $menuID);
        $stm->execute();
        $stm->bind_result($menu_item_object_id);
        
        while ($stm->fetch()) {
            $parentElementsIds[] = $menu_item_object_id;
            $hasResults = true;
        }
        $stm->close();
    }

    if (strpos(strtolower("Header"), $filter) !== false || strpos(strtolower("Element"), $filter) !== false) {
        $stm = $db3->prepare("SELECT DISTINCT menu_item_object_id FROM ZC_Menu_Item_Object WHERE menu_item_definition_id < 100 AND menu_id = ?");
        $stm->bind_param("i", $menuID);
        $stm->execute();
        $stm->bind_result($menu_item_object_id);

        while ($stm->fetch()) {
            $headerElementsIds[] = $menu_item_object_id;
            $hasResults = true;
        }
        $stm->close();
    }

    $filter = "%" . $filter . "%";
    $stm = $db3->prepare("SELECT DISTINCT c.menu_item_object_id 
                          FROM ZC_Menu_Item_Object AS p
                          INNER JOIN ZC_Menu_Item_Object AS c ON c.parent_id = p.menu_item_object_id
                          INNER JOIN ZC_Menu_Item_Definition AS d ON d.menu_item_definition_id = p.menu_item_definition_id
                          WHERE p.menu_id = ? 
                          AND p.name LIKE ? OR (p.name ='' AND d.name LIKE ?)"); // if its name is empty check the default name from definition
    $stm->bind_param("iss", $menuID, $filter,$filter);
    $stm->execute();
    $stm->bind_result($menu_item_object_id);

    while ($stm->fetch()) {
        $childsMenuIds[] = $menu_item_object_id;
        $hasResults = true;
    }
    $stm->close();

    if ($hasResults == true) {
        $menuIDsList = implode(',', array_unique(array_merge($parentElementsIds, $headerElementsIds, $childsMenuIds)));
        $where .= ' AND menu_item_object_id IN (' . $menuIDsList . ')';
    } else{
        $where .= " AND 1=0";
    }
}


require( ROOT.'backend/core/controllers/ssp2.class.php' );

echo json_encode(
    SSP::simple( $_GET, $sql_details, $table, $primaryKey, $columns, $joinQuery, $where )
);


?>