<?php

/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 * Easy set variables
 */
include_once('../../../../param.php');

// DB table to use
$table = 'ERP_Last_Prices';

// Table's primary key
$primaryKey = "erp_last_price_id";

// Array of database columns which should be read and sent back to DataTables.
// The db parameter represents the column name in the database, while the dt
// parameter represents the DataTables column identifier. In this case object
// parameter names
$columns = array(
    array(
        'db' => " CONCAT(c.customer_code,' - ',c.customer_company_name)",
        'dt' => 'customer',
        'field' => 'customer',
        'as'=>'customer'
    ),
    array(
        'db' => "CONCAT(i.item_code,' - ',i.name)",
        'dt' => 'item',
        'field' => 'item',
        'as'=>'item'
    ),
    array(
        'db' => 'e.price',
        'dt' => 'price',
        'field' => 'price'
    ),
    array(
        'db' => 'e.qty',
        'dt' => 'qty',
        'field' => 'qty'
    ),
    array(
        'db' => 'e.invoice_code',
        'dt' => 'invoice_code',
        'field' => 'invoice_code'
    ),
    array(
        'db' => "DATE_FORMAT(e.invoice_date, '%d-%m-%Y')",
        'dt' => 'invoice_date',
        'field' => 'invoice_date',
        'as'=>'invoice_date'
    ),
    array(
        'db' => "CONCAT(s.salesperson_code,' - ',s.first_name,' ',s.last_name)",
        'dt' => 'salesperson',
        'field' => 'salesperson',
        'as'=> 'salesperson'
    ),
    array(
        'db' => "e.timestamp",
        'dt' => 'timestamp',
        'field' => 'timestamp'
    )


);
global $username,$password,$database;
// SQL server connection information
$sql_details = array(
    'user' => $username,
    'pass' => $password,
    'db'   => $database,
    'host' => 'localhost'
);

/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 * If you just want to use the basic configuration for DataTables with PHP
 * server-side, there is no need to edit below this line.
 */
$joinQuery = "FROM ERP_Last_Prices AS e 
                LEFT JOIN Customers AS c ON e.customer_id = c.customer_id 
                LEFT JOIN Items AS i ON e.item_id = i.item_id 
                LEFT JOIN SalesPersons as s ON s.salesperson_id = e.salesperson_id
             ";
$where = '';


require( ROOT.'backend/core/controllers/ssp2.class.php' );

echo json_encode(
    SSP::simple( $_GET, $sql_details, $table, $primaryKey, $columns, $joinQuery, $where )
);

?>
