<?php
include_once('../../../../param.php');
include_once(ROOT . "concc/dbhelpers/dbhelper.php");

global $username,$password,$database;
$db = new mysqli(localhost,$username,$password,$database);
if (mysqli_connect_errno())
{
    printf("Connect failed: %s\n", mysqli_connect_error());
    exit();
}
$currentDate = date( 'Y-m-d', strtotime( 'today' ) );
$month = date("m",strtotime($currentDate));
$year = date("Y",strtotime($currentDate));

$arrayOfCompanies = array();
$stm = $db->prepare("SELECT company_id,company_code,company_name FROM Companies ");
$stm-> execute();
$stm-> bind_result($companyID,$companyCode,$companyName);
while ($stm->fetch()) {
    $objCompanies = new stdClass();
    $objCompanies->id = $companyID;
    $objCompanies->code = $companyCode;
    $objCompanies->name = $companyName;
    $objCompanies->month = $month;
    $objCompanies->year = $year;
    array_push($arrayOfCompanies,$objCompanies);
}
$stm-> close();
$myfileInsertJournals = fopen("insertJournals.txt", "w") or die("Unable to open file!");
fwrite($myfileInsertJournals,"Start Insert ".date('Y-m-d H:i:s')." \n");
fwrite($myfileInsertJournals,"--------------------------------------------------------------------------\n");
try {
    $db->begin_transaction();
    foreach ($arrayOfCompanies as $company){
        fwrite($myfileInsertJournals,"Start Insert -> " . $company->code." - ".$company->name." - ".$company->month." - ".$company->year." \n");
        $journalID = getNextKeySingleTransaction("Journals","journal_id",$db);
        $period = $company->month;
        $year = $company->year;
        $companyID = $company->id;
        $journalCode ="expenses_".$period."_".$year;
        $journalDate =  date("Y-m-d");
        $status = 'Pending';
        $stmt = $db->prepare("INSERT INTO Journals (journal_id,company_id,journal_code,year,period_id,journal_date,action_code,timestamp) VALUES(?,?,?,?,?,?,?,NOW())");
        $stmt->bind_param('iisssss',$journalID,$companyID,$journalCode,$year,$period,$journalDate,$status);
        $stmt->execute();
        if(strcmp($stmt->error,"")!=0) {throw new Exception("$stmt->error");}
        $stmt->close();
        fwrite($myfileInsertJournals,"Success Insert -> " . $company->code." - ".$company->name." \n");
        fwrite($myfileInsertJournals,"--------------------------------------------------------------------------\n");
    }
    fwrite($myfileInsertJournals,"Finish Insert -> " . count($arrayOfCompanies)." Journals \n");
    $db->commit(true);
} catch (Exception  $e) {
    $errorMsg = $e->getMessage();
    fwrite($myfileInsertJournals,"Faild Insert -> " .$errorMsg." Journals \n");
    $db->rollback();
}

?>