<?php
include_once("../../../../param.php");

global $username,$password,$database;
$db = new mysqli('localhost',$username,$password,$database);
if (mysqli_connect_errno()) {
    printf("Connect failed: %s\n", mysqli_connect_error());
    exit();
}
$db->set_charset("utf8");
$companiesSelection = '';
$stm = $db->prepare("SELECT CONCAT(company_code, ' - ',company_name), company_id FROM Companies");
$stm-> execute();
$stm-> bind_result($companyName, $companyID);
while ($stm->fetch()) {
    $companiesSelection .= "<option value='$companyID'>$companyName</option>";
}
$stm-> close();

$yearCurrent = date("Y");
$yearCurrent = $yearCurrent-1;
$selectYearCurrent ="";
$selectYearCurrent .= "<option value='$yearCurrent' selected>$yearCurrent</option>";
for($i=0; $i<=5; $i++){
    $yearCurrent++;
    $selectYearCurrent .= "<option value='$yearCurrent'>$yearCurrent</option>";
}

?>

<div id="main" role="main" class="background-color-whitish">

    <!-- Start CUSTOM CODE-->


    <!-- RIBBON -->
    <div id="ribbon" class="bg-color-blue">

				<span class="ribbon-button-alignment">
					<span id="refresh" class="btn btn-ribbon2" onclick="location.reload(true);" data-title="refresh" rel="tooltip" data-placement="bottom" data-original-title="<i class='text-warning fa fa-warning'></i> Reload Page?" data-html="true">
						<i class="fa fa-refresh"></i>
					</span>
				</span>

        <!-- breadcrumb -->
        <ol class="breadcrumb">
            <li class="txt-color-white">Finance / Report</li>
        </ol>
        <!-- end breadcrumb -->

    </div>
    <!-- END RIBBON -->

    <!-- MAIN CONTENT -->
    <div id="content">

        <div class="row">
            <div class="col-xs-12 col-sm-6 col-md-6 col-lg-6">
                <h3 style="display:inline;margin-left:10px;" class="page-title txt-color-blueDark header-margin">
                    <i class="fa-fw fa fa-signal"></i>
                    Finance Report
                </h3>
            </div>
        </div>

        <!-- row -->
        <section id="widget-grid" class="" style="margin-top:10px;">
            <!-- row -->
            <div class="row">

                <!-- NEW WIDGET START -->
                <article class="col-xs-12 col-sm-12 col-md-12 col-lg-12">

                    <div class="jarviswidget jarviswidget-color-blueDark" id="wid-id-001" data-widget-editbutton="false" data-widget-deletebutton="false">
                        <header>
                            <span class="widget-icon"> <i class="fa fa fa-table"></i> </span>
                            <h2>Finance Report Criteria</h2>
                        </header>
                        <!-- widget div-->
                        <div>
                            <!-- widget content -->
                            <div class="widget-body" style="overflow-x:scroll">
                                <label style="display: inline"><b>From:&nbsp;</b></label>
                                <select class="form-control" id="monthFrom" style="display: inline-block;width: 15%;">
                                    <option value="1" >Jan</option>
                                    <option value="2" >Feb</option>
                                    <option value="3" >Mar</option>
                                    <option value="4" >Apr</option>
                                    <option value="5" >May</option>
                                    <option value="6" >Jun</option>
                                    <option value="7" >Jul</option>
                                    <option value="8" >Aug</option>
                                    <option value="9" >Sept</option>
                                    <option value="10" >Oct</option>
                                    <option value="11" >Nov</option>
                                    <option value="12" >Dec</option>
                                </select>
                                <select class='form-control' id='yearFrom' style='display: inline-block;width: 15%;'>
                                    <?php
                                         echo $selectYearCurrent;
                                    ?>
                                </select>
                                <br><br>
                                <label style="display: inline"><b>To:&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;</b></label>
                                <select class="form-control" id="monthTo" style="display: inline-block;width: 15%;">
                                    <option value="1" >Jan</option>
                                    <option value="2" >Feb</option>
                                    <option value="3" >Mar</option>
                                    <option value="4" >Apr</option>
                                    <option value="5" >May</option>
                                    <option value="6" >Jun</option>
                                    <option value="7" >Jul</option>
                                    <option value="8" >Aug</option>
                                    <option value="9" >Sept</option>
                                    <option value="10" >Oct</option>
                                    <option value="11" >Nov</option>
                                    <option value="12" >Dec</option>
                                </select>
                                <select class='form-control' id='yearTo' style='display: inline-block;width: 15%;'>
                                <?php
                                    echo $selectYearCurrent;
                                ?>
                                </select>
                                <br><br>
                                <div>
                                    <input type="radio" id="multipleBranches" name="optionsFinanceReport" value="byBranches" checked />
                                    <label for="multipleBranches"><b>By Branches</b></label>
                                </div>

                                <div>
                                    <input type="radio" id="bydateRadio" name="optionsFinanceReport" value="byDate" />
                                    <label for="bydateRadio"><b>Period Range</b></label>
                                </div>

                                <div>
                                    <input type="radio" id="byExpensesLinesRadio" name="optionsFinanceReport" value="byExpensesLines" />
                                    <label for="byExpensesLinesRadio"><b>By Expenses Lines</b></label>
                                </div>
<!--                                BY BRANCHES-->
                                <div id="multipleBranchesElement" style="display: block;">
                                    <label style="display: block; margin-top: 10px"><b>Select Branches:</b></label>
                                    <select name="companies" id="byBranches" class="form-control" style="width: 50%" multiple="multiple">
                                        <?php echo $companiesSelection; ?>
                                    </select>
                                </div>
<!--                                BY date-->
                                <div id="branchesElement" style="display: none;">
                                    <label style="display: block; margin-top: 10px"><b>Select Branche:</b></label>
                                    <select name="companies" id="byDate" class="form-control" style="width: 50%" >
                                        <?php echo $companiesSelection; ?>
                                    </select>
                                </div>
<!--                                BY LINES -->
                                <div id="financeLinesElement" style="display: none;">
                                    <label style="display: block; margin-top: 10px"><b>Select Branche:</b></label>
                                    <select name="companies" id="byExpensesLines" class="form-control" style="width: 50%" >
                                        <?php echo $companiesSelection; ?>
                                    </select>
                                </div>
                                <br>
                                <br>

                                <button type="button" name="generateReport" id="generateReport" class="btn btn-primary" onclick="getReport()" >Generate Report</button>
                                <button type="button" name="generateExcel"  id="generateExcel"  class="btn btn-waybill" onclick="exportXLS()" >Export to Excel</button>
                            </div>
                            <!-- end widget content -->

                        </div>
                        <!-- end widget div -->

                    </div>
                    <!-- end widget -->
                </article>
                <!-- NEW WIDGET END -->

                <!-- NEW WIDGET START -->
                <article class="col-xs-12 col-sm-12 col-md-12 col-lg-12">

                    <div class="jarviswidget jarviswidget-color-blueDark" id="wid-id-100" data-widget-editbutton="false" data-widget-deletebutton="false">
                        <header>
                            <span class="widget-icon"> <i class="fa fa fa-table"></i> </span>
                            <h2>Finance Report</h2>
                        </header>
                        <!-- widget div-->
                        <div>
                            <!-- widget content -->
                            <div class="widget-body" style="overflow-x:scroll">

                                <div name="reportResult" id="reportResult"></div>
                                <form method="POST" action="#" name="xlsForm" id="xlsForm" >
                                    <input type="hidden" name="inputResult" id="inputResult" value=""/>
                                    <input type="hidden" name="inputTitle" id="inputTitle" value="FinanceReport"/>
                                </form>

                            </div>
                            <!-- end widget content -->

                        </div>
                        <!-- end widget div -->

                    </div>
                    <!-- end widget -->
                </article>
                <!-- NEW WIDGET END -->

            </div>


    </div>
    <!-- end widget content -->

    <!-- end row -->
    </section>

</div>

<script type="text/javascript">
    $('input[type=radio][name=optionsFinanceReport]').change(function() {
        if (this.value == 'byBranches'){
            $("#multipleBranchesElement").css("display", "block");
            $("#branchesElement").css("display", "none");
            $("#financeLinesElement").css("display", "none");
        }else if(this.value == 'byDate'){
            $("#branchesElement").css("display", "block");
            $("#financeLinesElement").css("display", "none");
            $("#multipleBranchesElement").css("display", "none");
        }else{
            $("#financeLinesElement").css("display", "block");
            $("#branchesElement").css("display", "none");
            $("#multipleBranchesElement").css("display", "none");
        }
    });


    $(document).ready(function() {
        pageSetUp();
        $('#byBranches').select2();
        $('#byDate').select2();
        $('#byExpensesLines').select2();
    });

    function getReport(){
        var checkCallReport = true;
        var monthFrom = $('#monthFrom').val();
        var monthTo = $('#monthTo').val();
        var yearFrom = $('#yearFrom').val();
        var yearTo = $('#yearTo').val();
        var typeReport = $('input[name=optionsFinanceReport]:checked').val();
        var companies = $('#'+typeReport).val();

        console.log('Month From:'+monthFrom);
        console.log('Year From:'+yearFrom);
        console.log('Month To:'+monthTo);
        console.log('Year To:'+yearTo);
        console.log('Type :'+typeReport);
        console.log('Companies :'+companies);

        if(companies===null){
            checkCallReport = false;
        }

        // if ((yearTo < yearFrom) || (monthFrom > monthTo &&  yearTo === yearFrom)){
        //     checkCallReport = false;
        // }
        //
        if ((yearTo < yearFrom)){
            checkCallReport = false;
        }

        if (checkCallReport){
            $('#reportResult').html('<center><b>Generating Report..</b></center>');
            $.ajax({
                type: "POST",
                url: '//<?php echo HTML_PATH ?>/cop/backend/modules/expenses/controllers/generateFinanceReportBranches.php',
                data: {
                    'monthFrom':monthFrom,
                    'yearFrom':yearFrom,
                    'monthTo':monthTo,
                    'yearTo':yearTo,
                    'typeReport':typeReport,
                    'companies':companies
                },
                success: function (result) {
                    $('#reportResult').html(result);
                }
            });
        }else{
            $.smallBox({
                title: "Failed!",
                content: "Something went wrong please select correct filter and try again.",
                color: '#b22222',
                timeout: 3000,
                icon: "fa fa-user swing animated"
            });
        }


    }

    function exportXLS(){
        var checkCallReport = true;
        var monthFrom = $('#monthFrom').val();
        var monthTo = $('#monthTo').val();
        var yearFrom = $('#yearFrom').val();
        var yearTo = $('#yearTo').val();
        var typeReport = $('input[name=optionsFinanceReport]:checked').val();
        var companies = $('#'+typeReport).val();

        console.log('Month From:'+monthFrom);
        console.log('Year From:'+yearFrom);
        console.log('Month To:'+monthTo);
        console.log('Year To:'+yearTo);
        console.log('Type :'+typeReport);
        console.log('Companies :'+companies);

        if(companies===null){
            checkCallReport = false;
        }

        // if ((yearTo < yearFrom) || (monthFrom > monthTo &&  yearTo === yearFrom)){
        //     checkCallReport = false;
        // }
        //
        if ((yearTo < yearFrom)){
            checkCallReport = false;
        }

        if (checkCallReport){
            $('#reportResult').html('<center><b>Generating Report..</b></center>');
            $.ajax({
                type: "POST",
                url: '//<?php echo HTML_PATH ?>/cop/backend/modules/expenses/controllers/generateFinanceReportBranches.php',
                data: {
                    'monthFrom':monthFrom,
                    'yearFrom':yearFrom,
                    'monthTo':monthTo,
                    'yearTo':yearTo,
                    'typeReport':typeReport,
                    'companies':companies
                },
                success: function (result) {
                    $('#reportResult').html(result);
                    $('#inputResult').val(result);
                    $('#xlsForm').attr('action','//<?php echo HTML_PATH ?>/cop/backend/core/templates/xls/generateGeneralXLS.php').submit();
                }
            });
        }else{
            $.smallBox({
                title: "Failed!",
                content: "Something went wrong please select correct filter and try again.",
                color: '#b22222',
                timeout: 3000,
                icon: "fa fa-user swing animated"
            });
        }


    }



</script>


