<?php
include_once("../../../../param.php");
include_once(ROOT . "concc/dbhelpers/dbhelper.php");
require_once(ROOT . "backend/core/model/CustomTable.php");
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ERROR);

$customerID              = trim($_POST['customerID']);
$salespersonID           = trim($_POST['salespersonID']);
$technicianID            = trim($_POST['technicianID']);
$validFrom               = trim($_POST['contractValidFrom']);
$validUntil              = trim($_POST['contractValidUntil']);
$details                 = trim($_POST['details']);
$detailsExtra            = trim($_POST['detailsExtra']);
$notes                   = trim($_POST['notes']);
$notesExtra              = trim($_POST['notesExtra']);
$contractTitle            = trim($_POST['contractTitle']);
$contractTypeID            = trim($_POST['typeOfContract']);


global $username,$password,$database;
$db = new mysqli(localhost,$username,$password,$database);
if (mysqli_connect_errno())
{
    printf("Connect failed: %s\n", mysqli_connect_error());
    exit();
}
$db->set_charset("utf8");

try {
    $db->begin_transaction();

    $contractID         = getNextKeySingleTransaction("Group_Contract_Header", "group_contract_header_id", $db);
    $groupContractCode  = getNextCodeSingleTransaction("Group_Contract_Header", "group_contract_header_code", "C", "CLOUD", $db);



    if (isset($validFrom) && strcmp("$validFrom", "") != 0) {
        $date = DateTime::createFromFormat('d/m/Y', $validFrom);
        $validFrom = $date->format('Y-m-d');
    }

    if (isset($validUntil) && strcmp("$validUntil", "") != 0) {
        $date = DateTime::createFromFormat('d/m/Y', $validUntil);
        $validUntil = $date->format('Y-m-d');
    }

    
    $itemID = 0;
    $serialNumberID = 0;
    $customerAddressID = 0;
    $title = "$contractTitle";
    $status = 'Pending';
    $stmt = $db->prepare("INSERT INTO Group_Contract_Header (group_contract_header_id,group_contract_header_code,customer_id,salesperson_id,technician_id,contract_type_id,item_id,serial_number_id,customer_address_id,title,valid_from,valid_until,status,details,details_2,notes,notes_2,creation_date,timestamp) VALUES(?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, NOW(), NOW())");
    $stmt->bind_param(
        'ssiiiiiiissssssss',
        $contractID,
        $groupContractCode,
        $customerID,
        $salespersonID,
        $technicianID,
        $contractTypeID,
        $itemID,
        $serialNumberID,
        $customerAddressID,
        $title,
        $validFrom,
        $validUntil,
        $status,
        $details,
        $detailsExtra,
        $notes,
        $notesExtra
    );
    $stmt->execute();
    if(strcmp("$stmt->error","")!=0) {throw new Exception();}
    $stmt->close();

    $custTable = new CustomTable('Group_Contract_Header', $contractID);
    $codes = array();
    $codes = $custTable->getCustomTableCodes($db);
    foreach ($codes as $code) {
        $custTable->insertVariablesToCustomTable($_POST[$code->formCode], $code->tableCode, $db);
    }

    $db->commit(true);

    echo $contractID;

} catch (Exception  $e) {
    echo 'error '.$e->getMessage().' '.$e->getLine();
//    echo $e->getMessage();
    $db->rollback();

}

?>