<?php
use PhpOffice\PhpSpreadsheet\Spreadsheet;
use PhpOffice\PhpSpreadsheet\Writer\Xlsx;
use PhpOffice\PhpSpreadsheet\Reader\Html;
include_once("../../../../param.php");
require_once (ROOT . "libs/phpSpreadsheet/vendor/autoload.php");
include_once(ROOT . "concc/dbhelpers/classes/DBItem.php");
$dbHelperItem= new DBItem();


$contractGroupHeaderID      = $_POST['group_contract_header_id'];
$contractGroupHeaderCode    = $_POST['group_contract_header_code'];

$htmlCode                   = getHtmlCode($contractGroupHeaderID,$contractGroupHeaderCode,$dbHelperItem);
exportExcel($htmlCode,$contractGroupHeaderCode);


function getHtmlCode($contractGroupHeaderID,$contractGroupHeaderCode,$dbHelperItem){
    global $username,$password,$database;
    $db = new mysqli(localhost,$username,$password,$database);
    if (mysqli_connect_errno())
    {
        printf("Connect failed: %s\n", mysqli_connect_error());
        exit();
    }
    $db->set_charset("utf8");



    $stm = $db->prepare("SELECT  d.group_contract_doc_id,  d.valid_from, d.valid_until, l.item_id,  SUM((l.qty * l.unit_price) - l.line_discount - l.global_discount) AS total_price
        FROM Group_Contracts_Documents_Lines l INNER JOIN Group_Contracts_Documents d  ON l.group_contract_doc_id = d.group_contract_doc_id
        WHERE d.group_contract_header_id = ?
        GROUP BY d.group_contract_doc_id, l.item_id
        ORDER BY d.valid_from ASC");
    $stm->bind_param("i", $contractGroupHeaderID);
    $stm->execute();
    $stm->bind_result($groupContractDocID, $validFrom, $validUntil, $itemID, $totalPrice);
    $itemTotals = [];
    $documentPeriods = [];

    while ($stm->fetch()) {


        // use for sorting purposes
        if (!isset($documentPeriods[$groupContractDocID])) {
            $documentPeriods[$groupContractDocID] = [
                'valid_from' => $validFrom,
                'valid_until' => $validUntil,
                'doc_id' => $groupContractDocID,
            ];
        }

        $itemTotals[$itemID][$groupContractDocID] = $totalPrice;


    }
    $stm->close();



    //sort periods
    usort($documentPeriods, function ($a, $b) {
        $dateA = strtotime($a['valid_from']);
        $dateB = strtotime($b['valid_from']);

        if ($dateA == $dateB) {
            return 0;
        } elseif ($dateA > $dateB) {
            return 1;
        } else {
            return -1;
        }
    });
    $htmlString ="<style>
  

</style>
";



    $htmlString .= '<table style="border-collapse: collapse; width: 100%; ">';
    $htmlString .= '<thead>
                    <tr style=" font-weight: bold;">
                        <th style="border: 1px solid black;text-align: center; padding: 8px;vertical-align: middle;"><b>A/A</b></th>
                        <th style="border: 1px solid black;text-align: center; padding: 8px;vertical-align: middle;"><b>Description</b></th>
                        <th style="border: 1px solid black;text-align: center; padding: 8px;vertical-align: middle;"><b>Service Frequency</b></th>';

    foreach ($documentPeriods as $doc) {
        $startDate = new DateTime($doc['valid_from']);
        $endDate = new DateTime($doc['valid_until']);
        $formattedStart = $startDate->format('d/m/y');
        $formattedEnd = $endDate->format('d/m/y');
        $period = "{$formattedStart} - {$formattedEnd}";

        $htmlString .= "<th style='border: 1px solid black; text-align: center; padding: 8px;'><b>$period<br>Price Euro<br>Excl. V.A.T </b></th>";
    }

    $htmlString .= '</tr></thead><tbody>';

    $counter = 1;
    $totalAll = array();

    foreach ($itemTotals as $itemID => $periodTotal) {
        $item =  $dbHelperItem->getItemByID($itemID);
        $description = $item->name . " - ". $item->itemCode;
        $serviceFrequency =  $item->notes;
        $htmlString .= "<tr>";
        $htmlString .= "<td style='border: 1px solid black; text-align: center;padding: 8px;'>$counter</td>";
        $htmlString .= "<td style='border: 1px solid black; text-align: left;padding: 8px;'>$description</td>";
        $htmlString .= "<td style='border: 1px solid black; text-align: center;padding: 8px;'>$serviceFrequency</td>";

        foreach ($documentPeriods as $doc) {
            $docID = $doc['doc_id'];
            $total = $periodTotal[$docID];
            $total=number_format($total, 2, '.', '');
            $htmlString .= "<td style='border: 1px solid black;text-align: center; padding: 8px;'>$total</td>";

            if (!isset($totalAll[$docID])) {
                $totalAll[$docID] = 0;
            }
            $totalAll[$docID] += floatval($total);
        }

        $htmlString .= '</tr>';
        $counter++;
    }

    $htmlString .= "<tr >";
    $htmlString .= "<td style='border: 1px solid black;text-align: center; padding: 8px;'></td>
                <td style='border: 1px solid black;text-align: left; padding: 8px;'><b>TOTAL:</b></td>
                <td style='border: 1px solid black;text-align: center; padding: 8px;'></td>";

    foreach ($documentPeriods as $doc) {
        $docID = $doc['doc_id'];
        $htmlString .= "<td style='border: 1px solid black;text-align: center; padding: 8px;'>$totalAll[$docID]</td>";
    }

    $htmlString .= "</tr>";

    $htmlString .= '</tbody></table>';

    //notes section
    $htmlString .= "<table>";
    $htmlString .= "<tr><td  style='font-family: Cambria; font-size: 8pt; '>*NOTE 1: The above works will be scheduled during working hours.</td></tr>";
    $htmlString .= "<tr><td  style='font-family: Cambria; font-size: 8pt; '>*NOTE 2: All materials needed for corrective maintenance will be charged, and a relevant quotation will be sent for approval. (ACCORDING TO APPENDIX B)</td></tr>";
    $htmlString .= "<tr><td  style='font-family: Cambria; font-size: 8pt; '>*NOTE 3: In case of any malicious damage or damages caused by external factors (e.g., thunderbolt, water leakage), the above terms will not apply, and the corrective maintenance will be charged.</td></tr>";
    $htmlString .= "<tr><td style='font-family: Cambria; font-size: 8pt; '> *NOTE 4: Labour and materials for any NEW electrical works and NEW works for the electrical systems during the maintenance period are not included.</td></tr>";
    $htmlString .= "<tr><td  style='font-family: Cambria; font-size: 8pt; '>*NOTE 5: VAT is not included.</td></tr>";
    $htmlString .= "</table>";

    // signature section
    $htmlString .= "<table >";
    $htmlString .= "<tr >
                    <td  style='font-family: Cambria; font-size: 10pt; '>Client's Acceptance and Stamp:..........................................</td>
                    <td  style='font-family: Cambria; font-size: 10pt; '>Service Provider's Signature & Stamp:......................................</td>
                </tr>";
    $htmlString .= "<tr>
                    <td ></td>
                    <td ></td>
                </tr>";
    $htmlString .= "<tr>
                    <td  style='font-family: Cambria; font-size: 10pt; ' >Date:.................................................</td>
                    <td  style='font-family: Cambria; font-size: 10pt; '>Date:.................................................</td>
                </tr>";
    $htmlString .= "</table>";

    $title = '';
//    $logoDirectory = "//" . HTML_PATH . "/cop/media/pdfimage/logo.png";
//    $logoDirectory.= "?".time();
//    $title .="<htmlpageheader name='myHTMLHeader1'>
//                  <table class='heading' style='width: 100%'>
//                  <tr>
//                  <td valign='top' style='width:30%'>
//                      <img style='display:block;max-width: 200px;' src='$logoDirectory'/>
//                  </td>
//                   </tr>
//                  </table>
//
//                </htmlpageheader> ";
    $colspan=(count($documentPeriods) + 3);
    $GLOBALS['tableRows'] = count($itemTotals)+1; //(includes total row)
    $GLOBALS['tableColumns'] = (count($documentPeriods) + 3);
    $title .= "<table style='width: 100%;'>";
    $title .= "<tr><td colspan=' $colspan' style='text-align: center; font-weight: bold;'><h4>APPENDIX A</h4></td></tr>";
    $title .= "<tr><td colspan='$colspan ' style='text-align: center; font-weight: bold;'><h4>PREVENTIVE MAINTENANCE SCHEDULE - RITZ CARLTON</h4></td></tr>";
    $title .= "</table>";
    return $title.$htmlString;

}

function exportExcel($htmlString,$contractGroupHeaderCode){
    $spreadsheet = new Spreadsheet();
    $reader = new Html();
    $spreadsheet = $reader->loadFromString($htmlString);


    $endColumn = getColumnLetter($GLOBALS['tableColumns']);
    $startRow = 4;
    $endRow = $startRow +  $GLOBALS['tableRows'] ;
    $tableRange = "A$startRow:$endColumn$endRow";

    $spreadsheet->getActiveSheet()->getColumnDimension('A')->setWidth(10);
    $spreadsheet->getActiveSheet()->getColumnDimension('B')->setWidth(80);
    $spreadsheet->getActiveSheet()->getColumnDimension('C')->setWidth(25);

    foreach (range('D', $spreadsheet->getActiveSheet()->getHighestDataColumn()) as $col) {
        $spreadsheet->getActiveSheet()->getColumnDimension($col)->setWidth(20);
    }



    $spreadsheet->getActiveSheet()->getStyle($tableRange)->getBorders()->getAllBorders()
        ->setBorderStyle(\PhpOffice\PhpSpreadsheet\Style\Border::BORDER_MEDIUM)
        ->getColor()->setRGB('000000');

    $highestColumn = $spreadsheet->getActiveSheet()->getHighestColumn();
    $spreadsheet->getActiveSheet()->getStyle("D:$highestColumn")->getNumberFormat()->setFormatCode('0.00');



    $writer = new Xlsx($spreadsheet);


    ob_end_clean();
    $fileName = $contractGroupHeaderCode."_export.xlsx";
    header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
    header('Content-Disposition: attachment;filename="' . time() . '_' . $fileName . '"');
    header('Cache-Control: max-age=0');

    echo $writer->save('php://output');

}
function getColumnLetter($columnIndex) {
    $letter = '';
    while ($columnIndex > 0) {
        $columnIndex--;
        $letter = chr($columnIndex % 26 + 65) . $letter;
        $columnIndex = intval($columnIndex / 26);
    }
    return $letter;
}

?>