<?php

/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 * Easy set variables
 */
include_once('../../../../param.php');
// DB table to use
$table = 'Group_Contracts_Documents';

// Table's primary key
$primaryKey = "group_contract_doc_code";

// Array of database columns which should be read and sent back to DataTables.
// The `db` parameter represents the column name in the database, while the `dt`
// parameter represents the DataTables column identifier. In this case object
// parameter names
$columns = array(
    array( 'db' => '`gd`.`group_contract_header_id`', 'dt' => 'id', 'formatter' => function( $d, $row ) {
        $GLOBALS['group_contract_header_id']=$d;
        return '';}, 'field' => 'group_contract_header_id' ),
    array( 'db' => '`gd`.`group_contract_doc_code`', 'dt' => 'image', 'formatter' => function( $d, $row ) {
        return '<img class="custom-rounded-image-padding " style="background-color: #c5b07b !important;display:inline;" src="//' . HTML_PATH . '/cop/backend/themes/' . THEME_NAME . '/img/visiticon.png" width="30" height="30">';},
        'field' => 'group_contract_doc_code' ),


    array( 'db' => '`gd`.`group_contract_doc_code`', 'dt' =>  'code', 'field' =>'group_contract_doc_code' ),
    array( 'db' => '`c`.`customer_code`', 'dt' => 'cus_code', 'field' => 'customer_code' ),
    array( 'db' => '`c`.`customer_company_name`', 'dt' => 'cus_name', 'field' => 'customer_company_name' ),

    array( 'db' => '`gd`.`grand_total`', 'dt' => 'grandtotal', 'formatter' => function( $d, $row ) {
        return $GLOBALS['currencySymbol'] . number_format($d,2);},
        'field' => 'grand_total' ),
    array( 'db' => '`gd`.`subtotal`', 'dt' => 'subtotal', 'formatter' => function( $d, $row ) {
        return $GLOBALS['currencySymbol'] . number_format($d,2);},
        'field' => 'subtotal' ),


    array( 'db' => '`s`.`salesperson_code`', 'dt' => 'salesperson',

        'formatter' => function( $d, $row ) {


            global $username;
            global $password;
            global $database;
            $db1 = new mysqli(localhost,$username,$password,$database);
            if (mysqli_connect_errno()) {
                printf("Connect failed: %s\n", mysqli_connect_error());
                exit();
            }

            $db1->set_charset("utf8");
            $stm1 = $db1->prepare("SELECT first_name,last_name FROM SalesPersons WHERE salesperson_code='$d'");
            $stm1-> execute();
            $stm1-> bind_result($fname,$lname);
            while ($stm1->fetch()) {

            }
            $stm1->close();

            return "$d - $fname $lname";
        },
        'field' => 'salesperson_code' ),

    array( 'db' => '`gd`.`contract_date`', 'dt' => 'date' , 'formatter' => function( $d, $row ) {
        return date('d-m-Y',strtotime($d));},'field' => 'contract_date' ),
    array( 'db' => '`gd`.`valid_from`', 'dt' => 'valid_from' , 'formatter' => function( $d, $row ) {
        return date('d-m-Y',strtotime($d));},'field' => 'valid_from' ),
    array( 'db' => '`gd`.`valid_until`', 'dt' => 'valid_until' , 'formatter' => function( $d, $row ) {
        return date('d-m-Y',strtotime($d));},'field' => 'valid_until' ),

    array( 'db' => '`gd`.`status`', 'dt' => 'status', 'field' => 'status' ),
    array( 'db' => '`gd`.`status`', 'dt' => 'status', 'formatter' => function( $d, $row ) {
        $GLOBALS['status'] = $d;
        return $d;
        },'field' => 'status' ),

    array( 'db' => '`gd`.`group_contract_doc_id`', 'dt' => 'actions', 'formatter' => function( $d, $row ) {
        $contractHeaderID = $GLOBALS['group_contract_header_id'];
        $statusDocument = $GLOBALS['status'];

        if (strcmp($statusDocument,'Winning')==0){
            $organizeInvoiceDraft = "";
            $displayEdit = "display:none";
            $organizeInvoiceDraft = "<button type='button' class='btn btn-return' style='margin:1px;' onclick='organizeInvoicesDraft($d);'>Organize Invoices</button>";
        }else{
            $organizeInvoiceDraft = "";
            $displayEdit = "";
            $organizeInvoiceDraft = "<button type='button' class='btn btn-return' style='margin:1px;' onclick='organizeInvoicesDraft($d);'>Organize Invoices</button>";
        }

        return '<form style="display:inline;" target="_blank" id="'.$d.'" action="//'.HTML_PATH .'/cop/backend/modules/groupContracts/views/view_group_contract_document.php" method="post">
           		<input type="hidden" name="group_contract_doc_id" value="'.$d.'">	           			                   
			<input style="font-size:13px;" type="submit" class="btn btn-primary" value="View Document" style="width:60px">
			</form>
			<form style="display:inline;'.$displayEdit.'" target="_blank" class="tableRowForm" id="'.$d.'" action="//'.HTML_PATH .'/cop/backend/modules/groupContracts/views/create_group_contract_document.php" method="post">
           		<input type="hidden" class="group_contract_doc_id" name="group_contract_doc_id" value="'.$d.'">
           		<input type="hidden" class="group_contract_header_id" name="group_contract_header_id" value="'.$contractHeaderID.'">
			<input style="font-size:13px;" type="submit" class="btn btn-invoice" value="Edit Document">
			</form>	
			'.$organizeInvoiceDraft;},
        'field' => 'group_contract_doc_id' )
);

// SQL server connection information
global  $username,$password,$database;
$sql_details = array(
    'user' => $username,
    'pass' => $password,
    'db'   => $database ,
    'host' => 'localhost'
);
$where = '';
if (isset($_GET['group_contract_header_id'])){
    $groupContractHeaderID = $_GET['group_contract_header_id'];
    $where .= "  group_contract_header_id= $groupContractHeaderID ";
}
/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 * If you just want to use the basic configuration for DataTables with PHP
 * server-side, there is no need to edit below this line.
 */
$joinQuery = "FROM `Group_Contracts_Documents` AS `gd` LEFT JOIN `Customers` AS `c` ON (`gd`.`customer_id` = `c`.`customer_id`) LEFT JOIN `SalesPersons` AS `s` ON (`gd`.`salesperson_id` = `s`.`salesperson_id`)";
require( ROOT.'backend/core/controllers/ssp2.class.php' );

echo json_encode(
    SSP::simple( $_GET, $sql_details, $table, $primaryKey, $columns,$joinQuery,$where)
);

?>