<?php

/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 * Easy set variables
 */
include_once('../../../../param.php');
// DB table to use
$table = 'Group_Contract_Header';

// Table's primary key
$primaryKey = "group_contract_header_code";

// Array of database columns which should be read and sent back to DataTables.
// The `db` parameter represents the column name in the database, while the `dt`
// parameter represents the DataTables column identifier. In this case object
// parameter names
$columns = array(
    array( 'db' => '`g`.`group_contract_header_id`', 'dt' => 'id', 'formatter' => function( $d, $row ) {
        $GLOBALS['group_contract_header_id']=$d;
        return '';}, 'field' => 'group_contract_header_id' ),
    array( 'db' => '`g`.`group_contract_header_code`', 'dt' => 'image', 'formatter' => function( $d, $row ) {
        return '<img class="custom-rounded-image-padding " style="background-color: #c5b07b !important;display:inline;" src="//' . HTML_PATH . '/cop/backend/themes/' . THEME_NAME . '/img/visiticon.png" width="30" height="30">';},
        'field' => 'group_contract_header_code' ),


    array( 'db' => '`g`.`title`', 'dt' =>  'title', 'field' =>'title' ),
    array( 'db' => '`g`.`notes`', 'dt' =>  'notes', 'field' =>'notes' ),
    array( 'db' => '`g`.`group_contract_header_code`', 'dt' =>  'code', 'field' =>'group_contract_header_code' ),
    array( 'db' => '`c`.`customer_code`', 'dt' => 'cus_code', 'field' => 'customer_code' ),
    array( 'db' => '`c`.`customer_company_name`', 'dt' => 'cus_name', 'field' => 'customer_company_name' ),




    array( 'db' => '`s`.`salesperson_code`', 'dt' => 'salesperson',

        'formatter' => function( $d, $row ) {


            global $username;
            global $password;
            global $database;
            $db1 = new mysqli(localhost,$username,$password,$database);
            if (mysqli_connect_errno()) {
                printf("Connect failed: %s\n", mysqli_connect_error());
                exit();
            }

            $db1->set_charset("utf8");
            $stm1 = $db1->prepare("SELECT first_name,last_name FROM SalesPersons WHERE salesperson_code='$d'");
            $stm1-> execute();
            $stm1-> bind_result($fname,$lname);
            while ($stm1->fetch()) {

            }
            $stm1->close();

            return "$d - $fname $lname";
        },
        'field' => 'salesperson_code' ),

    array( 'db' => '`g`.`technician_id`', 'dt' => 'technician',

        'formatter' => function( $d, $row ) {


            global $username;
            global $password;
            global $database;
            $db1 = new mysqli(localhost,$username,$password,$database);
            if (mysqli_connect_errno()) {
                printf("Connect failed: %s\n", mysqli_connect_error());
                exit();
            }

            $db1->set_charset("utf8");
            $stm1 = $db1->prepare("SELECT first_name,last_name FROM SalesPersons WHERE salesperson_id='$d'");
            $stm1-> execute();
            $stm1-> bind_result($fname,$lname);
            while ($stm1->fetch()) {

            }
            $stm1->close();

            return "$d - $fname $lname";
        },
        'field' => 'technician_id' ),
    array( 'db' => '`g`.`valid_from`', 'dt' => 'valid_from' , 'formatter' => function( $d, $row ) {
        return date('d-m-Y',strtotime($d));},'field' => 'valid_from' ),
    array( 'db' => '`g`.`valid_until`', 'dt' => 'valid_until' , 'formatter' => function( $d, $row ) {
        return date('d-m-Y',strtotime($d));},'field' => 'valid_until' ),

    array( 'db' => '`g`.`status`', 'dt' => 'status', 'field' => 'status' ),

    array( 'db' => '`g`.`group_contract_header_id`', 'dt' => 'actions', 'formatter' => function( $d, $row ) {
        return '
        <div style="display: flex">
         <form style="display:inline;" target="_blank" id="'.$d.'" action="//'.HTML_PATH .'/cop/backend/modules/groupContracts/views/manage_group_contract_child.php" method="post">
           		<input type="hidden" name="group_contract_header_id" value="'.$d.'">	           			                   
			<input style="font-size:13px;" type="submit" class="btn btn-warning" value="Contract Analysis" style="width:60px">
			</form>
			<form style="display:inline;" target="_blank" class="tableRowForm" id="'.$d.'" action="//'.HTML_PATH .'/cop/backend/modules/groupContracts/views/create_group_contract_header.php" method="post">
           		<input type="hidden" class="group_contract_header_id" name="group_contract_header_id" value="'.$d.'">
			<input style="font-size:13px;" type="submit" class="btn btn-invoice" value="Edit Contract">
			</form>	
</div>
       
			';},
        'field' => 'group_contract_header_id' )
);

// SQL server connection information
global  $username,$password,$database;
$sql_details = array(
    'user' => $username,
    'pass' => $password,
    'db'   => $database ,
    'host' => 'localhost'
);
$where = " `g`.title LIKE 'YTM_PROJECT_%' ";

/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 * If you just want to use the basic configuration for DataTables with PHP
 * server-side, there is no need to edit below this line.
 */
$joinQuery = "FROM `Group_Contract_Header` AS `g` LEFT JOIN `Customers` AS `c` ON (`g`.`customer_id` = `c`.`customer_id`) LEFT JOIN `SalesPersons` AS `s` ON (`g`.`salesperson_id` = `s`.`salesperson_id`)";
require( ROOT.'backend/core/controllers/ssp2.class.php' );

echo json_encode(
    SSP::simple( $_GET, $sql_details, $table, $primaryKey, $columns,$joinQuery,$where)
);

?>