<?php
//ini_set('display_errors', 1);
//ini_set('display_startup_errors', 1);
//error_reporting(E_ALL);
include_once('../../../../param.php');
// DB table to use
$table = 'Z_Z_Logistics';

// Table's primary key
$primaryKey = "logistics_id";

// Array of database columns which should be read and sent back to DataTables.
// The `db` parameter represents the column name in the database, while the `dt`
// parameter represents the DataTables column identifier. In this case object
// parameter names
$columns = array(
    array( 'db' => '`l`.`logistics_id`', 'dt' => 'logo', 'formatter' => function( $d, $row ) {
        return '<i class="fa fa-lg fa-fw fa-map-marker text-color-black"></i></td>';},
        'field' => 'logistics_id' ),

    array( 'db' => '`l`.`date`', 'dt' => 'date', 'formatter' => function( $d, $row ) {
        $GLOBALS['logistic_date'] = $d;
        if(strcmp($d,'0000-00-00') == 0){
            return "";
        } else {
            return date('d-m-Y',strtotime($d));}
    },'field' => 'date' ),
    array( 'db' => '`l`.`type`', 'dt' => 'type', 'formatter' => function( $d, $row ) {
        $GLOBALS['logistic_type'] = $d;
        return $d;
    },'field' => 'type' ),

    array( 'db' => '`l`.`status`', 'dt' => 'status', 'field' => 'status' ),

    array( 'db' => '`l`.`logistics_id`', 'dt' => 'actions', 'formatter' => function( $d, $row ) {
        $logisticDate = $GLOBALS['logistic_date'];
        $logisticType = $GLOBALS['logistic_type'];
        return '<form style="display:inline;" target="_blank" class="tableRowForm" id="'.$d.'" action="//'.HTML_PATH .'/cop/backend/modules/logistics/views/logistics.php" method="post">
                    <input type="hidden"  name="logistic_date" value="'.$logisticDate.'">
                    <input type="hidden"  name="logistic_type" value="'.$logisticType.'">
                    <input style="font-size:13px;" type="submit" class="btn btn-primary" value="View">
                 </form>
			';},
        'field' => 'logistics_id' )
);

// SQL server connection information
global $username,$password,$database;
$sql_details = array(
    'user' => $username,
    'pass' => $password,
    'db'   => $database ,
    'host' => 'localhost'
);


/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 * If you just want to use the basic configuration for DataTables with PHP
 * server-side, there is no need to edit below this line.
 */

$where = '';
$joinQuery = "FROM `Z_Z_Logistics` AS `l`";
require( ROOT.'backend/core/controllers/ssp2.class.php' );

echo json_encode(
    SSP::simple( $_GET, $sql_details, $table, $primaryKey, $columns,$joinQuery,$where)
);

?>