<?php
 
/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 * Easy set variables
 */
 include_once('../../../../param.php');
// DB table to use
$table = 'Pick';
 
// Table's primary key
$primaryKey = "pick_code";
 
// Array of database columns which should be read and sent back to DataTables.
// The `db` parameter represents the column name in the database, while the `dt`
// parameter represents the DataTables column identifier. In this case object
// parameter names
$columns = array(
    array( 'db' => '`p`.`pick_id`', 'dt' => 'img', 'formatter' => function( $d, $row ) {
        return '<img class="custom-rounded-image invoice center-canvas" src="//' . HTML_PATH . '/cop/backend/themes/' . THEME_NAME . '/img/pickinglisticon.png" width="30" height="30"></td>';
    },'field' => 'pick_id' ),
    array( 'db' => '`p`.`pick_code`', 'dt' =>  'pick', 'field' =>'pick_code' ),
    array( 'db' => '`p`.`date`', 'dt' => 'date' , 'formatter' => function( $d, $row ) {return date('d-m-Y',strtotime($d));},'field' => 'date' ),
    array( 'db' => '`s`.`salesperson_code`', 'dt' => 'salesperson', 'field' => 'salesperson_code' ),

    array( 'db' => '`p`.`pick_id`', 'dt' => 'orderSP', 'formatter' => function( $d, $row ) {
        global $username, $password, $database;

        $db = new mysqli(localhost,$username,$password,$database);
        if (mysqli_connect_errno())
        {
            printf("Connect failed: %s\n", mysqli_connect_error());
            exit();
        }
        $db->set_charset("utf8");

        $stm = $db->prepare("SELECT GROUP_CONCAT(DISTINCT(Orders.salesperson_id)) FROM Pick_Order INNER JOIN Pick ON (Pick.pick_id = Pick_Order.pick_id) INNER JOIN Orders ON(Pick_Order.order_id=Orders.order_id) WHERE Pick.pick_id LIKE '$d'");
        $stm->execute();
        $stm->bind_result($salespersonIDs);
        while ($stm->fetch()) {}
        $stm->close();

        $salespersonNames = '';
        $isFirstSP = true;
        if(strcmp($salespersonIDs,'')!=0){
            $stm = $db->prepare("SELECT CONCAT(salesperson_code,' ',first_name,' ',last_name) FROM SalesPersons  WHERE salesperson_id IN ($salespersonIDs)");
            $stm->execute();
            $stm->bind_result($salesPersonName);
            while ($stm->fetch()) {
                if(!$isFirstSP){$salespersonNames .= "<br>";}
                $salespersonNames .= "$salesPersonName";
                $isFirstSP = false;

            }
            $stm->close();
        }

        return $salespersonNames;

    },'field' => 'pick_id' ),

    array( 'db' => '`p`.`pick_id`', 'dt' => 'salesPersonSelect', 'formatter' => function( $d, $row ) {

        global $username, $password, $database;

        $db = new mysqli(localhost,$username,$password,$database);
        if (mysqli_connect_errno())
        {
            printf("Connect failed: %s\n", mysqli_connect_error());
            exit();
        }
        $db->set_charset("utf8");
        $disabled = '';
        $selectInput = true;
        $stm = $db->prepare("SELECT Pick.status FROM Pick WHERE pick_id LIKE '$d'");
        $stm->execute();
        $stm->bind_result($pickStatus);
        while ($stm->fetch()) {
            if(strcmp($pickStatus,'Cancelled')==0 || strcmp($pickStatus,'Canceled')==0 || strcmp($pickStatus,'Completed')==0){
                $disabled = 'disabled';
                $selectInput = false;
            }
        }
        $stm->close();

        $stm = $db->prepare("SELECT Pick.salesperson_id, salesperson_code, CONCAT(first_name,' ',last_name) FROM Pick INNER JOIN SalesPersons ON (SalesPersons.salesperson_id = Pick.salesperson_id) WHERE pick_id LIKE '$d'");
        $stm->execute();
        $stm->bind_result($salesPersonID, $salesPersonCode, $salesPersonName);
        while ($stm->fetch()) {
        }
        $stm->close();

        if($selectInput) {
            $select = "<select name='select$d' id ='select$d' class='form-control' onchange='updateSalesPerson($d)' $disabled>";

            $select .= "<option value='$salesPersonID' selected >$salesPersonCode $salesPersonName</option>";

            $stm = $db->prepare("SELECT salesperson_id, salesperson_code, CONCAT(first_name,' ',last_name) FROM SalesPersons  WHERE salesperson_id NOT LIKE '$salesPersonID'");
            $stm->execute();
            $stm->bind_result($salesPersonID, $salesPersonCode, $salesPersonName);
            while ($stm->fetch()) {
                $select .= "<option value='$salesPersonID' >$salesPersonCode $salesPersonName</option>";
            }
            $stm->close();
            $select .= "</select>";
        } else {
            $select = "<label >$salesPersonCode $salesPersonName</label>";
        }


        return $select;


    }, 'field' => 'pick_id' ),
    array( 'db' => '`p`.`status`', 'dt' =>  'status', 'formatter' => function( $d, $row ) {
        switch ($d){
            case 'Cancelled':
                $result = "<center><div style='color: firebrick;'><b>$d</b></div></center>";
                break;
            case 'Ready to Pick':
                $result = "<center><div style='color: #0a6ebd;width: 100px;'><b>$d</b></div></center>";
                break;
            case 'Completed':
                $result = "<center><div style='color: #00a300;'><b>$d</b></div></center>";
                break;
            default:
                $result = "<center><div style='color: black;'>$d</div></center>";
        }
        return $result;
    },'field' =>'status' ),
    array( 'db' => '`p`.`pick_id`', 'dt' => 'form', 'formatter' => function( $d, $row ) {

         global $username, $password, $database;

         $db2 = new mysqli(localhost,$username,$password,$database);
         if (mysqli_connect_errno())
         {
             printf("Connect failed: %s\n", mysqli_connect_error());
             exit();
         }
//         $stm = $db->prepare("SELECT order_id FROM Pick_Order INNER JOIN Pick ON (Pick.pick_id = Pick_Order.pick_id) WHERE Pick.pick_id LIKE '$d'");
//         $stm->execute();
//         $stm->bind_result($orderID);
//         while ($stm->fetch()) {}
//         $stm->close();


                return '<form style="display:inline;" target="_blank" id="'.$d.'" action="//'.HTML_PATH .'/cop/backend/core/views/view/view_pick.php" method="post">
           		            <input type="hidden" name="pick_id" value="'.$d.'">	           			                   
			                <input style="font-size:13px;width:110px; margin-top: 3px;" type="submit" class="btn btn-invoice" value="View Pick" >
			            </form>
			            <button type="button" class="btn btn-primary" style="font-size:13px;width:110px; margin-top: 3px;" onclick="viewPickOrders('.$d.')">View Orders</button>
			            
			           
						
			';},
            'field' => 'pick_id' )
);
 
// SQL server connection information
$sql_details = array(
    'user' => $username,
    'pass' => $password,
    'db'   => $database ,
    'host' => 'localhost'
);
 
 
/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 * If you just want to use the basic configuration for DataTables with PHP
 * server-side, there is no need to edit below this line.
 */
$where = " is_for_pack = 'yes'";
if(isset($_SESSION['Allow_Customers']) && strcmp($_SESSION['Allow_Customers'],'')!=0){
    if(strcmp($where,'')!=0){$where.= " AND ";}
    $where .= "`c`.`customer_id` IN (".$_SESSION['Allow_Customers'].")";
}
if(isset($_SESSION['Allow_Salespersons']) && strcmp($_SESSION['Allow_Salespersons'],'')!=0){
    if(strcmp($where,'')!=0){$where.= " AND ";}
    $where .= " `o`.`salesperson_id` IN (".$_SESSION['Allow_Salespersons'].")";
}
$joinQuery = "FROM `Pick` AS `p`   LEFT JOIN `SalesPersons` AS `s` ON (`p`.`salesperson_id` = `s`.`salesperson_id`)";
require( ROOT.'backend/core/controllers/ssp2.class.php' );
 
echo json_encode(
       SSP::simple( $_GET, $sql_details, $table, $primaryKey, $columns,$joinQuery,$where)
     );
     
     ?>