<?php
include_once("../../../../param.php");
require_once(ROOT . "backend/modules/sapServiceLayerReader/model/SAPClient.php");
require_once(ROOT . "/backend/core/model/CopJsonHandler.php");

$pageRows = 20;
$sapTable = 'view.svc/ctrx_ProdOrders_B1SLQuery';
$hideColumns = array('id__');
$hideColumnFilters = array();
//$buttonURL = '//'.HTML_PATH.'/cop/backend/modules/sapServiceLayerReader/views/view_product_sap_sl.php';
$highlightRow = array('Status|Released'=>'#66FF99','Status|Closed'=>'salmon');
$viewButtonFilterKey = 'Code';



global $username,$password,$database;
$db= new mysqli('localhost',$username,$password,$database);
if (mysqli_connect_errno())
{
    printf("Connect failed: %s\n", mysqli_connect_error());
    exit();
}
$db->set_charset("utf8");
$stm = $db->prepare("SELECT erp_host,erp_port,erp_username,erp_identifier,erp_database,erp_error_mail,erp_name FROM ERP_Connection LIMIT 1");
$stm->execute();
$stm->bind_result($b1Host,$b1Port,$b1UserName,$b1Password,$b1CompanyDB,$errorMail,$erpName);
while ($stm->fetch()) {}
$stm->close();

$client = new SAPClient($b1Host,$b1Port,$b1UserName,$b1Password,$b1CompanyDB);
$client->startConnection();
$erpErrors = $client->getErrors();

$skip = $_GET['$skip'];
$filter = $_GET['$filter'];

if(isset($_GET['$filter']) && strcmp($filter,'')!=0 ){
    $filterQuery = '?$filter='.$_GET['$filter'];
} else {
    $filterQuery = '';
}

if(isset($_GET['prdLine']) && strcmp($_GET['prdLine'],'')!=0){
    $filterQuery = '?$filter='."ProdLine%20eq%20'".$_GET['prdLine']."'";
}

if(isset($_GET['$skip']) && strcmp($skip,'')!=0 && $skip > 0){

    $unSkip = $skip - $pageRows;
    if(strcmp($filterQuery,'')!=0){
        $filterNext = '&$skip='.$skip;
    } else {
        $filterNext = '?$skip='.$skip;
    }
    $paging = ($skip/$pageRows) + 1;

} else {
    $filterNext = '';
    $filterPrev = '';
    $paging = 1;
}

$result = $client->requestData($sapTable.$filterQuery.$filterNext,'',false);

$s6Filter = $client->requestDataRecursive('view.svc/ctrx_ProdLines_B1SLQuery', '', false);
$s6FilterSrr = json_decode( json_encode($s6Filter), true);
$s6FilterSelect = "<table style='width: 100%'><tr><td style='width: 35%'><span class='pull-right'><b>Production Line: &nbsp;&nbsp;</span></td><td style='width: 25%'>";
$s6FilterSelect .= "<select class='form-control' id='prodLineFilter'>";
$isfirstFilter = true;
foreach ($s6FilterSrr as $arrLvl1){
    foreach ($arrLvl1 as $lvl1) {
        $lvl1 = (object)$lvl1;
        if(isset($_GET['prdLine']) && strcmp($_GET['prdLine'],$lvl1->Name)==0){
            $s6FilterSelect .= "<option value='".$lvl1->Name."' selected>".$lvl1->Name."</option>";
            $filterQuery  = '?$filter='."ProdLine%20eq%20'".$lvl1->Name."'";
        } else if(isset($_GET['prdLine']) && strpos($_GET['prdLine'], 'WAREHOUSE PACKING') !== false && strpos($lvl1->Name, 'WAREHOUSE PACKING') !== false) {
            $s6FilterSelect .= "<option value='".$lvl1->Name."' selected>".$lvl1->Name."</option>";
            $lvl1->Name = str_replace('&','%26',$lvl1->Name);
            $filterQuery  = '?$filter='."ProdLine%20eq%20'".$lvl1->Name."'";
        } else {
            $s6FilterSelect .= "<option value='".$lvl1->Name."'>".$lvl1->Name."</option>";
        }
        $filterName = str_replace(' ','%20' ,$lvl1->Name);
        if($isfirstFilter){$filterQuery  = '?$filter='."ProdLine%20eq%20'".$lvl1->Name."'";$isfirstFilter=false;}
    }
}
$s6FilterSelect .= "</select>";
$s6FilterSelect .= "</td><td style='width: 25%'><button class='btn btn-primary pull-left' onclick='refreshProductionOrders()'> Refresh </button></td>";
$s6FilterSelect .= "</td><td >
                            <form action='//".HTML_PATH."/cop/backend/modules/sapServiceLayerReader/views/generateLabels.php' method='post' target='_blank'>
                            
                                <input type='hidden' id='productionOrderFilter' name='productionOrderFilter'>
                                <input type='hidden' id='itemCodeFilter' name='itemCodeFilter'>
                                <input type='hidden' id='qtyFilter' name='qtyFilter'>
                                <input type='hidden' id='dateFilter' name='dateFilter'>
                                <input type='hidden' id='DocEntryFilter' name='DocEntryFilter'>
                                
                                <button type='button' id='closeProd'      onclick='closeProductionModal();' class='btn btn-danger'  style='border-radius: 5%; display: inline;margin-bottom: 3px;' title='Close Production'   ><i class='fa fa-gift'></i></button>
                                <button type='button' id='getProdReceipt' onclick='getProductionReceipt();' class='btn btn-waybill' style='border-radius: 5%; display: inline;margin-bottom: 3px;' title='Production Receipts'><i class='fa fa-money'></i></button>
                                <button type='button' id='issueReceipt' onclick='issueNewReceipt();' class='btn btn-invoice' style='border-radius: 5%; display: inline;margin-bottom: 3px;' title='Issue Production'><i class='fa fa-pencil-square-o'></i></button>
                                <!--<button type='submit' id='printLabels'    name='printLabels'                class='btn btn-return'  style='border-radius: 5%; display: inline;margin-bottom: 3px;' title='Print Labels'       ><i class='fa fa-file-text-o'></i></button>-->
                                <button type='button' id='resetColors'    onclick='resetColumns();'         class='btn btn-primary' style='border-radius: 5%; display: inline;margin-bottom: 3px;' title='Reset Columns'      ><i class='fa fa-home'></i></button>
                            </form>
                    </td></tr></table>";


?>

<div id="main" role="main" class="background-color-whitish">
    <!-- Start CUSTOM CODE-->

    <!-- RIBBON -->
    <div id="ribbon" class="bg-color-blue">

				<span class="ribbon-button-alignment">
					<span id="refresh" class="btn btn-ribbon2" onclick="location.reload(true);" data-title="refresh" rel="tooltip" data-placement="bottom" data-original-title="<i class='text-warning fa fa-warning'></i> Reload Page?" data-html="true">
						<i class="fa fa-refresh"></i>
					</span>
				</span>

        <!-- breadcrumb -->
        <ol class="breadcrumb">
            <li class="txt-color-white">Home / Manage <?php echo "$erpName"?> Production Orders</li>
        </ol>
        <!-- end breadcrumb -->
    </div>
    <!-- END RIBBON -->
    <!-- MAIN CONTENT -->
    <div id="content">

        <div class="row">
            <div class="col-xs-12 col-sm-8 col-md-9 col-lg-10">
                <h3 class="page-title txt-color-blueDark" style="margin-top: 3px;margin-bottom: 5px;">
                    <img style="display:inline;"class="custom-rounded-image order" src="//<?php echo HTML_PATH ?>/cop/backend/themes/<?php echo THEME_NAME ?>/img/ordericon.png" width="30" height="30">&nbsp;
                    <?php echo "$erpName"?> Production Orders
                </h3>
            </div>

            <div class="col-xs-12 col-sm-4 col-md-3 col-lg-2">

            </div>

        </div>

        <!-- row -->
        <section id="widget-grid" class="">
            <!-- row -->
            <div class="row">
                <!-- NEW WIDGET START -->
                <article class="col-xs-12 col-sm-12 col-md-12 col-lg-12">
                    <div class="jarviswidget jarviswidget-color-blueDark" id="wid-id-0" data-widget-editbutton="false" data-widget-deletebutton="false">
                        <header>
                            <span class="widget-icon"> <i class="fa fa-table"></i> </span>
                            <h2>Production Orders Table </h2>
                        </header>
                        <!-- widget div-->
                        <div>
                            <!-- widget content -->
                            <div class="widget-body no-padding">
                                <br>
                                    <?php


                                    echo $s6FilterSelect;

                                    $filterQuery = str_replace(' ','%20',$filterQuery);
                                    $result = $client->requestDataRecursive($sapTable . $filterQuery, '', false);
                                    $paging5 = 1;
                                    $filterNext5 = '';


                                    $data = $result[0];
                                    if (strcmp($result[1], '') != 0) {
                                        $filterNext5 = "&tabActive=s4&" . explode('?', $result[1])[1];
                                        $filterPrev = $filterNext5;
                                        $filterPrevSkip = explode('$skip=', $filterPrev)[1];
                                        $unSkip = $filterPrevSkip - $pageRows * 2;
                                        if ($unSkip <= 0) {
                                            $unSkip = 0;
                                        }
                                        $filterPrev = str_replace('$skip=' . $filterPrevSkip, '$skip=' . $unSkip, "$filterPrev");
                                    }
                                    $buttonRedirect = '';
                                    $buttonURL = '';
                                    $viewButtonFilterKey = '';
                                    $duplicateColumns = array();
                                    $functionToCall = 'closeProductionMarker(this);';
                                    $cellFunctionToCall = array('DocEntry'=>$functionToCall,'Date'=>$functionToCall,'PrOrdNumber'=>$functionToCall,'ItemCode'=>$functionToCall,'Remain Qty'=>$functionToCall,'Compl Qty'=>$functionToCall,'Remarks'=>$functionToCall,'Urgent'=>$functionToCall,'Status'=>$functionToCall,'ProdLine'=>$functionToCall);

                                    $jsonHandler = new CopJsonHandler();

                                    $string = json_encode($data);
                                    $disableApplyfilterButton = true;

                                    echo $jsonHandler->jsonToDataTable($string, $hideColumns, $hideColumnFilters, $buttonRedirect, $buttonURL, $viewButtonFilterKey, $disableApplyfilterButton, 's5',$highlightRow,true,$duplicateColumns,$cellFunctionToCall);

                                    if (strcmp($string, '[]') != 0) {
                                    } else {
                                        echo "<center><h2>- No Data found -</h2>";
                                    }


                                    ?>


                            </div>
                            <!-- end widget content -->

                        </div>
                        <!-- end widget div -->

                    </div>
                    <!-- end widget -->

                </article>
                <!-- WIDGET END -->

            </div>

            <!-- end row -->

        </section>
    </div>


</div>

<!-- Modal -->
<div class="modal fade" id="closeProductionModal" tabindex="-1" role="dialog" aria-labelledby="myModalLabel">
    <div class="modal-dialog" role="document"  style="width: 60%;">
        <div class="modal-content" style="">
            <div class="modal-body" style="">

                <div id="closeProductionModalContainer" >

                </div>

            </div>

        </div>
    </div>
</div>

<!-- Modal -->
<div class="modal fade" id="productionReceiptModal" tabindex="-1" role="dialog" aria-labelledby="myModalLabel">
    <div class="modal-dialog" role="document"  style="width: 80%;">
        <div class="modal-content" style="width: 100%;">
            <div class="modal-body" style="width: 100%;">

                <div id="productionReceiptModalContainer" >

                </div>

            </div>

        </div>
    </div>
</div>

<!-- Modal -->
<div class="modal fade" id="issueReceiptModal" tabindex="-1" role="dialog" aria-labelledby="myModalLabel">
    <div class="modal-dialog" role="document"  style="width: 80%;">
        <div class="modal-content" style="width: 100%;">
            <div class="modal-body" style="width: 100%;">

                <div id="issueReceiptModalContainer" >

                </div>

            </div>

        </div>
    </div>
</div>



<script src="//<?php echo HTML_PATH ?>/cop/backend/themes/<?php echo THEME_NAME ?>/js/DataTables/datatables.js"></script>
<script src="//<?php echo HTML_PATH ?>/cop/backend/themes/<?php echo THEME_NAME ?>/js/plugin/datatables/dataTables.colVis.min.js"></script>
<script src="//<?php echo HTML_PATH ?>/cop/backend/themes/<?php echo THEME_NAME ?>/js/plugin/datatables/dataTables.tableTools.min.js"></script>
<script src="//<?php echo HTML_PATH ?>/cop/backend/themes/<?php echo THEME_NAME ?>/js/plugin/datatables/dataTables.bootstrap.min.js"></script>
<script src="//<?php echo HTML_PATH ?>/cop/backend/themes/<?php echo THEME_NAME ?>/js/plugin/datatable-responsive/datatables.responsive.min.js"></script>
<script src="//<?php echo HTML_PATH ?>/cop/backend/themes/<?php echo THEME_NAME ?>/js/plugin/select2/select2.min.js"></script>

<script type="text/javascript">

    var tablePosition = <?php if(isset($tablePosition)) {echo $tablePosition;}else{echo 0;} ?>

        function showImage(url){
            $('#modalImage').attr("src",url);
        }

    function activateButtonClicked(itemID)
    {

        $.ajax({
            type: "POST",
            url: '//<?php echo HTML_PATH . "/cop/backend/core/controllers/change/changeItemStatus.php"?>',
            data: {
                'itemID':itemID,
                'active':"yes"
            },

            success: function (result) {

                $('#a'+itemID).text('Deactivate');
                $('#a'+itemID).removeClass('btn-success');
                $('#a'+itemID).addClass('btn-danger');
                $('#a'+itemID).unbind('click');
                $('#a'+itemID).click(function()
                {
                    deactivateButtonClicked(itemID);
                });
            }

        });
    }

    function deactivateButtonClicked(itemID)
    {

        $.ajax({
            type: "POST",
            url: '//<?php echo HTML_PATH . "/cop/backend/core/controllers/change/changeItemStatus.php"?>',
            data: {
                'itemID':itemID,
                'active':"no"
            },
            success: function (result) {

                $('#a'+itemID).text('Activate');
                $('#a'+itemID).removeClass('btn-danger');
                $('#a'+itemID).addClass('btn-success');
                $('#a'+itemID).unbind('click');
                $('#a'+itemID).click(function()
                {
                    activateButtonClicked(itemID);
                });
            }
        });
    }

    function refreshProductionOrders(){
        var prdLine =  $('#prodLineFilter').val();
        window.location.href= "manage_production_orders_sap_sl.php?prdLine="+prdLine+'&tabActive=s5';


    }

    function closeProductionMarker(element){

        var docEntry    = $(element).closest('tr').find('.DocEntry').html();
        var PrOrdNumber = $(element).closest('tr').find('.PrOrdNumber').html();
        var itemCode    = $(element).closest('tr').find('.ItemCode').html();
        var date        = $(element).closest('tr').find('.Date').html();
        var Qty         = $(element).closest('tr').find('.Compl').html();
        var Status      = $(element).closest('tr').find('.Status').html();

        docEntry    = trimElementValue(docEntry);
        PrOrdNumber = trimElementValue(PrOrdNumber);
        itemCode    = trimElementValue(itemCode);
        date        = trimElementValue(date);
        Qty         = trimElementValue(Qty);
        Status      = trimElementValue(Status);

        resetColumns();

        $(element).closest('tr').children('td, th').css('background-color','lightblue');

        $('#productionOrderFilter').val(PrOrdNumber);
        $('#itemCodeFilter').val(itemCode);
        $('#qtyFilter').val(Qty);
        $('#dateFilter').val(date);
        $('#DocEntryFilter').val(docEntry);

        if(Status.localeCompare('Closed') !== 0) {
            $('#closeProd').prop('disabled', false);
        }

        $('#printLabels').prop('disabled', false);
        $('#resetColors').prop('disabled', false);
        $('#getProdReceipt').prop('disabled', false);
        $('#issueReceipt').prop('disabled', false);



    }

    function productionReceiptsMarker(element){

        var PrOrdNumber = $(element).closest('tr').find('.ProdNumber').html();
        var itemCode    = $(element).closest('tr').find('.PartNumber').html();
        var date        = $(element).closest('tr').find('.Date').html();
        var Qty         = $(element).closest('tr').find('.Quantity').html();

        PrOrdNumber = trimElementValue(PrOrdNumber);
        itemCode    = trimElementValue(itemCode);
        date        = trimElementValue(date);
        Qty         = trimElementValue(Qty);

        resetReceiptColumns();

        $(element).closest('tr').children('td, th').css('background-color','lightblue');

        $('#productionOrderFilterReceipt').val(PrOrdNumber);
        $('#itemCodeFilterReceipt').val(itemCode);
        $('#qtyFilterReceipt').val(Qty);
        $('#dateFilterReceipt').val(date);

        $('#printLabelsReceipt').prop('disabled',false);


    }

    function closeProductionModal(){

        $('#closeProductionModalContainer').html('Processing...');

        var PrOrdNumber = $('#productionOrderFilter').val();
        var itemCode = $('#itemCodeFilter').val();
        var Qty = $('#qtyFilter').val();
        var prodLine = $('#prodLineFilter').val();

        var title = ' ';


        $.ajax({
            type:"POST",
            url: '//<?php echo HTML_PATH?>/cop/backend/modules/sapServiceLayerReader/controllers/get_scrap_reasons.php',
            data:{'title':title,'prodLine':prodLine},
            success:function(result){

                $('#closeProductionModalContainer').html(
                    '<center><h2><b>Closing Production</b></h2></center><table class="table table-bordered" style="width: 100%"><tr><td style="width: 33%"><div align="left" style="font-size: 16px;"><b>Production Order: '+PrOrdNumber
                    +'</td><td style="width: 33%"><div align="center" style="font-size: 16px;"><b>Part: '+itemCode
                    +'</td><td style="width: 33%"><div align="right" style="font-size: 16px;"><b>Quantity: '+Qty
                    +'</td></tr></table>'+result

                );




            }
        });

        $('#closeProductionModal').modal('toggle');




    }

    function getProductionReceipt(){

        $('#productionReceiptModalContainer').html('Processing...');

        var PrOrdNumber = $('#productionOrderFilter').val();
        var itemCode = $('#itemCodeFilter').val();
        var Qty = $('#qtyFilter').val();

        var title = 'Receipts From Production '+PrOrdNumber;
        var sapTable = 'view.svc/ctrx_RctFromProd_B1SLQuery';
        var hideColumns = ['id__'];
        // var highlightRow = {'BOM|Production':'lightblue','BOM|Assembly':'lightblue'};
        // var duplicateColumns = {'Required':'Required_2|display:none;'};
        var cellFunctionToCall = {'ProdNumber':'productionReceiptsMarker(this);','PartNumber':'productionReceiptsMarker(this);','ItemDescription':'productionReceiptsMarker(this);','Supplier':'productionReceiptsMarker(this);','Date':'productionReceiptsMarker(this);','Quantity':'productionReceiptsMarker(this);','Received':'productionReceiptsMarker(this);'};

        var hideColumnFilters = [];
        var filterQuery = '?$filter=ProdNumber%20eq%20'+PrOrdNumber;


        $.ajax({
            type:"POST",
            url: '//<?php echo HTML_PATH?>/cop/backend/modules/sapServiceLayerReader/controllers/getTable.php',
            data:{
                'title':title,
                'filterQuery':filterQuery,
                'itemCode':itemCode,
                'sapTable':sapTable,
                'hideColumns':hideColumns,
                // 'highlightRow':highlightRow,
                // 'duplicateColumns':duplicateColumns,
                'cellFunctionToCall':cellFunctionToCall,
                'hideColumnFilters':hideColumnFilters
            },
            success:function(result){

                $('#productionReceiptModalContainer').html('<form action=\'//<?php echo HTML_PATH ?>/cop/backend/modules/sapServiceLayerReader/views/generateLabels.php\' method=\'post\' target=\'_blank\'>'
                    +'<input type=\'hidden\' id=\'productionOrderFilterReceipt\' name=\'productionOrderFilter\'>'
                    +'<input type=\'hidden\' id=\'itemCodeFilterReceipt\' name=\'itemCodeFilter\'>'
                    +'<input type=\'hidden\' id=\'qtyFilterReceipt\' name=\'qtyFilter\'>'
                    +'<input type=\'hidden\' id=\'dateFilterReceipt\' name=\'dateFilter\'>'
                    +'<input type=\'hidden\' id=\'DocEntryFilterReceipt\' name=\'DocEntryFilter\'>'
                    +'<button type=\'submit\' id=\'printLabelsReceipt\'    name=\'printLabelsReceipt\' class=\'btn btn-return pull-right\'  style=\'border-radius: 5%; display: inline;margin-bottom: 3px;\' title=\'Print Labels\' disabled><i class=\'fa fa-file-text-o\' >&nbsp; Print Labels</i></button>'
                    +'</form>'
                    +result);


            }
        });

        $('#productionReceiptModal').modal('toggle');




    }

    function closeProduction(array){

        $('#closeProductionConfirmButton').prop('disabled',true);
        $('#closeProductionCancelButton').prop('disabled',true);

        var PrOrdNumber = $('#productionOrderFilter').val();
        var itemCode = $('#itemCodeFilter').val();
        var Qty = $('#qtyFilter').val();
        var docEntry = $('#DocEntryFilter').val();
        var lineCounter = 1;
        var scrapData = '[';


        var now     = new Date();
        var year    = now.getFullYear();
        var month   = now.getMonth() + 1;
        var day     = now.getDate();
        var hour    = now.getHours();
        var minutes = now.getMinutes();

        if(day <= 9){day = '0'+day;}
        if(month <= 9){month = '0'+month;}
        if(hour <= 9){hour = '0'+hour;}
        if(minutes <= 9){minutes = '0'+minutes;}

        for (const scrap of array) {

            var Code            = PrOrdNumber+'_'+lineCounter;
            var Name            = PrOrdNumber+'_'+lineCounter;
            var U_OWORDocEntry  = docEntry;
            var U_ScrapReason   = $('#c'+scrap).val();
            var U_ReasonDescr   = $('#n'+scrap).val();
            var U_ScrapQty      = $('#q'+scrap).val();
            var U_Date          = year+''+month+''+day;
            var U_Time          = hour+':'+minutes;

            if(U_ScrapQty.localeCompare('')!==0 && U_ScrapQty > 0){
                if(lineCounter === 1){
                    scrapData += "{";
                } else {
                    scrapData += ",{";
                }

                 scrapData += '"Code":"'+Code+'",'
                             +'"Name":"'+Name+'",'
                             +'"U_OWORDocEntry":"'+U_OWORDocEntry+'",'
                             +'"U_OIGNDocEntry": "0",'
                             +'"U_ScrapReason":"'+U_ScrapReason+'",'
                             +'"U_ReasonDescr":"'+U_ReasonDescr+'",'
                             +'"U_ScrapQty":"'+U_ScrapQty+'",'
                             +'"U_Date":"'+U_Date+'",'
                             +'"U_Time":"'+U_Time+'"}';

                lineCounter++;
            }

        }

        scrapData += ']';

        if(scrapData.localeCompare('[]') != 0){

            var scrapRequestApi = 'CTRX_SCRAP_QTY';

            $.ajax({
                type:"POST",
                url: '//<?php echo HTML_PATH?>/cop/backend/modules/sapServiceLayerReader/controllers/postData.php',
                data:{'postData':scrapData,'postAction':scrapRequestApi},
                success:function(result){}
            });

        }
        var productionCloseRequestApi = 'ProductionOrders('+docEntry+')';
        var productionCloseData = '[{"ProductionOrderStatus":"boposClosed"}]';
        var postAlternative = 'PATCH';

        $.ajax({
            type:"POST",
            url: '//<?php echo HTML_PATH?>/cop/backend/modules/sapServiceLayerReader/controllers/postData.php',
            data:{'postData':productionCloseData,'postAction':productionCloseRequestApi,'postAlternative':postAlternative},
            success:function(result){
                $('#closeProductionModalContainer').html(result);
                // location.reload();
            }
        });



        // $('#closeProductionModal').modal('toggle');

    }

    function resetColumns(){
        $('#datatable_fixed_column_s5_1').DataTable().rows().every(function () {
            var row = $(this.node());
            var status = row.find('.Status').html();
            var RemainQty = row.find('.Remain').html();

            status = trimElementValue(status);
            RemainQty = trimElementValue(RemainQty);

            if(status.localeCompare('Released')==0){

                $(row).closest('tr').children('td, th').css('background-color','#66FF99');

            } else if(status.localeCompare('Closed')==0){

                $(row).closest('tr').children('td, th').css('background-color','salmon');

            }

            if(RemainQty < 0){

                row.find('.Remain').css('background-color','salmon');

            }

        });
        $('#productionOrderFilter').val('');
        $('#itemCodeFilter').val('');
        $('#qtyFilter').val('');
        $('#printLabels').prop('disabled',true);
        $('#closeProd').prop('disabled',true);
        $('#resetColors').prop('disabled',true);
        $('#getProdReceipt').prop('disabled',true);

    }

    function resetReceiptColumns(){
        $('#datatable_fixed_column_ajax-table_1').DataTable().rows().every(function () {
            var row = $(this.node());

            $(row).closest('tr').children('td, th').css('background-color','');

        });

    }

    function trimElementValue(elementValue){

        elementValue = elementValue.replace('<span onclick="closeProductionMarker(this);">','');
        elementValue = elementValue.replace('<span onclick="productionReceiptsMarker(this);">','');
        elementValue = elementValue.replace('<center>','');
        elementValue = elementValue.replace('</center>','');
        elementValue = elementValue.replace('</span>','');

        return elementValue
    }

    function issueNewReceipt(){
        $('#issueReceiptModalContainer').html('Processing...');

        var PrOrdNumber = $('#productionOrderFilter').val();
        var itemCode = $('#itemCodeFilter').val();
        var Qty = $('#qtyFilter').val();
        var DocEntry = $('#DocEntryFilter').val();


        $.ajax({
            type:"POST",
            url: '//<?php echo HTML_PATH?>/cop/backend/modules/sapServiceLayerReader/controllers/getItemDescription.php',
            data:{'itemCode':itemCode},
            success:function(itemDescr){
                $('#issueReceiptModalContainer').html(
                    '<center><h2><b>Issue Production</b></h2></center><table class="table table-bordered" style="width: 100%"><tr>'
                    +'<td style="width: 33%"><div align="left" style="font-size: 16px;"><b>Production Order: </td><td> '+ PrOrdNumber
                    +'</td></tr><tr><td style="width: 33%"><div align="left" style="font-size: 16px;"><b>Item: </td><td> '+itemCode+' / '+itemDescr
                    +'</td></tr><tr><td style="width: 33%"><div align="left" style="font-size: 16px;"><b>Quantity: </td><td><div align="center" style="font-size: 16px;"> <input type="number" id="issueReceiptQty" class="form-control" style="width: 80%;text-align: center;">'
                    +'</td></tr></table>'
                    +'<button type="button" class="btn btn-primary pull-left" id="closeProductionConfirmButton" onclick="issueProduction('+DocEntry+');"><b> Issue Production</button>'
                    +'<button type="button" class="btn btn-danger pull-right" id="closeProductionCancelButton" style="width: 100px;" onclick="$(\'#closeProductionModal\').modal(\'toggle\');"><b> Cancel</button><br><br>'
                );
            }
        });









        $('#issueReceiptModal').modal('toggle');




    }

    function issueProduction(BaseEntry){

        var Quantity = $('#issueReceiptQty').val();

        if(Quantity > 0 && BaseEntry > 0){
            var receiptRequestApi = 'InventoryGenEntries';
            var receiptRequestData = '[{"DocumentLines":[{"Quantity": "'+Quantity+'","BaseEntry":"'+BaseEntry+'"}]}]';

            $('#issueReceiptModalContainer').html('Processing...');

            $.ajax({
                type:"POST",
                url: '//<?php echo HTML_PATH?>/cop/backend/modules/sapServiceLayerReader/controllers/postData.php',
                data:{'postData':receiptRequestData,'postAction':receiptRequestApi},
                success:function(result){

                    if(!result.includes('"error"') && result.includes('"BaseEntry"')){
                        $('#issueReceiptModal').modal('toggle');
                        getProductionReceipt();
                    } else {
                        $('#issueReceiptModalContainer').html('<center><h3>Something went Wrong Please Try Again</h3></center>');
                    }


                }
            });
        }

    }


    $(document).ready(function() {

        pageSetUp();

        $('#printLabels').prop('disabled',true);
        $('#closeProd').prop('disabled',true);
        $('#resetColors').prop('disabled',true);
        $('#getProdReceipt').prop('disabled',true);
        $('#issueReceipt').prop('disabled', true);




    })

</script>