<?php
include_once("../../../../param.php");
require_once(ROOT . "backend/modules/sapServiceLayerReader/model/SAPClient.php");
require_once(ROOT . "/backend/core/model/CopJsonHandler.php");

$pageRows = 20;
$sapTable = 'view.svc/ctrx_ItemsAllB1SLQuery';
$hideColumns = array('id__','ItemPrices','ItemWarehouseInfoCollection','ItemPreferredVendors','ItemBarCodeCollection');
$hideColumnFilters = array('AvgCost','BoxQty','Buy/Make','GroupCode');
$buttonURL = '//'.HTML_PATH.'/cop/backend/modules/sapServiceLayerReader/views/view_product_sap_sl.php';
$viewButtonFilterKey = 'Code';

global $username,$password,$database;
$db= new mysqli('localhost',$username,$password,$database);
if (mysqli_connect_errno())
{
    printf("Connect failed: %s\n", mysqli_connect_error());
    exit();
}
$db->set_charset("utf8");
$stm = $db->prepare("SELECT erp_host,erp_port,erp_username,erp_identifier,erp_database,erp_error_mail,erp_name FROM ERP_Connection LIMIT 1");
$stm->execute();
$stm->bind_result($b1Host,$b1Port,$b1UserName,$b1Password,$b1CompanyDB,$errorMail,$erpName);
while ($stm->fetch()) {}
$stm->close();

$client = new SAPClient($b1Host,$b1Port,$b1UserName,$b1Password,$b1CompanyDB);
$client->startConnection();
$erpErrors = $client->getErrors();

$skip = $_GET['$skip'];
$filter = $_GET['$filter'];

if(isset($_GET['$filter']) && strcmp($filter,'')!=0 ){
    $filterQuery = '?$filter='.$_GET['$filter'];
} else {
    $filterQuery = '';
}

if(isset($_GET['$skip']) && strcmp($skip,'')!=0 && $skip > 0){

    $unSkip = $skip - $pageRows;
    if(strcmp($filterQuery,'')!=0){
        $filterNext = '&$skip='.$skip;
    } else {
        $filterNext = '?$skip='.$skip;
    }
    $paging = ($skip/$pageRows) + 1;

} else {
    $filterNext = '';
    $filterPrev = '';
    $paging = 1;
}

$result = $client->requestData($sapTable.$filterQuery.$filterNext,'',false);

?>

<div id="main" role="main" class="background-color-whitish">
    <!-- Start CUSTOM CODE-->

    <!-- RIBBON -->
    <div id="ribbon" class="bg-color-blue">

				<span class="ribbon-button-alignment">
					<span id="refresh" class="btn btn-ribbon2" onclick="location.reload(true);" data-title="refresh" rel="tooltip" data-placement="bottom" data-original-title="<i class='text-warning fa fa-warning'></i> Reload Page?" data-html="true">
						<i class="fa fa-refresh"></i>
					</span>
				</span>

        <!-- breadcrumb -->
        <ol class="breadcrumb">
            <li class="txt-color-white">Home / Manage your <?php echo "$erpName"?> Products</li>
        </ol>
        <!-- end breadcrumb -->
    </div>
    <!-- END RIBBON -->
    <!-- MAIN CONTENT -->
    <div id="content">

        <div class="row">
            <div class="col-xs-12 col-sm-8 col-md-9 col-lg-10">
                <h3 class="page-title txt-color-blueDark" style="margin-top: 3px;margin-bottom: 5px;">
                    <img src="//<?php echo HTML_PATH ?>/cop/backend/themes/<?php echo THEME_NAME ?>/img/itemdefaulticon.jpg" width="32" height="32">
                    <?php echo "$erpName"?> Product Management
                </h3>
            </div>

            <div class="col-xs-12 col-sm-4 col-md-3 col-lg-2">

            </div>

        </div>

        <!-- row -->
        <section id="widget-grid" class="">
            <!-- row -->
            <div class="row">
                <!-- NEW WIDGET START -->
                <article class="col-xs-12 col-sm-12 col-md-12 col-lg-12">
                    <div class="jarviswidget jarviswidget-color-blueDark" id="wid-id-1" data-widget-editbutton="false" data-widget-deletebutton="false">
                        <header>
                            <span class="widget-icon"> <i class="fa fa-table"></i> </span>
                            <h2>Company Product Table </h2>
                        </header>
                        <!-- widget div-->
                        <div>
                            <!-- widget content -->
                            <div class="widget-body no-padding">
                                    <?php



                                        $data = $result[0];
                                        if(strcmp($result[1],'')!=0){
                                            $filterNext= "?".explode('?',$result[1])[1];
                                            $filterPrev= $filterNext;
                                            $filterPrevSkip = explode('$skip=',$filterPrev)[1];
                                            $unSkip = $filterPrevSkip - $pageRows*2;
                                            if($unSkip <= 0){$unSkip=0;}
                                            $filterPrev = str_replace('$skip='.$filterPrevSkip,'$skip='.$unSkip,"$filterPrev");
                                        }


                                        $jsonHandler = new CopJsonHandler();
                                        $duplicateColumns=array();
                                        $cellFunctionToCall=array('Link'=>'openFile(this);');
                                        $string = json_encode($data);
                                        echo $jsonHandler->jsonToDataTable($string,$hideColumns,$hideColumnFilters,'//'.HTML_PATH.'/cop/backend/modules/sapServiceLayerReader/views/manage_products_sap_sl.php',$buttonURL,"$viewButtonFilterKey",'','','',false,$duplicateColumns,$cellFunctionToCall);

                                        if(strcmp($string,'null')!=0) {
                                            echo "<table style='width: 100%;'><tr>";
                                            echo "<td style='width: 33%;'>";
                                            if($paging > 1) {
                                                echo "<div class='pull-left' style='margin: 10px;'><a href=\"manage_products_sap_sl.php$filterPrev\" class='btn btn-primary'  >Prev Page</a></div>";
                                            } else {
                                                echo "<div class='pull-left' style='margin: 10px;'><button class='btn' disabled readonly >Prev Page</button></div>";
                                            }
                                            echo "</td>";
                                            echo "<td style='width: 33%;'>";

                                            echo "<center><h3>Page $paging</h3></center>";

                                            echo "</td>";
                                            echo "<td style='width: 33%;'>";
                                            if(strcmp($filterNext,'')!=0){
                                                echo "<div class='pull-right' style='margin: 10px;'><a href=\"manage_products_sap_sl.php$filterNext\" class='btn btn-primary'  >Next Page</a></div>";
                                            } else {
                                                echo "<div class='pull-right' style='margin: 10px;'><button class='btn' disabled readonly >Next Page</button></div>";
                                            }

                                            echo "</td>";
                                            echo "</tr></table>";
                                        } else {
                                            echo "<center><h2>- No Products found -</h2></center><br><center><a href='//".HTML_PATH."/cop/backend/modules/sapServiceLayerReader/views/manage_products_sap_sl.php' class='btn btn-primary'>- Clear Filters -</a></center><br>";
                                        }


                                    ?>


                            </div>
                            <!-- end widget content -->

                        </div>
                        <!-- end widget div -->

                    </div>
                    <!-- end widget -->

                </article>
                <!-- WIDGET END -->

            </div>

            <!-- end row -->

        </section>
    </div>


</div>

<!-- Modal -->
<div class="modal fade" id="imageModal" tabindex="-1" role="dialog" aria-labelledby="myModalLabel">
    <div class="modal-dialog" role="document" >
        <div class="modal-content">
            <div class="modal-body">

                <img class="img-responsive img-rounded center-canvas" src="" id='modalImage'>


            </div>

        </div>
    </div>
</div>

<script src="//<?php echo HTML_PATH ?>/cop/backend/themes/<?php echo THEME_NAME ?>/js/DataTables/datatables.js"></script>
<script src="//<?php echo HTML_PATH ?>/cop/backend/themes/<?php echo THEME_NAME ?>/js/plugin/datatables/dataTables.colVis.min.js"></script>
<script src="//<?php echo HTML_PATH ?>/cop/backend/themes/<?php echo THEME_NAME ?>/js/plugin/datatables/dataTables.tableTools.min.js"></script>
<script src="//<?php echo HTML_PATH ?>/cop/backend/themes/<?php echo THEME_NAME ?>/js/plugin/datatables/dataTables.bootstrap.min.js"></script>
<script src="//<?php echo HTML_PATH ?>/cop/backend/themes/<?php echo THEME_NAME ?>/js/plugin/datatable-responsive/datatables.responsive.min.js"></script>
<script src="//<?php echo HTML_PATH ?>/cop/backend/themes/<?php echo THEME_NAME ?>/js/plugin/select2/select2.min.js"></script>

<script type="text/javascript">

    var tablePosition = <?php if(isset($tablePosition)) {echo $tablePosition;}else{echo 0;} ?>

        function showImage(url){
            $('#modalImage').attr("src",url);
        }

    function activateButtonClicked(itemID)
    {

        $.ajax({
            type: "POST",
            url: '//<?php echo HTML_PATH . "/cop/backend/core/controllers/change/changeItemStatus.php"?>',
            data: {
                'itemID':itemID,
                'active':"yes"
            },

            success: function (result) {

                $('#a'+itemID).text('Deactivate');
                $('#a'+itemID).removeClass('btn-success');
                $('#a'+itemID).addClass('btn-danger');
                $('#a'+itemID).unbind('click');
                $('#a'+itemID).click(function()
                {
                    deactivateButtonClicked(itemID);
                });
            }

        });
    }

    function deactivateButtonClicked(itemID)
    {

        $.ajax({
            type: "POST",
            url: '//<?php echo HTML_PATH . "/cop/backend/core/controllers/change/changeItemStatus.php"?>',
            data: {
                'itemID':itemID,
                'active':"no"
            },
            success: function (result) {

                $('#a'+itemID).text('Activate');
                $('#a'+itemID).removeClass('btn-danger');
                $('#a'+itemID).addClass('btn-success');
                $('#a'+itemID).unbind('click');
                $('#a'+itemID).click(function()
                {
                    activateButtonClicked(itemID);
                });
            }
        });
    }

    function openFile(element){
        var file = $(element).html();

        file = file.replace('<center>','');
        file = file.replace('</center>','');
        file = file.replace('\\\\SAPSERVER','\\\\192.168.10.100');

        // alert(file)
        // window.open(file);

    }


    $(document).ready(function() {

        pageSetUp();





    })

</script>